/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/d64dolphin.cpp,v 1.2 2006/07/21 14:46:04 doj Exp $ */

#include "d64dolphin.hpp"
#include <stdio.h>

D64DOLPHIN::D64DOLPHIN(BYTE *disk_) : D64(disk_) { }
int D64DOLPHIN::track_max() { return 42; }
int D64DOLPHIN::maxblocks() { return 768; }
CBMdisk::bamentry* D64DOLPHIN::getbamentry(const BYTE t)
{
  if(t > this->track_max())
    return NULL;
  if(t<=35)
    return D64::getbamentry(t);
  bam_dolphin *BAM=reinterpret_cast<bam_dolphin*>(getsector(18,0));
  if(!BAM) return NULL;
  return &(BAM->entryDolphin[t-35]);
}

void D64DOLPHIN::printbam()
{
  printf("BAM: D64 DolphinDOS 40 track image\n");
  this->printbaminfo();
  this->printbamblocks();
}
