/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/d64prologic.cpp,v 1.2 2006/07/21 14:46:04 doj Exp $ */

#include "d64prologic.hpp"
#include <stdio.h>

D64PROLOGIC::D64PROLOGIC(BYTE *disk_) : D64(disk_) { }
int D64PROLOGIC::track_max() { return 42; }
int D64PROLOGIC::maxblocks() { return 768; }
void D64PROLOGIC::printbaminfo()
{
  const bam_prologic *BAM=reinterpret_cast<bam_prologic*>(getsector(18,0));
  fuse_assert(BAM);
  printf("  dir=%i:%i version=%c oneside=%i unused1=0x%02X,0x%02X id=%c%c unused2=0x%02X DOStype=%c%c unused3=0x%02X,0x%02X,0x%02X,0x%02X\n",
	 BAM->dir.track, BAM->dir.sector,
	 BAM->version,
	 BAM->onesided,
	 BAM->unused1[0], BAM->unused1[1],
	 BAM->id[0], BAM->id[1],
	 BAM->unused2,
	 BAM->DOStype[0], BAM->DOStype[1],
	 BAM->unused3[0], BAM->unused3[1], BAM->unused3[2], BAM->unused3[3]);
}

void D64PROLOGIC::printbam()
{
  printf("BAM: D64 PrologicDOS 40 track image\n");
  this->printbaminfo();
  this->printbamblocks();
}
