/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/d81.hpp,v 1.4 2006/07/21 14:46:04 doj Exp $ */

#ifndef D81__HPP
#define D81__HPP

#include "cbmdisk.hpp"

class D81 : public CBMdisk
{
public:

#pragma pack(push, 1)
  struct header_81 {
    /*0x00*/ TS dir;
    /*0x02*/ BYTE version;	/* should be 0x44='D' */
    /*0x03*/ BYTE unused1;	/* should be 0 */
    /*0x04*/ BYTE name[16];	/* padded with 0xA0 */
    /*0x14*/ BYTE unused2[2];	/* should be 0xA0 */
    /*0x16*/ BYTE id[2];
    /*0x18*/ BYTE unused3;	/* should be 0xA0 */
    /*0x19*/ BYTE DOSversion;	/* should be '3' */
    /*0x1A*/ BYTE DiskVersion;	/* should be 'D' */
    /*0x1B*/ BYTE unused4[2];	/* should be 0xA0 */
    /*0x1D*/ BYTE unused5[0x100-0x1D]; /* should be 0 */
  };
  BOOST_STATIC_ASSERT(sizeof(header_81) == SECTOR_SIZE);

  struct bamentry_81 {
    BYTE freeblocks;
    BYTE bm0, bm1, bm2, bm3, bm4;
  };
  BOOST_STATIC_ASSERT(sizeof(bamentry_81) == 6);

  struct bam_81 {
    /*0x00*/ TS next;		/* should be 0x40/0x3 for first, 0x00/0xFF for second */
    /*0x02*/ BYTE version;	/* should be 'D' */
    /*0x03*/ BYTE notversion;	/* one's complement of version 0xBB */
    /*0x04*/ BYTE id[2];
    /*0x06*/ BYTE io;
    /*0x07*/ BYTE autobootloader;
    /*0x08*/ BYTE unused[8];
    /*0x10*/ bamentry_81 entry[40];
  };
  BOOST_STATIC_ASSERT(sizeof(bam_81) == SECTOR_SIZE);

#pragma pack(pop)

  D81(BYTE *disk_);
  virtual TS dir();
  virtual int maxblocks();
  virtual void bam_set(const BYTE t, const BYTE s, const bool b);
  virtual void printbam();
  virtual int track_max();

protected:
  virtual void fix(bamentry*, const BYTE t);
  void fix(bamentry_81*, const BYTE t);
  virtual bool bam_get(const BYTE t, const BYTE s);
  virtual const int* sectorsPerTrack();
  bamentry_81* getbamentry_81(const BYTE t);
  virtual bamentry* getbamentry(const BYTE t);
  void printheaderinfo();
  virtual bool reserved_track(const BYTE t);

private:
  D81();
  D81(const D81&);
  D81& operator= (const D81&);
};

#endif
