/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/d82.cpp,v 1.2 2006/07/21 14:46:04 doj Exp $ */

#include "d82.hpp"
#include <stdio.h>

D82::D82(BYTE *disk_) :
  D80(disk_)
{
  this->bam_set(38,6,0);
  this->bam_set(38,9,0);
}

int D82::maxblocks() { return 4166; }
int D82::track_max() { return 154; }
void D82::printbam()
{
  printf("BAM: D82 154 track image\n");
  this->printbaminfo();
  this->printbamblocks();
}
