#! /usr/bin/env python

#Common imports
import os, sys
import unittest
import DiskSearchTest
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), '..'))

#~ print sys.path
#import specific to the test
from libdisksearch import Disk

class TestCase(DiskSearchTest.TestCase):
    def setUp(self):
        self.name = 'name123'
        self.type = 'type456'
        self.remark = 'remark789'
        self.timestamp = 'timestamp147'
        self.content = 'content258'

    def testDisk(self):
        disk = Disk.Disk(self.name, self.type, self.remark, self.timestamp, self.content)
        self.assertEqual (self.name, disk.name)
        self.assertEqual (self.type, disk.type)
        self.assertEqual (self.remark, disk.remark)
        self.assertEqual (self.content, disk.content)

def suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(TestCase))
    return suite

if __name__ == '__main__':
    unittest.main()
