#! /bin/bash
#
# Copyright 2010 Emeric Nasi
# -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=--=-=-=-=-=-=-
#    This file is part of Glyptodon
#
#    Glyptodon is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Glyptodon is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with glyptodon  If not, see <http://www.gnu.org/licenses/>.
# -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=--=-=-=-=-=-=-
#
###################################################################################################
######  - install.sh  -                                                                       #####
#####   Description : glyptodon installer                                                     #####
#####        Author : Emeric Nasi                                                             #####
#####       Contact ; glyptodon[at]sevagas.com                                                #####
#####  Requirements : Run by root (uid=0)                                                     #####
###################################################################################################


declare -r AUTHOR="Emeric Nasi"
PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin 
export PATH

#User must be root
if [ `/usr/bin/id -u` != 0 ] 
then
	echo -e "\033[40m\033[1;31m Error: Sorry, this script needs root access. -> abort $0 script\033[0m" >&2
	exit 1 
fi

# usage : ask "QUESTION" (use in tests)
# NOTE : Ask for confirmations (y/Y -> return 0, else 1)
ask ()          
{
	echo -n " $@" '[y/n] ' 
	local ans
	read ans
	case "$ans" in
		y*|Y*) return 0 ;;
		*) return 1 ;;
	esac
}


echo "Install glyptodon script in /usr/local/sbin/glyptodon ..." 
cp "glyptodon.sh" "/usr/local/sbin/glyptodon"
chmod 700 "/usr/local/sbin/glyptodon"
chown root:root "/usr/local/sbin/glyptodon"
echo "Creating glyptodon daily run script in /etc/cron.daily ..."
(umask 027 && touch /etc/cron.daily/glyptodon)	
echo '#!/bin/sh' > /etc/cron.daily/glyptodon
chown root:root /etc/cron.daily/glyptodon
echo >> /etc/cron.daily/glyptodon
glyptodonOptions=""
if grep -x "CONFIG_SECURITY_FILE_CAPABILITIES=y" /boot/config-`cat /proc/version | cut -d " " -f 3` &> /dev/null && which getcap &>/dev/null
then
	glyptodonOptions+=" --capabilities-scan "
fi

if which mail &>/dev/null  
then
	echo "It seems the mail command is installed on your system."
	if ask "Do you want to receive an email containing the daily scan report?"
	then
		echo "Emails can be send to a distant email address or to a local mailbox (/var/mail/ACCOUNT)"
		echo "Please enter an e-mail addresse, or a user local account (ex. root):"
		read EMAIL
		[ $EMAIL ] && echo " -> OK send emails to : $EMAIL" 
	fi
fi
if [ $EMAIL ]
then
	echo  "/usr/local/sbin/glyptodon $glyptodonOptions --skip-dir=/mnt,/media --log=/var/log/glyptodon.log | mail -s \"Daily glyptodon run from $HOSTNAME\" $EMAIL" >> /etc/cron.daily/glyptodon
else
	echo  "/usr/local/sbin/glyptodon $glyptodonOptions --skip-dir=/mnt,/media --log=/var/log/glyptodon.log" >> /etc/cron.daily/glyptodon
fi
unset glyptodonOptions
echo  >> /etc/cron.daily/glyptodon
chmod 700 /etc/cron.daily/glyptodon
if [ -d /etc/logrotate.d ]
then
	(umask 027 && touch /etc/logrotate.d/glyptodon)
	echo "Creating logrotate script in /etc/logrotate.d ..."
	echo '
/var/log/glyptodon.log {
	weekly
	size 16k
	rotate 8
	compress
}
' >  /etc/logrotate.d/glyptodon
fi
echo "Install completed!"
exit 0
