# Progressively fillable notebook demo

This notebook demonstrates the progressively fillable notebook
features of GraphTerm. Code lines ending with comment ``## ANSWER``
will be hidden when this notebook is renamed as
``name-fill.py.gnb.md`` or ``name-share.py.gnb.md`` or
``name-assign.py.gnb.md``. The ``-share`` suffix enables the super
user to share the notebook with other users for viewing and filling
synchronously. The ``-assign`` suffix enables asynchronous sharing. If
a subdirectory SUBMIT is present in the same directory as a shared
notebook file, other users can *submit* a filled shared notebook to
this directory using the *notebook/submit* menu option.

Use *Control-Enter* to execute filled code without saving it. This can
be repeated as needed, until the filled code yields the correct
results. (As a special case, deleting the entire code cell and typing
*Control-Enter* will restore the originally displayed content.)  Use
*Shift-Enter* to save filled code and advance to the next code
cell. The previous code cell will display the correct (ANSWER) code
after this operation, and the filled code cannot be modified. Cells
further down are hidden until your reach them after successive
*Shift-Enter* operations, but if the first line of a Markdown cell
following a page break (*triple-dash*) starts with "#", then the first
line alone is displayed (as a section heading). The
*notebook/page/slide* menu option can be used to enable page view.

To access a shared notebook, other users should start ``gpython`` and
select the *notebook/open* menu option, typing in the name of the
terminal path (``/user/session_name``). For synchronous sharing, other
users can only execute code using *Control-Enter* and cannot advance
to the next code cell until the super user has executed *Shift-Enter*
on the current cell. New users can start accessing the shared notebook
any time and should execute cells sequentially using *Control-Enter*.

To create a progressively fillable notebook that displays *expected
output*, open a regular notebook, append the comment ``## ANSWER`` to
code lines that need to be hidden, execute the code sequentially and
save it with the suffix ``-fill`` (or ``-share`` or ``-assign``)
appended to the base name of the file. This will automatically convert
the code output to *expected output*. (Note: The ``## ANSWER`` suffix
may also be used in the ``expect`` block of fillable notebook to hide
test results.)

---

## Part I

Write a function ``abs_add`` that returns the sum of the absolute values of two numbers and another
function ``abs_sub`` that computes the difference of absolute values. Test the two functions.

```python
# Part 1a: Define the function abs_add
def abs_add(a, b):          ## ANSWER
    return abs(a) + abs(b)  ## ANSWER

# Testing function abs_add
print abs_add(3, -4)

# Part 1b: Define the function abs_sub
def abs_sub(a, b):          ## ANSWER
    return abs(a) - abs(b)  ## ANSWER

# Testing function abs_sub
print abs_sub(3, -4)
```

```expect


7
-1
```

---

## Part II

Write some code to create a simple line plot with a title using the ``pylab`` module.


```python
x = [1, 2, 3, 4]
y = [1, 4, 9, 16]
title = "Plot of y = x-squared"

import pylab
# Part 2: Plotting code
pylab.plot(x, y)     ## ANSWER
pylab.title(title)   ## ANSWER

```

```expect



```

```expect

```

![image][expect-fig1-temp-fill.py]

```expect

```

[expect-fig1-temp-fill.py]: data:image/png;base64,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
