/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.TransformationChain;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerSourceTaskContext;
import org.apache.kafka.connect.runtime.WorkerTask;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.apache.kafka.connect.storage.OffsetStorageWriter;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerSourceTask
extends WorkerTask {
    private static final Logger log = LoggerFactory.getLogger(WorkerSourceTask.class);
    private static final long SEND_FAILED_BACKOFF_MS = 100L;
    private final WorkerConfig workerConfig;
    private final SourceTask task;
    private final Converter keyConverter;
    private final Converter valueConverter;
    private final TransformationChain<SourceRecord> transformationChain;
    private KafkaProducer<byte[], byte[]> producer;
    private final OffsetStorageReader offsetReader;
    private final OffsetStorageWriter offsetWriter;
    private final Time time;
    private List<SourceRecord> toSend;
    private boolean lastSendFailed;
    private IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> outstandingMessages;
    private IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> outstandingMessagesBacklog;
    private boolean flushing;
    private CountDownLatch stopRequestedLatch;
    private Map<String, String> taskConfig;
    private boolean finishedStart = false;
    private boolean startedShutdownBeforeStartCompleted = false;

    public WorkerSourceTask(ConnectorTaskId id, SourceTask task, TaskStatus.Listener statusListener, TargetState initialState, Converter keyConverter, Converter valueConverter, TransformationChain<SourceRecord> transformationChain, KafkaProducer<byte[], byte[]> producer, OffsetStorageReader offsetReader, OffsetStorageWriter offsetWriter, WorkerConfig workerConfig, ClassLoader loader, Time time) {
        super(id, statusListener, initialState, loader);
        this.workerConfig = workerConfig;
        this.task = task;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.transformationChain = transformationChain;
        this.producer = producer;
        this.offsetReader = offsetReader;
        this.offsetWriter = offsetWriter;
        this.time = time;
        this.toSend = null;
        this.lastSendFailed = false;
        this.outstandingMessages = new IdentityHashMap();
        this.outstandingMessagesBacklog = new IdentityHashMap();
        this.flushing = false;
        this.stopRequestedLatch = new CountDownLatch(1);
    }

    @Override
    public void initialize(TaskConfig taskConfig) {
        try {
            this.taskConfig = taskConfig.originalsStrings();
        }
        catch (Throwable t) {
            log.error("Task {} failed initialization and will not be started.", t);
            this.onFailure(t);
        }
    }

    @Override
    protected void close() {
        this.producer.close(30L, TimeUnit.SECONDS);
        this.transformationChain.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        this.stopRequestedLatch.countDown();
        WorkerSourceTask workerSourceTask = this;
        synchronized (workerSourceTask) {
            if (this.finishedStart) {
                this.task.stop();
            } else {
                this.startedShutdownBeforeStartCompleted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            this.task.initialize((SourceTaskContext)new WorkerSourceTaskContext(this.offsetReader));
            this.task.start(this.taskConfig);
            log.info("Source task {} finished initialization and start", (Object)this);
            WorkerSourceTask workerSourceTask = this;
            synchronized (workerSourceTask) {
                block12: {
                    if (!this.startedShutdownBeforeStartCompleted) break block12;
                    this.task.stop();
                    return;
                }
                this.finishedStart = true;
            }
            while (!this.isStopping()) {
                if (this.shouldPause()) {
                    this.onPause();
                    if (!this.awaitUnpause()) continue;
                    this.onResume();
                    continue;
                }
                if (this.toSend == null) {
                    log.debug("Nothing to send to Kafka. Polling source for additional records");
                    this.toSend = this.task.poll();
                }
                if (this.toSend == null) continue;
                log.debug("About to send " + this.toSend.size() + " records to Kafka");
                if (this.sendRecords()) continue;
                this.stopRequestedLatch.await(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.commitOffsets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRecords() {
        int processed = 0;
        for (final SourceRecord preTransformRecord : this.toSend) {
            SourceRecord record = this.transformationChain.apply(preTransformRecord);
            if (record == null) {
                this.commitTaskRecord(preTransformRecord);
                continue;
            }
            byte[] key = this.keyConverter.fromConnectData(record.topic(), record.keySchema(), record.key());
            byte[] value = this.valueConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            final ProducerRecord producerRecord = new ProducerRecord(record.topic(), record.kafkaPartition(), ConnectUtils.checkAndConvertTimestamp(record.timestamp()), (Object)key, (Object)value);
            log.trace("Appending record with key {}, value {}", record.key(), record.value());
            WorkerSourceTask workerSourceTask = this;
            synchronized (workerSourceTask) {
                if (!this.lastSendFailed) {
                    if (!this.flushing) {
                        this.outstandingMessages.put((ProducerRecord<byte[], byte[]>)producerRecord, (ProducerRecord<byte[], byte[]>)producerRecord);
                    } else {
                        this.outstandingMessagesBacklog.put((ProducerRecord<byte[], byte[]>)producerRecord, (ProducerRecord<byte[], byte[]>)producerRecord);
                    }
                    this.offsetWriter.offset(record.sourcePartition(), record.sourceOffset());
                }
            }
            try {
                final String topic = producerRecord.topic();
                this.producer.send(producerRecord, new org.apache.kafka.clients.producer.Callback(){

                    public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                        if (e != null) {
                            log.error("{} failed to send record to {}: {}", new Object[]{WorkerSourceTask.this.id, topic, e});
                            log.debug("Failed record: {}", (Object)preTransformRecord);
                        } else {
                            log.trace("Wrote record successfully: topic {} partition {} offset {}", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                            WorkerSourceTask.this.commitTaskRecord(preTransformRecord);
                        }
                        WorkerSourceTask.this.recordSent((ProducerRecord<byte[], byte[]>)producerRecord);
                    }
                });
                this.lastSendFailed = false;
            }
            catch (RetriableException e) {
                log.warn("Failed to send {}, backing off before retrying:", (Object)producerRecord, (Object)e);
                this.toSend = this.toSend.subList(processed, this.toSend.size());
                this.lastSendFailed = true;
                return false;
            }
            catch (KafkaException e) {
                throw new ConnectException("Unrecoverable exception trying to send", (Throwable)e);
            }
            ++processed;
        }
        this.toSend = null;
        return true;
    }

    private void commitTaskRecord(SourceRecord record) {
        try {
            this.task.commitRecord(record);
        }
        catch (InterruptedException e) {
            log.error("Exception thrown", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Exception thrown while calling task.commitRecord()", t);
        }
    }

    private synchronized void recordSent(ProducerRecord<byte[], byte[]> record) {
        ProducerRecord<byte[], byte[]> removed = this.outstandingMessages.remove(record);
        if (removed == null && this.flushing) {
            removed = this.outstandingMessagesBacklog.remove(record);
        }
        if (removed == null) {
            log.error("CRITICAL Saw callback for record that was not present in the outstanding message set: {}", record);
        } else if (this.flushing && this.outstandingMessages.isEmpty()) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitOffsets() {
        long commitTimeoutMs = this.workerConfig.getLong("offset.flush.timeout.ms");
        log.debug("{} Committing offsets", (Object)this);
        long started = this.time.milliseconds();
        long timeout = started + commitTimeoutMs;
        WorkerSourceTask workerSourceTask = this;
        synchronized (workerSourceTask) {
            this.flushing = true;
            boolean flushStarted = this.offsetWriter.beginFlush();
            log.debug("{} flushing {} outstanding messages for offset commit", (Object)this, (Object)this.outstandingMessages.size());
            while (!this.outstandingMessages.isEmpty()) {
                try {
                    long timeoutMs = timeout - this.time.milliseconds();
                    if (timeoutMs <= 0L) {
                        log.error("Failed to flush {}, timed out while waiting for producer to flush outstanding {} messages", (Object)this, (Object)this.outstandingMessages.size());
                        this.finishFailedFlush();
                        return false;
                    }
                    this.wait(timeoutMs);
                }
                catch (InterruptedException e) {
                    log.error("{} Interrupted while flushing messages, offsets will not be committed", (Object)this);
                    this.finishFailedFlush();
                    return false;
                }
            }
            if (!flushStarted) {
                this.finishSuccessfulFlush();
                log.debug("Finished {} offset commitOffsets successfully in {} ms", (Object)this, (Object)(this.time.milliseconds() - started));
                this.commitSourceTask();
                return true;
            }
        }
        Future<Void> flushFuture = this.offsetWriter.doFlush(new Callback<Void>(){

            @Override
            public void onCompletion(Throwable error, Void result) {
                if (error != null) {
                    log.error("Failed to flush {} offsets to storage: ", (Object)this, (Object)error);
                } else {
                    log.trace("Finished flushing {} offsets to storage", (Object)this);
                }
            }
        });
        if (flushFuture == null) {
            this.finishFailedFlush();
            return false;
        }
        try {
            flushFuture.get(Math.max(timeout - this.time.milliseconds(), 0L), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Flush of {} offsets interrupted, cancelling", (Object)this);
            this.finishFailedFlush();
            return false;
        }
        catch (ExecutionException e) {
            log.error("Flush of {} offsets threw an unexpected exception: ", (Object)this, (Object)e);
            this.finishFailedFlush();
            return false;
        }
        catch (TimeoutException e) {
            log.error("Timed out waiting to flush {} offsets to storage", (Object)this);
            this.finishFailedFlush();
            return false;
        }
        this.finishSuccessfulFlush();
        log.info("Finished {} commitOffsets successfully in {} ms", (Object)this, (Object)(this.time.milliseconds() - started));
        this.commitSourceTask();
        return true;
    }

    private void commitSourceTask() {
        try {
            this.task.commit();
        }
        catch (InterruptedException ex) {
            log.warn("Commit interrupted", (Throwable)ex);
        }
        catch (Throwable t) {
            log.error("Exception thrown while calling task.commit()", t);
        }
    }

    private synchronized void finishFailedFlush() {
        this.offsetWriter.cancelFlush();
        this.outstandingMessages.putAll(this.outstandingMessagesBacklog);
        this.outstandingMessagesBacklog.clear();
        this.flushing = false;
    }

    private synchronized void finishSuccessfulFlush() {
        IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> temp = this.outstandingMessages;
        this.outstandingMessages = this.outstandingMessagesBacklog;
        this.outstandingMessagesBacklog = temp;
        this.flushing = false;
    }

    public String toString() {
        return "WorkerSourceTask{id=" + this.id + '}';
    }
}

