/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WorkerTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkerTask.class);
    protected final ConnectorTaskId id;
    private final TaskStatus.Listener statusListener;
    protected final ClassLoader loader;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private volatile TargetState targetState;
    private volatile boolean stopping;
    private volatile boolean cancelled;

    public WorkerTask(ConnectorTaskId id, TaskStatus.Listener statusListener, TargetState initialState, ClassLoader loader) {
        this.id = id;
        this.statusListener = statusListener;
        this.loader = loader;
        this.targetState = initialState;
        this.stopping = false;
        this.cancelled = false;
    }

    public ConnectorTaskId id() {
        return this.id;
    }

    public ClassLoader loader() {
        return this.loader;
    }

    public abstract void initialize(TaskConfig var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerStop() {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            this.stopping = true;
            this.notifyAll();
        }
    }

    public void stop() {
        this.triggerStop();
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean awaitStop(long timeoutMs) {
        try {
            return this.shutdownLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected abstract void execute();

    protected abstract void close();

    protected boolean isStopping() {
        return this.stopping;
    }

    private void doClose() {
        try {
            this.close();
        }
        catch (Throwable t) {
            log.error("Task {} threw an uncaught and unrecoverable exception during shutdown", (Object)this.id, (Object)t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRun() throws InterruptedException {
        try {
            WorkerTask workerTask = this;
            synchronized (workerTask) {
                if (this.stopping) {
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 12] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.doClose();
                    return;
                }
                if (this.targetState == TargetState.PAUSED) {
                    this.onPause();
                    if (!this.awaitUnpause()) {
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 10, 11] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                        this.doClose();
                        return;
                    }
                }
                this.statusListener.onStartup(this.id);
            }
            this.execute();
            return;
        }
        catch (Throwable t) {
            log.error("Task {} threw an uncaught and unrecoverable exception", (Object)this.id, (Object)t);
            log.error("Task is being killed and will not recover until manually restarted");
            throw t;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onShutdown() {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            this.triggerStop();
            if (!this.cancelled) {
                this.statusListener.onShutdown(this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFailure(Throwable t) {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            this.triggerStop();
            if (!this.cancelled) {
                this.statusListener.onFailure(this.id, t);
            }
        }
    }

    protected synchronized void onPause() {
        this.statusListener.onPause(this.id);
    }

    protected synchronized void onResume() {
        this.statusListener.onResume(this.id);
    }

    @Override
    public void run() {
        ClassLoader savedLoader = Plugins.compareAndSwapLoaders(this.loader);
        try {
            this.doRun();
            this.onShutdown();
        }
        catch (Throwable t) {
            this.onFailure(t);
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        finally {
            Plugins.compareAndSwapLoaders(savedLoader);
            this.shutdownLatch.countDown();
        }
    }

    public boolean shouldPause() {
        return this.targetState == TargetState.PAUSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitUnpause() throws InterruptedException {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            while (this.targetState == TargetState.PAUSED) {
                if (this.stopping) {
                    return false;
                }
                this.wait();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionTo(TargetState state) {
        WorkerTask workerTask = this;
        synchronized (workerTask) {
            if (this.stopping) {
                return;
            }
            this.targetState = state;
            this.notifyAll();
        }
    }
}

