/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicAdmin
implements AutoCloseable {
    private static final String CLEANUP_POLICY_CONFIG = "cleanup.policy";
    private static final String CLEANUP_POLICY_COMPACT = "compact";
    private static final String MIN_INSYNC_REPLICAS_CONFIG = "min.insync.replicas";
    private static final String UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG = "unclean.leader.election.enable";
    private static final Logger log = LoggerFactory.getLogger(TopicAdmin.class);
    private final Map<String, Object> adminConfig;
    private final AdminClient admin;

    public static NewTopicBuilder defineTopic(String topicName) {
        return new NewTopicBuilder(topicName);
    }

    public TopicAdmin(Map<String, Object> adminConfig) {
        this(adminConfig, AdminClient.create(adminConfig));
    }

    TopicAdmin(Map<String, Object> adminConfig, AdminClient adminClient) {
        this.admin = adminClient;
        this.adminConfig = adminConfig != null ? adminConfig : Collections.emptyMap();
    }

    public boolean createTopic(NewTopic topic) {
        if (topic == null) {
            return false;
        }
        Set<String> newTopicNames = this.createTopics(topic);
        return newTopicNames.contains(topic.name());
    }

    public Set<String> createTopics(NewTopic ... topics) {
        HashMap<String, NewTopic> topicsByName = new HashMap<String, NewTopic>();
        if (topics != null) {
            for (NewTopic topic : topics) {
                if (topic == null) continue;
                topicsByName.put(topic.name(), topic);
            }
        }
        if (topicsByName.isEmpty()) {
            return Collections.emptySet();
        }
        String bootstrapServers = this.bootstrapServers();
        String topicNameList = Utils.join(topicsByName.keySet(), (String)"', '");
        CreateTopicsOptions args = new CreateTopicsOptions().validateOnly(false);
        Map newResults = this.admin.createTopics(topicsByName.values(), args).values();
        HashSet<String> newlyCreatedTopicNames = new HashSet<String>();
        for (Map.Entry entry : newResults.entrySet()) {
            String topic = (String)entry.getKey();
            try {
                ((KafkaFuture)entry.getValue()).get();
                log.info("Created topic {} on brokers at {}", topicsByName.get(topic), (Object)bootstrapServers);
                newlyCreatedTopicNames.add(topic);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (e.getCause() instanceof TopicExistsException) {
                    log.debug("Found existing topic '{}' on the brokers at {}", (Object)topic, (Object)bootstrapServers);
                    continue;
                }
                if (cause instanceof UnsupportedVersionException) {
                    log.error("Unable to use Kafka admin client to create topic descriptions for '{}' using the brokers at {}", (Object)topicNameList, (Object)bootstrapServers);
                    throw (UnsupportedVersionException)cause;
                }
                if (cause instanceof TimeoutException) {
                    throw new ConnectException("Timed out while checking for or creating topic(s) '" + topicNameList + "'. This could indicate a connectivity issue, unavailable topic partitions, or if this is your first use of the topic it may have taken too long to create.", cause);
                }
                throw new ConnectException("Error while attempting to create/find topic(s) '" + topicNameList + "'", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ConnectException("Interrupted while attempting to create/find topic(s) '" + topicNameList + "'", (Throwable)e);
            }
        }
        return newlyCreatedTopicNames;
    }

    @Override
    public void close() {
        this.admin.close();
    }

    private String bootstrapServers() {
        Object servers = this.adminConfig.get("bootstrap.servers");
        return servers != null ? servers.toString() : "<unknown>";
    }

    public static class NewTopicBuilder {
        private String name;
        private int numPartitions;
        private short replicationFactor;
        private Map<String, String> configs = new HashMap<String, String>();

        NewTopicBuilder(String name) {
            this.name = name;
        }

        public NewTopicBuilder partitions(int numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        public NewTopicBuilder replicationFactor(short replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public NewTopicBuilder compacted() {
            this.configs.put(TopicAdmin.CLEANUP_POLICY_CONFIG, TopicAdmin.CLEANUP_POLICY_COMPACT);
            return this;
        }

        public NewTopicBuilder minInSyncReplicas(short minInSyncReplicas) {
            this.configs.put(TopicAdmin.MIN_INSYNC_REPLICAS_CONFIG, Short.toString(minInSyncReplicas));
            return this;
        }

        public NewTopicBuilder uncleanLeaderElection(boolean allow) {
            this.configs.put(TopicAdmin.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(allow));
            return this;
        }

        public NewTopicBuilder config(Map<String, Object> configs) {
            if (configs != null) {
                for (Map.Entry<String, Object> entry : configs.entrySet()) {
                    Object value = entry.getValue();
                    this.configs.put(entry.getKey(), value != null ? value.toString() : null);
                }
            } else {
                this.configs.clear();
            }
            return this;
        }

        public NewTopic build() {
            return new NewTopic(this.name, this.numPartitions, this.replicationFactor).configs(this.configs);
        }
    }
}

