/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.UUID;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.AwaitingSync$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rus!B\u0001\u0003\u0011\u0013I\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005)qM]8va*\u0011QAB\u0001\fG>|'\u000fZ5oCR|'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\n5\u0011Qb\u0012:pkBlU\r^1eCR\f7CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b1-\u0011\r\u0011\"\u0003\u001a\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\u0005Q\u0002\u0003B\u000e#K!r!\u0001\b\u0011\u0011\u0005u\u0001R\"\u0001\u0010\u000b\u0005}A\u0011A\u0002\u001fs_>$h(\u0003\u0002\"!\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\u00075\u000b\u0007O\u0003\u0002\"!A\u0011!BJ\u0005\u0003O\t\u0011!b\u0012:pkB\u001cF/\u0019;f!\rY\u0012&J\u0005\u0003U\u0011\u00121aU3u\u0011\u0019a3\u0002)A\u00055\u0005!b/\u00197jIB\u0013XM^5pkN\u001cF/\u0019;fg\u0002BqAL\u0006\u0012\u0002\u0013\u0005q&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0002a)\u0012Q%M\u0016\u0002eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u000e\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002:i\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0007\u000b1\u0011\u0001AA\u001e\u0014\u0007irA\b\u0005\u0002>\u00016\taH\u0003\u0002@\r\u0005)Q\u000f^5mg&\u0011\u0011I\u0010\u0002\b\u0019><w-\u001b8h\u0011!\u0019%H!b\u0001\n\u0003!\u0015aB4s_V\u0004\u0018\nZ\u000b\u0002\u000bB\u00111DR\u0005\u0003\u000f\u0012\u0012aa\u0015;sS:<\u0007\u0002C%;\u0005\u0003\u0005\u000b\u0011B#\u0002\u0011\u001d\u0014x.\u001e9JI\u0002B\u0001b\u0013\u001e\u0003\u0002\u0003\u0006I!J\u0001\rS:LG/[1m'R\fG/\u001a\u0005\u0006+i\"\t!\u0014\u000b\u0004\u001d>\u0003\u0006C\u0001\u0006;\u0011\u0015\u0019E\n1\u0001F\u0011\u001dYE\n%AA\u0002\u0015BqA\u0015\u001eA\u0002\u0013%1+A\u0003ti\u0006$X-F\u0001&\u0011\u001d)&\b1A\u0005\nY\u000b\u0011b\u001d;bi\u0016|F%Z9\u0015\u0005]S\u0006CA\bY\u0013\tI\u0006C\u0001\u0003V]&$\bbB.U\u0003\u0003\u0005\r!J\u0001\u0004q\u0012\n\u0004BB/;A\u0003&Q%\u0001\u0004ti\u0006$X\r\t\u0005\b?j\u0012\r\u0011\"\u0003a\u0003\u001diW-\u001c2feN,\u0012!\u0019\t\u0005E\u001e,\u0015.D\u0001d\u0015\t!W-A\u0004nkR\f'\r\\3\u000b\u0005\u0019\u0004\u0012AC2pY2,7\r^5p]&\u0011\u0001n\u0019\u0002\b\u0011\u0006\u001c\b.T1q!\tQ!.\u0003\u0002l\u0005\tqQ*Z7cKJlU\r^1eCR\f\u0007BB7;A\u0003%\u0011-\u0001\u0005nK6\u0014WM]:!\u0011\u001dy'H1A\u0005\nA\fqa\u001c4gg\u0016$8/F\u0001r!\u0011\u0011wM]?\u0011\u0005M\\X\"\u0001;\u000b\u0005U4\u0018AB2p[6|gN\u0003\u0002\bo*\u0011\u00010_\u0001\u0007CB\f7\r[3\u000b\u0003i\f1a\u001c:h\u0013\taHO\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005)q\u0018BA@\u0003\u0005u\u0019u.\\7jiJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uC\u0006sGm\u00144gg\u0016$\bbBA\u0002u\u0001\u0006I!]\u0001\t_\u001a47/\u001a;tA!I\u0011q\u0001\u001eC\u0002\u0013%\u0011\u0011B\u0001\u0015a\u0016tG-\u001b8h\u001f\u001a47/\u001a;D_6l\u0017\u000e^:\u0016\u0005\u0005-\u0001#\u00022he\u00065\u0001\u0003BA\b\u0003'i!!!\u0005\u000b\u0005U4\u0011\u0002BA\u000b\u0003#\u0011\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0011!\tIB\u000fQ\u0001\n\u0005-\u0011!\u00069f]\u0012LgnZ(gMN,GoQ8n[&$8\u000f\t\u0005\n\u0003;Q$\u0019!C\u0005\u0003?\t\u0011\u0005]3oI&tw\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiN,\"!!\t\u0011\r\t<\u00171EA\u0015!\ry\u0011QE\u0005\u0004\u0003O\u0001\"\u0001\u0002'p]\u001e\u0004RAYA\u0016evL!aI2\t\u0011\u0005=\"\b)A\u0005\u0003C\t!\u0005]3oI&tw\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiN\u0004\u0003\"CA\u001au\u0001\u0007I\u0011BA\u001b\u0003\t\u0012XmY3jm\u0016$GK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5ugV\u0011\u0011q\u0007\t\u0004\u001f\u0005e\u0012bAA\u001e!\t9!i\\8mK\u0006t\u0007\"CA u\u0001\u0007I\u0011BA!\u0003\u0019\u0012XmY3jm\u0016$GK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5ug~#S-\u001d\u000b\u0004/\u0006\r\u0003\"C.\u0002>\u0005\u0005\t\u0019AA\u001c\u0011!\t9E\u000fQ!\n\u0005]\u0012a\t:fG\u0016Lg/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8\u000f\t\u0005\n\u0003\u0017R\u0004\u0019!C\u0005\u0003k\tQD]3dK&4X\rZ\"p]N,X.\u001a:PM\u001a\u001cX\r^\"p[6LGo\u001d\u0005\n\u0003\u001fR\u0004\u0019!C\u0005\u0003#\n\u0011E]3dK&4X\rZ\"p]N,X.\u001a:PM\u001a\u001cX\r^\"p[6LGo]0%KF$2aVA*\u0011%Y\u0016QJA\u0001\u0002\u0004\t9\u0004\u0003\u0005\u0002Xi\u0002\u000b\u0015BA\u001c\u0003y\u0011XmY3jm\u0016$7i\u001c8tk6,'o\u00144gg\u0016$8i\\7nSR\u001c\b\u0005C\u0005\u0002\\i\u0002\r\u0011\"\u0001\u0002^\u0005a\u0001O]8u_\u000e|G\u000eV=qKV\u0011\u0011q\f\t\u0005\u001f\u0005\u0005T)C\u0002\u0002dA\u0011aa\u00149uS>t\u0007\"CA4u\u0001\u0007I\u0011AA5\u0003A\u0001(o\u001c;pG>dG+\u001f9f?\u0012*\u0017\u000fF\u0002X\u0003WB\u0011bWA3\u0003\u0003\u0005\r!a\u0018\t\u0011\u0005=$\b)Q\u0005\u0003?\nQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003\"CA:u\u0001\u0007I\u0011AA;\u000319WM\\3sCRLwN\\%e+\t\t9\bE\u0002\u0010\u0003sJ1!a\u001f\u0011\u0005\rIe\u000e\u001e\u0005\n\u0003\u007fR\u0004\u0019!C\u0001\u0003\u0003\u000b\u0001cZ3oKJ\fG/[8o\u0013\u0012|F%Z9\u0015\u0007]\u000b\u0019\tC\u0005\\\u0003{\n\t\u00111\u0001\u0002x!A\u0011q\u0011\u001e!B\u0013\t9(A\u0007hK:,'/\u0019;j_:LE\r\t\u0005\t\u0003\u0017S\u0004\u0019!C\u0001\t\u0006AA.Z1eKJLE\rC\u0005\u0002\u0010j\u0002\r\u0011\"\u0001\u0002\u0012\u0006aA.Z1eKJLEm\u0018\u0013fcR\u0019q+a%\t\u0011m\u000bi)!AA\u0002\u0015Cq!a&;A\u0003&Q)A\u0005mK\u0006$WM]%eA!A\u00111\u0014\u001eA\u0002\u0013\u0005A)\u0001\u0005qe>$xnY8m\u0011%\tyJ\u000fa\u0001\n\u0003\t\t+\u0001\u0007qe>$xnY8m?\u0012*\u0017\u000fF\u0002X\u0003GC\u0001bWAO\u0003\u0003\u0005\r!\u0012\u0005\b\u0003OS\u0004\u0015)\u0003F\u0003%\u0001(o\u001c;pG>d\u0007\u0005C\u0005\u0002,j\u0002\r\u0011\"\u0001\u00026\u0005qa.Z<NK6\u0014WM]!eI\u0016$\u0007\"CAXu\u0001\u0007I\u0011AAY\u0003IqWm^'f[\n,'/\u00113eK\u0012|F%Z9\u0015\u0007]\u000b\u0019\fC\u0005\\\u0003[\u000b\t\u00111\u0001\u00028!A\u0011q\u0017\u001e!B\u0013\t9$A\boK^lU-\u001c2fe\u0006#G-\u001a3!\u0011\u001d\tYL\u000fC\u0001\u0003{\u000b!![:\u0015\t\u0005]\u0012q\u0018\u0005\b\u0003\u0003\fI\f1\u0001&\u0003)9'o\\;q'R\fG/\u001a\u0005\b\u0003\u000bTD\u0011AAd\u0003\rqw\u000e\u001e\u000b\u0005\u0003o\tI\rC\u0004\u0002B\u0006\r\u0007\u0019A\u0013\t\u000f\u00055'\b\"\u0001\u0002P\u0006\u0019\u0001.Y:\u0015\t\u0005]\u0012\u0011\u001b\u0005\b\u0003'\fY\r1\u0001F\u0003!iW-\u001c2fe&#\u0007bBAlu\u0011\u0005\u0011\u0011\\\u0001\u0004O\u0016$HcA5\u0002\\\"9\u00111[Ak\u0001\u0004)\u0005bBApu\u0011\u0005\u0011\u0011]\u0001\u0004C\u0012$GcA,\u0002d\"9\u0011Q]Ao\u0001\u0004I\u0017AB7f[\n,'\u000fC\u0004\u0002jj\"\t!a;\u0002\rI,Wn\u001c<f)\r9\u0016Q\u001e\u0005\b\u0003'\f9\u000f1\u0001F\u0011\u0019\t\tP\u000fC\u0001'\u0006a1-\u001e:sK:$8\u000b^1uK\"9\u0011Q\u001f\u001e\u0005\u0002\u0005]\u0018!\u00068pif+GOU3k_&tW\rZ'f[\n,'o]\u000b\u0003\u0003s\u0004R!a?\u0003\u0002%t1aDA\u007f\u0013\r\ty\u0010E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019A!\u0002\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u007f\u0004\u0002b\u0002B\u0005u\u0011\u0005!1B\u0001\u000bC2dW*Z7cKJ\u001cXC\u0001B\u0007!\u0015\u0011yA!\u0005F\u001b\u0005)\u0017B\u0001\u0016f\u0011\u001d\u0011)B\u000fC\u0001\u0003o\f\u0011#\u00197m\u001b\u0016l'-\u001a:NKR\fG-\u0019;b\u0011\u001d\u0011IB\u000fC\u0001\u0003k\n!C]3cC2\fgnY3US6,w.\u001e;Ng\"9!Q\u0004\u001e\u0005\u0002\t}\u0011AF4f]\u0016\u0014\u0018\r^3NK6\u0014WM]%e'V4g-\u001b=\u0016\u0005\t\u0005\u0002\u0003\u0002B\u0012\u0005[i!A!\n\u000b\t\t\u001d\"\u0011F\u0001\u0005Y\u0006twM\u0003\u0002\u0003,\u0005!!.\u0019<b\u0013\r9%Q\u0005\u0005\b\u0005cQD\u0011AA\u001b\u00031\u0019\u0017M\u001c*fE\u0006d\u0017M\\2f\u0011\u001d\u0011)D\u000fC\u0001\u0005o\tA\u0002\u001e:b]NLG/[8o)>$2a\u0016B\u001d\u0011\u001d\t\tMa\rA\u0002\u0015BaA!\u0010;\t\u0003!\u0015AD:fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0005\b\u0005\u0003RD\u0011\u0002B\"\u0003I\u0019\u0017M\u001c3jI\u0006$X\r\u0015:pi>\u001cw\u000e\\:\u0016\u0005\t\u0015\u0003#\u0002B$\u0005\u001b*UB\u0001B%\u0015\r\u0011Y%Z\u0001\nS6lW\u000f^1cY\u0016L1A\u000bB%\u0011\u001d\u0011\tF\u000fC\u0001\u0005'\n\u0011c];qa>\u0014Ho\u001d)s_R|7m\u001c7t)\u0011\t9D!\u0016\t\u0011\t]#q\na\u0001\u00053\nq\"\\3nE\u0016\u0014\bK]8u_\u000e|Gn\u001d\t\u00047%*\u0005b\u0002B/u\u0011\u0005!qL\u0001\u0013S:LGOT3yi\u001e+g.\u001a:bi&|g\u000eF\u0001X\u0011\u001d\u0011\u0019G\u000fC\u0001\u0005K\nQcY;se\u0016tG/T3nE\u0016\u0014X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0003hA)1DI#\u0003jA)qBa\u001b\u0003p%\u0019!Q\u000e\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\u0011\t(C\u0002\u0003tA\u0011AAQ=uK\"9!q\u000f\u001e\u0005\u0002\te\u0014aB:v[6\f'/_\u000b\u0003\u0005w\u00022A\u0003B?\u0013\r\u0011yH\u0001\u0002\r\u000fJ|W\u000f]*v[6\f'/\u001f\u0005\b\u0005\u0007SD\u0011\u0001BC\u0003!yg/\u001a:wS\u0016<XC\u0001BD!\rQ!\u0011R\u0005\u0004\u0005\u0017\u0013!!D$s_V\u0004xJ^3sm&,w\u000fC\u0004\u0003\u0010j\"\tA!%\u0002#%t\u0017\u000e^5bY&TXm\u00144gg\u0016$8\u000fF\u0003X\u0005'\u0013I\nC\u0004p\u0005\u001b\u0003\rA!&\u0011\r\t=!q\u0013:~\u0013\t\u0019S\r\u0003\u0005\u0003\u001c\n5\u0005\u0019\u0001BO\u0003E\u0001XM\u001c3j]\u001e$\u0006P\\(gMN,Go\u001d\t\u00077\t\n\u0019#!\u000b\t\u000f\t\u0005&\b\"\u0001\u0003$\u0006!rN\\(gMN,GoQ8n[&$\u0018\t\u001d9f]\u0012$Ra\u0016BS\u0005SCqAa*\u0003 \u0002\u0007!/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\t-&q\u0014a\u0001{\u0006qrN\u001a4tKR<\u0016\u000e\u001e5D_6l\u0017\u000e\u001e*fG>\u0014H-T3uC\u0012\fG/\u0019\u0005\b\u0005_SD\u0011\u0001BY\u0003Y1\u0017-\u001b7QK:$\u0017N\\4PM\u001a\u001cX\r^,sSR,G#B,\u00034\nU\u0006b\u0002BT\u0005[\u0003\rA\u001d\u0005\t\u0005o\u0013i\u000b1\u0001\u0002\u000e\u00051qN\u001a4tKRDqAa/;\t\u0003\u0011i,A\nqe\u0016\u0004\u0018M]3PM\u001a\u001cX\r^\"p[6LG\u000fF\u0002X\u0005\u007fCqa\u001cB]\u0001\u0004\u0011\t\rE\u0003\u001cEI\fi\u0001C\u0004\u0003Fj\"\tAa2\u0002-A\u0014X\r]1sKRChn\u00144gg\u0016$8i\\7nSR$Ra\u0016Be\u0005\u001bD\u0001Ba3\u0003D\u0002\u0007\u00111E\u0001\u000baJ|G-^2fe&#\u0007bB8\u0003D\u0002\u0007!\u0011\u0019\u0005\b\u0005#TD\u0011AA\u001b\u0003\tB\u0017m\u001d*fG\u0016Lg/\u001a3D_:\u001c\u0018n\u001d;f]R|eMZ:fi\u000e{W.\\5ug\"9!Q\u001b\u001e\u0005\u0002\t]\u0017A\u00074bS2\u0004VM\u001c3j]\u001e$\u0006P\\(gMN,GoQ8n[&$H#B,\u0003Z\nm\u0007\u0002\u0003Bf\u0005'\u0004\r!a\t\t\u000f\t\u001d&1\u001ba\u0001e\"9!q\u001c\u001e\u0005\u0002\t\u0005\u0018aF8o)btwJ\u001a4tKR\u001cu.\\7ji\u0006\u0003\b/\u001a8e)\u001d9&1\u001dBs\u0005OD\u0001Ba3\u0003^\u0002\u0007\u00111\u0005\u0005\b\u0005O\u0013i\u000e1\u0001s\u0011\u001d\u0011IO!8A\u0002u\fQdY8n[&$(+Z2pe\u0012lU\r^1eCR\f\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0005[TD\u0011\u0001Bx\u0003y\u0019w.\u001c9mKR,\u0007+\u001a8eS:<G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fF\u0003X\u0005c\u0014\u0019\u0010\u0003\u0005\u0003L\n-\b\u0019AA\u0012\u0011!\u0011)Pa;A\u0002\u0005]\u0012\u0001C5t\u0007>lW.\u001b;\t\u000f\te(\b\"\u0001\u0003|\u0006y\u0011m\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148/\u0006\u0002\u0003~B1!q\u0002B\t\u0003GAqa!\u0001;\t\u0003\u0019\u0019!A\u0012iCN\u0004VM\u001c3j]\u001e|eMZ:fi\u000e{W.\\5ug\u001a\u0013x.\u001c)s_\u0012,8-\u001a:\u0015\t\u0005]2Q\u0001\u0005\t\u0005\u0017\u0014y\u00101\u0001\u0002$!91\u0011\u0002\u001e\u0005\u0002\r-\u0011!\u0004:f[>4Xm\u00144gg\u0016$8\u000f\u0006\u0003\u0004\u000e\rE\u0001c\u0002B$\u0007\u001f\u0011\u0018QB\u0005\u0004G\t%\u0003\u0002CB\n\u0007\u000f\u0001\ra!\u0006\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004RAa\u0004\u0004\u0018IL1a!\u0007f\u0005\r\u0019V-\u001d\u0005\b\u0007;QD\u0011AB\u0010\u0003Q\u0011X-\\8wK\u0016C\b/\u001b:fI>3gm]3ugR!!\u0011YB\u0011\u0011!\u0019\u0019ca\u0007A\u0002\u0005\r\u0012aB:uCJ$Xj\u001d\u0005\b\u0007OQD\u0011AB\u0015\u0003)\tG\u000e\\(gMN,Go]\u000b\u0003\u0007\u001bAqAa.;\t\u0003\u0019i\u0003\u0006\u0003\u00040\rE\u0002#B\b\u0002b\u00055\u0001b\u0002BT\u0007W\u0001\rA\u001d\u0005\t\u0007kQD\u0011\u0001\u0002\u00048\u0005ArN\u001a4tKR<\u0016\u000e\u001e5SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1\u0015\t\re21\b\t\u0005\u001f\u0005\u0005T\u0010C\u0004\u0003(\u000eM\u0002\u0019\u0001:\t\u000f\r}\"\b\"\u0001\u0002v\u0005Qa.^7PM\u001a\u001cX\r^:\t\u000f\r\r#\b\"\u0001\u00026\u0005Q\u0001.Y:PM\u001a\u001cX\r^:\t\u000f\r\u001d#\b\"\u0003\u0004J\u0005)\u0012m]:feR4\u0016\r\\5e)J\fgn]5uS>tGcA,\u0004L!91QJB#\u0001\u0004)\u0013a\u0003;be\u001e,Go\u0015;bi\u0016Dqa!\u0015;\t\u0003\u001a\u0019&\u0001\u0005u_N#(/\u001b8h)\u0005)\u0005f\u0001\u001e\u0004XA\u0019Qh!\u0017\n\u0007\rmcHA\u0007o_:$\bN]3bIN\fg-\u001a")
public class GroupMetadata
implements Logging {
    private final String groupId;
    private GroupState state;
    private final HashMap<String, MemberMetadata> members;
    private final HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets;
    private final HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits;
    private final HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits;
    private boolean receivedTransactionalOffsetCommits;
    private boolean receivedConsumerOffsetCommits;
    private Option<String> protocolType;
    private int generationId;
    private String leaderId;
    private String protocol;
    private boolean newMemberAdded;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static GroupState $lessinit$greater$default$2() {
        return GroupMetadata$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        GroupMetadata groupMetadata = this;
        synchronized (groupMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    private HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets() {
        return this.offsets;
    }

    private HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits() {
        return this.pendingOffsetCommits;
    }

    private HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits() {
        return this.pendingTransactionalOffsetCommits;
    }

    private boolean receivedTransactionalOffsetCommits() {
        return this.receivedTransactionalOffsetCommits;
    }

    private void receivedTransactionalOffsetCommits_$eq(boolean x$1) {
        this.receivedTransactionalOffsetCommits = x$1;
    }

    private boolean receivedConsumerOffsetCommits() {
        return this.receivedConsumerOffsetCommits;
    }

    private void receivedConsumerOffsetCommits_$eq(boolean x$1) {
        this.receivedConsumerOffsetCommits = x$1;
    }

    public Option<String> protocolType() {
        return this.protocolType;
    }

    public void protocolType_$eq(Option<String> x$1) {
        this.protocolType = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(String x$1) {
        this.leaderId = x$1;
    }

    public String protocol() {
        return this.protocol;
    }

    public void protocol_$eq(String x$1) {
        this.protocol = x$1;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    public void newMemberAdded_$eq(boolean x$1) {
        this.newMemberAdded = x$1;
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 == null ? groupState3 != null : !groupState2.equals(groupState3);
    }

    public boolean has(String memberId) {
        return this.members().contains((Object)memberId);
    }

    public MemberMetadata get(String memberId) {
        return (MemberMetadata)this.members().apply((Object)memberId);
    }

    public void add(MemberMetadata member) {
        if (this.members().isEmpty()) {
            this.protocolType_$eq((Option<String>)new Some((Object)member.protocolType()));
        }
        String string = this.groupId();
        String string2 = member.groupId();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Object object = this.protocolType().orNull(Predef$.MODULE$.$conforms());
        String string3 = member.protocolType();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string3) : string3 != null));
        Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
        if (this.leaderId() == null) {
            this.leaderId_$eq(member.memberId());
        }
        this.members().put((Object)member.memberId(), (Object)member);
    }

    public void remove(String memberId) {
        block0: {
            this.members().remove((Object)memberId);
            String string = memberId;
            String string2 = this.leaderId();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.leaderId_$eq(this.members().isEmpty() ? null : (String)this.members().keys().head());
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$notYetRejoinedMembers$1(x$1)))).toList();
    }

    public Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeoutMs() {
        return BoxesRunTime.unboxToInt((Object)this.members().values().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(timeout, member) -> BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)timeout)), member.rebalanceTimeoutMs()))));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    public boolean canRebalance() {
        return ((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)PreparingRebalance$.MODULE$)).contains((Object)this.state());
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        scala.collection.immutable.Set<String> candidates = this.candidateProtocols();
        List votes = ((TraversableLike)this.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.vote(candidates), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())).toList();
        return (String)((Tuple2)votes.maxBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
    }

    private scala.collection.immutable.Set<String> candidateProtocols() {
        return (scala.collection.immutable.Set)((LinearSeqOptimized)this.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.protocols(), List$.MODULE$.canBuildFrom())).reduceLeft((Function2 & Serializable & scala.Serializable)(commonProtocols, protocols) -> (scala.collection.immutable.Set)commonProtocols.$amp((GenSet)protocols));
    }

    public boolean supportsProtocols(scala.collection.immutable.Set<String> memberProtocols) {
        return this.members().isEmpty() || ((TraversableOnce)memberProtocols.$amp(this.candidateProtocols())).nonEmpty();
    }

    public void initNextGeneration() {
        List<MemberMetadata> list = this.notYetRejoinedMembers();
        List list2 = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list != null ? !list.equals((Object)list2) : list2 != null));
        if (this.members().nonEmpty()) {
            this.generationId_$eq(this.generationId() + 1);
            this.protocol_$eq(this.selectProtocol());
            this.transitionTo(AwaitingSync$.MODULE$);
        } else {
            this.generationId_$eq(this.generationId() + 1);
            this.protocol_$eq(null);
            this.transitionTo(Empty$.MODULE$);
        }
        this.receivedConsumerOffsetCommits_$eq(false);
        this.receivedTransactionalOffsetCommits_$eq(false);
    }

    public scala.collection.immutable.Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String memberId = (String)tuple2._1();
            MemberMetadata memberMetadata = (MemberMetadata)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)memberMetadata.metadata(this.protocol()));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            List members = ((TraversableOnce)this.members().values().map((Function1 & Serializable & scala.Serializable)member -> member.summary(this.protocol()), Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), this.protocol(), (List<MemberSummary>)members);
        } else {
            List members = ((TraversableOnce)this.members().values().map((Function1 & Serializable & scala.Serializable)member -> member.summaryNoMetadata(), Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), GroupCoordinator$.MODULE$.NoProtocol(), (List<MemberSummary>)members);
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public void initializeOffsets(Map<TopicPartition, CommitRecordMetadataAndOffset> offsets, scala.collection.immutable.Map<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTxnOffsets) {
        this.offsets().$plus$plus$eq(offsets);
        this.pendingTransactionalOffsetCommits().$plus$plus$eq(pendingTxnOffsets);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onOffsetCommitAppend(TopicPartition topicPartition, CommitRecordMetadataAndOffset offsetWithCommitRecordMetadata) {
        Object object;
        if (this.pendingOffsetCommits().contains((Object)topicPartition)) {
            if (offsetWithCommitRecordMetadata.appendedBatchOffset().isEmpty()) {
                throw new IllegalStateException("Cannot complete offset commit write without providing the metadata of the record in the log.");
            }
            object = !this.offsets().contains((Object)topicPartition) || ((CommitRecordMetadataAndOffset)this.offsets().apply((Object)topicPartition)).olderThan(offsetWithCommitRecordMetadata) ? this.offsets().put((Object)topicPartition, (Object)offsetWithCommitRecordMetadata) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option option = this.pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata stagedOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offsetWithCommitRecordMetadata.offsetAndMetadata();
            OffsetAndMetadata offsetAndMetadata2 = stagedOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void failPendingOffsetWrite(TopicPartition topicPartition, OffsetAndMetadata offset) {
        Option option = this.pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata pendingOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offset;
            OffsetAndMetadata offsetAndMetadata2 = pendingOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void prepareOffsetCommit(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.receivedConsumerOffsetCommits_$eq(true);
        this.pendingOffsetCommits().$plus$plus$eq(offsets);
    }

    public void prepareTxnOffsetCommit(long producerId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " is pending"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId), this.groupId(), offsets})));
        this.receivedTransactionalOffsetCommits_$eq(true);
        scala.collection.mutable.Map producerOffsets = (scala.collection.mutable.Map)this.pendingTransactionalOffsetCommits().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        offsets.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
            Option option = producerOffsets.put((Object)topicPartition, (Object)new CommitRecordMetadataAndOffset((Option<Object>)None$.MODULE$, offsetAndMetadata));
            return option;
        });
    }

    public boolean hasReceivedConsistentOffsetCommits() {
        return !this.receivedConsumerOffsetCommits() || !this.receivedTransactionalOffsetCommits();
    }

    public void failPendingTxnOffsetCommit(long producerId, TopicPartition topicPartition) {
        Option option = this.pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)some.value();
            Option pendingOffsetCommit = pendingOffsets.remove((Object)topicPartition);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId), this.groupId(), pendingOffsetCommit})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be appended to the log"})).s((Seq)Nil$.MODULE$));
            if (pendingOffsets.isEmpty()) {
                this.pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onTxnOffsetCommitAppend(long producerId, TopicPartition topicPartition, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        block3: {
            block2: {
                var6_4 = this.pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
                if (!(var6_4 instanceof Some)) break block2;
                var7_5 = (Some)var6_4;
                pendingOffset = (scala.collection.mutable.Map)var7_5.value();
                if (!pendingOffset.contains((Object)topicPartition)) ** GOTO lbl-1000
                v0 = ((CommitRecordMetadataAndOffset)pendingOffset.apply((Object)topicPartition)).offsetAndMetadata();
                var9_7 = commitRecordMetadataAndOffset.offsetAndMetadata();
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    pendingOffset.update((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                var5_8 = v1;
                break block3;
            }
            var5_9 = BoxedUnit.UNIT;
        }
    }

    public void completePendingTxnOffsetCommit(long producerId, boolean isCommit) {
        Option pendingOffsetsOpt = this.pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
        if (isCommit) {
            pendingOffsetsOpt.foreach((Function1 & Serializable & scala.Serializable)pendingOffsets -> {
                pendingOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
                        if (commitRecordMetadataAndOffset.appendedBatchOffset().isEmpty()) {
                            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete a transactional offset commit for producerId ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId$3)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and groupId ", " even though the the offset commit record itself hasn't been appended to the log."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.groupId()})));
                        }
                        Option currentOffsetOpt = $this.offsets().get((Object)topicPartition);
                        if (currentOffsetOpt.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.olderThan(commitRecordMetadataAndOffset)))) {
                            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId$3), $this.groupId(), commitRecordMetadataAndOffset})) + "committed and loaded into the cache.");
                            boxedUnit = $this.offsets().put((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                        } else {
                            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId$3), $this.groupId(), commitRecordMetadataAndOffset})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed, but not loaded since its offset is older than current offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentOffsetOpt})));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
                return BoxedUnit.UNIT;
            });
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId), this.groupId(), pendingOffsetsOpt})));
        }
    }

    public Set<Object> activeProducers() {
        return this.pendingTransactionalOffsetCommits().keySet();
    }

    public boolean hasPendingOffsetCommitsFromProducer(long producerId) {
        return this.pendingTransactionalOffsetCommits().contains((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeOffsets(Seq<TopicPartition> topicPartitions) {
        return ((TraversableOnce)topicPartitions.flatMap((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.pendingOffsetCommits().remove(topicPartition);
            this.pendingTransactionalOffsetCommits().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)tuple2._2();
                Option option = pendingOffsets.remove(topicPartition);
                return option;
            });
            Option removedOffset = this.offsets().remove(topicPartition);
            return Option$.MODULE$.option2Iterable(removedOffset.map((Function1 & Serializable & scala.Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)x$7.offsetAndMetadata())));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeExpiredOffsets(long startMs) {
        HashMap expiredOffsets = (HashMap)((TraversableLike)this.offsets().filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$removeExpiredOffsets$1(this, startMs, x0$5)))).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordOffsetAndMetadata = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordOffsetAndMetadata.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
        this.offsets().$minus$minus$eq((TraversableOnce)expiredOffsets.keySet());
        return expiredOffsets.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> allOffsets() {
        return ((TraversableOnce)this.offsets().map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordMetadataAndOffset.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<OffsetAndMetadata> offset(TopicPartition topicPartition) {
        return this.offsets().get((Object)topicPartition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.offsetAndMetadata());
    }

    public Option<CommitRecordMetadataAndOffset> offsetWithRecordMetadata(TopicPartition topicPartition) {
        return this.offsets().get((Object)topicPartition);
    }

    public int numOffsets() {
        return this.offsets().size();
    }

    public boolean hasOffsets() {
        return this.offsets().nonEmpty() || this.pendingOffsetCommits().nonEmpty() || this.pendingTransactionalOffsetCommits().nonEmpty();
    }

    private void assertValidTransition(GroupState targetState) {
        if (!((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).contains((Object)this.state())) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).mkString(","), targetState, this.state()})));
        }
    }

    public String toString() {
        return "GroupMetadata(" + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"groupId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.groupId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generation=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.generationId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"protocolType=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.protocolType()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentState=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentState()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"members=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.members()}));
    }

    public static final /* synthetic */ boolean $anonfun$notYetRejoinedMembers$1(MemberMetadata x$1) {
        return x$1.awaitingJoinCallback() == null;
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredOffsets$1(GroupMetadata $this, long startMs$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
        boolean bl = commitRecordMetadataAndOffset.offsetAndMetadata().expireTimestamp() < startMs$1 && !$this.pendingOffsetCommits().contains((Object)topicPartition);
        return bl;
    }

    public GroupMetadata(String groupId, GroupState initialState) {
        this.groupId = groupId;
        Logging.$init$(this);
        this.state = initialState;
        this.members = new HashMap();
        this.offsets = new HashMap();
        this.pendingOffsetCommits = new HashMap();
        this.pendingTransactionalOffsetCommits = new HashMap();
        this.receivedTransactionalOffsetCommits = false;
        this.receivedConsumerOffsetCommits = false;
        this.protocolType = None$.MODULE$;
        this.generationId = 0;
        this.leaderId = null;
        this.protocol = null;
        this.newMemberAdded = false;
    }
}

