/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.common.KafkaException;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%v!B\u0001\u0003\u0011\u0003I\u0011a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0006ue\u0006t7/Y2uS>t'BA\u0003\u0007\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QBA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4feN\u00111B\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bUYA\u0011\u0001\f\u0002\rqJg.\u001b;?)\u0005I\u0001b\u0002\r\f\u0005\u0004%\t!G\u0001 \t\u00164\u0017-\u001e7u)J\fgn]1di&|gn]'bqRKW.Z8vi6\u001bX#\u0001\u000e\u0011\u0005=Y\u0012B\u0001\u000f\u0011\u0005\rIe\u000e\u001e\u0005\u0007=-\u0001\u000b\u0011\u0002\u000e\u0002A\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5\u000f\t\u0005\bA-\u0011\r\u0011\"\u0001\u001a\u0003\t\"UMZ1vYR$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\"1!e\u0003Q\u0001\ni\t1\u0005R3gCVdG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005C\u0004%\u0017\t\u0007I\u0011A\r\u0002U\u0011+g-Y;mi\u0006\u0013wN\u001d;US6,GmT;u)J\fgn]1di&|gn]%oi\u0016\u0014h/\u00197Ng\"1ae\u0003Q\u0001\ni\t1\u0006R3gCVdG/\u00112peR$\u0016.\\3e\u001fV$HK]1og\u0006\u001cG/[8og&sG/\u001a:wC2l5\u000f\t\u0005\bQ-\u0011\r\u0011\"\u0001\u001a\u00039\"UMZ1vYR\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001c;feZ\fG.T:\t\r)Z\u0001\u0015!\u0003\u001b\u0003=\"UMZ1vYR\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001c;feZ\fG.T:!\r\u0011a!\u0001\u0001\u0017\u0014\u0007-rQ\u0006\u0005\u0002/c5\tqF\u0003\u00021\r\u0005)Q\u000f^5mg&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0011!!4F!A!\u0002\u0013Q\u0012\u0001\u00032s_.,'/\u00133\t\u0011YZ#\u0011!Q\u0001\n]\nqA_6Vi&d7\u000f\u0005\u0002/q%\u0011\u0011h\f\u0002\b5.,F/\u001b7t\u0011!Y4F!A!\u0002\u0013a\u0014!C:dQ\u0016$W\u000f\\3s!\tqS(\u0003\u0002?_\tI1k\u00195fIVdWM\u001d\u0005\t\u0001.\u0012\t\u0011)A\u0005\u0003\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0007\u0003\u0019\u0019XM\u001d<fe&\u0011ai\u0011\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!A5F!A!\u0002\u0013I\u0015AB2p]\u001aLw\r\u0005\u0002\u000b\u0015&\u00111J\u0001\u0002\u0012)J\fgn]1di&|gnQ8oM&<\u0007\u0002C',\u0005\u0003\u0005\u000b\u0011\u0002(\u0002\tQLW.\u001a\t\u0003\u001fbk\u0011\u0001\u0015\u0006\u0003aES!AU*\u0002\r\r|W.\\8o\u0015\t9AK\u0003\u0002V-\u00061\u0011\r]1dQ\u0016T\u0011aV\u0001\u0004_J<\u0017BA-Q\u0005\u0011!\u0016.\\3\t\u000bUYC\u0011A.\u0015\u000fqkfl\u00181bEB\u0011!b\u000b\u0005\u0006ii\u0003\rA\u0007\u0005\u0006mi\u0003\ra\u000e\u0005\u0006wi\u0003\r\u0001\u0010\u0005\u0006\u0001j\u0003\r!\u0011\u0005\u0006\u0011j\u0003\r!\u0013\u0005\u0006\u001bj\u0003\rAT\u0003\u0005I.\u0002QM\u0001\fTK:$G\u000b\u001f8NCJ\\WM]:DC2d'-Y2l!!ya\r\u001b\u000etsr|\u0018BA4\u0011\u0005%1UO\\2uS>tW\u0007\u0005\u0002ja:\u0011!N\u001c\t\u0003WBi\u0011\u0001\u001c\u0006\u0003[\"\ta\u0001\u0010:p_Rt\u0014BA8\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\u0004\u0002C\u0001;x\u001b\u0005)(B\u0001<R\u0003!\u0011X-];fgR\u001c\u0018B\u0001=v\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\t\u0003\u0015iL!a\u001f\u0002\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0011\u0005)i\u0018B\u0001@\u0003\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u0011\u0007=\t\t!C\u0002\u0002\u0004A\u0011A!\u00168ji\"I\u0011qA\u0016C\u0002\u0013%\u0011\u0011B\u0001\rg\",H\u000f^5oO\u0012{wO\\\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002 5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003+\t9\"\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0007\u0002\u001c\u0005!Q\u000f^5m\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003\u001f\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA\u0013W\u0001\u0006I!a\u0003\u0002\u001bMDW\u000f\u001e;j]\u001e$un\u001e8!\u0011%\tIc\u000bb\u0001\n\u0013\tY#A\u0005ti\u0006$X\rT8dWV\u0011\u0011Q\u0006\t\u0005\u0003_\t)$\u0004\u0002\u00022)!\u00111GA\n\u0003\u0015awnY6t\u0013\u0011\t9$!\r\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.D\u0001\"a\u000f,A\u0003%\u0011QF\u0001\u000bgR\fG/\u001a'pG.\u0004\u0003\"CA W\t\u0007I\u0011BA!\u0003Eaw.\u00193j]\u001e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u0007\u0002b!!\u0012\u0002P\u0005MSBAA$\u0015\u0011\tI%a\u0013\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\n\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0005\u001d#aA*fiB\u0019!\"!\u0016\n\u0007\u0005]#A\u0001\u0012Ue\u0006t7/Y2uS>t\u0007+\u0019:uSRLwN\\!oI2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\t\u00037Z\u0003\u0015!\u0003\u0002D\u0005\u0011Bn\\1eS:<\u0007+\u0019:uSRLwN\\:!\u0011%\tyf\u000bb\u0001\n\u0013\t\t%A\tmK\u00064\u0018N\\4QCJ$\u0018\u000e^5p]ND\u0001\"a\u0019,A\u0003%\u00111I\u0001\u0013Y\u0016\fg/\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0005\u0002h-\u0012\r\u0011\"\u0003\u0002j\u0005ABO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005-\u0004cBA#\u0003[R\u0012\u0011O\u0005\u0005\u0003_\n9EA\u0002NCB\u00042ACA:\u0013\r\t)H\u0001\u0002\u0016)btW*\u001a;bI\u0006$\u0018mQ1dQ\u0016,e\u000e\u001e:z\u0011!\tIh\u000bQ\u0001\n\u0005-\u0014!\u0007;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7)Y2iK\u0002B\u0001\"! ,\u0005\u0004%I!G\u0001\u001fiJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RDq!!!,A\u0003%!$A\u0010ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u0002B\u0001\"!\",\t\u0003\u0011\u0011qQ\u0001\u0014C\u0012$Gj\\1eS:<\u0007+\u0019:uSRLwN\u001c\u000b\u0006\u007f\u0006%\u0015Q\u0012\u0005\b\u0003\u0017\u000b\u0019\t1\u0001\u001b\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\u0005=\u00151\u0011a\u00015\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\b\u0003'[C\u0011AAK\u0003Q!\u0018.\\3e\u001fV$HK]1og\u0006\u001cG/[8ogR\u0011\u0011q\u0013\t\u0007\u00033\u000b\u0019+!+\u000f\t\u0005m\u0015q\u0014\b\u0004W\u0006u\u0015\"A\t\n\u0007\u0005\u0005\u0006#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0016q\u0015\u0002\t\u0013R,'/\u00192mK*\u0019\u0011\u0011\u0015\t\u0011\u0007)\tY+C\u0002\u0002.\n\u0011\u0011\u0005\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ!oIB\u0013x\u000eZ;dKJLE-\u00129pG\"Dq!!-,\t\u0003\t\u0019,A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$\u0012a \u0005\b\u0003o[C\u0011AA]\u0003M9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f)\u0011\tY,!7\u0011\u0011\u0005e\u0015QXAa\u0003\u001bLA!a0\u0002(\n1Q)\u001b;iKJ\u0004B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000f\f\u0016\u0001\u00039s_R|7m\u001c7\n\t\u0005-\u0017Q\u0019\u0002\u0007\u000bJ\u0014xN]:\u0011\u000b=\ty-a5\n\u0007\u0005E\u0007C\u0001\u0004PaRLwN\u001c\t\u0004\u0015\u0005U\u0017bAAl\u0005\tq2i\\8sI&t\u0017\r^8s\u000bB|7\r[!oIRCh.T3uC\u0012\fG/\u0019\u0005\b\u00037\f)\f1\u0001i\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007bBApW\u0011\u0005\u0011\u0011]\u0001\u001faV$HK]1og\u0006\u001cG/[8o'R\fG/Z%g\u001d>$X\t_5tiN$b!a9\u0002f\u0006\u001d\b\u0003CAM\u0003{\u000b\t-a5\t\u000f\u0005m\u0017Q\u001ca\u0001Q\"9\u0011\u0011^Ao\u0001\u0004I\u0018a\u0003;y]6+G/\u00193bi\u0006Dq!!<,\t\u0013\ty/\u0001\u0010hKR\fe\u000eZ'bs\n,\u0017\t\u001a3Ue\u0006t7/Y2uS>t7\u000b^1uKR1\u00111XAy\u0003gDq!a7\u0002l\u0002\u0007\u0001\u000e\u0003\u0005\u0002v\u0006-\b\u0019AA|\u0003U\u0019'/Z1uK\u0012$\u0006P\\'fi\u0006$\u0017\r^1PaR\u0004BaDAhs\"9\u00111`\u0016\u0005\u0002\u0005u\u0018\u0001\b<bY&$\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u000b\u0005\u0003\u007f\u0014)\u0001E\u0002\u0010\u0005\u0003I1Aa\u0001\u0011\u0005\u001d\u0011un\u001c7fC:DqAa\u0002\u0002z\u0002\u0007!$\u0001\u0007uq:$\u0016.\\3pkRl5\u000fC\u0004\u0003\f-\"\tA!\u0004\u0002/Q\u0014\u0018M\\:bGRLwN\u001c+pa&\u001c7i\u001c8gS\u001e\u001cXC\u0001B\b!\u0011\u0011\tBa\u0005\u000e\u0005\u0005]\u0011\u0002\u0002B\u000b\u0003/\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011Ib\u000bC\u0001\u00057\tA\u0002]1si&$\u0018n\u001c8G_J$2A\u0007B\u000f\u0011\u001d\tYNa\u0006A\u0002!DaA!\t,\t\u0013I\u0012!I4fiR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\bb\u0002B\u0013W\u0011%!qE\u0001\u0018Y>\fG\r\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$bA!\u000b\u00030\tm\u0002#\u0002\u0018\u0003,!L\u0018b\u0001B\u0017_\t!\u0001k\\8m\u0011!\u0011\tDa\tA\u0002\tM\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0005k\u00119$D\u0001R\u0013\r\u0011I$\u0015\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tyIa\tA\u0002iA\u0001Ba\u0010,\t\u0003\u0011!\u0011I\u0001\u001dC\u0012$Gj\\1eK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)>\u001c\u0015m\u00195f)\u001dy(1\tB$\u0005\u0013BqA!\u0012\u0003>\u0001\u0007!$A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a$\u0003>\u0001\u0007!\u0004\u0003\u0005\u0003L\tu\u0002\u0019\u0001B\u0015\u0003iiW\r^1eCR\f\u0007+\u001a:Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0011\u001d\u0011ye\u000bC\u0001\u0005#\nA\u0005\\8bIR\u0013\u0018M\\:bGRLwN\\:G_J$\u0006P\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\b\u007f\nM#Q\u000bB,\u0011\u001d\tYI!\u0014A\u0002iAq!a$\u0003N\u0001\u0007!\u0004\u0003\u0005\u0003Z\t5\u0003\u0019\u0001B.\u00039\u0019XM\u001c3Uq:l\u0015M]6feN\u00042A!\u0018d\u001b\u0005Y\u0003b\u0002B1W\u0011\u0005!1M\u0001'e\u0016lwN^3Ue\u0006t7/Y2uS>t7OR8s)btGk\u001c9jGB\u000b'\u000f^5uS>tG#B@\u0003f\t\u001d\u0004bBAF\u0005?\u0002\rA\u0007\u0005\b\u0003\u001f\u0013y\u00061\u0001\u001b\u0011\u001d\u0011Yg\u000bC\u0005\u0003g\u000baF^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0013N\u001cF/\u00192mK\"9!qN\u0016\u0005\u0002\tE\u0014AF1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4\u0015\u0017}\u0014\u0019H!\u001e\u0003x\tm$Q\u0011\u0005\b\u00037\u0014i\u00071\u0001i\u0011\u001d\tyI!\u001cA\u0002iAqA!\u001f\u0003n\u0001\u0007A0A\u0006oK^lU\r^1eCR\f\u0007\u0002\u0003B?\u0005[\u0002\rAa \u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007CB\b\u0003\u0002\u0006\u0005w0C\u0002\u0003\u0004B\u0011\u0011BR;oGRLwN\\\u0019\t\u0015\t\u001d%Q\u000eI\u0001\u0002\u0004\u0011I)\u0001\u0007sKR\u0014\u0018p\u00148FeJ|'\u000fE\u0004\u0010\u0005\u0003\u000b\t-a@\t\u000f\t55\u0006\"\u0001\u00024\u0006A1\u000f[;uI><h\u000eC\u0005\u0003\u0012.\n\n\u0011\"\u0001\u0003\u0014\u0006\u0001\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{w\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011)J\u000b\u0003\u0003\n\n]5F\u0001BM!\u0011\u0011YJ!*\u000e\u0005\tu%\u0002\u0002BP\u0005C\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\r\u0006#\u0001\u0006b]:|G/\u0019;j_:LAAa*\u0003\u001e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TransactionStateManager
implements Logging {
    private final ZkUtils zkUtils;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final Set<TransactionPartitionAndLeaderEpoch> leavingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TransactionStateManager transactionStateManager = this;
        synchronized (transactionStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    private Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    private Set<TransactionPartitionAndLeaderEpoch> leavingPartitions() {
        return this.leavingPartitions;
    }

    private scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        long now = this.time.milliseconds();
        return (Iterable)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> (Iterable)((TraversableLike)this.transactionMetadataCache().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$2(this, x0$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
            Iterable iterable = (Iterable)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$5(now, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String txnId = (String)tuple2._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long now = $this.time.milliseconds();
            CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map transactionalIdByPartition = ((TraversableLike)this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
                    Iterable iterable = (Iterable)((TraversableLike)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$6)))).filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5(this, now, x0$7)))).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                        TxnTransitMetadata txnTransitMetadata;
                        String transactionalId;
                        Tuple2 tuple2 = x0$8;
                        if (tuple2 != null) {
                            TransactionMetadata txnMetadata;
                            transactionalId = (String)tuple2._1();
                            TransactionMetadata transactionMetadata = txnMetadata = (TransactionMetadata)tuple2._2();
                            synchronized (transactionMetadata) {
                                txnTransitMetadata = txnMetadata.prepareDead();
                            }
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        TxnTransitMetadata txnMetadataTransition = txnTransitMetadata;
                        TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                        return transactionalIdCoordinatorEpochAndMetadata;
                    }, Iterable$.MODULE$.canBuildFrom());
                    return iterable;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
                scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                    Tuple2 tuple2 = x0$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int partition = tuple2._1$mcI$sp();
                    scala.collection.mutable.Iterable transactionalIdCoordinatorEpochAndMetadatas = (scala.collection.mutable.Iterable)tuple2._2();
                    SimpleRecord[] deletes = (SimpleRecord[])((TraversableOnce)transactionalIdCoordinatorEpochAndMetadatas.map((Function1 & Serializable & scala.Serializable)entry -> new SimpleRecord(now, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                    MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])deletes);
                    TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)records);
                    return tuple22;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responses -> {
                    this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
                    return BoxedUnit.UNIT;
                }, (Option<Object>)None$.MODULE$);
            });
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(String transactionalId, TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)new Some((Object)txnMetadata)).right().map((Function1 & Serializable & scala.Serializable)x$2 -> (CoordinatorEpochAndTxnMetadata)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected empty transaction metadata returned while putting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata})));
        }));
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        return (Either)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            int partitionId = this.partitionFor(transactionalId);
            if (this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$3)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
            } else if (this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(partitionId, x$4)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
            } else {
                Left left2;
                Option option = this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)some.value();
                    Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId)).orElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadataOpt.map((Function1 & Serializable & scala.Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadata)));
                    left2 = package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable & scala.Serializable)x$5 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$5)));
                } else if (None$.MODULE$.equals(option)) {
                    left2 = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                } else {
                    throw new MatchError((Object)option);
                }
                left = left2;
            }
            return left;
        });
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogMinInsyncReplicas())).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogSegmentBytes())).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        return BoxesRunTime.unboxToInt((Object)this.zkUtils.getTopicPartitionCount("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.config.transactionLogNumPartitions()));
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to load offsets and group metadata from ", ", but found no log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Log log = (Log)some.value();
            LazyRef buffer$lzy = new LazyRef();
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && !this.shuttingDown().get() && BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition, coordinatorEpoch, idAndEpoch)))))) {
                    MemoryRecords memoryRecords;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), (Option<Object>)None$.MODULE$, true, IsolationLevel.READ_UNCOMMITTED);
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        MemoryRecords memoryRecords2;
                        memoryRecords = memoryRecords2 = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        this.buffer$1(buffer$lzy).clear();
                        ByteBuffer bufferRead = fileRecords.readInto(this.buffer$1(buffer$lzy), 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)bufferRead);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    MemoryRecords memRecords = memoryRecords;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$5(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished loading ", " transaction metadata from ", " in ", " milliseconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)loadedTransactions.size()), topicPartition, BoxesRunTime.boxToLong((long)($this.time.milliseconds() - startMs))})));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error loading transactions from transaction log ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> metadataPerTransactionalId) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, metadataPerTransactionalId);
        Option currentTxnMetadataCacheEntry = this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry);
        if (currentTxnMetadataCacheEntry.isDefined()) {
            int coordinatorEpoch2 = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).coordinatorEpoch();
            Pool<String, TransactionMetadata> metadataPerTxnId = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).metadataPerTransactionalId();
            String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The metadata cache for txn partition ", " has already exist with epoch ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnTopicPartition), BoxesRunTime.boxToInteger((int)coordinatorEpoch2)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and ", " entries while trying to add to it; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)metadataPerTxnId.size())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this should not happen"})).s((Seq)Nil$.MODULE$);
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"load-txns-for-partition-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loadTransactions$1(coordinatorEpoch, sendTxnMarkers, topicPartition, partitionAndLeaderEpoch), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.loadingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.leavingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remove-txns-for-partition-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeTransactions$1(partitionId, topicPartition, partitionAndLeaderEpoch), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction topic number of partitions has changed from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.transactionTopicPartitionCount()), BoxesRunTime.boxToInteger((int)curTransactionTopicPartitionCount)})));
        }
    }

    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TransactionMetadata metadata;
            Option option;
            boolean bl = false;
            Right right = null;
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.getTransactionState(transactionalId);
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
                return;
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Option option2 = (Option)right.value();
                if (None$.MODULE$.equals(option2)) {
                    BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    return;
                }
            }
            if (!bl || !((option = (Option)right.value()) instanceof Some)) throw new MatchError(either);
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata transactionMetadata = metadata = epochAndMetadata.transactionMetadata();
            synchronized (transactionMetadata) {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                    responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else {
                    $this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
                        this.updateCacheCallback$1(responseStatus, transactionalId, coordinatorEpoch, newMetadata, responseCallback, retryOnError, topicPartition);
                        return BoxedUnit.UNIT;
                    }, (Option<Object>)new Some((Object)newMetadata));
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appending new metadata ", " for transaction id ", " with coordinator epoch ", " to the local transaction log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newMetadata, transactionalId, BoxesRunTime.boxToInteger((int)coordinatorEpoch)})));
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$6));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(int txnPartitionId$1, TransactionPartitionAndLeaderEpoch x$1) {
        return x$1.txnPartitionId() == txnPartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$2(TransactionStateManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int txnPartitionId = tuple2._1$mcI$sp();
        boolean bl = !$this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(txnPartitionId, x$1)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$5(long now$1, Tuple2 x0$3) {
        boolean bl;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        TransactionState transactionState = txnMetadata.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        boolean bl3 = bl2;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        boolean bl = txnMetadata.txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$10(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)tuple2._2();
            Errors errors = response.error;
            if (Errors.NONE.equals(errors)) {
                BoxedUnit boxedUnit = (BoxedUnit)CoreUtils$.MODULE$.inReadLock($this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                    $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
                        toRemove.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                            BoxedUnit boxedUnit;
                            TransactionMetadata txnMetadata;
                            TransactionMetadata transactionMetadata = txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(idCoordinatorEpochAndMetadata.transactionalId());
                            synchronized (transactionMetadata) {
                                Object object;
                                if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                                    object = txnMetadataCacheEntry.metadataPerTransactionalId().remove(idCoordinatorEpochAndMetadata.transactionalId());
                                } else {
                                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to remove expired transactionalId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{idCoordinatorEpochAndMetadata.transactionalId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" from cache. pendingState: ", " producerEpoch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.pendingState(), BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected producerEpoch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" coordinatorEpoch: ", " expected coordinatorEpoch: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnMetadataCacheEntry.coordinatorEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idCoordinatorEpochAndMetadata.coordinatorEpoch())})));
                                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                                    object = BoxedUnit.UNIT;
                                }
                                boxedUnit = object;
                            }
                            return boxedUnit;
                        });
                        return BoxedUnit.UNIT;
                    });
                });
            } else {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writing transactionalId tombstones for partition: ", " failed with error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)topicPartition.partition()), response$1.error.message()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$10(this, transactionalIdByPartition$1, x0$10);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$3) {
        return x$3.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$3(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$2;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    private final /* synthetic */ ByteBuffer buffer$lzycompute$1(LazyRef buffer$lzy$1) {
        ByteBuffer byteBuffer;
        LazyRef lazyRef = buffer$lzy$1;
        synchronized (lazyRef) {
            byteBuffer = buffer$lzy$1.initialized() ? (ByteBuffer)buffer$lzy$1.value() : (ByteBuffer)buffer$lzy$1.initialize((Object)ByteBuffer.allocate(this.config.transactionLogLoadBufferSize()));
        }
        return byteBuffer;
    }

    private final ByteBuffer buffer$1(LazyRef buffer$lzy$1) {
        return buffer$lzy$1.initialized() ? (ByteBuffer)buffer$lzy$1.value() : this.buffer$lzycompute$1(buffer$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$3;
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Object object;
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable & scala.Serializable)() -> "Transaction state log's key should not be null");
        TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        String transactionalId = txnKey.transactionalId();
        if (!record.hasValue()) {
            object = loadedTransactions$1.remove(transactionalId);
        } else {
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
            object = loadedTransactions$1.put(transactionalId, txnMetadata);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$5(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    private final void loadTransactions$1(int coordinatorEpoch$2, Function5 sendTxnMarkers$1, TopicPartition topicPartition$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading transaction metadata from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition$3})));
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$2);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) break block0;
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$2, loadedTransactions);
                ListBuffer transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$11;
                    if (tuple2 != null) {
                        TransactionMetadata txnMetadata;
                        String transactionalId = (String)tuple2._1();
                        TransactionMetadata transactionMetadata = txnMetadata = (TransactionMetadata)tuple2._2();
                        synchronized (transactionMetadata) {
                            TransactionState transactionState = txnMetadata.state();
                            Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                            boxedUnit = object;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                transactionsPendingForCompletion.foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    private final void removeTransactions$1(int partitionId$1, TopicPartition topicPartition$4, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3) {
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            if (this.leavingPartitions().contains((Object)partitionAndLeaderEpoch$3)) {
                Option option = this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$1));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)some.value();
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " cached transaction metadata for ", " on follower transition"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnMetadataCacheEntry.metadataPerTransactionalId().size()), topicPartition$4})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to remove cached transaction metadata for ", " on follower transition but there is no entries remaining; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition$4})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"it is likely that another process for removing the cached entries has just executed earlier before"})).s((Seq)Nil$.MODULE$));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.leavingPartitions().remove((Object)partitionAndLeaderEpoch$3));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$1, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appending ", "'s new metadata ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, newMetadata$1, status$1.error.exceptionName()}));
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$1, Errors err$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accessing the cached transaction metadata for ", " returns ", " error; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, err$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborting transition to the new metadata and setting the error in the callback"})).s((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$3(TransactionStateManager $this, String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1, CoordinatorEpochAndTxnMetadata epochAndMetadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cached coordinator epoch for ", " has changed to ", " after appended its new metadata ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, BoxesRunTime.boxToInteger((int)epochAndMetadata$1.coordinatorEpoch()), newMetadata$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to the transaction log (txn topic partition ", ") while it was ", " before appending; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.partitionFor(transactionalId$1)), BoxesRunTime.boxToInteger((int)coordinatorEpoch$1)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborting transition to the new metadata and returning ", " in the callback"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NOT_COORDINATOR}));
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$4(String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating ", "'s transaction state to ", " with coordinator epoch ", " for ", " succeeded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, newMetadata$1, BoxesRunTime.boxToInteger((int)coordinatorEpoch$1), transactionalId$1}));
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$5(TransactionStateManager $this, String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cached coordinator metadata does not exist in the cache anymore for ", " after appended its new metadata ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, newMetadata$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to the transaction log (txn topic partition ", ") while it was ", " before appending; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.partitionFor(transactionalId$1)), BoxesRunTime.boxToInteger((int)coordinatorEpoch$1)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborting transition to the new metadata and returning ", " in the callback"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NOT_COORDINATOR}));
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " append transaction log for ", " transition failed due to ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata$1.transactionalId(), newMetadata$1, (Errors)responseError$1.elem})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not resetting pending state ", " but just returning the error in the callback to let the caller retry"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata$1.pendingState()}));
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$7(TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " append transaction log for ", " transition failed due to ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata$1.transactionalId(), newMetadata$1, (Errors)responseError$1.elem})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"resetting pending state from ", ", aborting state transition and returning ", " in the callback"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata$1.pendingState(), (Errors)responseError$1.elem}));
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$8(int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, TransactionMetadata metadata$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " append transaction log for ", " transition failed due to ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata$1.transactionalId(), newMetadata$1, (Errors)responseError$1.elem})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborting state transition and returning the error in the callback since the coordinator epoch has changed from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndTxnMetadata$1.coordinatorEpoch()), BoxesRunTime.boxToInteger((int)coordinatorEpoch$1)}));
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$9(String transactionalId$1, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " append transaction log for ", " transition failed due to ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, newMetadata$1, (Errors)responseError$1.elem})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborting state transition and returning the error in the callback since metadata is not available in the cache anymore"})).s((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$10(String transactionalId$1, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " append transaction log for ", " transition failed due to ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, newMetadata$1, (Errors)responseError$1.elem})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborting state transition and returning the error in the callback since retrieving metadata returned ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error$1}));
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, String transactionalId$1, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Function1 retryOnError$1, TopicPartition topicPartition$5) {
        block27: {
            block25: {
                block29: {
                    block28: {
                        block26: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$5)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$5})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$5);
                            v0 = status.error;
                            var15_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var15_9) == false : var15_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$1, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var16_10 = status.error;
                                var12_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var16_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var16_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var16_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var16_10) != false));
                                if (var12_11) {
                                    var10_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else if (Errors.NOT_LEADER_FOR_PARTITION.equals(var16_10)) {
                                    var10_12 = Errors.NOT_COORDINATOR;
                                } else {
                                    var11_13 = Errors.MESSAGE_TOO_LARGE.equals(var16_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var16_10) != false;
                                    var10_12 = var11_13 != false ? Errors.UNKNOWN : var16_10;
                                }
                                v1 = var10_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var17_15 = Errors.NONE;
                            if (v2 != null ? v2.equals(var17_15) == false : var17_15 != null) break block25;
                            var18_16 = false;
                            var19_17 = null;
                            var20_18 = this.getTransactionState(transactionalId$1);
                            if (!(var20_18 instanceof Left)) break block26;
                            var21_19 = (Left)var20_18;
                            err = (Errors)var21_19.value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$1, (Errors)err));
                            responseError.elem = err;
                            var9_21 = BoxedUnit.UNIT;
                            break block27;
                        }
                        if (!(var20_18 instanceof Right)) break block28;
                        var18_16 = true;
                        var19_17 = (Right)var20_18;
                        var23_24 = (Option)var19_17.value();
                        if (!(var23_24 instanceof Some)) break block28;
                        var24_25 = (Some)var23_24;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var24_25.value();
                        var27_28 = metadata = epochAndMetadata.transactionMetadata();
                        synchronized (var27_28) {
                            if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$1) {
                                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager java.lang.String int kafka.coordinator.transaction.TxnTransitMetadata kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$1, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1, (CoordinatorEpochAndTxnMetadata)epochAndMetadata));
                                responseError.elem = Errors.NOT_COORDINATOR;
                            } else {
                                metadata.completeTransitionTo(newMetadata$1);
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$4(java.lang.String int kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((String)transactionalId$1, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1));
                            }
                        }
                        var9_22 = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (!var18_16 || !None$.MODULE$.equals(var28_29 = (Option)var19_17.value())) break block29;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$5(kafka.coordinator.transaction.TransactionStateManager java.lang.String int kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$1, (int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    var9_23 = BoxedUnit.UNIT;
                    break block27;
                }
                throw new MatchError(var20_18);
            }
            var29_30 = false;
            var30_31 = null;
            var31_32 = this.getTransactionState(transactionalId$1);
            if (!(var31_32 instanceof Right)) ** GOTO lbl-1000
            var29_30 = true;
            var30_31 = (Right)var31_32;
            var32_33 = (Option)var30_31.value();
            if (var32_33 instanceof Some) {
                var33_34 = (Some)var32_33;
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)var33_34.value();
                var36_37 = metadata = epochAndTxnMetadata.transactionMetadata();
                synchronized (var36_37) {
                    if (epochAndTxnMetadata.coordinatorEpoch() == coordinatorEpoch$1) {
                        if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError.elem)))) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        } else {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                            metadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        }
                    } else {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$8(int kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata kafka.coordinator.transaction.TransactionMetadata ), ()Ljava/lang/String;)((int)coordinatorEpoch$1, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (TransactionMetadata)metadata));
                    }
                }
                var8_38 = BoxedUnit.UNIT;
            } else if (var29_30 && None$.MODULE$.equals(var37_41 = (Option)var30_31.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$9(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$1, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
                var8_39 = BoxedUnit.UNIT;
            } else if (var31_32 instanceof Left) {
                var38_42 = (Left)var31_32;
                error = (Errors)var38_42.value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$10(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$1, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
                var8_40 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var31_32);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$6) {
        return false;
    }

    public TransactionStateManager(int brokerId, ZkUtils zkUtils, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time) {
        this.zkUtils = zkUtils;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[Transaction State Manager " + brokerId + "]: ");
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.leavingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
    }
}

