/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tmb!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t\u001b^\u001b2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\r\u0011\"\u0001\u0018\u0003\u00111\u0017\u000e\\3\u0016\u0003a\u0001\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u0005%|'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011AAR5mK\"A\u0011\u0005\u0001BA\u0002\u0013\u0005!%\u0001\u0005gS2,w\fJ3r)\t\u0019c\u0005\u0005\u0002\u000bI%\u0011Qe\u0003\u0002\u0005+:LG\u000fC\u0004(A\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u0005*\u0001\t\u0005\t\u0015)\u0003\u0019\u0003\u00151\u0017\u000e\\3!Q\tA3\u0006\u0005\u0002\u000bY%\u0011Qf\u0003\u0002\tm>d\u0017\r^5mK\"Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\u0006cCN,wJ\u001a4tKR,\u0012!\r\t\u0003\u0015IJ!aM\u0006\u0003\t1{gn\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005Y!-Y:f\u001f\u001a47/\u001a;!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001D7bq&sG-\u001a=TSj,W#A\u001d\u0011\u0005)Q\u0014BA\u001e\f\u0005\rIe\u000e\u001e\u0005\t{\u0001\u0011\t\u0011)A\u0005s\u0005iQ.\u0019=J]\u0012,\u0007pU5{K\u0002B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001Q\u0001\toJLG/\u00192mKV\t\u0011\t\u0005\u0002\u000b\u0005&\u00111i\u0003\u0002\b\u0005>|G.Z1o\u0011!)\u0005A!A!\u0002\u0013\t\u0015!C<sSR\f'\r\\3!\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q)\u0011*\u0017.\\9B!!\nA&W\u001b\u0005\u0011\u0001C\u0001'N\u0019\u0001!QA\u0014\u0001C\u0002=\u0013\u0011aS\t\u0003!N\u0003\"AC)\n\u0005I[!a\u0002(pi\"Lgn\u001a\t\u0003\u0015QK!!V\u0006\u0003\u0007\u0005s\u0017\u0010\u0005\u0002M/\u0012)\u0001\f\u0001b\u0001\u001f\n\ta\u000bC\u0003\u0017\r\u0002\u0007\u0001\u0004C\u00030\r\u0002\u0007\u0011\u0007C\u00048\rB\u0005\t\u0019A\u001d\t\u000b}2\u0005\u0019A!\t\u000by\u0003a\u0011\u0003\u001d\u0002\u0013\u0015tGO]=TSj,\u0007b\u00021\u0001\u0005\u0004%\t\"Y\u0001\u0005Y>\u001c7.F\u0001c!\t\u0019'.D\u0001e\u0015\t)g-A\u0003m_\u000e\\7O\u0003\u0002hQ\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%d\u0012\u0001B;uS2L!a\u001b3\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019i\u0007\u0001)A\u0005E\u0006)An\\2lA!9q\u000e\u0001a\u0001\n#\u0001\u0018\u0001B7nCB,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003ir\t1A\\5p\u0013\t18O\u0001\tNCB\u0004X\r\u001a\"zi\u0016\u0014UO\u001a4fe\"9\u0001\u0010\u0001a\u0001\n#I\u0018\u0001C7nCB|F%Z9\u0015\u0005\rR\bbB\u0014x\u0003\u0003\u0005\r!\u001d\u0005\u0007y\u0002\u0001\u000b\u0015B9\u0002\u000b5l\u0017\r\u001d\u0011)\u0005m\\\u0003BB@\u0001A\u0003&\u0011(A\u0006`[\u0006DXI\u001c;sS\u0016\u001c\bF\u0001@,\u0011!\t)\u0001\u0001a\u0001\n#A\u0014\u0001C0f]R\u0014\u0018.Z:\t\u0013\u0005%\u0001\u00011A\u0005\u0012\u0005-\u0011\u0001D0f]R\u0014\u0018.Z:`I\u0015\fHcA\u0012\u0002\u000e!Aq%a\u0002\u0002\u0002\u0003\u0007\u0011\bC\u0004\u0002\u0012\u0001\u0001\u000b\u0015B\u001d\u0002\u0013}+g\u000e\u001e:jKN\u0004\u0003fAA\bW!1\u0011q\u0003\u0001\u0005\u0002\u0001\u000ba![:Gk2d\u0007BBA\u000e\u0001\u0011\u0005\u0001(\u0001\u0006nCb,e\u000e\u001e:jKNDa!a\b\u0001\t\u0003A\u0014aB3oiJLWm\u001d\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003\u0019\u0011Xm]5{KR\u00191%a\n\t\u000f\u0005%\u0012\u0011\u0005a\u0001s\u00059a.Z<TSj,\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\te\u0016t\u0017-\\3U_R\u00191%!\r\t\u000f\u0005M\u00121\u0006a\u00011\u0005\ta\rC\u0004\u00028\u0001!\t!!\u000f\u0002\u000b\u0019dWo\u001d5\u0015\u0003\rBq!!\u0010\u0001\t\u0003\ty$\u0001\u0004eK2,G/\u001a\u000b\u0002\u0003\"9\u00111\t\u0001\u0005\u0002\u0005e\u0012a\u0004;sS6$vNV1mS\u0012\u001c\u0016N_3\t\r\u0005\u001d\u0003\u0001\"\u00019\u0003-\u0019\u0018N_3J]\nKH/Z:\t\u000f\u0005-\u0003\u0001\"\u0001\u0002:\u0005)1\r\\8tK\"9\u0011q\n\u0001\u0007\u0002\u0005e\u0012aC:b]&$\u0018p\u00115fG.Dq!a\u0015\u0001\r\u0003\tI$\u0001\u0005ueVt7-\u0019;f\u0011\u001d\t9\u0006\u0001D\u0001\u00033\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\r\u0019\u00131\f\u0005\b\u0003;\n)\u00061\u00012\u0003\u0019ygMZ:fi\"9\u0011\u0011\r\u0001\u0005\u0012\u0005\r\u0014A\u00034pe\u000e,WK\\7baR\u00191%!\u001a\t\u000f\u0005\u001d\u0014q\fa\u0001c\u0006\tQ\u000eC\u0004\u0002l\u0001!\t\"!\u001c\u0002\u00135\f\u0017PY3M_\u000e\\W\u0003BA8\u0003k\"B!!\u001d\u0002\u0004R!\u00111OA=!\ra\u0015Q\u000f\u0003\b\u0003o\nIG1\u0001P\u0005\u0005!\u0006\"CA>\u0003S\"\t\u0019AA?\u0003\r1WO\u001c\t\u0006\u0015\u0005}\u00141O\u0005\u0004\u0003\u0003[!\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0001\fI\u00071\u0001\u0002\u0006B\u00191-a\"\n\u0007\u0005%EM\u0001\u0003M_\u000e\\\u0007bBAG\u0001\u0019E\u0011qR\u0001\u000ba\u0006\u00148/Z#oiJLHCBAI\u0003/\u000b\t\u000bE\u0002K\u0003'K1!!&\u0003\u0005)Ie\u000eZ3y\u000b:$(/\u001f\u0005\t\u00033\u000bY\t1\u0001\u0002\u001c\u00061!-\u001e4gKJ\u00042A]AO\u0013\r\tyj\u001d\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBAR\u0003\u0017\u0003\r!O\u0001\u0002]\"9\u0011q\u0015\u0001\u0005\u0012\u0005%\u0016\u0001\u00077be\u001e,7\u000f\u001e'po\u0016\u0014(i\\;oINcw\u000e\u001e$peR9\u0011(a+\u00020\u0006M\u0006\u0002CAW\u0003K\u0003\r!a'\u0002\u0007%$\u0007\u0010C\u0004\u00022\u0006\u0015\u0006\u0019A\u0019\u0002\rQ\f'oZ3u\u0011!\t),!*A\u0002\u0005]\u0016\u0001D:fCJ\u001c\u0007.\u00128uSRL\b\u0003BA]\u0003\u001btA!a/\u0002J:!\u0011QXAd\u001d\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAb\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u0007\u0011I1!a3\u0003\u0003=Ie\u000eZ3y'\u0016\f'o\u00195UsB,\u0017\u0002BAh\u0003#\u0014\u0011#\u00138eKb\u001cV-\u0019:dQ\u0016sG/\u001b;z\u0015\r\tYM\u0001\u0005\b\u0003+\u0004A\u0011CAl\u0003e\u0019X.\u00197mKN$X\u000b\u001d9fe\n{WO\u001c3TY>$hi\u001c:\u0015\u000fe\nI.a7\u0002^\"A\u0011QVAj\u0001\u0004\tY\nC\u0004\u00022\u0006M\u0007\u0019A\u0019\t\u0011\u0005U\u00161\u001ba\u0001\u0003oCq!!9\u0001\t\u0013\t\u0019/A\tj]\u0012,\u0007p\u00157piJ\u000bgnZ3G_J$\u0002\"!:\u0002l\u00065\u0018q\u001e\t\u0006\u0015\u0005\u001d\u0018(O\u0005\u0004\u0003S\\!A\u0002+va2,'\u0007\u0003\u0005\u0002.\u0006}\u0007\u0019AAN\u0011\u001d\t\t,a8A\u0002EB\u0001\"!.\u0002`\u0002\u0007\u0011q\u0017\u0005\b\u0003g\u0004A\u0011BA{\u0003E\u0019w.\u001c9be\u0016Le\u000eZ3y\u000b:$(/\u001f\u000b\bs\u0005]\u00181`A\u007f\u0011!\tI0!=A\u0002\u0005E\u0015AC5oI\u0016DXI\u001c;ss\"9\u0011\u0011WAy\u0001\u0004\t\u0004\u0002CA[\u0003c\u0004\r!a.\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005A\"o\\;oI\u0012{wO\u001c+p\u000bb\f7\r^'vYRL\u0007\u000f\\3\u0015\u000be\u0012)A!\u0003\t\u000f\t\u001d\u0011q a\u0001s\u00051a.^7cKJDqAa\u0003\u0002\u0000\u0002\u0007\u0011(\u0001\u0004gC\u000e$xN]\u0004\n\u0005\u001f\u0011\u0011\u0011!E\u0001\u0005#\tQ\"\u00112tiJ\f7\r^%oI\u0016D\bc\u0001&\u0003\u0014\u0019A\u0011AAA\u0001\u0012\u0003\u0011)bE\u0002\u0003\u0014%Aqa\u0012B\n\t\u0003\u0011I\u0002\u0006\u0002\u0003\u0012!Q!Q\u0004B\n#\u0003%\tAa\b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0011\tCa\u000e\u0003:U\u0011!1\u0005\u0016\u0004s\t\u00152F\u0001B\u0014!\u0011\u0011ICa\r\u000e\u0005\t-\"\u0002\u0002B\u0017\u0005_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tE2\"\u0001\u0006b]:|G/\u0019;j_:LAA!\u000e\u0003,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\r9\u0013YB1\u0001P\t\u0019A&1\u0004b\u0001\u001f\u0002")
public abstract class AbstractIndex<K, V>
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    public abstract int entrySize();

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public void resize(int newSize) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Buffer buffer;
            RandomAccessFile raf = new RandomAccessFile(this.file(), "rw");
            int roundedNewSize = this.roundDownToExactMultiple(newSize, this.entrySize());
            int position = this.mmap().position();
            if (OperatingSystem.IS_WINDOWS) {
                this.forceUnmap(this.mmap());
            }
            try {
                raf.setLength(roundedNewSize);
                this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                $this._maxEntries = this.mmap().limit() / this.entrySize();
                buffer = this.mmap().position(position);
            }
            finally {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close());
            }
            return buffer;
        });
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.mmap().force());
    }

    public boolean delete() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()})));
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.forceUnmap(this.mmap()));
            this.mmap_$eq(null);
        });
        return this.file().delete();
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.resize(this.entrySize() * this._entries()));
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void forceUnmap(MappedByteBuffer m) {
        block5: {
            try {
                MappedByteBuffer mappedByteBuffer = m;
                if (mappedByteBuffer instanceof DirectBuffer) {
                    BoxedUnit boxedUnit;
                    MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
                    Cleaner bufferCleaner = ((DirectBuffer)((Object)mappedByteBuffer2)).cleaner();
                    if (bufferCleaner != null) {
                        bufferCleaner.clean();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block5;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error when freeing index buffer", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        int lo = 0;
        int hi = this._entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx, mid);
            int compareResult = this.compareIndexEntry(found, target, searchEntity);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        int n;
        Enumeration.Value value = searchEntity;
        Enumeration.Value value2 = IndexSearchType$.MODULE$.KEY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
        } else {
            Enumeration.Value value4 = IndexSearchType$.MODULE$.VALUE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            } else {
                throw new MatchError((Object)value);
            }
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException("Invalid max index size: " + maxIndexSize);
                }
                raf.setLength(this.roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            long len = raf.length();
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, len);
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.roundDownToExactMultiple(idx.limit(), this.entrySize()));
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close());
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

