/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.RecoveringFromUncleanShutdown$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%h\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\bY><G)\u001b:t+\u00059\u0002cA\u0005\u00195%\u0011\u0011D\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0018\u0003!awn\u001a#jeN\u0004\u0003\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0019Q|\u0007/[2D_:4\u0017nZ:\u0016\u0003\u001d\u0002B\u0001K\u0016.q5\t\u0011F\u0003\u0002+\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051J#aA'baB\u0011a&\u000e\b\u0003_M\u0002\"\u0001\r\u0006\u000e\u0003ER!A\r\u0004\u0002\rq\u0012xn\u001c;?\u0013\t!$\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u000b!\tI$(D\u0001\u0003\u0013\tY$AA\u0005M_\u001e\u001cuN\u001c4jO\"AQ\b\u0001B\u0001B\u0003%q%A\u0007u_BL7mQ8oM&<7\u000f\t\u0005\t\u007f\u0001\u0011)\u0019!C\u0001\u0001\u0006iA-\u001a4bk2$8i\u001c8gS\u001e,\u0012\u0001\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005q\u0005qA-\u001a4bk2$8i\u001c8gS\u001e\u0004\u0003\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A#\u0002\u001b\rdW-\u00198fe\u000e{gNZ5h+\u00051\u0005CA\u001dH\u0013\tA%AA\u0007DY\u0016\fg.\u001a:D_:4\u0017n\u001a\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\r\u0006q1\r\\3b]\u0016\u00148i\u001c8gS\u001e\u0004\u0003\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\u0013%|G\u000b\u001b:fC\u0012\u001c\bCA\u0005O\u0013\ty%BA\u0002J]RD\u0001\"\u0015\u0001\u0003\u0006\u0004%\tAU\u0001\rM2,8\u000f[\"iK\u000e\\Wj]\u000b\u0002'B\u0011\u0011\u0002V\u0005\u0003+*\u0011A\u0001T8oO\"Aq\u000b\u0001B\u0001B\u0003%1+A\u0007gYV\u001c\bn\u00115fG.l5\u000f\t\u0005\t3\u0002\u0011)\u0019!C\u0001%\u0006yb\r\\;tQJ+7m\u001c<fef|eMZ:fi\u000eCWmY6q_&tG/T:\t\u0011m\u0003!\u0011!Q\u0001\nM\u000b\u0001E\u001a7vg\"\u0014VmY8wKJLxJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^'tA!AQ\f\u0001BC\u0002\u0013\u0005!+\u0001\u000fgYV\u001c\bn\u0015;beR|eMZ:fi\u000eCWmY6q_&tG/T:\t\u0011}\u0003!\u0011!Q\u0001\nM\u000bQD\u001a7vg\"\u001cF/\u0019:u\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]Rl5\u000f\t\u0005\tC\u0002\u0011)\u0019!C\u0001%\u0006\u0001\"/\u001a;f]RLwN\\\"iK\u000e\\Wj\u001d\u0005\tG\u0002\u0011\t\u0011)A\u0005'\u0006\t\"/\u001a;f]RLwN\\\"iK\u000e\\Wj\u001d\u0011\t\u0011\u0015\u0004!Q1A\u0005\u0002\u0019\f!#\\1y!&$W\t\u001f9je\u0006$\u0018n\u001c8NgV\tQ\n\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003N\u0003Mi\u0017\r\u001f)jI\u0016C\b/\u001b:bi&|g.T:!\u0011!Q\u0007A!A!\u0002\u0013Y\u0017!C:dQ\u0016$W\u000f\\3s!\tyA.\u0003\u0002n!\tI1k\u00195fIVdWM\u001d\u0005\t_\u0002\u0011)\u0019!C\u0001a\u0006Y!M]8lKJ\u001cF/\u0019;f+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011ao\u001d\u0002\f\u0005J|7.\u001a:Ti\u0006$X\r\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003r\u00031\u0011'o\\6feN#\u0018\r^3!\u0011!Q\bA!A!\u0002\u0013Y\u0018\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\t\u0011H0\u0003\u0002~g\n\u0001\"I]8lKJ$v\u000e]5d'R\fGo\u001d\u0005\n\u007f\u0002\u0011\t\u0011)A\u0005\u0003\u0003\tA\u0001^5nKB!\u00111AA\u000b\u001b\t\t)AC\u0002\u0012\u0003\u000fQA!!\u0003\u0002\f\u000511m\\7n_:T1!BA\u0007\u0015\u0011\ty!!\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019\"A\u0002pe\u001eLA!a\u0006\u0002\u0006\t!A+[7f\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\ta\u0001P5oSRtDCHA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011HA\u001e!\tI\u0004\u0001\u0003\u0004\u0016\u00033\u0001\ra\u0006\u0005\u0007K\u0005e\u0001\u0019A\u0014\t\r}\nI\u00021\u00019\u0011\u0019!\u0015\u0011\u0004a\u0001\r\"1A*!\u0007A\u00025Ca!UA\r\u0001\u0004\u0019\u0006BB-\u0002\u001a\u0001\u00071\u000b\u0003\u0004^\u00033\u0001\ra\u0015\u0005\u0007C\u0006e\u0001\u0019A*\t\r\u0015\fI\u00021\u0001N\u0011\u0019Q\u0017\u0011\u0004a\u0001W\"1q.!\u0007A\u0002EDaA_A\r\u0001\u0004Y\bbB@\u0002\u001a\u0001\u0007\u0011\u0011\u0001\u0005\n\u0003\u007f\u0001!\u0019!C\u0001\u0003\u0003\n1DU3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;GS2,WCAA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%=\u0005!A.\u00198h\u0013\r1\u0014q\t\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002D\u0005a\"+Z2pm\u0016\u0014\u0018\u0010U8j]R\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u0004\u0003\"CA*\u0001\t\u0007I\u0011AA!\u0003qaunZ*uCJ$xJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016D\u0001\"a\u0016\u0001A\u0003%\u00111I\u0001\u001e\u0019><7\u000b^1si>3gm]3u\u0007\",7m\u001b9pS:$h)\u001b7fA!I\u00111\f\u0001C\u0002\u0013\u0005\u0011\u0011I\u0001\t\u0019>\u001c7NR5mK\"A\u0011q\f\u0001!\u0002\u0013\t\u0019%A\u0005M_\u000e\\g)\u001b7fA!A\u00111\r\u0001C\u0002\u0013\u0005a-\u0001\nJ]&$\u0018.\u00197UCN\\G)\u001a7bs6\u001b\bbBA4\u0001\u0001\u0006I!T\u0001\u0014\u0013:LG/[1m)\u0006\u001c8\u000eR3mCfl5\u000f\t\u0005\n\u0003W\u0002!\u0019!C\u0005\u0003[\n\u0011\u0004\\8h\u0007J,\u0017\r^5p]>\u0013H)\u001a7fi&|g\u000eT8dWV\u0011\u0011q\u000e\t\u0005\u0003\u000b\n\t(\u0003\u0003\u0002t\u0005\u001d#AB(cU\u0016\u001cG\u000f\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA8\u0003iawnZ\"sK\u0006$\u0018n\u001c8Pe\u0012+G.\u001a;j_:dunY6!\u0011%\tY\b\u0001b\u0001\n\u0013\ti(\u0001\u0003m_\u001e\u001cXCAA@!\u001dy\u0011\u0011QAC\u0003\u001bK1!a!\u0011\u0005\u0011\u0001vn\u001c7\u0011\t\u0005\u001d\u0015\u0011R\u0007\u0003\u0003\u000fIA!a#\u0002\b\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007cA\u001d\u0002\u0010&\u0019\u0011\u0011\u0013\u0002\u0003\u00071{w\r\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BA@\u0003\u0015awnZ:!\u0011%\tI\n\u0001b\u0001\n\u0013\tY*A\bm_\u001e\u001cHk\u001c\"f\t\u0016dW\r^3e+\t\ti\n\u0005\u0004\u0002 \u0006%\u0016QR\u0007\u0003\u0003CSA!a)\u0002&\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005\u001df$\u0001\u0003vi&d\u0017\u0002BAV\u0003C\u00131\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016D\u0001\"a,\u0001A\u0003%\u0011QT\u0001\u0011Y><7\u000fV8CK\u0012+G.\u001a;fI\u0002B\u0011\"a-\u0001\u0005\u0004%I!!.\u0002\u0011\u0011L'\u000fT8dWN,\"!a.\u0011\u000b!\nI,!0\n\u0007\u0005m\u0016FA\u0002TKF\u00042aDA`\u0013\r\t\t\r\u0005\u0002\t\r&dW\rT8dW\"A\u0011Q\u0019\u0001!\u0002\u0013\t9,A\u0005eSJdunY6tA!I\u0011\u0011\u001a\u0001C\u0002\u0013%\u00111Z\u0001\u0019e\u0016\u001cwN^3ssB{\u0017N\u001c;DQ\u0016\u001c7\u000e]8j]R\u001cXCAAg!\u001d\ty-!6\u001b\u0003/l!!!5\u000b\u0007\u0005M\u0017&A\u0005j[6,H/\u00192mK&\u0019A&!5\u0011\t\u0005e\u0017q\\\u0007\u0003\u00037T1!!8t\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\t\u0005\u0005\u00181\u001c\u0002\u0015\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003\u001b\f\u0011D]3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;tA!I\u0011\u0011\u001e\u0001C\u0002\u0013%\u00111Z\u0001\u001aY><7\u000b^1si>3gm]3u\u0007\",7m\u001b9pS:$8\u000f\u0003\u0005\u0002n\u0002\u0001\u000b\u0011BAg\u0003iawnZ*uCJ$xJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^:!\u0011%\t\t\u0010\u0001b\u0001\n\u0003\t\u00190A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005U\bcA\u001d\u0002x&\u0019\u0011\u0011 \u0002\u0003\u00151{wm\u00117fC:,'\u000f\u0003\u0005\u0002~\u0002\u0001\u000b\u0011BA{\u0003!\u0019G.Z1oKJ\u0004\u0003b\u0002B\u0001\u0001\u0011%!1A\u0001\u0019GJ,\u0017\r^3B]\u00124\u0016\r\\5eCR,Gj\\4ESJ\u001cH\u0003\u0002B\u0003\u0005\u0017\u00012!\u0003B\u0004\u0013\r\u0011IA\u0003\u0002\u0005+:LG\u000f\u0003\u0005\u0003\u000e\u0005}\b\u0019\u0001B\b\u0003\u0011!\u0017N]:\u0011\t!\nIL\u0007\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0003-awnY6M_\u001e$\u0015N]:\u0015\t\u0005]&q\u0003\u0005\t\u0005\u001b\u0011\t\u00021\u0001\u0003\u0010!9!1\u0004\u0001\u0005\n\tu\u0011\u0001\u00037pC\u0012dunZ:\u0015\u0005\t\u0015\u0001b\u0002B\u0011\u0001\u0011\u0005!QD\u0001\bgR\f'\u000f^;q\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005;\t\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0005\u0005\u000b\u0011i\u0003\u0003\u0005\u00030\t\u001d\u0002\u0019\u0001B\u0019\u0003A\u0001\u0018M\u001d;ji&|gn\u00144gg\u0016$8\u000fE\u0003)W\u0005\u00155\u000bC\u0004\u00036\u0001!\tAa\u000e\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HC\u0002B\u0003\u0005s\u0011i\u0004\u0003\u0005\u0003<\tM\u0002\u0019AAC\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DqAa\u0010\u00034\u0001\u00071+A\u0005oK^|eMZ:fi\"9!1\t\u0001\u0005\u0002\tu\u0011AH2iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef\u0004v.\u001b8u\u001f\u001a47/\u001a;t\u0011\u001d\u00119\u0005\u0001C\u0001\u0005;\t\u0011d\u00195fG.\u0004x.\u001b8u\u0019><7\u000b^1si>3gm]3ug\"9!1\n\u0001\u0005\n\t5\u0013!I2iK\u000e\\\u0007o\\5oi2{wMU3d_Z,'/_(gMN,Go]%o\t&\u0014H\u0003\u0002B\u0003\u0005\u001fBqA!\u0015\u0003J\u0001\u0007!$A\u0002eSJDqA!\u0016\u0001\t\u0013\u00119&\u0001\u0010dQ\u0016\u001c7\u000e]8j]RdunZ*uCJ$xJ\u001a4tKR\u001c\u0018J\u001c#jeR!!Q\u0001B-\u0011\u001d\u0011\tFa\u0015A\u0002iAqA!\u0018\u0001\t\u0003\u0011y&\u0001\u0004hKRdun\u001a\u000b\u0005\u0005C\u00129\u0007E\u0003\n\u0005G\ni)C\u0002\u0003f)\u0011aa\u00149uS>t\u0007\u0002\u0003B\u001e\u00057\u0002\r!!\"\t\u000f\t-\u0004\u0001\"\u0001\u0003n\u0005I1M]3bi\u0016dun\u001a\u000b\u0007\u0003\u001b\u0013yG!\u001d\t\u0011\tm\"\u0011\u000ea\u0001\u0003\u000bCqAa\u001d\u0003j\u0001\u0007\u0001(\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0005o\u0002A\u0011\u0002B\u000f\u0003)!W\r\\3uK2{wm\u001d\u0005\b\u0005w\u0002A\u0011\u0001B?\u0003-\t7/\u001f8d\t\u0016dW\r^3\u0015\t\t\u0015!q\u0010\u0005\t\u0005w\u0011I\b1\u0001\u0002\u0006\"9!1\u0011\u0001\u0005\n\t\u0015\u0015A\u00038fqRdun\u001a#jeR\t!\u0004C\u0004\u0003\n\u0002!\tA!\b\u0002\u0017\rdW-\u00198va2{wm\u001d\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0003\u001d\tG\u000e\u001c'pON$\"A!%\u0011\u000b!\u0012\u0019*!$\n\u0007\tU\u0015F\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0011I\n\u0001C\u0001\u00057\u000bA\u0003\\8hg\nKHk\u001c9jGB\u000b'\u000f^5uS>tWC\u0001BO!\u0019A3&!\"\u0002\u000e\"9!\u0011\u0015\u0001\u0005\n\t\r\u0016!\u00037pON\u0014\u0015\u0010R5s+\t\u0011)\u000b\u0005\u0005\u0002P\u0006U\u00171\tBO\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005;\taB\u001a7vg\"$\u0015N\u001d;z\u0019><7\u000fK\u0002\u0001\u0005[\u00032a\u0004BX\u0013\r\u0011\t\f\u0005\u0002\u000bi\"\u0014X-\u00193tC\u001a,wa\u0002B[\u0005!\u0005!qW\u0001\u000b\u0019><W*\u00198bO\u0016\u0014\bcA\u001d\u0003:\u001a1\u0011A\u0001E\u0001\u0005w\u001b2A!/\t\u0011!\tYB!/\u0005\u0002\t}FC\u0001B\\\u0011!\u0011\u0019M!/\u0005\u0002\t\u0015\u0017!B1qa2LHCDA\u0010\u0005\u000f\u0014yM!7\u0003\\\n\u0015(q\u001d\u0005\t\u0005g\u0012\t\r1\u0001\u0003JB\u0019!Oa3\n\u0007\t57OA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003Bi\u0005\u0003\u0004\rAa5\u0002\u000fi\\W\u000b^5mgB\u0019qB!6\n\u0007\t]\u0007CA\u0004[WV#\u0018\u000e\\:\t\r=\u0014\t\r1\u0001r\u0011!\u0011iN!1A\u0002\t}\u0017AD6bM.\f7k\u00195fIVdWM\u001d\t\u0004\u001f\t\u0005\u0018b\u0001Br!\tq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\bbB@\u0003B\u0002\u0007\u0011\u0011\u0001\u0005\u0007u\n\u0005\u0007\u0019A>")
public class LogManager
implements Logging {
    private final File[] logDirs;
    private final Map<String, LogConfig> topicConfigs;
    private final LogConfig defaultConfig;
    private final CleanerConfig cleanerConfig;
    private final int ioThreads;
    private final long flushCheckMs;
    private final long flushRecoveryOffsetCheckpointMs;
    private final long flushStartOffsetCheckpointMs;
    private final long retentionCheckMs;
    private final int maxPidExpirationMs;
    private final Scheduler scheduler;
    private final BrokerState brokerState;
    private final BrokerTopicStats brokerTopicStats;
    private final Time time;
    private final String RecoveryPointCheckpointFile;
    private final String LogStartOffsetCheckpointFile;
    private final String LockFile;
    private final int InitialTaskDelayMs;
    private final Object logCreationOrDeletionLock;
    private final Pool<TopicPartition, Log> logs;
    private final LinkedBlockingQueue<Log> logsToBeDeleted;
    private final Seq<FileLock> dirLocks;
    private final scala.collection.immutable.Map<File, OffsetCheckpointFile> recoveryPointCheckpoints;
    private final scala.collection.immutable.Map<File, OffsetCheckpointFile> logStartOffsetCheckpoints;
    private final LogCleaner cleaner;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static LogManager apply(KafkaConfig kafkaConfig, ZkUtils zkUtils, BrokerState brokerState, KafkaScheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats) {
        return LogManager$.MODULE$.apply(kafkaConfig, zkUtils, brokerState, kafkaScheduler, time, brokerTopicStats);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogManager logManager = this;
        synchronized (logManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, LogConfig> topicConfigs() {
        return this.topicConfigs;
    }

    public LogConfig defaultConfig() {
        return this.defaultConfig;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public long flushCheckMs() {
        return this.flushCheckMs;
    }

    public long flushRecoveryOffsetCheckpointMs() {
        return this.flushRecoveryOffsetCheckpointMs;
    }

    public long flushStartOffsetCheckpointMs() {
        return this.flushStartOffsetCheckpointMs;
    }

    public long retentionCheckMs() {
        return this.retentionCheckMs;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public BrokerState brokerState() {
        return this.brokerState;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return this.LogStartOffsetCheckpointFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public int InitialTaskDelayMs() {
        return this.InitialTaskDelayMs;
    }

    private Object logCreationOrDeletionLock() {
        return this.logCreationOrDeletionLock;
    }

    private Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    private LinkedBlockingQueue<Log> logsToBeDeleted() {
        return this.logsToBeDeleted;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> recoveryPointCheckpoints() {
        return this.recoveryPointCheckpoints;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> logStartOffsetCheckpoints() {
        return this.logStartOffsetCheckpoints;
    }

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    private void createAndValidateLogDirs(Seq<File> dirs) {
        if (((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getCanonicalPath(), Seq$.MODULE$.canBuildFrom())).toSet().size() < dirs.size()) {
            throw new KafkaException("Duplicate log directory found: " + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).mkString(", "));
        }
        dirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            LogManager.$anonfun$createAndValidateLogDirs$2(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> dirs) {
        return (Seq)dirs.map((Function1 & Serializable & scala.Serializable)dir -> {
            void var2_2;
            FileLock lock = new FileLock(new File((File)dir, this.LockFile()));
            if (!lock.tryLock()) {
                throw new KafkaException("Failed to acquire lock on file .lock in " + lock.file().getParentFile().getAbsolutePath() + ". A Kafka instance in another process or thread is using this directory.");
            }
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Loading logs.");
        long startMs = this.time.milliseconds();
        ArrayBuffer threadPools = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        scala.collection.mutable.Map jobs = Map$.MODULE$.empty();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            LogManager.$anonfun$loadLogs$2(this, threadPools, jobs, dir);
            return BoxedUnit.UNIT;
        });
        try {
            try {
                jobs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$loadLogs$18(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$loadLogs$19(x$3)));
            }
            catch (ExecutionException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There was an error in one of the threads during logs loading: " + e.getCause());
                throw e.getCause();
            }
        }
        finally {
            threadPools.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logs loading complete in ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)($this.time.milliseconds() - startMs))})));
    }

    public void startup() {
        block1: {
            if (this.scheduler != null) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Starting log cleanup with a period of %d ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.retentionCheckMs())})));
                this.scheduler.schedule("kafka-log-retention", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.cleanupLogs(), this.InitialTaskDelayMs(), this.retentionCheckMs(), TimeUnit.MILLISECONDS);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Starting log flusher with a default period of %d ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.flushCheckMs())})));
                this.scheduler.schedule("kafka-log-flusher", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.flushDirtyLogs(), this.InitialTaskDelayMs(), this.flushCheckMs(), TimeUnit.MILLISECONDS);
                this.scheduler.schedule("kafka-recovery-point-checkpoint", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpointRecoveryPointOffsets(), this.InitialTaskDelayMs(), this.flushRecoveryOffsetCheckpointMs(), TimeUnit.MILLISECONDS);
                this.scheduler.schedule("kafka-log-start-offset-checkpoint", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpointLogStartOffsets(), this.InitialTaskDelayMs(), this.flushStartOffsetCheckpointMs(), TimeUnit.MILLISECONDS);
                this.scheduler.schedule("kafka-delete-logs", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.deleteLogs(), this.InitialTaskDelayMs(), Predef$.MODULE$.Long2long(this.defaultConfig().fileDeleteDelayMs()), TimeUnit.MILLISECONDS);
            }
            if (!this.cleanerConfig().enableCleaner()) break block1;
            this.cleaner().startup();
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        ArrayBuffer threadPools = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        scala.collection.mutable.Map jobs = Map$.MODULE$.empty();
        if (this.cleaner() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.cleaner().shutdown());
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            LogManager.$anonfun$shutdown$3(this, threadPools, jobs, dir);
            return BoxedUnit.UNIT;
        });
        try {
            try {
                jobs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$shutdown$9(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    LogManager.$anonfun$shutdown$10(this, x$6);
                    return BoxedUnit.UNIT;
                });
            }
            catch (ExecutionException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There was an error in one of the threads during LogManager shutdown: " + e.getCause());
                throw e.getCause();
            }
        }
        finally {
            threadPools.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.shutdown();
                return BoxedUnit.UNIT;
            });
            this.dirLocks().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.destroy();
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    public void truncateTo(Map<TopicPartition, Object> partitionOffsets) {
        partitionOffsets.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$truncateTo$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            LogManager.$anonfun$truncateTo$2(this, x$9);
            return BoxedUnit.UNIT;
        });
        this.checkpointRecoveryPointOffsets();
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long newOffset) {
        Log log = this.logs().get(topicPartition);
        if (log != null) {
            if (this.cleaner() != null) {
                this.cleaner().abortAndPauseCleaning(topicPartition);
            }
            log.truncateFullyAndStartAt(newOffset);
            if (this.cleaner() != null) {
                this.cleaner().maybeTruncateCheckpoint(log.dir().getParentFile(), topicPartition, log.activeSegment().baseOffset());
                this.cleaner().resumeCleaning(topicPartition);
            }
        }
        this.checkpointRecoveryPointOffsets();
    }

    public void checkpointRecoveryPointOffsets() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.checkpointLogRecoveryOffsetsInDir(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void checkpointLogStartOffsets() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.checkpointLogStartOffsetsInDir(dir);
            return BoxedUnit.UNIT;
        });
    }

    private void checkpointLogRecoveryOffsetsInDir(File dir) {
        block0: {
            Option recoveryPoints = this.logsByDir().get((Object)dir.toString());
            if (!recoveryPoints.isDefined()) break block0;
            ((OffsetCheckpointFile)this.recoveryPointCheckpoints().apply((Object)dir)).write((Map<TopicPartition, Object>)((MapLike)recoveryPoints.get()).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.recoveryPoint())));
        }
    }

    private void checkpointLogStartOffsetsInDir(File dir) {
        block0: {
            Option logs = this.logsByDir().get((Object)dir.toString());
            if (!logs.isDefined()) break block0;
            ((OffsetCheckpointFile)this.logStartOffsetCheckpoints().apply((Object)dir)).write((Map<TopicPartition, Object>)((MapLike)((TraversableLike)logs.get()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$checkpointLogStartOffsetsInDir$1(x0$2)))).mapValues((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.logStartOffset())));
        }
    }

    public Option<Log> getLog(TopicPartition topicPartition) {
        return Option$.MODULE$.apply((Object)this.logs().get(topicPartition));
    }

    public Log createLog(TopicPartition topicPartition, LogConfig config) {
        Log log;
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            log = (Log)this.getLog(topicPartition).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                File dataDir = this.nextLogDir();
                File dir = new File(dataDir, topicPartition.topic() + "-" + topicPartition.partition());
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                File x$26 = dir;
                LogConfig x$27 = config;
                long x$28 = 0L;
                long x$29 = 0L;
                int x$30 = this.maxPidExpirationMs();
                Scheduler x$31 = $this.scheduler;
                Time x$32 = $this.time;
                BrokerTopicStats x$33 = $this.brokerTopicStats;
                int x$34 = Log$.MODULE$.apply$default$9();
                Log log = Log$.MODULE$.apply(x$26, x$27, x$28, x$29, x$31, x$33, x$32, x$30, x$34);
                this.logs().put(topicPartition, log);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s with properties {%s}.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.topic(), BoxesRunTime.boxToInteger((int)topicPartition.partition()), dataDir.getAbsolutePath(), ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).mkString(", ")})));
                return log;
            });
        }
        return log;
    }

    private void deleteLogs() {
        try {
            int failed = 0;
            while (!this.logsToBeDeleted().isEmpty() && failed < this.logsToBeDeleted().size()) {
                Log removedLog = this.logsToBeDeleted().take();
                if (removedLog == null) continue;
                try {
                    removedLog.delete();
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted log for partition ", " in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{removedLog.topicPartition(), removedLog.dir().getAbsolutePath()})));
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception in deleting ", ". Moving it to the end of the queue."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{removedLog})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    ++failed;
                    this.logsToBeDeleted().put(removedLog);
                }
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception in kafka-delete-logs thread."})).s((Seq)Nil$.MODULE$), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void asyncDelete(TopicPartition topicPartition) {
        Log log;
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            log = this.logs().remove(topicPartition);
        }
        Log removedLog = log;
        if (removedLog != null) {
            if (this.cleaner() != null) {
                this.cleaner().abortCleaning(topicPartition);
                this.cleaner().updateCheckpoints(removedLog.dir().getParentFile());
            }
            String dirName = Log$.MODULE$.logDeleteDirName(removedLog.name());
            removedLog.close();
            File renamedDir = new File(removedLog.dir().getParent(), dirName);
            boolean renameSuccessful = removedLog.dir().renameTo(renamedDir);
            if (renameSuccessful) {
                this.checkpointLogStartOffsetsInDir(removedLog.dir().getParentFile());
                removedLog.dir_$eq(renamedDir);
                removedLog.logSegments().foreach((Function1 & Serializable & scala.Serializable)logSegment -> {
                    LogManager.$anonfun$asyncDelete$1(renamedDir, logSegment);
                    return BoxedUnit.UNIT;
                });
                this.logsToBeDeleted().add(removedLog);
                removedLog.removeLogMetrics();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log for partition ", " is renamed to ", " and is scheduled for deletion"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{removedLog.topicPartition(), removedLog.dir().getAbsolutePath()})));
            } else {
                throw new KafkaStorageException("Failed to rename log directory from " + removedLog.dir().getAbsolutePath() + " to " + renamedDir.getAbsolutePath());
            }
        }
    }

    private File nextLogDir() {
        File file;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map logCounts = this.allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dir().getParent()).mapValues((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.size()));
            scala.collection.immutable.Map zeros = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2((Object)dir.getPath(), (Object)BoxesRunTime.boxToInteger((int)0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            Buffer dirCounts = zeros.$plus$plus((GenTraversableOnce)logCounts).toBuffer();
            Tuple2 leastLoaded = (Tuple2)((IterableLike)dirCounts.sortBy((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).head();
            file = new File((String)leastLoaded._1());
        }
        return file;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Beginning log cleanup...");
        IntRef total = IntRef.create((int)0);
        long startMs = this.time.milliseconds();
        this.allLogs().withFilter((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$cleanupLogs$2(log))).foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManager.$anonfun$cleanupLogs$3(this, total, log);
            return BoxedUnit.UNIT;
        });
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Log cleanup completed. " + total$1.elem + " files deleted in " + ($this.time.milliseconds() - startMs) / 1000L + " seconds");
    }

    public Iterable<Log> allLogs() {
        return this.logs().values();
    }

    public Map<TopicPartition, Log> logsByTopicPartition() {
        return this.logs().toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, Map<TopicPartition, Log>> logsByDir() {
        return this.logsByTopicPartition().groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Log log = (Log)tuple2._2();
            String string = log.dir().getParent();
            return string;
        });
    }

    private void flushDirtyLogs() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Checking for dirty logs to flush...");
        this.logs().withFilter((Function1<Tuple2<TopicPartition, Log>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$flushDirtyLogs$2(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            LogManager.$anonfun$flushDirtyLogs$3(this, x$15);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$createAndValidateLogDirs$2(LogManager $this, File dir) {
        if (!dir.exists()) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Log directory '" + dir.getAbsolutePath() + "' not found, creating it.");
            boolean created = dir.mkdirs();
            if (!created) {
                throw new KafkaException("Failed to create data directory " + dir.getAbsolutePath());
            }
        }
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new KafkaException(dir.getAbsolutePath() + " is not a readable log directory.");
        }
    }

    public static final /* synthetic */ void $anonfun$loadLogs$2(LogManager $this, ArrayBuffer threadPools$1, scala.collection.mutable.Map jobs$1, File dir) {
        ExecutorService pool = Executors.newFixedThreadPool($this.ioThreads);
        threadPools$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool}));
        File cleanShutdownFile = new File(dir, Log$.MODULE$.CleanShutdownFile());
        if (cleanShutdownFile.exists()) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Found clean shutdown file. Skipping recovery for all logs in data directory: " + dir.getAbsolutePath());
        } else {
            $this.brokerState().newState(RecoveringFromUncleanShutdown$.MODULE$);
        }
        ObjectRef recoveryPoints = ObjectRef.create((Object)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        try {
            recoveryPoints.elem = ((OffsetCheckpointFile)$this.recoveryPointCheckpoints().apply((Object)dir)).read();
        }
        catch (Exception e) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while reading recovery-point-offset-checkpoint file of directory " + dir, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Resetting the recovery checkpoint to 0");
        }
        ObjectRef logStartOffsets = ObjectRef.create((Object)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        try {
            logStartOffsets.elem = ((OffsetCheckpointFile)$this.logStartOffsetCheckpoints().apply((Object)dir)).read();
        }
        catch (Exception e) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred while reading log-start-offset-checkpoint file of directory " + dir, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
        List jobsForDir = (List)Option$.MODULE$.apply((Object)dir.listFiles()).toList().flatMap((Function1 & Serializable & scala.Serializable)dirContent -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirContent)).withFilter((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)logDir.isDirectory())).map((Function1 & Serializable & scala.Serializable)logDir -> CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Loading log '" + logDir.getName() + "'");
            TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName((File)logDir);
            LogConfig config = (LogConfig)((Object)((Object)((Object)$this.topicConfigs().getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> $this.defaultConfig()))));
            long logRecoveryPoint = BoxesRunTime.unboxToLong((Object)((Map)recoveryPoints$1.elem).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            long logStartOffset = BoxesRunTime.unboxToLong((Object)((Map)logStartOffsets$1.elem).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            File x$17 = logDir;
            LogConfig x$18 = config;
            long x$19 = logStartOffset;
            long x$20 = logRecoveryPoint;
            int x$21 = $this.maxPidExpirationMs();
            Scheduler x$22 = $this.scheduler;
            Time x$23 = $this.time;
            BrokerTopicStats x$24 = $this.brokerTopicStats;
            int x$25 = Log$.MODULE$.apply$default$9();
            Log current = Log$.MODULE$.apply(x$17, x$18, x$19, x$20, x$22, x$24, x$23, x$21, x$25);
            if (logDir.getName().endsWith(Log$.MODULE$.DeleteDirSuffix())) {
                $this.logsToBeDeleted().add(current);
            } else {
                Log previous = $this.logs().put(topicPartition, current);
                if (previous != null) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{current.dir().getAbsolutePath(), previous.dir().getAbsolutePath()})));
                }
            }
        }), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Runnable.class))))), List$.MODULE$.canBuildFrom());
        jobs$1.update((Object)cleanShutdownFile, jobsForDir.map((Function1 & Serializable & scala.Serializable)x$1 -> pool.submit((Runnable)x$1), List$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$loadLogs$18(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$loadLogs$19(Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File cleanShutdownFile = (File)tuple2._1();
        Seq dirJobs = (Seq)tuple2._2();
        dirJobs.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get());
        boolean bl = cleanShutdownFile.delete();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$shutdown$3(LogManager $this, ArrayBuffer threadPools$2, scala.collection.mutable.Map jobs$2, File dir) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flushing and closing logs at " + dir);
        ExecutorService pool = Executors.newFixedThreadPool($this.ioThreads);
        threadPools$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool}));
        Iterable logsInDir = ((MapLike)$this.logsByDir().getOrElse((Object)dir.toString(), (Function0 & Serializable & scala.Serializable)() -> (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$))).values();
        Iterable jobsForDir = (Iterable)logsInDir.map((Function1 & Serializable & scala.Serializable)log -> CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            log.flush();
            log.close();
        }), Iterable$.MODULE$.canBuildFrom());
        jobs$2.update((Object)dir, (Object)((TraversableOnce)jobsForDir.map((Function1 & Serializable & scala.Serializable)x$1 -> pool.submit((Runnable)x$1), Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$9(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$shutdown$10(LogManager $this, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        Seq dirJobs = (Seq)tuple2._2();
        dirJobs.foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating recovery points at " + dir);
        $this.checkpointLogRecoveryOffsetsInDir(dir);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating log start offsets at " + dir);
        $this.checkpointLogStartOffsetsInDir(dir);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing clean shutdown marker at " + dir);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.createFile(new File(dir, Log$.MODULE$.CleanShutdownFile()).toPath(), new FileAttribute[0]));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$truncateTo$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateTo$2(LogManager $this, Tuple2 x$9) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            long truncateOffset = tuple2._2$mcJ$sp();
            Log log = $this.logs().get(topicPartition);
            if (log != null) {
                boolean needToStopCleaner;
                boolean bl = needToStopCleaner = $this.cleaner() != null && truncateOffset < log.activeSegment().baseOffset();
                if (needToStopCleaner) {
                    $this.cleaner().abortAndPauseCleaning(topicPartition);
                }
                try {
                    log.truncateTo(truncateOffset);
                    if (needToStopCleaner) {
                        $this.cleaner().maybeTruncateCheckpoint(log.dir().getParentFile(), topicPartition, log.activeSegment().baseOffset());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                finally {
                    if (needToStopCleaner) {
                        $this.cleaner().resumeCleaning(topicPartition);
                    }
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$checkpointLogStartOffsetsInDir$1(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.logStartOffset() > ((LogSegment)log.logSegments().head()).baseOffset();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$asyncDelete$1(File renamedDir$1, LogSegment logSegment) {
        logSegment.log().setFile(new File(renamedDir$1, logSegment.log().file().getName()));
        logSegment.index().file_$eq(new File(renamedDir$1, logSegment.index().file().getName()));
    }

    public static final /* synthetic */ boolean $anonfun$cleanupLogs$2(Log log) {
        return !log.config().compact();
    }

    public static final /* synthetic */ void $anonfun$cleanupLogs$3(LogManager $this, IntRef total$1, Log log) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Garbage collecting '" + log.name() + "'");
        total$1.elem += log.deleteOldSegments();
    }

    public static final /* synthetic */ boolean $anonfun$flushDirtyLogs$2(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$flushDirtyLogs$3(LogManager $this, Tuple2 x$15) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$15;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            Log log = (Log)tuple2._2();
            try {
                long timeSinceLastFlush = $this.time.milliseconds() - log.lastFlushTime();
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Checking if flush is needed on " + topicPartition.topic() + " flush interval  " + log.config().flushMs() + " last flushed " + log.lastFlushTime() + " time since last flush: " + timeSinceLastFlush);
                if (timeSinceLastFlush >= Predef$.MODULE$.Long2long(log.config().flushMs())) {
                    log.flush();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error flushing topic " + topicPartition.topic(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public LogManager(File[] logDirs, Map<String, LogConfig> topicConfigs, LogConfig defaultConfig, CleanerConfig cleanerConfig, int ioThreads, long flushCheckMs, long flushRecoveryOffsetCheckpointMs, long flushStartOffsetCheckpointMs, long retentionCheckMs, int maxPidExpirationMs, Scheduler scheduler, BrokerState brokerState, BrokerTopicStats brokerTopicStats, Time time) {
        this.logDirs = logDirs;
        this.topicConfigs = topicConfigs;
        this.defaultConfig = defaultConfig;
        this.cleanerConfig = cleanerConfig;
        this.ioThreads = ioThreads;
        this.flushCheckMs = flushCheckMs;
        this.flushRecoveryOffsetCheckpointMs = flushRecoveryOffsetCheckpointMs;
        this.flushStartOffsetCheckpointMs = flushStartOffsetCheckpointMs;
        this.retentionCheckMs = retentionCheckMs;
        this.maxPidExpirationMs = maxPidExpirationMs;
        this.scheduler = scheduler;
        this.brokerState = brokerState;
        this.brokerTopicStats = brokerTopicStats;
        this.time = time;
        Logging.$init$(this);
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";
        this.LockFile = ".lock";
        this.InitialTaskDelayMs = 30000;
        this.logCreationOrDeletionLock = new Object();
        this.logs = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.logsToBeDeleted = new LinkedBlockingQueue();
        this.createAndValidateLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.dirLocks = this.lockLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.recoveryPointCheckpoints = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDirs)).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.RecoveryPointCheckpointFile()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.logStartOffsetCheckpoints = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDirs)).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.LogStartOffsetCheckpointFile()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.loadLogs();
        this.cleaner = cleanerConfig.enableCleaner() ? new LogCleaner(cleanerConfig, logDirs, this.logs(), time) : null;
    }
}

