/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import kafka.log.CompletedTxn;
import kafka.log.ProducerIdEntry;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.errors.DuplicateSequenceNumberException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011)\u0019!C\u0001!\u0005Q\u0001O]8ek\u000e,'/\u00133\u0004\u0001U\t\u0011\u0003\u0005\u0002\t%%\u00111#\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0012\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\t\u0011]\u0001!\u0011!Q\u0001\na\tA\"\u001b8ji&\fG.\u00128uef\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003\u001fA\u0013x\u000eZ;dKJLE-\u00128uefD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0018m\u0006d\u0017\u000eZ1uKN+\u0017/^3oG\u0016tU/\u001c2feN\u0004\"\u0001C\u0010\n\u0005\u0001J!a\u0002\"p_2,\u0017M\u001c\u0005\tE\u0001\u0011\t\u0011)A\u0005=\u0005qAn\\1eS:<gI]8n\u0019><\u0007\"\u0002\u0013\u0001\t\u0003)\u0013A\u0002\u001fj]&$h\bF\u0003'O!J#\u0006\u0005\u0002\u001a\u0001!)ab\ta\u0001#!)qc\ta\u00011!)Qd\ta\u0001=!)!e\ta\u0001=!9A\u0006\u0001a\u0001\n\u0013i\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007.F\u0001/!\tAq&\u0003\u00021\u0013\t)1\u000b[8si\"9!\u0007\u0001a\u0001\n\u0013\u0019\u0014!\u00059s_\u0012,8-\u001a:Fa>\u001c\u0007n\u0018\u0013fcR\u0011Ag\u000e\t\u0003\u0011UJ!AN\u0005\u0003\tUs\u0017\u000e\u001e\u0005\bqE\n\t\u00111\u0001/\u0003\rAH%\r\u0005\u0007u\u0001\u0001\u000b\u0015\u0002\u0018\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA!9A\b\u0001a\u0001\n\u0013i\u0014\u0001\u00034jeN$8+Z9\u0016\u0003y\u0002\"\u0001C \n\u0005\u0001K!aA%oi\"9!\t\u0001a\u0001\n\u0013\u0019\u0015\u0001\u00044jeN$8+Z9`I\u0015\fHC\u0001\u001bE\u0011\u001dA\u0014)!AA\u0002yBaA\u0012\u0001!B\u0013q\u0014!\u00034jeN$8+Z9!\u0011\u001dA\u0005\u00011A\u0005\nu\nq\u0001\\1tiN+\u0017\u000fC\u0004K\u0001\u0001\u0007I\u0011B&\u0002\u00171\f7\u000f^*fc~#S-\u001d\u000b\u0003i1Cq\u0001O%\u0002\u0002\u0003\u0007a\b\u0003\u0004O\u0001\u0001\u0006KAP\u0001\tY\u0006\u001cHoU3rA!9\u0001\u000b\u0001a\u0001\n\u0013\u0001\u0012A\u00037bgR|eMZ:fi\"9!\u000b\u0001a\u0001\n\u0013\u0019\u0016A\u00047bgR|eMZ:fi~#S-\u001d\u000b\u0003iQCq\u0001O)\u0002\u0002\u0003\u0007\u0011\u0003\u0003\u0004W\u0001\u0001\u0006K!E\u0001\fY\u0006\u001cHo\u00144gg\u0016$\b\u0005C\u0004Y\u0001\u0001\u0007I\u0011\u0002\t\u0002\u00195\f\u0007\u0010V5nKN$\u0018-\u001c9\t\u000fi\u0003\u0001\u0019!C\u00057\u0006\u0001R.\u0019=US6,7\u000f^1na~#S-\u001d\u000b\u0003iqCq\u0001O-\u0002\u0002\u0003\u0007\u0011\u0003\u0003\u0004_\u0001\u0001\u0006K!E\u0001\u000e[\u0006DH+[7fgR\fW\u000e\u001d\u0011\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\u0006)2-\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X#\u00012\u0011\u0007!\u0019\u0017#\u0003\u0002e\u0013\t1q\n\u001d;j_:DqA\u001a\u0001A\u0002\u0013%q-A\rdkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;`I\u0015\fHC\u0001\u001bi\u0011\u001dAT-!AA\u0002\tDaA\u001b\u0001!B\u0013\u0011\u0017AF2veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e\u0011\t\u000f1\u0004\u0001\u0019!C\u0005{\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\b]\u0002\u0001\r\u0011\"\u0003p\u0003Q\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007n\u0018\u0013fcR\u0011A\u0007\u001d\u0005\bq5\f\t\u00111\u0001?\u0011\u0019\u0011\b\u0001)Q\u0005}\u0005\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\t\u000fQ\u0004!\u0019!C\u0005k\u0006aAO]1og\u0006\u001cG/[8ogV\ta\u000fE\u0002xyzl\u0011\u0001\u001f\u0006\u0003sj\fq!\\;uC\ndWM\u0003\u0002|\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uD(A\u0003'jgR\u0014UO\u001a4feB\u0011\u0011d`\u0005\u0004\u0003\u0003\u0011!a\u0003+y]6+G/\u00193bi\u0006Dq!!\u0002\u0001A\u0003%a/A\u0007ue\u0006t7/Y2uS>t7\u000f\t\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u000391\u0018\r\\5eCR,\u0017\t\u001d9f]\u0012$r\u0001NA\u0007\u0003\u001f\t\t\u0002\u0003\u0004-\u0003\u000f\u0001\rA\f\u0005\u0007y\u0005\u001d\u0001\u0019\u0001 \t\r!\u000b9\u00011\u0001?\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\t!\"\u001b8TKF,XM\\2f)\u0015q\u0012\u0011DA\u000e\u0011\u0019a\u00141\u0003a\u0001}!1\u0001*a\u0005A\u0002yBq!a\b\u0001\t\u0013\t\t#\u0001\u0005jg\u001a+gnY3e)\rq\u00121\u0005\u0005\u0007Y\u0005u\u0001\u0019\u0001\u0018\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u00051\u0011\r\u001d9f]\u0012$B!a\u000b\u00024A!\u0001bYA\u0017!\rI\u0012qF\u0005\u0004\u0003c\u0011!\u0001D\"p[BdW\r^3e)bt\u0007\u0002CA\u001b\u0003K\u0001\r!a\u000e\u0002\u000b\t\fGo\u00195\u0011\t\u0005e\u0012QJ\u0007\u0003\u0003wQA!!\u0010\u0002@\u00051!/Z2pe\u0012TA!!\u0011\u0002D\u000511m\\7n_:T1!BA#\u0015\u0011\t9%!\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY%A\u0002pe\u001eLA!a\u0014\u0002<\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\t9\u0003\u0001C\u0001\u0003'\"R\u0002NA+\u00033\nY&!\u0018\u0002b\u0005\r\u0004bBA,\u0003#\u0002\rAL\u0001\u0006KB|7\r\u001b\u0005\u0007y\u0005E\u0003\u0019\u0001 \t\r!\u000b\t\u00061\u0001?\u0011\u001d\ty&!\u0015A\u0002E\tQ\u0002\\1tiRKW.Z:uC6\u0004\bB\u0002)\u0002R\u0001\u0007\u0011\u0003C\u0004\u0002f\u0005E\u0003\u0019\u0001\u0010\u0002\u001f%\u001cHK]1og\u0006\u001cG/[8oC2Dq!!\u001b\u0001\t\u0003\tY'\u0001\nbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014HCCA\u0017\u0003[\n9(!\u001f\u0002~!A\u0011qNA4\u0001\u0004\t\t(\u0001\u0007f]\u0012$\u0006P\\'be.,'\u000f\u0005\u0003\u0002:\u0005M\u0014\u0002BA;\u0003w\u0011A#\u00128e)J\fgn]1di&|g.T1sW\u0016\u0014\bB\u0002\u0017\u0002h\u0001\u0007a\u0006C\u0004\u0002|\u0005\u001d\u0004\u0019A\t\u0002\r=4gm]3u\u0011\u001d\ty(a\u001aA\u0002E\t\u0011\u0002^5nKN$\u0018-\u001c9\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\u0006IA.Y:u\u000b:$(/_\u000b\u00021!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0015aE:uCJ$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cXCAAG!\u0015\ty)a(\u007f\u001d\u0011\t\t*a'\u000f\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&\u0010\u0003\u0019a$o\\8u}%\t!\"C\u0002\u0002\u001e&\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0006\r&\u0001\u0002'jgRT1!!(\n\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u000b\u0001%\\1zE\u0016\u001c\u0015m\u00195f)btg)\u001b:ti>3gm]3u\u001b\u0016$\u0018\rZ1uCR\u0019A'a+\t\u0011\u00055\u0016Q\u0015a\u0001\u0003_\u000b\u0011\u0003\\8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[\t\u000511/\u001a:wKJLA!!/\u00024\n\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\u0006AAo\\*ue&tw\r\u0006\u0002\u0002BB!\u00111YAf\u001d\u0011\t)-a2\u0011\u0007\u0005M\u0015\"C\u0002\u0002J&\ta\u0001\u0015:fI\u00164\u0017\u0002BAg\u0003\u001f\u0014aa\u0015;sS:<'bAAe\u0013\u0001")
public class ProducerAppendInfo {
    private final long producerId;
    private final boolean validateSequenceNumbers;
    private final boolean loadingFromLog;
    private short producerEpoch;
    private int firstSeq;
    private int lastSeq;
    private long lastOffset;
    private long maxTimestamp;
    private Option<Object> currentTxnFirstOffset;
    private int coordinatorEpoch;
    private final ListBuffer<TxnMetadata> transactions;

    public long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    private int firstSeq() {
        return this.firstSeq;
    }

    private void firstSeq_$eq(int x$1) {
        this.firstSeq = x$1;
    }

    private int lastSeq() {
        return this.lastSeq;
    }

    private void lastSeq_$eq(int x$1) {
        this.lastSeq = x$1;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(long x$1) {
        this.lastOffset = x$1;
    }

    private long maxTimestamp() {
        return this.maxTimestamp;
    }

    private void maxTimestamp_$eq(long x$1) {
        this.maxTimestamp = x$1;
    }

    private Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    private void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private void validateAppend(short producerEpoch, int firstSeq, int lastSeq) {
        if (this.isFenced(producerEpoch)) {
            throw new ProducerFencedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer's epoch is no longer valid. There is probably another producer "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with a newer epoch. ", " (request epoch), ", " (server epoch)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.producerEpoch())})));
        }
        if (this.validateSequenceNumbers) {
            if (producerEpoch != this.producerEpoch()) {
                if (firstSeq != 0) {
                    throw new OutOfOrderSequenceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number for new epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(request epoch), ", " (seq. number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstSeq)})));
                }
            } else {
                if (this.firstSeq() == -1 && firstSeq != 0) {
                    throw new OutOfOrderSequenceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": found ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)firstSeq)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), but expected 0"})).s((Seq)Nil$.MODULE$));
                }
                if (firstSeq == this.firstSeq() && lastSeq == this.lastSeq()) {
                    throw new DuplicateSequenceNumberException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate sequence number for producerId ", ": (incomingBatch.firstSeq, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incomingBatch.lastSeq): (", ", ", "), (lastEntry.firstSeq, lastEntry.lastSeq): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstSeq), BoxesRunTime.boxToInteger((int)lastSeq)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.firstSeq()), BoxesRunTime.boxToInteger((int)this.lastSeq())})));
                }
                if (!this.inSequence(firstSeq, lastSeq)) {
                    throw new OutOfOrderSequenceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)firstSeq)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), ", " (current end sequence number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastSeq())})));
                }
            }
        }
    }

    private boolean inSequence(int firstSeq, int lastSeq) {
        return (long)firstSeq == (long)this.lastSeq() + 1L || firstSeq == 0 && this.lastSeq() == Integer.MAX_VALUE;
    }

    private boolean isFenced(short producerEpoch) {
        return producerEpoch < this.producerEpoch();
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Record record = (Record)batch.iterator().next();
            EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
            CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
            none$ = new Some((Object)completedTxn);
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long lastOffset, boolean isTransactional) {
        block2: {
            if (epoch != -1 && !this.loadingFromLog) {
                this.validateAppend(epoch, firstSeq, lastSeq);
            }
            this.producerEpoch_$eq(epoch);
            this.firstSeq_$eq(firstSeq);
            this.lastSeq_$eq(lastSeq);
            this.maxTimestamp_$eq(lastTimestamp);
            this.lastOffset_$eq(lastOffset);
            if (this.currentTxnFirstOffset().isDefined() && !isTransactional) {
                throw new InvalidTxnStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected transactional write from producer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})));
            }
            if (!isTransactional || !this.currentTxnFirstOffset().isEmpty()) break block2;
            long firstOffset = lastOffset - (long)(lastSeq - firstSeq);
            this.currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        if (this.isFenced(producerEpoch)) {
            throw new ProducerFencedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer epoch: ", " (zombie): ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.producerEpoch())})));
        }
        if (this.coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            throw new TransactionCoordinatorFencedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid coordinator epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(zombie), ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.coordinatorEpoch())})));
        }
        if (producerEpoch != this.producerEpoch()) {
            this.producerEpoch_$eq(producerEpoch);
            this.firstSeq_$eq(-1);
            this.lastSeq_$eq(-1);
        } else {
            this.firstSeq_$eq(this.lastSeq());
        }
        Option<Object> option = this.currentTxnFirstOffset();
        if (option instanceof Some) {
            long txnFirstOffset;
            Some some = (Some)option;
            l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.lastOffset_$eq(offset);
        this.currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.maxTimestamp_$eq(timestamp);
        this.coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerIdEntry lastEntry() {
        return new ProducerIdEntry(this.producerId(), this.producerEpoch(), this.lastSeq(), this.lastOffset(), this.lastSeq() - this.firstSeq(), this.maxTimestamp(), this.coordinatorEpoch(), this.currentTxnFirstOffset());
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1 & Serializable & scala.Serializable)txn -> {
            ProducerAppendInfo.$anonfun$maybeCacheTxnFirstOffsetMetadata$1(logOffsetMetadata, txn);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return "ProducerAppendInfo(" + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.firstSeq())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastSeq())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentTxnFirstOffset()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.coordinatorEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startedTransactions=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactions()}));
    }

    public static final /* synthetic */ void $anonfun$maybeCacheTxnFirstOffsetMetadata$1(LogOffsetMetadata logOffsetMetadata$1, TxnMetadata txn) {
        block0: {
            if (txn.firstOffset().messageOffset() != logOffsetMetadata$1.messageOffset()) break block0;
            txn.firstOffset_$eq(logOffsetMetadata$1);
        }
    }

    public ProducerAppendInfo(long producerId, ProducerIdEntry initialEntry, boolean validateSequenceNumbers, boolean loadingFromLog) {
        this.producerId = producerId;
        this.validateSequenceNumbers = validateSequenceNumbers;
        this.loadingFromLog = loadingFromLog;
        this.producerEpoch = initialEntry.producerEpoch();
        this.firstSeq = initialEntry.firstSeq();
        this.lastSeq = initialEntry.lastSeq();
        this.lastOffset = initialEntry.lastOffset();
        this.maxTimestamp = initialEntry.timestamp();
        this.currentTxnFirstOffset = initialEntry.currentTxnFirstOffset();
        this.coordinatorEpoch = initialEntry.coordinatorEpoch();
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
    }
}

