/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.Serializable;
import kafka.security.auth.Acl;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.utils.Json$;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class Acl$
implements scala.Serializable {
    public static Acl$ MODULE$;
    private final KafkaPrincipal WildCardPrincipal;
    private final String WildCardHost;
    private final Acl AllowAllAcl;
    private final String PrincipalKey;
    private final String PermissionTypeKey;
    private final String OperationKey;
    private final String HostsKey;
    private final String VersionKey;
    private final int CurrentVersion;
    private final String AclsKey;

    static {
        new Acl$();
    }

    public KafkaPrincipal WildCardPrincipal() {
        return this.WildCardPrincipal;
    }

    public String WildCardHost() {
        return this.WildCardHost;
    }

    public Acl AllowAllAcl() {
        return this.AllowAllAcl;
    }

    public String PrincipalKey() {
        return this.PrincipalKey;
    }

    public String PermissionTypeKey() {
        return this.PermissionTypeKey;
    }

    public String OperationKey() {
        return this.OperationKey;
    }

    public String HostsKey() {
        return this.HostsKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public String AclsKey() {
        return this.AclsKey;
    }

    public Set<Acl> fromJson(String aclJson) {
        if (aclJson == null || aclJson.isEmpty()) {
            return Set$.MODULE$.empty();
        }
        ObjectRef acls = ObjectRef.create((Object)new HashSet());
        Option<Object> option = Json$.MODULE$.parseFull(aclJson);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object m = some.value();
            Map aclMap = (Map)m;
            Predef$.MODULE$.require(BoxesRunTime.equals((Object)aclMap.apply((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion())));
            List aclSet = (List)aclMap.apply((Object)this.AclsKey());
            aclSet.foreach((Function1 & Serializable & scala.Serializable)item -> {
                KafkaPrincipal principal = KafkaPrincipal.fromString((String)((String)item.apply((Object)this.PrincipalKey())));
                PermissionType permissionType = PermissionType$.MODULE$.fromString((String)item.apply((Object)this.PermissionTypeKey()));
                Operation operation = Operation$.MODULE$.fromString((String)item.apply((Object)this.OperationKey()));
                String host = (String)item.apply((Object)this.HostsKey());
                return ((HashSet)acls$1.elem).$plus$eq((Object)new Acl(principal, permissionType, host, operation));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return ((HashSet)acls.elem).toSet();
    }

    public Map<String, Object> toJsonCompatibleMap(Set<Acl> acls) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.AclsKey()), (Object)((TraversableOnce)acls.map((Function1 & Serializable & scala.Serializable)acl -> acl.toMap(), Set$.MODULE$.canBuildFrom())).toList())}));
    }

    public Acl apply(KafkaPrincipal principal, PermissionType permissionType, String host, Operation operation) {
        return new Acl(principal, permissionType, host, operation);
    }

    public Option<Tuple4<KafkaPrincipal, PermissionType, String, Operation>> unapply(Acl x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.principal(), (Object)x$0.permissionType(), (Object)x$0.host(), (Object)x$0.operation()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Acl$() {
        MODULE$ = this;
        this.WildCardPrincipal = new KafkaPrincipal("User", "*");
        this.WildCardHost = "*";
        this.AllowAllAcl = new Acl(this.WildCardPrincipal(), Allow$.MODULE$, this.WildCardHost(), All$.MODULE$);
        this.PrincipalKey = "principal";
        this.PermissionTypeKey = "permissionType";
        this.OperationKey = "operation";
        this.HostsKey = "host";
        this.VersionKey = "version";
        this.CurrentVersion = 1;
        this.AclsKey = "acls";
    }
}

