/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import kafka.server.BrokerMetadata;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u000f\tA\"I]8lKJlU\r^1eCR\f7\t[3dWB|\u0017N\u001c;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u0003\u00111\u0017\u000e\\3\u0016\u0003]\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\u0005%|'\"\u0001\u000f\u0002\t)\fg/Y\u0005\u0003=e\u0011AAR5mK\"A\u0001\u0005\u0001B\u0001B\u0003%q#A\u0003gS2,\u0007\u0005C\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0019\u0002\"!\n\u0001\u000e\u0003\tAQ!F\u0011A\u0002]Aq\u0001\u000b\u0001C\u0002\u0013%\u0011&\u0001\u0003m_\u000e\\W#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00055Z\u0012\u0001\u00027b]\u001eL!a\f\u0017\u0003\r=\u0013'.Z2u\u0011\u0019\t\u0004\u0001)A\u0005U\u0005)An\\2lA!)1\u0007\u0001C\u0001i\u0005)qO]5uKR\u0011Q\u0007\u000f\t\u0003\u0013YJ!a\u000e\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006sI\u0002\rAO\u0001\u000fEJ|7.\u001a:NKR\fG-\u0019;b!\t)3(\u0003\u0002=\u0005\tq!I]8lKJlU\r^1eCR\f\u0007\"\u0002 \u0001\t\u0003y\u0014\u0001\u0002:fC\u0012$\u0012\u0001\u0011\t\u0004\u0013\u0005S\u0014B\u0001\"\u000b\u0005\u0019y\u0005\u000f^5p]\u0002")
public class BrokerMetadataCheckpoint
implements Logging {
    private final File file;
    private final Object lock;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BrokerMetadataCheckpoint brokerMetadataCheckpoint = this;
        synchronized (brokerMetadataCheckpoint) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File file() {
        return this.file;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(BrokerMetadata brokerMetadata) {
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(brokerMetadata);
        }
    }

    public Option<BrokerMetadata> read() {
        Option option;
        Object object = new Object();
        try {
            Object object2 = this.lock();
            synchronized (object2) {
                Option option2 = this.liftedTree2$1(object);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                option = option2;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private final void liftedTree1$1(BrokerMetadata brokerMetadata$1) {
        try {
            Properties brokerMetaProps = new Properties();
            brokerMetaProps.setProperty("version", ((Object)BoxesRunTime.boxToInteger((int)0)).toString());
            brokerMetaProps.setProperty("broker.id", ((Object)BoxesRunTime.boxToInteger((int)brokerMetadata$1.brokerId())).toString());
            File temp = new File(this.file().getAbsolutePath() + ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(temp);
            try {
                brokerMetaProps.store(fileOutputStream, "");
                fileOutputStream.flush();
                fileOutputStream.getFD().sync();
            }
            finally {
                Utils.closeQuietly((AutoCloseable)fileOutputStream, (String)temp.getName());
            }
            Utils.atomicMoveWithFallback((Path)temp.toPath(), (Path)this.file().toPath());
        }
        catch (IOException ie) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to write meta.properties due to", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ie);
            throw ie;
        }
    }

    private final Option liftedTree2$1(Object nonLocalReturnKey1$1) {
        try {
            int version;
            VerifiableProperties brokerMetaProps = new VerifiableProperties(Utils.loadProps((String)this.file().getAbsolutePath()));
            int n = version = brokerMetaProps.getIntInRange("version", (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
            switch (n) {
                case 0: {
                    int brokerId = brokerMetaProps.getIntInRange("broker.id", (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new BrokerMetadata(brokerId)));
                }
            }
            throw new IOException("Unrecognized version of the server meta.properties file: " + version);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("No meta.properties file under dir %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()})));
        }
        catch (Exception e1) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to read meta.properties file under dir %s due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), e1.getMessage()})));
            throw e1;
        }
        return None$.MODULE$;
    }

    public BrokerMetadataCheckpoint(File file) {
        this.file = file;
        Logging.$init$(this);
        this.lock = new Object();
        Files.deleteIfExists(new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)file), ".tmp")).toPath());
    }
}

