/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\tI2\t\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\u0002C\u0007\u0001\u0005\u000b\u0007I\u0011\u0002\b\u0002\r\r|gNZ5h+\u0005y\u0001CA\u0005\u0011\u0013\t\t\"A\u0001\rDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u00148i\u001c8gS\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006IaD\u0001\bG>tg-[4!\u0011!)\u0002A!b\u0001\n\u00131\u0012aB7fiJL7m]\u000b\u0002/A\u0011\u0001$I\u0007\u00023)\u0011QC\u0007\u0006\u00037q\taaY8n[>t'BA\u0003\u001e\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\n\u0005\tJ\"aB'fiJL7m\u001d\u0005\tI\u0001\u0011\t\u0011)A\u0005/\u0005AQ.\u001a;sS\u000e\u001c\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0003(\u0003\u0011!\u0018.\\3\u0016\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00055R#\u0001\u0002+j[\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006i&lW\r\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM\"TG\u000e\t\u0003\u0013\u0001AQ!\u0004\u0019A\u0002=AQ!\u0006\u0019A\u0002]AQA\n\u0019A\u0002!Bq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011(A\tnCb$\u0006N]8ui2,G+[7f\u001bN,\u0012A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0005\u0019>tw\r\u0003\u0004B\u0001\u0001\u0006IAO\u0001\u0013[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\b\u0005C\u0004D\u0001\t\u0007I\u0011\u0001#\u0002\u0019\u0015DX-\u001c9u'\u0016t7o\u001c:\u0016\u0003\u0015\u0003\"\u0001\u0007$\n\u0005\u001dK\"AB*f]N|'\u000f\u0003\u0004J\u0001\u0001\u0006I!R\u0001\u000eKb,W\u000e\u001d;TK:\u001cxN\u001d\u0011\t\u000b-\u0003A\u0011\u0001'\u0002\u0019I,7m\u001c:e\u000bb,W\u000e\u001d;\u0015\u00055\u0003\u0006CA\u001eO\u0013\tyEH\u0001\u0003V]&$\b\"B)K\u0001\u0004\u0011\u0016!\u0002<bYV,\u0007CA\u001eT\u0013\t!FH\u0001\u0004E_V\u0014G.\u001a\u0005\u0006-\u0002!\tfV\u0001\ri\"\u0014x\u000e\u001e;mKRKW.\u001a\u000b\u0004uak\u0006\"B-V\u0001\u0004Q\u0016\u0001D2mS\u0016tG/T3ue&\u001c\u0007C\u0001\r\\\u0013\ta\u0016DA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0007\"B\u0007V\u0001\u0004q\u0006C\u0001\r`\u0013\t\u0001\u0017D\u0001\u0007NKR\u0014\u0018nY\"p]\u001aLw\rC\u0003c\u0001\u0011E3-\u0001\u000bdY&,g\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0004I\",\bCA3g\u001b\u0005Q\u0012BA4\u001b\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\u0006S\u0006\u0004\rA[\u0001\u000eg\u0006t\u0017\u000e^5{K\u0012,6/\u001a:\u0011\u0005-\u0014hB\u00017q!\tiG(D\u0001o\u0015\tyg!\u0001\u0004=e>|GOP\u0005\u0003cr\na\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000f\u0010\u0005\u0006m\u0006\u0004\rA[\u0001\tG2LWM\u001c;JI\")\u0001\u0010\u0001C\u0005s\u0006\u0001R\r_3naRlU\r\u001e:jG:\u000bW.Z\u000b\u0002I\")1\u0010\u0001C\u0005y\u0006\u0001R\r_3naR\u001cVM\\:pe:\u000bW.Z\u000b\u0002U\u0002")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;
    private final Sensor exemptSensor;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        return package$.MODULE$.min(super.throttleTime(clientMetric, config), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return "exempt-" + QuotaType$Request$.MODULE$;
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptSensor = this.createSensor(this.exemptSensorName(), this.exemptMetricName());
    }
}

