/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminClient;
import kafka.admin.TopicCommand;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Exit;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;

@InterfaceStability.Unstable
public class StreamsResetter {
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_ERROR = 1;
    private static OptionSpec<String> bootstrapServerOption;
    private static OptionSpec<String> zookeeperOption;
    private static OptionSpec<String> applicationIdOption;
    private static OptionSpec<String> inputTopicsOption;
    private static OptionSpec<String> intermediateTopicsOption;
    private static OptionSpecBuilder dryRunOption;
    private OptionSet options = null;
    private final Properties consumerConfig = new Properties();
    private final java.util.List<String> allTopics = new LinkedList<String>();
    private boolean dryRun = false;

    public int run(String[] args) {
        return this.run(args, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args, Properties config) {
        this.consumerConfig.clear();
        this.consumerConfig.putAll((Map<?, ?>)config);
        int exitCode = 0;
        AdminClient adminClient = null;
        ZkUtils zkUtils = null;
        try {
            this.parseArguments(args);
            this.dryRun = this.options.has((OptionSpec)dryRunOption);
            adminClient = AdminClient.createSimplePlaintext((String)this.options.valueOf(bootstrapServerOption));
            String groupId = (String)this.options.valueOf(applicationIdOption);
            zkUtils = ZkUtils.apply((String)this.options.valueOf(zookeeperOption), 30000, 30000, JaasUtils.isZkSecurityEnabled());
            this.allTopics.clear();
            this.allTopics.addAll(JavaConversions.seqAsJavaList(zkUtils.getAllTopics()));
            if (!((List)adminClient.describeConsumerGroup(groupId, 0L).consumers().get()).isEmpty()) {
                throw new IllegalStateException("Consumer group '" + groupId + "' is still active. Make sure to stop all running application instances before running the reset tool.");
            }
            if (this.dryRun) {
                System.out.println("----Dry run displays the actions which will be performed when running Streams Reset Tool----");
            }
            this.maybeResetInputAndSeekToEndIntermediateTopicOffsets();
            this.maybeDeleteInternalTopics(zkUtils);
        }
        catch (Throwable e) {
            exitCode = 1;
            System.err.println("ERROR: " + e.getMessage());
        }
        finally {
            if (adminClient != null) {
                adminClient.close();
            }
            if (zkUtils != null) {
                zkUtils.close();
            }
        }
        return exitCode;
    }

    private void parseArguments(String[] args) throws IOException {
        OptionParser optionParser = new OptionParser(false);
        applicationIdOption = optionParser.accepts("application-id", "The Kafka Streams application ID (application.id).").withRequiredArg().ofType(String.class).describedAs("id").required();
        bootstrapServerOption = optionParser.accepts("bootstrap-servers", "Comma-separated list of broker urls with format: HOST1:PORT1,HOST2:PORT2").withRequiredArg().ofType(String.class).defaultsTo((Object)"localhost:9092", (Object[])new String[0]).describedAs("urls");
        zookeeperOption = optionParser.accepts("zookeeper", "Zookeeper url with format: HOST:POST").withRequiredArg().ofType(String.class).defaultsTo((Object)"localhost:2181", (Object[])new String[0]).describedAs("url");
        inputTopicsOption = optionParser.accepts("input-topics", "Comma-separated list of user input topics. For these topics, the tool will reset the offset to the earliest available offset.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("list");
        intermediateTopicsOption = optionParser.accepts("intermediate-topics", "Comma-separated list of intermediate user topics (topics used in the through() method). For these topics, the tool will skip to the end.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("list");
        dryRunOption = optionParser.accepts("dry-run", "Display the actions that would be performed without executing the reset commands.");
        try {
            this.options = optionParser.parse(args);
        }
        catch (OptionException e) {
            this.printHelp(optionParser);
            throw e;
        }
    }

    private void maybeResetInputAndSeekToEndIntermediateTopicOffsets() {
        java.util.List inputTopics = this.options.valuesOf(inputTopicsOption);
        java.util.List intermediateTopics = this.options.valuesOf(intermediateTopicsOption);
        ArrayList<String> notFoundInputTopics = new ArrayList<String>();
        ArrayList<String> notFoundIntermediateTopics = new ArrayList<String>();
        String groupId = (String)this.options.valueOf(applicationIdOption);
        if (inputTopics.size() == 0 && intermediateTopics.size() == 0) {
            System.out.println("No input or intermediate topics specified. Skipping seek.");
            return;
        }
        if (!this.dryRun) {
            if (inputTopics.size() != 0) {
                System.out.println("Seek-to-beginning for input topics " + inputTopics);
            }
            if (intermediateTopics.size() != 0) {
                System.out.println("Seek-to-end for intermediate topics " + intermediateTopics);
            }
        }
        HashSet<String> topicsToSubscribe = new HashSet<String>(inputTopics.size() + intermediateTopics.size());
        for (String topic : inputTopics) {
            if (!this.allTopics.contains(topic)) {
                notFoundInputTopics.add(topic);
                continue;
            }
            topicsToSubscribe.add(topic);
        }
        for (String topic : intermediateTopics) {
            if (!this.allTopics.contains(topic)) {
                notFoundIntermediateTopics.add(topic);
                continue;
            }
            topicsToSubscribe.add(topic);
        }
        Properties config = new Properties();
        config.putAll((Map<?, ?>)this.consumerConfig);
        config.setProperty("bootstrap.servers", (String)this.options.valueOf(bootstrapServerOption));
        config.setProperty("group.id", groupId);
        config.setProperty("enable.auto.commit", "false");
        try (KafkaConsumer client = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            client.subscribe(topicsToSubscribe);
            client.poll(1L);
            Set partitions = client.assignment();
            HashSet<TopicPartition> inputTopicPartitions = new HashSet<TopicPartition>();
            HashSet<TopicPartition> intermediateTopicPartitions = new HashSet<TopicPartition>();
            for (TopicPartition p : partitions) {
                String topic = p.topic();
                if (this.isInputTopic(topic)) {
                    inputTopicPartitions.add(p);
                    continue;
                }
                if (this.isIntermediateTopic(topic)) {
                    intermediateTopicPartitions.add(p);
                    continue;
                }
                System.err.println("Skipping invalid partition: " + p);
            }
            this.maybeSeekToBeginning((KafkaConsumer<byte[], byte[]>)client, inputTopicPartitions);
            this.maybeSeekToEnd((KafkaConsumer<byte[], byte[]>)client, intermediateTopicPartitions);
            if (!this.dryRun) {
                for (TopicPartition p : partitions) {
                    client.position(p);
                }
                client.commitSync();
            }
            if (notFoundInputTopics.size() > 0) {
                System.out.println("Following input topics are not found, skipping them");
                for (String topic : notFoundInputTopics) {
                    System.out.println("Topic: " + topic);
                }
            }
            if (notFoundIntermediateTopics.size() > 0) {
                System.out.println("Following intermediate topics are not found, skipping them");
                for (String topic : notFoundIntermediateTopics) {
                    System.out.println("Topic:" + topic);
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println("ERROR: Resetting offsets failed.");
            throw e;
        }
        System.out.println("Done.");
    }

    private void maybeSeekToEnd(KafkaConsumer<byte[], byte[]> client, Set<TopicPartition> intermediateTopicPartitions) {
        String groupId = (String)this.options.valueOf(applicationIdOption);
        java.util.List intermediateTopics = this.options.valuesOf(intermediateTopicsOption);
        if (intermediateTopicPartitions.size() > 0) {
            if (!this.dryRun) {
                client.seekToEnd(intermediateTopicPartitions);
            } else {
                System.out.println("Following intermediate topics offsets will be reset to end (for consumer group " + groupId + ")");
                for (String topic : intermediateTopics) {
                    if (!this.allTopics.contains(topic)) continue;
                    System.out.println("Topic: " + topic);
                }
            }
        }
    }

    private void maybeSeekToBeginning(KafkaConsumer<byte[], byte[]> client, Set<TopicPartition> inputTopicPartitions) {
        java.util.List inputTopics = this.options.valuesOf(inputTopicsOption);
        String groupId = (String)this.options.valueOf(applicationIdOption);
        if (inputTopicPartitions.size() > 0) {
            if (!this.dryRun) {
                client.seekToBeginning(inputTopicPartitions);
            } else {
                System.out.println("Following input topics offsets will be reset to beginning (for consumer group " + groupId + ")");
                for (String topic : inputTopics) {
                    if (!this.allTopics.contains(topic)) continue;
                    System.out.println("Topic: " + topic);
                }
            }
        }
    }

    private boolean isInputTopic(String topic) {
        return this.options.valuesOf(inputTopicsOption).contains(topic);
    }

    private boolean isIntermediateTopic(String topic) {
        return this.options.valuesOf(intermediateTopicsOption).contains(topic);
    }

    private void maybeDeleteInternalTopics(ZkUtils zkUtils) {
        System.out.println("Deleting all internal/auto-created topics for application " + (String)this.options.valueOf(applicationIdOption));
        for (String topic : this.allTopics) {
            if (!this.isInternalTopic(topic)) continue;
            try {
                if (!this.dryRun) {
                    TopicCommand.TopicCommandOptions commandOptions = new TopicCommand.TopicCommandOptions(new String[]{"--zookeeper", (String)this.options.valueOf(zookeeperOption), "--delete", "--topic", topic});
                    TopicCommand.deleteTopic(zkUtils, commandOptions);
                    continue;
                }
                System.out.println("Topic: " + topic);
            }
            catch (RuntimeException e) {
                System.err.println("ERROR: Deleting topic " + topic + " failed.");
                throw e;
            }
        }
        System.out.println("Done.");
    }

    private boolean isInternalTopic(String topicName) {
        return topicName.startsWith((String)this.options.valueOf(applicationIdOption) + "-") && (topicName.endsWith("-changelog") || topicName.endsWith("-repartition"));
    }

    private void printHelp(OptionParser parser) throws IOException {
        System.err.println("The Application Reset Tool allows you to quickly reset an application in order to reprocess its data from scratch.\n* This tool resets offsets of input topics to the earliest available offset and it skips to the end of intermediate topics (topics used in the through() method).\n* This tool deletes the internal topics that were created by Kafka Streams (topics starting with \"<application.id>-\").\nYou do not need to specify internal topics because the tool finds them automatically.\n* This tool will not delete output topics (if you want to delete them, you need to do it yourself with the bin/kafka-topics.sh command).\n* This tool will not clean up the local state on the stream application instances (the persisted stores used to cache aggregation results).\nYou need to call KafkaStreams#cleanUp() in your application or manually delete them from the directory specified by \"state.dir\" configuration (/tmp/kafka-streams/<application.id> by default).\n\n*** Important! You will get wrong output if you don't clean up the local stores after running the reset tool!\n\n");
        parser.printHelpOn((OutputStream)System.err);
    }

    public static void main(String[] args) {
        Exit.exit((int)new StreamsResetter().run(args));
    }
}

