/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import kafka.TestLinearWriteSpeed$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.server.BrokerTopicStats;
import kafka.utils.Scheduler;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001du!B\u0001\u0003\u0011\u0003)\u0011\u0001\u0006+fgRd\u0015N\\3be^\u0013\u0018\u000e^3Ta\u0016,GMC\u0001\u0004\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AB\u0004\u000e\u0003\t1Q\u0001\u0003\u0002\t\u0002%\u0011A\u0003V3ti2Kg.Z1s/JLG/Z*qK\u0016$7CA\u0004\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011c\u0002C\u0001%\u00051A(\u001b8jiz\"\u0012!\u0002\u0005\u0006)\u001d!\t!F\u0001\u0005[\u0006Lg\u000e\u0006\u0002\u00173A\u00111bF\u0005\u000311\u0011A!\u00168ji\")!d\u0005a\u00017\u0005!\u0011M]4t!\rYADH\u0005\u0003;1\u0011Q!\u0011:sCf\u0004\"a\b\u0014\u000f\u0005\u0001\"\u0003CA\u0011\r\u001b\u0005\u0011#BA\u0012\u0005\u0003\u0019a$o\\8u}%\u0011Q\u0005D\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&\u0019\u00199!f\u0002I\u0001$\u0003Y#\u0001C,sSR\f'\r\\3\u0014\u0005%R\u0001\"B\u0017*\r\u0003q\u0013!B<sSR,G#A\u0018\u0011\u0005-\u0001\u0014BA\u0019\r\u0005\rIe\u000e\u001e\u0005\u0006g%2\t\u0001N\u0001\u0006G2|7/\u001a\u000b\u0002-\u0019!ag\u0002\u00018\u00051iU.\u00199Xe&$\u0018M\u00197f'\r)$\u0002\u000f\t\u0003s%j\u0011a\u0002\u0005\twU\u0012)\u0019!C\u0001y\u0005!a-\u001b7f+\u0005i\u0004C\u0001 D\u001b\u0005y$B\u0001!B\u0003\tIwNC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$\u0001\u0002$jY\u0016D\u0001BR\u001b\u0003\u0002\u0003\u0006I!P\u0001\u0006M&dW\r\t\u0005\t\u0011V\u0012\t\u0011)A\u0005\u0013\u0006!1/\u001b>f!\tY!*\u0003\u0002L\u0019\t!Aj\u001c8h\u0011!iUG!b\u0001\n\u0003q\u0015aB2p]R,g\u000e^\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!+Q\u0001\u0004]&|\u0017B\u0001+R\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\t-V\u0012\t\u0011)A\u0005\u001f\u0006A1m\u001c8uK:$\b\u0005C\u0003\u0012k\u0011\u0005\u0001\f\u0006\u0003Z5nc\u0006CA\u001d6\u0011\u0015Yt\u000b1\u0001>\u0011\u0015Au\u000b1\u0001J\u0011\u0015iu\u000b1\u0001P\u0011\u001dqVG1A\u0005\u0002}\u000b1A]1g+\u0005\u0001\u0007C\u0001 b\u0013\t\u0011wH\u0001\tSC:$w.\\!dG\u0016\u001c8OR5mK\"1A-\u000eQ\u0001\n\u0001\fAA]1gA!9a-\u000eb\u0001\n\u00039\u0017A\u00022vM\u001a,'/F\u0001i!\t\u0001\u0016.\u0003\u0002k#\n\u0001R*\u00199qK\u0012\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0007YV\u0002\u000b\u0011\u00025\u0002\u000f\t,hMZ3sA!)Q&\u000eC\u0001]!)1'\u000eC\u0001i\u0019!\u0001o\u0002\u0001r\u0005=\u0019\u0005.\u00198oK2<&/\u001b;bE2,7cA8\u000bq!A1h\u001cBC\u0002\u0013\u0005A\b\u0003\u0005G_\n\u0005\t\u0015!\u0003>\u0011!iuN!b\u0001\n\u0003q\u0005\u0002\u0003,p\u0005\u0003\u0005\u000b\u0011B(\t\u000bEyG\u0011A<\u0015\u0007aL(\u0010\u0005\u0002:_\")1H\u001ea\u0001{!)QJ\u001ea\u0001\u001f\"9al\u001cb\u0001\n\u0003y\u0006B\u00023pA\u0003%\u0001\rC\u0004\u007f_\n\u0007I\u0011A@\u0002\u000f\rD\u0017M\u001c8fYV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA)\u0002\u0011\rD\u0017M\u001c8fYNLA!a\u0003\u0002\u0006\tYa)\u001b7f\u0007\"\fgN\\3m\u0011!\tya\u001cQ\u0001\n\u0005\u0005\u0011\u0001C2iC:tW\r\u001c\u0011\t\u000b5zG\u0011\u0001\u0018\t\u000bMzG\u0011\u0001\u001b\u0007\r\u0005]q\u0001AA\r\u0005-aunZ,sSR\f'\r\\3\u0014\t\u0005U!\u0002\u000f\u0005\u000b\u0003;\t)B!b\u0001\n\u0003a\u0014a\u00013je\"Q\u0011\u0011EA\u000b\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\t\u0011L'\u000f\t\u0005\f\u0003K\t)B!A!\u0002\u0013\t9#\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0002\u0002\u00071|w-\u0003\u0003\u00022\u0005-\"!\u0003'pO\u000e{gNZ5h\u0011-\t)$!\u0006\u0003\u0002\u0003\u0006I!a\u000e\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u\"!A\u0003vi&d7/\u0003\u0003\u0002B\u0005m\"!C*dQ\u0016$W\u000f\\3s\u0011-\t)%!\u0006\u0003\u0006\u0004%\t!a\u0012\u0002\u00115,7o]1hKN,\"!!\u0013\u0011\t\u0005-\u0013qL\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u00051!/Z2pe\u0012TA!a\u0015\u0002V\u000511m\\7n_:T1aAA,\u0015\u0011\tI&a\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti&A\u0002pe\u001eLA!!\u0019\u0002N\tiQ*Z7pef\u0014VmY8sIND1\"!\u001a\u0002\u0016\t\u0005\t\u0015!\u0003\u0002J\u0005IQ.Z:tC\u001e,7\u000f\t\u0005\b#\u0005UA\u0011AA5))\tY'!\u001c\u0002p\u0005E\u00141\u000f\t\u0004s\u0005U\u0001bBA\u000f\u0003O\u0002\r!\u0010\u0005\t\u0003K\t9\u00071\u0001\u0002(!A\u0011QGA4\u0001\u0004\t9\u0004\u0003\u0005\u0002F\u0005\u001d\u0004\u0019AA%\u0011)\ti#!\u0006C\u0002\u0013\u0005\u0011qO\u000b\u0003\u0003s\u0002B!!\u000b\u0002|%!\u0011QPA\u0016\u0005\raun\u001a\u0005\n\u0003\u0003\u000b)\u0002)A\u0005\u0003s\nA\u0001\\8hA!1Q&!\u0006\u0005\u00029BaaMA\u000b\t\u0003!\u0004")
public final class TestLinearWriteSpeed {
    public static void main(String[] stringArray) {
        TestLinearWriteSpeed$.MODULE$.main(stringArray);
    }

    public static class ChannelWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final RandomAccessFile raf;
        private final FileChannel channel;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public RandomAccessFile raf() {
            return this.raf;
        }

        public FileChannel channel() {
            return this.channel;
        }

        @Override
        public int write() {
            this.channel().write(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.raf().close();
        }

        public ChannelWritable(File file, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.raf = new RandomAccessFile(file, "rw");
            this.channel = this.raf().getChannel();
        }
    }

    public static class LogWritable
    implements Writable {
        private final File dir;
        private final MemoryRecords messages;
        private final Log log;

        public File dir() {
            return this.dir;
        }

        public MemoryRecords messages() {
            return this.messages;
        }

        public Log log() {
            return this.log;
        }

        @Override
        public int write() {
            this.log().appendAsLeader(this.messages(), 0, this.log().appendAsLeader$default$3());
            return this.messages().sizeInBytes();
        }

        @Override
        public void close() {
            this.log().close();
            Utils.delete((File)this.log().dir());
        }

        public LogWritable(File dir, LogConfig config, Scheduler scheduler, MemoryRecords messages) {
            this.dir = dir;
            this.messages = messages;
            Utils.delete((File)dir);
            this.log = Log$.MODULE$.apply(dir, config, 0L, 0L, scheduler, new BrokerTopicStats(), Time.SYSTEM, Log$.MODULE$.apply$default$8(), Log$.MODULE$.apply$default$9());
        }
    }

    public static class MmapWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final RandomAccessFile raf;
        private final MappedByteBuffer buffer;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public RandomAccessFile raf() {
            return this.raf;
        }

        public MappedByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public int write() {
            this.buffer().put(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.raf().close();
        }

        public MmapWritable(File file, long size, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.raf = new RandomAccessFile(file, "rw");
            this.raf().setLength(size);
            this.buffer = this.raf().getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.raf().length());
        }
    }

    public static interface Writable {
        public int write();

        public void close();
    }
}

