/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001A\u0002\u0013\u0005Q#A\u0004d_:4\u0017nZ:\u0016\u0003Y\u00012aF\u0011%\u001d\tAbD\u0004\u0002\u001a95\t!D\u0003\u0002\u001c\r\u00051AH]8pizJ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?\u0001\nq\u0001]1dW\u0006<WMC\u0001\u001e\u0013\t\u00113EA\u0002TKFT!a\b\u0011\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\"\u0011AB:feZ,'/\u0003\u0002*M\tY1*\u00194lC\u000e{gNZ5h\u0011\u001dY\u0003\u00011A\u0005\u00021\n1bY8oM&<7o\u0018\u0013fcR\u0011Q&\r\t\u0003]=j\u0011\u0001I\u0005\u0003a\u0001\u0012A!\u00168ji\"9!GKA\u0001\u0002\u00041\u0012a\u0001=%c!1A\u0007\u0001Q!\nY\t\u0001bY8oM&<7\u000f\t\u0005\bm\u0001\u0001\r\u0011\"\u00018\u0003\u001d\u0019XM\u001d<feN,\u0012\u0001\u000f\t\u0004/\u0005J\u0004CA\u0013;\u0013\tYdEA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u001f\u0001\u0001\u0004%\tAP\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002.\u007f!9!\u0007PA\u0001\u0002\u0004A\u0004BB!\u0001A\u0003&\u0001(\u0001\u0005tKJ4XM]:!\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011\u000bqA\u0019:pW\u0016\u00148/F\u0001F!\r9\u0012E\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u0012\tqa\u00197vgR,'/\u0003\u0002L\u0011\n1!I]8lKJDq!\u0014\u0001A\u0002\u0013\u0005a*A\u0006ce>\\WM]:`I\u0015\fHCA\u0017P\u0011\u001d\u0011D*!AA\u0002\u0015Ca!\u0015\u0001!B\u0013)\u0015\u0001\u00032s_.,'o\u001d\u0011\t\u000fM\u0003!\u0019!C\u0001)\u0006Y\u0001/\u0019:uSRLwN\\%e+\u0005)\u0006C\u0001\u0018W\u0013\t9\u0006EA\u0002J]RDa!\u0017\u0001!\u0002\u0013)\u0016\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001X\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\t1\fgn\u001a\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0004TiJLgn\u001a\u0005\u0007M\u0002\u0001\u000b\u0011B/\u0002\u000fQ|\u0007/[22A!9\u0001\u000e\u0001b\u0001\n\u0003a\u0016A\u0002;pa&\u001c'\u0007\u0003\u0004k\u0001\u0001\u0006I!X\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u001da\u0007A1A\u0005\u0002q\u000ba\u0001^8qS\u000e\u001c\u0004B\u00028\u0001A\u0003%Q,A\u0004u_BL7m\r\u0011\t\u000fA\u0004!\u0019!C\u00019\u00061Ao\u001c9jGRBaA\u001d\u0001!\u0002\u0013i\u0016a\u0002;pa&\u001cG\u0007\t\u0005\u0006i\u0002!\t%^\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002[!\u00121o\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\fQA[;oSRT\u0011\u0001`\u0001\u0004_J<\u0017B\u0001@z\u0005\u0019\u0011UMZ8sK\"1\u0011\u0011\u0001\u0001\u0005BU\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u007f\u0006\u0015\u0001c\u0001=\u0002\b%\u0019\u0011\u0011B=\u0003\u000b\u00053G/\u001a:\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\u0005)B/Z:u)>\u0004\u0018n\u0019#pKNtu\u000e^#ySN$X#A\u0017)\t\u0005-\u00111\u0003\t\u0004q\u0006U\u0011bAA\fs\n!A+Z:u\u0011\u001d\tY\u0002\u0001C\u0001\u0003\u001f\tQ\u0003^3ti^\u0013xN\\4SKBd\u0017nY1D_VtG\u000f\u000b\u0003\u0002\u001a\u0005M\u0001bBA\u0011\u0001\u0011\u0005\u0011qB\u0001\u0018i\u0016\u001cH/\u00138de\u0016lWM\u001c;QCJ$\u0018\u000e^5p]NDC!a\b\u0002\u0014!9\u0011q\u0005\u0001\u0005\u0002\u0005=\u0011A\b;fgRl\u0015M\\;bY\u0006\u001b8/[4o[\u0016tGo\u00144SKBd\u0017nY1tQ\u0011\t)#a\u0005\t\u000f\u00055\u0002\u0001\"\u0001\u0002\u0010\u0005qB/Z:u%\u0016\u0004H.[2b!2\f7-Z7f]R\fE\u000e\\*feZ,'o\u001d\u0015\u0005\u0003W\t\u0019\u0002C\u0004\u00024\u0001!\t!a\u0004\u0002EQ,7\u000f\u001e*fa2L7-\u0019)mC\u000e,W.\u001a8u!\u0006\u0014H/[1m'\u0016\u0014h/\u001a:tQ\u0011\t\t$a\u0005\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<\u0005Ib/\u00197jI\u0006$X\rT3bI\u0016\u0014\u0018I\u001c3SKBd\u0017nY1t)%i\u0013QHA'\u0003\u001f\n\u0019\u0006\u0003\u0005\u0002@\u0005]\u0002\u0019AA!\u0003!iW\r^1eCR\f\u0007\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dC!A\u0002ba&LA!a\u0013\u0002F\tiAk\u001c9jG6+G/\u00193bi\u0006DaaUA\u001c\u0001\u0004)\u0006bBA)\u0003o\u0001\r!V\u0001\u0011Kb\u0004Xm\u0019;fI2+\u0017\rZ3s\u0013\u0012D\u0001\"!\u0016\u00028\u0001\u0007\u0011qK\u0001\u0011Kb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCN\u0004R!!\u0017\u0002bUsA!a\u0017\u0002^A\u0011\u0011\u0004I\u0005\u0004\u0003?\u0002\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$aA*fi*\u0019\u0011q\f\u0011")
public class AddPartitionsTest
extends ZooKeeperTestHarness {
    private Seq<KafkaConfig> configs = null;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private Seq<Broker> brokers = (Seq)Seq$.MODULE$.empty();
    private final int partitionId;
    private final String topic1;
    private final String topic2;
    private final String topic3;
    private final String topic4;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Seq<Broker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<Broker> x$1) {
        this.brokers = x$1;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String topic3() {
        return this.topic3;
    }

    public String topic4() {
        return this.topic4;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configs_$eq((Seq<KafkaConfig>)((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), IndexedSeq$.MODULE$.canBuildFrom())));
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.configs().map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer((KafkaConfig)c, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        this.brokers_$eq((Seq<Broker>)((Seq)this.servers().map((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createBroker(s.config().brokerId(), s.config().hostName(), TestUtils$.MODULE$.boundPort((KafkaServer)s, TestUtils$.MODULE$.boundPort$default$2()), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic2(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic3(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic4(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}))), this.servers());
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testTopicDoesNotExist() {
        try {
            AdminUtils$.MODULE$.addPartitions(this.zkUtils(), "Blah", 1, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
            throw this.fail("Topic should not exist", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic1(), 2, "0:1,0:1:2", AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic1(), 3, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic1(), 1).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic1(), 2).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), (Seq)this.brokers().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getBrokerEndPoint(listenerName), Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testIncrementPartitions", 2000, 0).topicsMetadata();
        Seq metaDataForTopic1 = (Seq)metadata.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$testIncrementPartitions$2(this, p)));
        Seq partitionDataForTopic1 = (Seq)((TopicMetadata)metaDataForTopic1.head()).partitionsMetadata().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partitionId()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitionDataForTopic1.size(), (long)3L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic1.apply(1)).partitionId(), (long)1L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic1.apply(2)).partitionId(), (long)2L);
        Seq replicas = ((PartitionMetadata)partitionDataForTopic1.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Seq $org_scalatest_assert_macro_left = replicas;
        BrokerEndPoint $org_scalatest_assert_macro_right = (BrokerEndPoint)((PartitionMetadata)partitionDataForTopic1.apply(1)).leader().get();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        Bool bool;
        Bool bool2;
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic2(), 3, "1:2,0:1,2:3", AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic2(), 1).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic2(), 2).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})), (Seq)this.brokers().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)), Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testManualAssignmentOfReplicas", 2000, 0).topicsMetadata();
        Seq metaDataForTopic2 = (Seq)metadata.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$testManualAssignmentOfReplicas$2(this, p)));
        Seq partitionDataForTopic2 = (Seq)((TopicMetadata)metaDataForTopic2.head()).partitionsMetadata().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.partitionId()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitionDataForTopic2.size(), (long)3L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic2.apply(1)).partitionId(), (long)1L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic2.apply(2)).partitionId(), (long)2L);
        Seq replicas = ((PartitionMetadata)partitionDataForTopic2.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        int $org_scalatest_assert_macro_left = ((BrokerEndPoint)replicas.head()).id();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left2.value()) {
            bool2 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
        } else {
            int $org_scalatest_assert_macro_left3 = ((BrokerEndPoint)replicas.head()).id();
            int $org_scalatest_assert_macro_right2 = 1;
            bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right3 = bool2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        int $org_scalatest_assert_macro_left4 = ((BrokerEndPoint)replicas.apply(1)).id();
        int $org_scalatest_assert_macro_right4 = 0;
        Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left5.value()) {
            bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
        } else {
            int $org_scalatest_assert_macro_left6 = ((BrokerEndPoint)replicas.apply(1)).id();
            int $org_scalatest_assert_macro_right5 = 1;
            bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right6 = bool;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "||", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic3(), 7, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()})), (Seq)this.brokers().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)), Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testReplicaPlacementAllServers", 2000, 0).topicsMetadata();
        TopicMetadata metaDataForTopic3 = (TopicMetadata)metadata.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$testReplicaPlacementAllServers$2(this, p))).get();
        this.validateLeaderAndReplicas(metaDataForTopic3, 0, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 1, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 2, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 3, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 4, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 5, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 6, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic2(), 3, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})), (Seq)this.brokers().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)), Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testReplicaPlacementPartialServers", 2000, 0).topicsMetadata();
        TopicMetadata metaDataForTopic2 = (TopicMetadata)metadata.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$testReplicaPlacementPartialServers$2(this, p))).get();
        this.validateLeaderAndReplicas(metaDataForTopic2, 0, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic2, 1, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic2, 2, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(TopicMetadata metadata, int partitionId, int expectedLeaderId, scala.collection.immutable.Set<Object> expectedReplicas) {
        Option partitionOpt = metadata.partitionsMetadata().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$7)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})), (boolean)partitionOpt.isDefined());
        PartitionMetadata partition = (PartitionMetadata)partitionOpt.get();
        Assert.assertTrue((String)"Partition leader should exist", (boolean)partition.leader().isDefined());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)((BrokerEndPoint)partition.leader().get()).id());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)partition.replicas().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementPartitions$2(AddPartitionsTest $this, TopicMetadata p) {
        return p.topic().equals($this.topic1());
    }

    public static final /* synthetic */ boolean $anonfun$testManualAssignmentOfReplicas$2(AddPartitionsTest $this, TopicMetadata p) {
        return p.topic().equals($this.topic2());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaPlacementAllServers$2(AddPartitionsTest $this, TopicMetadata p) {
        String string = p.topic();
        String string2 = $this.topic3();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaPlacementPartialServers$2(AddPartitionsTest $this, TopicMetadata p) {
        String string = p.topic();
        String string2 = $this.topic2();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, PartitionMetadata x$7) {
        return x$7.partitionId() == partitionId$1;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
    }
}

