/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Properties;
import kafka.admin.AdminUtilities;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$4$;
import kafka.admin.TestAdminUtils;
import kafka.common.InvalidConfigException;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaId$;
import kafka.utils.ZkUtils;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\t\t2i\u001c8gS\u001e\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001)g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J\u001cE.[3oiN,e\u000e^5usRK\b/\u001a\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5uQ\tI2\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005)!.\u001e8ji*\t\u0001&A\u0002pe\u001eL!AK\u0013\u0003\tQ+7\u000f\u001e\u0005\u0006Y\u0001!\taG\u0001(g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J$v\u000e]5dg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002,G!)q\u0006\u0001C\u00017\u0005A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d\"s_.,'o]#oi&$\u0018\u0010V=qK\"\u0012af\t\u0005\u0006e\u0001!\taM\u0001\u0012i\u0016\u001cH/\u0011:hk6,g\u000e\u001e)beN,GC\u0001\u000f5\u0011\u0015)\u0014\u00071\u00017\u0003))g\u000e^5usRK\b/\u001a\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005erR\"\u0001\u001e\u000b\u0005m2\u0011A\u0002\u001fs_>$h(\u0003\u0002>=\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\tid\u0004C\u0003C\u0001\u0011\u00051$\u0001\u0012tQ>,H\u000e\u001a$bS2Le-\u00168sK\u000e|wM\\5tK\u0012,e\u000e^5usRK\b/\u001a\u0015\u0005\u0003\u000e\"U)\u0001\u0005fqB,7\r^3eG\u00051\u0005CA$M\u001d\tA%J\u0004\u0002:\u0013&\tq$\u0003\u0002L=\u00059\u0001/Y2lC\u001e,\u0017BA'O\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003\u0017zAQ\u0001\u0015\u0001\u0005\u0002m\tQc\u001d5pk2$\u0017\t\u001a3DY&,g\u000e^\"p]\u001aLw\r\u000b\u0002PG!)1\u000b\u0001C\u00017\u0005!2\u000f[8vY\u0012\fE\r\u001a+pa&\u001c7i\u001c8gS\u001eD#AU\u0012\t\u000bY\u0003A\u0011A\u000e\u0002+MDw.\u001e7e\u0003\u0012$'I]8lKJ\u001cuN\u001c4jO\"\u0012Qk\t\u0005\u00063\u0002!\taG\u0001\"g\"|W\u000f\u001c3TkB\u0004xN\u001d;D_6l\u0017mU3qCJ\fG/\u001a3WC2,Xm\u001d\u0015\u00031\u000eBQ\u0001\u0018\u0001\u0005\u0002m\t\u0001g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u000b:$\u0018\u000e^=OC6,\u0007\u0006B.$\t\u0016CQa\u0018\u0001\u0005\u0002m\tAf\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0007>tg-[4)\ty\u001bC)\u0012\u0005\u0006E\u0002!\taG\u00014g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4JM6\u000bGNZ8s[\u0016$'I]1dW\u0016$8i\u001c8gS\u001eDC!Y\u0012E\u000b\")Q\r\u0001C\u00017\u000594\u000f[8vY\u0012tu\u000e^+qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001eLeMT8o\u000bbL7\u000f^5oO\u000e{gNZ5h\u0013N$U\r\\3uK\u0012DC\u0001Z\u0012EO\u000e\n\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l\t\u000511m\\7n_:L!!\u001c6\u0003-%sg/\u00197jI\u000e{gNZ5h\u000bb\u001cW\r\u001d;j_:DQa\u001c\u0001\u0005\u0002m\t\u0001d\u001d5pk2$G)\u001a7fi\u0016\u0014%o\\6fe\u000e{gNZ5hQ\tq7\u0005C\u0003s\u0001\u0011\u00051$\u0001\u000buKN$8k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u0015\u0003c\u000eBQ!\u001e\u0001\u0005\u0002m\tQ\u0003^3tiF+x\u000e^1D_:4\u0017nZ#oi&$\u0018\u0010\u000b\u0002uG!)\u0001\u0010\u0001C\u00017\u00059B/Z:u+N,'o\u00117jK:$\u0018+^8uC>\u0003Ho\u001d\u0015\u0003o\u000eBQa\u001f\u0001\u0005\u0002m\t\u0011\u0004^3tiF+x\u000e^1EKN\u001c'/\u001b2f\u000b:$\u0018\u000e^5fg\"\u0012!p\t")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients");
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers");
    }

    public void testArgumentParse(String entityType) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "x", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldAddClientConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(null){

            public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddTopicConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(null){

            public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldAddBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        TestAdminUtils configChange = new TestAdminUtils(null){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void shouldSupportCommaSeparatedValues() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        TestAdminUtils configChange = new TestAdminUtils(null){

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "a=b"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a="}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test(expected=InvalidConfigException.class)
    public void shouldNotUpdateBrokerConfigIfNonExistingConfigIsDeleted() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)new TestAdminUtils());
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        TestAdminUtils configChange = new TestAdminUtils(null){

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return properties;
            }

            public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }
        };
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminUtilities)configChange);
    }

    @Test
    public void testScramCredentials() {
        LazyRef CredentialChange$module = new LazyRef();
        Map credentials = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$3
        extends TestAdminUtils
        implements Product,
        scala.Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0 & Serializable & scala.Serializable)() -> new Properties());
            }

            public void changeUserOrUserClientIdConfig(ZkUtils zkUtils, String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                    String value = configChange.getProperty((String)mechanism);
                    Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    Assert.assertEquals((long)this.iterations(), (long)scramCredential.iterations());
                    return configChange != null ? $this.credentials$1.put((Object)this.user(), (Object)configChange) : BoxedUnit.UNIT;
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$3 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$3(this.$outer, user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.user();
                        break;
                    }
                    case 1: {
                        object = this.mechanisms();
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.iterations());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$3 var4_4 = (Kafka_admin_ConfigCommandTest$CredentialChange$3)x$1;
                String string = this.user();
                String string2 = var4_4.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var4_4.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var4_4.iterations()) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$3(ConfigCommandTest $outer, String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                Product.$init$((Product)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchEntityConfig$1(), $anonfun$changeUserOrUserClientIdConfig$1(kafka.admin.ConfigCommandTest$CredentialChange$3 java.util.Properties java.lang.String )}, serializedLambda);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, optsA, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfig(null, optsB, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfig(null, del256, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfig(null, del512, (AdminUtilities)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$1(this, clientId, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)QuotaId$.MODULE$.desanitize(sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$2(this, principal, sanitizedPrincipal, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = sanitizedPrincipal + "/clients/" + clientId;
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$3(this, describeOpts, clientId, principal, sanitizedPrincipal, userClient, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)new Some((Object)principal), sanitizedPrincipal + "/clients", (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        try {
            this.checkEntity$2("clients", QuotaId$.MODULE$.sanitize("<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
            throw this.fail("Did not fail with invalid client-id", new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        }
        catch (InvalidConfigException invalidConfigException) {
            this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("CN=user1") + "/clients/client1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
            this.checkEntity$2("users", QuotaId$.MODULE$.sanitize("CN=user1") + "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
            this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
            return;
        }
    }

    @Test
    public void testQuotaDescribeEntities() {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        String userClient = sanitizedPrincipal + "/clients/" + clientId;
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal + "/clients/<default>"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)("users/" + sanitizedPrincipal + "/clients")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal + "/clients/client-4"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkUtils);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)("users/" + sanitizedPrincipal + "/clients")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        ConfigCommandTest.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", sanitizedPrincipal + "/clients/client-2"})), zkUtils);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final /* synthetic */ ConfigCommandTest$CredentialChange$4$ CredentialChange$lzycompute$1(Map credentials$1, LazyRef CredentialChange$module$1) {
        ConfigCommandTest$CredentialChange$4$ configCommandTest$CredentialChange$4$;
        LazyRef lazyRef = CredentialChange$module$1;
        synchronized (lazyRef) {
            configCommandTest$CredentialChange$4$ = CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.value()) : (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.initialize((Object)new ConfigCommandTest$CredentialChange$4$(this, credentials$1)));
        }
        return configCommandTest$CredentialChange$4$;
    }

    private final ConfigCommandTest$CredentialChange$4$ CredentialChange$2(Map credentials$1, LazyRef CredentialChange$module$1) {
        return CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.value()) : this.CredentialChange$lzycompute$1(credentials$1, CredentialChange$module$1);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        String[] stringArray;
        String[] optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
        Option option = entityName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            stringArray = (String[])((Object[])new String[]{"--entity-name", name});
        } else if (None$.MODULE$.equals(option)) {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)option);
        }
        String[] nameArray = stringArray;
        return new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])optArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            throw this.fail("Did not fail with invalid argument list", new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$1(ConfigCommandTest $this, String clientId$1, String[] opts) {
        $this.checkEntity$1("clients", (Option)new Some((Object)clientId$1), clientId$1, opts);
        $this.checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$2(ConfigCommandTest $this, String principal$1, String sanitizedPrincipal$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1, opts);
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    private static final String[] clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$3(ConfigCommandTest $this, String[] describeOpts$1, String clientId$1, String principal$1, String sanitizedPrincipal$1, String userClient$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), userClient$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1 + "/clients/" + ConfigEntityName$.MODULE$.Default(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default() + "/clients/" + clientId$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default() + "/clients/" + ConfigEntityName$.MODULE$.Default(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()})).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private static final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, ZkUtils zkUtils$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)zkUtils$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
            return iExpectationSetters;
        });
        EasyMock.replay((Object[])new Object[]{zkUtils$1});
        Seq entities = entity.getAllEntities(zkUtils$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1 & Serializable & scala.Serializable)e -> e.fullSanitizedName(), Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkUtils$1});
    }
}

