/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R3mKR,7i\u001c8tk6,'o\u0012:pkB$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QB\u0003\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t!F\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgR\ta\u0003E\u0002\u0018C\u0011r!\u0001\u0007\u0010\u000f\u0005eaR\"\u0001\u000e\u000b\u0005m1\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\ty\u0002%A\u0004qC\u000e\\\u0017mZ3\u000b\u0003uI!AI\u0012\u0003\u0007M+\u0017O\u0003\u0002 AA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005%2#aC&bM.\f7i\u001c8gS\u001eDQa\u000b\u0001\u0005\u00021\nq\u0003^3ti\u001e\u0013x.\u001e9XS\u0012,G)\u001a7fi\u0016LeNW&\u0015\u00035\u0002\"AL\u0018\u000e\u0003\u0001J!\u0001\r\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0003UI\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u000b),h.\u001b;\u000b\u0003]\n1a\u001c:h\u0013\tIDG\u0001\u0003UKN$\b\"B\u001e\u0001\t\u0003a\u0013\u0001\u000f;fgR<%o\\;q/&$W\rR3mKR,\u0017J\u001c.L\t>,7OT8uQ&twMR8s\u0003\u000e$\u0018N^3D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0015\u0003uIBQA\u0010\u0001\u0005\u00021\nQ\u0007^3ti\u001e\u0013x.\u001e9U_BL7mV5eK\u0012+G.\u001a;f\u0013:T6JR8s\u000fJ|W\u000f]\"p]N,X.\u001b8h\u001f:,Gk\u001c9jG\"\u0012QH\r\u0005\u0006\u0003\u0002!\t\u0001L\u0001<i\u0016\u001cHo\u0012:pkB$v\u000e]5d/&$W\rR3mKR,\u0017J\u001c.L\r>\u0014xI]8va\u000e{gn];nS:<W*\u001e7uSBdW\rV8qS\u000e\u001c\bF\u0001!3\u0011\u0015!\u0005\u0001\"\u0001-\u00031#Xm\u001d;He>,\b\u000fV8qS\u000e<\u0016\u000eZ3EK2,G/Z%o5.#u.Z:O_RD\u0017N\\4G_J\f5\r^5wK\u001e\u0013x.\u001e9D_:\u001cX/\\5oO6+H\u000e^5qY\u0016$v\u000e]5dg\"\u00121I\r\u0005\u0006\u000f\u0002!\t\u0001L\u0001\u0018i\u0016\u001cH\u000fV8qS\u000e<\u0016\u000eZ3EK2,G/Z%o5.C#A\u0012\u001a\t\u000b)\u0003A\u0011\u0001\u0017\u0002oQ,7\u000f^\"p]N,X\u000e\u001d;j_:|eNU3de\u0016\fG/\u001a3U_BL7-\u00114uKJ$v\u000e]5d/&$W\rR3mKR,\u0017J\u001c.LQ\tI%\u0007C\u0003N\u0001\u0011%a*A\fgS2d\u0017J\\\"p]N,X.\u001a:He>,\b/\u00138g_R9QfT-\\;\n$\u0007\"\u0002)M\u0001\u0004\t\u0016!\u0002;pa&\u001c\u0007C\u0001*W\u001d\t\u0019F\u000b\u0005\u0002\u001aA%\u0011Q\u000bI\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002VA!)!\f\u0014a\u0001#\u0006)qM]8va\")A\f\u0014a\u0001#\u0006Q1m\u001c8tk6,'/\u00133\t\u000byc\u0005\u0019A0\u0002\u0013A\f'\u000f^5uS>t\u0007C\u0001\u0018a\u0013\t\t\u0007EA\u0002J]RDQa\u0019'A\u0002}\u000baa\u001c4gg\u0016$\b\"B3M\u0001\u00041\u0017\u0001\u0005:fO&\u001cH/\u001a:D_:\u001cX/\\3s!\tqs-\u0003\u0002iA\t9!i\\8mK\u0006t\u0007\"\u00026\u0001\t\u0013Y\u0017AD4s_V\u0004H)\u001b:Fq&\u001cHo\u001d\u000b\u0003M2DQ!\\5A\u00029\f1\u0001Z5s!\ty'/D\u0001q\u0015\t\tH!A\u0003vi&d7/\u0003\u0002ta\nY!lS$s_V\u0004H)\u001b:t\u0011\u0015)\b\u0001\"\u0003w\u0003\u0005:'o\\;q)>\u0004\u0018nY(gMN,G/\u00118e\u001f^tWM\u001d#jeN,\u00050[:u)\t1w\u000fC\u0003ni\u0002\u0007\u0001\u0010\u0005\u0002ps&\u0011!\u0010\u001d\u0002\u00115.;%o\\;q)>\u0004\u0018n\u0019#jeNDQ\u0001 \u0001\u0005\nu\fQ\u0002\u001d:pIV\u001cW-\u0012<f]R\u001cHCB\u0017\u007f\u0003C\t\u0019\u0003\u0003\u0004\u0000w\u0002\u0007\u0011\u0011A\u0001\taJ|G-^2feBA\u00111AA\t\u0003+\t)\"\u0004\u0002\u0002\u0006)\u0019q0a\u0002\u000b\t\u0005%\u00111B\u0001\bG2LWM\u001c;t\u0015\r)\u0011Q\u0002\u0006\u0004\u0003\u001f1\u0014AB1qC\u000eDW-\u0003\u0003\u0002\u0014\u0005\u0015!!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0003/\u0003/\tY\"C\u0002\u0002\u001a\u0001\u0012Q!\u0011:sCf\u00042ALA\u000f\u0013\r\ty\u0002\t\u0002\u0005\u0005f$X\rC\u0003Qw\u0002\u0007\u0011\u000bC\u0004\u0002&m\u0004\r!a\n\u0002\u00115,7o]1hKN\u0004BaFA\u0015#&\u0019\u00111F\u0012\u0003\t1K7\u000f\u001e\u0005\b\u0003_\u0001A\u0011BA\u0019\u00035\u0019wN\\:v[\u0016,e/\u001a8ugR)Q&a\r\u0002D!A\u0011QGA\u0017\u0001\u0004\t9$A\u0007nKN\u001c\u0018mZ3TiJ,\u0017-\u001c\t\t\u0003s\ty$!\u0006\u0002\u00165\u0011\u00111\b\u0006\u0004\u0003{!\u0011\u0001C2p]N,X.\u001a:\n\t\u0005\u0005\u00131\b\u0002\f\u0017\u000647.Y*ue\u0016\fW\u000eC\u0004\u0002F\u00055\u0002\u0019A0\u0002\u00039Ds\u0001AA%\u0003\u001f\n\u0019\u0006E\u0002/\u0003\u0017J1!!\u0014!\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003#\na\t\u00165jg\u0002\"Xm\u001d;!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004s/\u001b7mA\t,\u0007E]3n_Z,G\rI5oA\u0005\u0004c-\u001e;ve\u0016\u0004#/\u001a7fCN,g&\t\u0002\u0002V\u0005A\u0001GL\u00192]Ar\u0003\u0007")
public class DeleteConsumerGroupTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testGroupWideDeleteInZK() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, false);
        this.fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInZK(this.zkUtils(), groupToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.groupDirExists(new ZKGroupDirs(groupToDelete)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInZK should delete the provided consumer group's directory", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupDirExists(new ZKGroupDirs(otherGroup)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInZK should not delete unrelated consumer group directories", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupWideDeleteInZKDoesNothingForActiveConsumerGroup() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, true);
        this.fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInZK(this.zkUtils(), groupToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupDirExists(new ZKGroupDirs(groupToDelete)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInZK should not delete the provided consumer group's directory if the consumer group is still active", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupDirExists(new ZKGroupDirs(otherGroup)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInZK should not delete unrelated consumer group directories", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupTopicWideDeleteInZKForGroupConsumingOneTopic() {
        String topic = "test";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.fillInConsumerGroupInfo(topic, groupToDelete, "consumer", 0, 10, false);
        this.fillInConsumerGroupInfo(topic, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), groupToDelete, topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.groupDirExists(new ZKGroupDirs(groupToDelete)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInfoForTopicInZK should delete the provided consumer group's directory if it just consumes from one topic", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(otherGroup, topic)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInfoForTopicInZK should not delete unrelated consumer group owner and offset directories", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupTopicWideDeleteInZKForGroupConsumingMultipleTopics() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        String groupToDelete = "groupToDelete";
        String otherGroup = "otherGroup";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicToDelete, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.fillInConsumerGroupInfo(topicToDelete, groupToDelete, "consumer", 0, 10, false);
        this.fillInConsumerGroupInfo(otherTopic, groupToDelete, "consumer", 0, 10, false);
        this.fillInConsumerGroupInfo(topicToDelete, otherGroup, "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), groupToDelete, topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(groupToDelete, topicToDelete)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInfoForTopicInZK should delete the provided consumer group's owner and offset directories for the given topic", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(groupToDelete, otherTopic)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for unrelated topics", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(otherGroup, topicToDelete)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInfoForTopicInZK should not delete unrelated consumer group owner and offset directories", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testGroupTopicWideDeleteInZKDoesNothingForActiveGroupConsumingMultipleTopics() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        String group = "group";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicToDelete, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.fillInConsumerGroupInfo(topicToDelete, group, "consumer", 0, 10, true);
        this.fillInConsumerGroupInfo(otherTopic, group, "consumer", 0, 10, true);
        AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils(), group, topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(group, topicToDelete)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for the given topic if the consumer group is still active", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupTopicOffsetAndOwnerDirsExist(new ZKGroupTopicDirs(group, otherTopic)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DeleteConsumerGroupInfoForTopicInZK should not delete the provided consumer group's owner and offset directories for unrelated topics", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testTopicWideDeleteInZK() {
        String topicToDelete = "topicToDelete";
        String otherTopic = "otherTopic";
        Seq groups = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group1", "group2"}));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicToDelete, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Seq groupTopicDirsForTopicToDelete = (Seq)groups.map((Function1 & Serializable & scala.Serializable)group -> new ZKGroupTopicDirs(group, topicToDelete), Seq$.MODULE$.canBuildFrom());
        Seq groupTopicDirsForOtherTopic = (Seq)groups.map((Function1 & Serializable & scala.Serializable)group -> new ZKGroupTopicDirs(group, otherTopic), Seq$.MODULE$.canBuildFrom());
        groupTopicDirsForTopicToDelete.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.fillInConsumerGroupInfo(topicToDelete, dir.group(), "consumer", 0, 10, false);
            return BoxedUnit.UNIT;
        });
        groupTopicDirsForOtherTopic.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.fillInConsumerGroupInfo(otherTopic, dir.group(), "consumer", 0, 10, false);
            return BoxedUnit.UNIT;
        });
        AdminUtils$.MODULE$.deleteAllConsumerGroupInfoForTopicInZK(this.zkUtils(), topicToDelete);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !groupTopicDirsForTopicToDelete.exists((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)this.groupTopicOffsetAndOwnerDirsExist(dir))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer group info on deleted topic topic should be deleted by DeleteAllConsumerGroupInfoForTopicInZK", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> groupTopicDirsForOtherTopic.forall((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)this.groupTopicOffsetAndOwnerDirsExist(dir))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer group info on unrelated topics should not be deleted by DeleteAllConsumerGroupInfoForTopicInZK", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testConsumptionOnRecreatedTopicAfterTopicWideDeleteInZK() {
        String topic = "topic";
        String group = "group";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
        this.fillInConsumerGroupInfo(topic, dir.group(), "consumer", 0, 10, false);
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        AdminUtils$.MODULE$.deleteAllConsumerGroupInfoForTopicInZK(this.zkUtils(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.groupDirExists((ZKGroupDirs)dir), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer group info on related topics should be deleted by DeleteAllConsumerGroupInfoForTopicInZK", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        try (KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(this.brokerList(), TestUtils$.MODULE$.createNewProducer$default$2(), TestUtils$.MODULE$.createNewProducer$default$3(), TestUtils$.MODULE$.createNewProducer$default$4(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6(), TestUtils$.MODULE$.createNewProducer$default$7(), TestUtils$.MODULE$.createNewProducer$default$8(), TestUtils$.MODULE$.createNewProducer$default$9(), TestUtils$.MODULE$.createNewProducer$default$10(), TestUtils$.MODULE$.createNewProducer$default$11(), TestUtils$.MODULE$.createNewProducer$default$12(), TestUtils$.MODULE$.createNewProducer$default$13());){
            this.produceEvents(producer, topic, (List<String>)((List)List$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> "test")));
        }
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, "consumer", TestUtils$.MODULE$.createConsumerProperties$default$4());
        consumerProps.put("auto.commit.enable", "false");
        consumerProps.put("auto.offset.reset", "smallest");
        consumerProps.put("consumer.timeout.ms", "2000");
        consumerProps.put("fetch.wait.max.ms", "0");
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        try {
            KafkaStream messageStream = (KafkaStream)((IterableLike)consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))}))).apply((Object)topic)).head();
            this.consumeEvents((KafkaStream<byte[], byte[]>)messageStream, 5);
            consumerConnector.commitOffsets(false);
        }
        finally {
            consumerConnector.shutdown();
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.groupTopicOffsetAndOwnerDirsExist(dir), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer group info should exist after consuming from a recreated topic", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void fillInConsumerGroupInfo(String topic, String group, String consumerId, int partition, int offset, boolean registerConsumer) {
        block0: {
            Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, consumerId, TestUtils$.MODULE$.createConsumerProperties$default$4());
            ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
            ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
            TestUtils$.MODULE$.updateConsumerOffset(consumerConfig, dir.consumerOffsetDir() + "/" + partition, offset);
            ZkUtils qual$1 = this.zkUtils();
            String x$2 = this.zkUtils().getConsumerPartitionOwnerPath(group, topic, partition);
            String x$3 = "";
            java.util.List x$4 = qual$1.createEphemeralPathExpectConflict$default$3();
            qual$1.createEphemeralPathExpectConflict(x$2, x$3, x$4);
            ZkUtils qual$2 = this.zkUtils();
            String x$5 = dir.consumerRegistryDir();
            java.util.List x$6 = qual$2.makeSurePersistentPathExists$default$2();
            qual$2.makeSurePersistentPathExists(x$5, x$6);
            if (!registerConsumer) break block0;
            ZkUtils qual$3 = this.zkUtils();
            String x$7 = dir.consumerRegistryDir() + "/" + consumerId;
            String x$8 = "";
            java.util.List x$9 = qual$3.createEphemeralPathExpectConflict$default$3();
            qual$3.createEphemeralPathExpectConflict(x$7, x$8, x$9);
        }
    }

    private boolean groupDirExists(ZKGroupDirs dir) {
        return this.zkUtils().pathExists(dir.consumerGroupDir());
    }

    private boolean groupTopicOffsetAndOwnerDirsExist(ZKGroupTopicDirs dir) {
        return this.zkUtils().pathExists(dir.consumerOffsetDir()) && this.zkUtils().pathExists(dir.consumerOwnerDir());
    }

    private void produceEvents(KafkaProducer<byte[], byte[]> producer, String topic, List<String> messages) {
        messages.foreach((Function1 & Serializable & scala.Serializable)message -> producer.send(new ProducerRecord(topic, (Object)message.getBytes(StandardCharsets.UTF_8))));
    }

    private void consumeEvents(KafkaStream<byte[], byte[]> messageStream, int n) {
        ConsumerIterator iter = messageStream.iterator();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1 & Serializable & scala.Serializable)x$1 -> iter.next());
    }
}

