/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReplicationQuotaUtils$;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001\u001d\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000ecWo\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t\u0019\u0011J\u001c;\t\r\r\u0002\u0001\u0015!\u0003\u001d\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011\u001d)\u0003\u00011A\u0005\u0002\u0019\nqa]3sm\u0016\u00148/F\u0001(!\rA3&L\u0007\u0002S)\u0011!FH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0017*\u0005\r\u0019V-\u001d\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001a0\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fQ\u0002\u0001\u0019!C\u0001k\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\t1\u0014\b\u0005\u0002\u001eo%\u0011\u0001H\b\u0002\u0005+:LG\u000fC\u0004;g\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013\u0007\u0003\u0004=\u0001\u0001\u0006KaJ\u0001\tg\u0016\u0014h/\u001a:tA!9a\b\u0001b\u0001\n\u0003y\u0014!\u0003;pa&\u001cg*Y7f+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007'R\u0014\u0018N\\4\t\r%\u0003\u0001\u0015!\u0003A\u0003)!x\u000e]5d\u001d\u0006lW\r\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001\u001c\u0003\u001d!W\r\\1z\u001bNDa!\u0014\u0001!\u0002\u0013a\u0012\u0001\u00033fY\u0006LXj\u001d\u0011\t\u000b=\u0003A\u0011\u0001)\u0002\u001bi\\W\u000b\u001d3bi\u0016$U\r\\1z+\u00051\u0004\"\u0002*\u0001\t\u0003\u001a\u0016!B:fiV\u0003H#\u0001\u001c)\u0005E+\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0015QWO\\5u\u0015\u0005Q\u0016aA8sO&\u0011Al\u0016\u0002\u0007\u0005\u00164wN]3\t\u000by\u0003A\u0011A0\u0002\u0019M$\u0018M\u001d;Ce>\\WM]:\u0015\u0005Y\u0002\u0007\"B1^\u0001\u0004\u0011\u0017!\u00032s_.,'/\u00133t!\rA3\u0006\b\u0005\u0006I\u0002!\teU\u0001\ti\u0016\f'\u000fR8x]\"\u00121M\u001a\t\u0003-\u001eL!\u0001[,\u0003\u000b\u00053G/\u001a:\t\u000b)\u0004A\u0011\u0001)\u00023MDw.\u001e7e\u001b>4XmU5oO2,\u0007+\u0019:uSRLwN\u001c\u0015\u0003S2\u0004\"AV7\n\u00059<&\u0001\u0002+fgRDQ\u0001\u001d\u0001\u0005\u0002M\u000b1c\u001d5pk2$W\t\u001f9b]\u0012\u001cE.^:uKJD#a\u001c7\t\u000bM\u0004A\u0011A*\u0002'MDw.\u001e7e'\"\u0014\u0018N\\6DYV\u001cH/\u001a:)\u0005Id\u0007\"\u0002<\u0001\t\u0003\u0019\u0016\u0001H:i_VdG-T8wKN+(m]3u\u001f\u001a\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003k2DQ!\u001f\u0001\u0005\u0002M\u000b!e\u001d5pk2$W\t_3dkR,G\u000b\u001b:piRdW\r\u001a*fCN\u001c\u0018n\u001a8nK:$\bF\u0001=m\u0011\u0015a\b\u0001\"\u0001T\u0003\u0001\u001a\bn\\;mI>sG.\u001f+ie>$H\u000f\\3N_ZLgn\u001a*fa2L7-Y:)\u0005md\u0007\"B@\u0001\t\u0003\u0019\u0016\u0001L:i_VdGm\u00115b]\u001e,G\u000b\u001b:piRdWm\u00148SKJ,h.\u00118e%\u0016lwN^3P]Z+'/\u001b4zQ\tqH\u000e\u0003\u0004\u0002\u0006\u0001!\taU\u0001)g\"|W\u000f\u001c3GC&d\u0017J\u001a)s_B|7/\u001a3E_\u0016\u001chj\u001c;NCR\u001c\u0007.\u0012=jgRLgn\u001a\u0015\b\u0003\u0007a\u0017\u0011BA\u0006\u0003!)\u0007\u0010]3di\u0016$7EAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\t\u000511m\\7n_:LA!a\u0006\u0002\u0012\tY\u0012\tZ7j]\u000e{W.\\1oI\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:Da!a\u0007\u0001\t\u0003\u0019\u0016aJ:i_VdGMR1jY&3\u0007K]8q_N,G\rS1t\u000b6\u0004H/\u001f*fa2L7-\u0019'jgRDs!!\u0007m\u0003\u0013\tY\u0001\u0003\u0004\u0002\"\u0001!\taU\u0001'g\"|W\u000f\u001c3GC&d\u0017J\u001a)s_B|7/\u001a3ICNLeN^1mS\u0012\u0014%o\\6fe&#\u0005fBA\u0010Y\u0006%\u00111\u0002\u0005\u0007\u0003O\u0001A\u0011A*\u0002gMDw.\u001e7e!\u0016\u0014hm\u001c:n)\"\u0014x\u000e\u001e;mK\u0012\u0014V-Y:tS\u001etW.\u001a8u\u001fZ,'OV1sS>,8\u000fV8qS\u000e\u001c\bfAA\u0013Y\"1\u0011Q\u0006\u0001\u0005\u0002M\u000bQd^1ji\u001a{'OU3bgNLwM\\7f]R$vnQ8na2,G/\u001a\u0005\b\u0003c\u0001A\u0011AA\u001a\u0003\u0011Q7o\u001c8\u0015\t\u0005U\u0012\u0011\n\t\u0005\u0003o\t)E\u0004\u0003\u0002:\u0005\u0005\u0003cAA\u001e=5\u0011\u0011Q\b\u0006\u0004\u0003\u007f1\u0011A\u0002\u001fs_>$h(C\u0002\u0002Dy\ta\u0001\u0015:fI\u00164\u0017bA$\u0002H)\u0019\u00111\t\u0010\t\u0011\u0005-\u0013q\u0006a\u0001\u0003\u001b\nQ\u0001^8qS\u000e\u0004R!HA(\u0003kI1!!\u0015\u001f\u0005)a$/\u001a9fCR,GM\u0010")
public class ReassignPartitionsClusterTest
extends ZooKeeperTestHarness {
    private final int partitionId;
    private Seq<KafkaServer> servers = null;
    private final String topicName;
    private final int delayMs;

    public int partitionId() {
        return this.partitionId;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public void zkUpdateDelay() {
        Thread.sleep(this.delayMs());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    public void startBrokers(Seq<Object> brokerIds) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void shouldMoveSinglePartition() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        int partition = 0;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle());
        this.waitForReassignmentToComplete();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})), (Object)((MapLike)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).get((Object)this.topicName()).get()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
    }

    @Test
    public void shouldExpandCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(brokers), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle());
        this.waitForReassignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test
    public void shouldShrinkCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle());
        this.waitForReassignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test
    public void shouldMoveSubsetOfPartitions() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map proposed = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(proposed), ReassignPartitionsCommand$.MODULE$.NoThrottle());
        this.waitForReassignmentToComplete();
        scala.collection.mutable.Map actual = this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic1", "topic2"})));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
    }

    @Test
    public void shouldExecuteThrottledReassignment() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        ReassignPartitionsCommand.Throttle initialThrottle = new ReassignPartitionsCommand.Throttle(10000000L, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkUpdateDelay());
        int expectedDurationSecs = 5;
        int numMessages = 500;
        int msgSize = 100000;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), numMessages, 0, msgSize);
        Assert.assertEquals((long)expectedDurationSecs, (long)((long)(numMessages * msgSize) / initialThrottle.value()));
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        long start = System.currentTimeMillis();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), initialThrottle);
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle.value(), this.servers(), this.topicName(), "0:100,0:101", "0:102");
        this.waitForReassignmentToComplete();
        long took = System.currentTimeMillis() - start - (long)this.delayMs();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be > ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)expectedDurationSecs * 0.9 * (double)1000)), BoxesRunTime.boxToLong((long)took)})), ((double)took > (double)expectedDurationSecs * 0.9 * (double)1000 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be < ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(expectedDurationSecs * 2 * 1000)), BoxesRunTime.boxToLong((long)took)})), (took < (long)(expectedDurationSecs * 2 * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void shouldOnlyThrottleMovingReplicas() {
        int[] brokers = new int[]{100, 101, 102, 103, 104, 105};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        long throttle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic1", 100, 0, 100000);
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic2", 100, 0, 100000);
        Map newAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), new ReassignPartitionsCommand.Throttle(throttle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(throttle, this.servers(), "topic1", "1:100,1:101,0:100,0:101", "1:102,0:102");
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(throttle, this.servers(), "topic2", "1:104,1:105,0:104,0:105", "1:103,0:103");
    }

    @Test
    public void shouldChangeThrottleOnRerunAndRemoveOnVerify() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        long initialThrottle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), 200, 0, 100000);
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), new ReassignPartitionsCommand.Throttle(initialThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        long newThrottle = initialThrottle * 1000L;
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment), new ReassignPartitionsCommand.Throttle(newThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(newThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        this.waitForReassignmentToComplete();
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkUtils(), ZkUtils$.MODULE$.formatAsReassignmentJson(newAssignment));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigRemovedFromZK(this.topicName(), this.servers());
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedDoesNotMatchExisting() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":1,\"replicas\":[101]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasEmptyReplicaList() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInvalidBrokerID() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101, 102]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle());
    }

    @Test
    public void shouldPerformThrottledReassignmentOverVariousTopics() {
        ReassignPartitionsCommand.Throttle throttle = new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1 & Serializable & scala.Serializable)conf -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(conf), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "payments", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "deliveries", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "customers", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))}))), this.servers());
        Map move = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        new ReassignPartitionsCommand(this.zkUtils(), move, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3()).reassignPartitions(throttle);
        this.waitForReassignmentToComplete();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkUtils().getReplicasForPartition("orders", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)this.zkUtils().getReplicasForPartition("orders", 1));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkUtils().getReplicasForPartition("payments", 1));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkUtils().getReplicasForPartition("deliveries", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkUtils().getReplicasForPartition("payments", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkUtils().getReplicasForPartition("customers", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkUtils().getReplicasForPartition("customers", 1));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkUtils().getReplicasForPartition("customers", 2));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkUtils().getReplicasForPartition("customers", 3));
    }

    public void waitForReassignmentToComplete() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.ReassignPartitionsPath()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public String json(Seq<String> topic) {
        String topicStr = ((TraversableOnce)topic.map((Function1 & Serializable & scala.Serializable)t -> "{\"topic\": \"" + t + "\"}", Seq$.MODULE$.canBuildFrom())).mkString(",");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"topics\": [", "],\"version\":1}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicStr}));
    }

    public ReassignPartitionsClusterTest() {
        this.partitionId = 0;
        this.topicName = "my-topic";
        this.delayMs = 1000;
    }
}

