/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.utils.Exit$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u000f\t\t#+Z1tg&<g\u000eU1si&$\u0018n\u001c8t\u0007>lW.\u00198e\u0003J<7\u000fV3ti*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0007\u0005\u00164wN]3\t\u000b\u001d\u0002A\u0011A\r\u0002\u0011Q,\u0017M\u001d#po:D#AJ\u0015\u0011\u0005\tR\u0013BA\u0016$\u0005\u0015\te\r^3s\u0011\u0015i\u0003\u0001\"\u0001\u001a\u0003=\u001a\bn\\;mI\u000e{'O]3di2L\b+\u0019:tKZ\u000bG.\u001b3NS:LW.^7HK:,'/\u0019;f\u001fB$\u0018n\u001c8tQ\tas\u0006\u0005\u0002#a%\u0011\u0011g\t\u0002\u0005)\u0016\u001cH\u000fC\u00034\u0001\u0011\u0005\u0011$\u0001\u0018tQ>,H\u000eZ\"peJ,7\r\u001e7z!\u0006\u00148/\u001a,bY&$W*\u001b8j[VlW\t_3dkR,w\n\u001d;j_:\u001c\bF\u0001\u001a0\u0011\u00151\u0004\u0001\"\u0001\u001a\u00035\u001a\bn\\;mI\u000e{'O]3di2L\b+\u0019:tKZ\u000bG.\u001b3NS:LW.^7WKJLg-_(qi&|gn\u001d\u0015\u0003k=BQ!\u000f\u0001\u0005\u0002e\t!e\u001d5pk2$\u0017\t\u001c7poRC'o\u001c;uY\u0016|\u0005\u000f^5p]>sW\t_3dkR,\u0007F\u0001\u001d0\u0011\u0015a\u0004\u0001\"\u0001\u001a\u0003I\u0019\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u001d>\f%oZ:)\u0005mz\u0003\"B \u0001\t\u0003I\u0012\u0001F:i_VdGMR1jY&3'\t\\1oW\u0006\u0013x\r\u000b\u0002?_!)!\t\u0001C\u00013\u0005)3\u000f[8vY\u0012tu\u000e^!mY><X\t_3dkR,w+\u001b;i)>\u0004\u0018nY:PaRLwN\u001c\u0015\u0003\u0003>BQ!\u0012\u0001\u0005\u0002e\t\u0001e\u001d5pk2$gj\u001c;BY2|w/\u0012=fGV$XmV5uQ\n\u0013xn[3sg\"\u0012Ai\f\u0005\u0006\u0011\u0002!\t!G\u0001/g\"|W\u000f\u001c3O_R\fE\u000e\\8x\u000bb,7-\u001e;f/&$\bn\\;u%\u0016\f7o]5h]6,g\u000e^(qi&|g\u000e\u000b\u0002H_!)1\n\u0001C\u00013\u0005!4\u000f[8vY\u0012tu\u000e^!mY><x)\u001a8fe\u0006$XmV5uQ>,HO\u0011:pW\u0016\u00148/\u00118e)>\u0004\u0018nY:PaRLwN\\:)\u0005){\u0003\"\u0002(\u0001\t\u0003I\u0012AK:i_VdGMT8u\u00032dwn^$f]\u0016\u0014\u0018\r^3XSRDw.\u001e;Ce>\\WM]:PaRLwN\u001c\u0015\u0003\u001b>BQ!\u0015\u0001\u0005\u0002e\t\u0011f\u001d5pk2$gj\u001c;BY2|woR3oKJ\fG/Z,ji\"|W\u000f\u001e+pa&\u001c7o\u00149uS>t\u0007F\u0001)0\u0011\u0015!\u0006\u0001\"\u0001\u001a\u0003!\u001a\bn\\;mI:{G/\u00117m_^<UM\\3sCR,w+\u001b;i)\"\u0014x\u000e\u001e;mK>\u0003H/[8oQ\t\u0019v\u0006C\u0003X\u0001\u0011\u0005\u0011$\u0001\u0017tQ>,H\u000e\u001a(pi\u0006cGn\\<HK:,'/\u0019;f/&$\bNU3bgNLwM\\7f]R|\u0005\u000f^5p]\"\u0012ak\f\u0005\u00065\u0002!\t!G\u0001.g\"|W\u000f\u001c3O_R\fE\u000e\\8x-\u0016\u0014\u0018NZ=XSRDw.\u001e;SK\u0006\u001c8/[4o[\u0016tGo\u00149uS>t\u0007FA-0\u0011\u0015i\u0006\u0001\"\u0001\u001a\u0003%\u001a\bn\\;mI:{G/\u00117m_^\u0014%o\\6feNd\u0015n\u001d;XSRDg+\u001a:jMf|\u0005\u000f^5p]\"\u0012Al\f\u0005\u0006A\u0002!\t!G\u0001'g\"|W\u000f\u001c3O_R\fE\u000e\\8x)\"\u0014x\u000e\u001e;mK^KG\u000f\u001b,fe&4\u0017p\u00149uS>t\u0007FA00\u0011\u0015\u0019\u0007\u0001\"\u0001\u001a\u0003\u0011\u001a\bn\\;mI:{G/\u00117m_^$v\u000e]5dg>\u0003H/[8o/&$\bNV3sS\u001aL\bF\u000120\u0011\u00151\u0007\u0001\"\u0001h\u00039\u0019\bn\\;mI\u001a\u000b\u0017\u000e\\,ji\"$2A\u00075v\u0011\u0015IW\r1\u0001k\u0003\ri7o\u001a\t\u0003WJt!\u0001\u001c9\u0011\u00055dR\"\u00018\u000b\u0005=4\u0011A\u0002\u001fs_>$h(\u0003\u0002r9\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\rM#(/\u001b8h\u0015\t\tH\u0004C\u0003wK\u0002\u0007q/\u0001\u0003be\u001e\u001c\bcA\u000eyU&\u0011\u0011\u0010\b\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class ReassignPartitionsCommandArgsTest
extends JUnitSuite {
    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(x$1, message) -> ReassignPartitionsCommandArgsTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message));
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void shouldCorrectlyParseValidMinimumGenerateOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumExecuteOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumVerifyOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldAllowThrottleOptionOnExecute() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldFailIfNoArgs() {
        String[] args = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.shouldFailWith("This command moves topic partitions between replicas.", args);
    }

    @Test
    public void shouldFailIfBlankArg() {
        String[] args = (String[])((Object[])new String[]{" "});
        this.shouldFailWith("Command must include exactly one action: --generate, --execute or --verify", args);
    }

    @Test
    public void shouldNotAllowExecuteWithTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option\"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithBrokers() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--broker-list", "101,102"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option\"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute"});
        this.shouldFailWith("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersAndTopicsOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--topics-to-move-json-file", "myfile.json", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--broker-list", "101,102", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithThrottleOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--throttle", "100", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option\"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option\"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowVerifyWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify"});
        this.shouldFailWith("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option", args);
    }

    @Test
    public void shouldNotAllowBrokersListWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--broker-list", "100,101", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option\"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowThrottleWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option\"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowTopicsOptionWithVerify() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option\"[topics-to-move-json-file]\"", args);
    }

    public void shouldFailWith(String msg, String[] args) {
        try {
            ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have failed with [", "] but no failure occurred."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})), new Position("ReassignPartitionsCommandArgsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        }
        catch (Exception e) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected exception with message:\\n[", "]\\nbut was\\n[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, e.getMessage()})), (boolean)e.getMessage().startsWith(msg));
            return;
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

