/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.AdminClientIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmb\u0001B\u0001\u0003\u0001\u001d\u0011!$\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012!D4m_\n\fG\u000eV5nK>,H/F\u0001\u001d!\tiB%D\u0001\u001f\u0015\ty\u0002%A\u0003sk2,7O\u0003\u0002\"E\u0005)!.\u001e8ji*\t1%A\u0002pe\u001eL!!\n\u0010\u0003\u000fQKW.Z8vi\"\u0012\u0011d\n\t\u0003Q%j\u0011\u0001I\u0005\u0003U\u0001\u0012AAU;mK\"9A\u0006\u0001a\u0001\n\u0003i\u0013AB2mS\u0016tG/F\u0001/!\tys'D\u00011\u0015\t\t$'A\u0003bI6LgN\u0003\u00024i\u000591\r\\5f]R\u001c(BA\u00036\u0015\t1$%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003qA\u00121\"\u00113nS:\u001cE.[3oi\"9!\b\u0001a\u0001\n\u0003Y\u0014AC2mS\u0016tGo\u0018\u0013fcR\u0011AH\u0011\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0005+:LG\u000fC\u0004Ds\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006KAL\u0001\bG2LWM\u001c;!\u0011\u00159\u0005\u0001\"\u0011I\u0003\u0015\u0019X\r^+q)\u0005a\u0004F\u0001$K!\tA3*\u0003\u0002MA\t1!)\u001a4pe\u0016DQA\u0014\u0001\u0005B!\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u001bB\u0003\"\u0001K)\n\u0005I\u0003#!B!gi\u0016\u0014\bb\u0002+\u0001\u0005\u0004%\t!V\u0001\fEJ|7.\u001a:D_VtG/F\u0001W!\tit+\u0003\u0002Y}\t\u0019\u0011J\u001c;\t\ri\u0003\u0001\u0015!\u0003W\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011!a\u0006\u0001#b\u0001\n\u0003i\u0016\u0001D:feZ,'oQ8oM&<W#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001B;uS2T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b\u001d\u0004A\u0011\u00015\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0003%\u0004Ba\u00186mo&\u00111\u000e\u0019\u0002\u0004\u001b\u0006\u0004\bCA7u\u001d\tq'\u000f\u0005\u0002p}5\t\u0001O\u0003\u0002r\r\u00051AH]8pizJ!a\u001d \u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003gz\u0002\"\u0001_>\u000e\u0003eT!A\u001f2\u0002\t1\fgnZ\u0005\u0003yf\u0014aa\u00142kK\u000e$\b\"\u0002@\u0001\t\u0003y\u0018!D<bSR4uN\u001d+pa&\u001c7\u000fF\u0004=\u0003\u0003\t\u0019!!\u0007\t\u000b1j\b\u0019\u0001\u0018\t\u000f\u0005\u0015Q\u00101\u0001\u0002\b\u0005yQ\r\u001f9fGR,G\r\u0015:fg\u0016tG\u000fE\u0003\u0002\n\u0005MAN\u0004\u0003\u0002\f\u0005=abA8\u0002\u000e%\tq(C\u0002\u0002\u0012y\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!aA*fc*\u0019\u0011\u0011\u0003 \t\u000f\u0005mQ\u00101\u0001\u0002\b\u0005yQ\r\u001f9fGR,G-T5tg&tw\rC\u0004\u0002 \u0001!\t!!\t\u0002?\u0005\u001c8/\u001a:u\rV$XO]3Fq\u000e,\u0007\u000f^5p]RK\b/Z#rk\u0006d7\u000fF\u0003=\u0003G\tY\u0005\u0003\u0005\u0002&\u0005u\u0001\u0019AA\u0014\u0003\u00191W\u000f^;sKB\"\u0011\u0011FA\u001d!\u0019\tY#!\r\u000265\u0011\u0011Q\u0006\u0006\u0004\u0003_!\u0014AB2p[6|g.\u0003\u0003\u00024\u00055\"aC&bM.\fg)\u001e;ve\u0016\u0004B!a\u000e\u0002:1\u0001A\u0001DA\u001e\u0003G\t\t\u0011!A\u0003\u0002\u0005u\"aA0%cE!\u0011qHA#!\ri\u0014\u0011I\u0005\u0004\u0003\u0007r$a\u0002(pi\"Lgn\u001a\t\u0004{\u0005\u001d\u0013bAA%}\t\u0019\u0011I\\=\t\u0011\u00055\u0013Q\u0004a\u0001\u0003\u001f\nQa\u00197buj\u0004D!!\u0015\u0002ZA)Q.a\u0015\u0002X%\u0019\u0011Q\u000b<\u0003\u000b\rc\u0017m]:\u0011\t\u0005]\u0012\u0011\f\u0003\r\u00037\nY%!A\u0001\u0002\u000b\u0005\u0011Q\f\u0002\u0004?\u0012\u0012\u0014\u0003BA \u0003?\u0002B!!\u0003\u0002b%!\u00111MA\f\u0005%!\u0006N]8xC\ndW\r\u0003\u0004\u0002h\u0001!\t\u0001S\u0001\ni\u0016\u001cHo\u00117pg\u0016DC!!\u001a\u0002lA\u0019\u0001&!\u001c\n\u0007\u0005=\u0004E\u0001\u0003UKN$\bBBA:\u0001\u0011\u0005\u0001*A\u0007uKN$H*[:u\u001d>$Wm\u001d\u0015\u0005\u0003c\nY\u0007\u0003\u0004\u0002z\u0001!\t\u0001S\u0001\u0017i\u0016\u001cHo\u0011:fCR,G)\u001a7fi\u0016$v\u000e]5dg\"\"\u0011qOA6\u0011\u0019\ty\b\u0001C\u0001\u0011\u0006aB/Z:u\t\u0016\u001c8M]5cK:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007\u0006BA?\u0003WBa!!\"\u0001\t\u0003A\u0015a\u0005;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014\b\u0006BAB\u0003WBa!a#\u0001\t\u0003A\u0015a\u0007;fgR$Um]2sS\n,\u0017I\u001c3BYR,'oQ8oM&<7\u000f\u000b\u0003\u0002\n\u0006-\u0004BBAI\u0001\u0011\u0005\u0001*A\fuKN$\u0018J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hg\"\"\u0011qRA6\u0011%\t9\n\u0001b\u0001\n\u0003\tI*\u0001\u0003B\u00072\u000bTCAAN!\u0011\ti*a)\u000e\u0005\u0005}%\u0002BAQ\u0003[\t1!Y2m\u0013\u0011\t)+a(\u0003\u0015\u0005\u001bGNQ5oI&tw\r\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAN\u0003\u0015\t5\tT\u0019!\u0011\u0019\ti\u000b\u0001C\u0001\u0011\u0006\tB/Z:u\u0003\u000edw\n]3sCRLwN\\:)\t\u0005-\u00161\u000e\u0005\u0007\u0003g\u0003A\u0011\u0001%\u0002!Q,7\u000f\u001e#fY\u0006LX\rZ\"m_N,\u0007\u0006BAY\u0003WBa!!/\u0001\t\u0003A\u0015A\u0004;fgR4uN]2f\u00072|7/\u001a\u0015\u0005\u0003o\u000bY\u0007\u0003\u0004\u0002@\u0002!\t\u0001S\u0001\u001bi\u0016\u001cH/T5oS6,XNU3rk\u0016\u001cH\u000fV5nK>,Ho\u001d\u0015\u0005\u0003{\u000bY\u0007C\u0004\u0002F\u0002!\t%a2\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON$\"!!3\u0011\r\u0005%\u00111CAf!\u0011\ti-a5\u000e\u0005\u0005='bAAi\t\u000511/\u001a:wKJLA!!6\u0002P\nY1*\u00194lC\u000e{gNZ5h\u0011\u0019\tI\u000e\u0001C\u0001\u0011\u0006AB/Z:u\u0007\u0006dG.\u00138GY&<\u0007\u000e\u001e+j[\u0016|W\u000f^:)\t\u0005]\u00171N\u0004\b\u0003?\u0014\u0001\u0012AAq\u0003i\tE-\\5o\u00072LWM\u001c;J]R,wM]1uS>tG+Z:u!\rA\u00121\u001d\u0004\u0007\u0003\tA\t!!:\u0014\r\u0005\r\u0018q]Aw!\ri\u0014\u0011^\u0005\u0004\u0003Wt$AB!osJ+g\rE\u0002>\u0003_L1!!=?\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d)\u00121\u001dC\u0001\u0003k$\"!!9\t\u0011\u0005e\u00181\u001dC\u0001\u0003w\fac\u00195fG.4\u0016\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\fy\u0005u(q\u0001B\n\u0005+\u0011)\u0003\u0003\u0005\u0002\u0000\u0006]\b\u0019\u0001B\u0001\u0003\u001dQ8.\u0016;jYN\u00042a\u0004B\u0002\u0013\r\u0011)\u0001\u0005\u0002\b5.,F/\u001b7t\u0011!\u0011I!a>A\u0002\t-\u0011aB:feZ,'o\u001d\t\u0007\u0003\u0013\t\u0019B!\u0004\u0011\t\u00055'qB\u0005\u0005\u0005#\tyMA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bB\u0002\u0017\u0002x\u0002\u0007a\u0006\u0003\u0005\u0003\u0018\u0005]\b\u0019\u0001B\r\u00039!x\u000e]5d%\u0016\u001cx.\u001e:dKF\u0002BAa\u0007\u0003\"5\u0011!Q\u0004\u0006\u0005\u0005?\ti#\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0005G\u0011iB\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u0011\t\u001d\u0012q\u001fa\u0001\u00053\ta\u0002^8qS\u000e\u0014Vm]8ve\u000e,'\u0007\u0003\u0005\u0003,\u0005\rH\u0011\u0001B\u0017\u0003a\u0019\u0007.Z2l\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\by\t=\"\u0011\u0007B\u001a\u0011!\tyP!\u000bA\u0002\t\u0005\u0001\u0002\u0003B\u0005\u0005S\u0001\rAa\u0003\t\r1\u0012I\u00031\u0001/\u0011)\u00119$a9\u0002\u0002\u0013%!\u0011H\u0001\fe\u0016\fGMU3t_24X\rF\u0001x\u0001")
public class AdminClientIntegrationTest
extends KafkaServerTestHarness {
    private Properties serverConfig;
    private AdminClient client = null;
    private final int brokerCount;
    private final AclBinding ACL1 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private volatile boolean bitmap$0;

    public static void checkInvalidAlterConfigs(ZkUtils zkUtils, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(zkUtils, seq, adminClient);
    }

    public static void checkValidAlterConfigs(ZkUtils zkUtils, Seq<KafkaServer> seq, AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(zkUtils, seq, adminClient, configResource, configResource2);
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    private Properties serverConfig$lzycompute() {
        AdminClientIntegrationTest adminClientIntegrationTest = this;
        synchronized (adminClientIntegrationTest) {
            if (!this.bitmap$0) {
                this.serverConfig = new Properties();
                this.bitmap$0 = true;
            }
        }
        return this.serverConfig;
    }

    public Properties serverConfig() {
        return !this.bitmap$0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        Properties securityProps = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Object object = config.put((String)key, (String)value);
            return object;
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set topics = (Set)client.listTopics().names().get();
            return expectedPresent.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$waitForTopics$4(topics, topicName)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for topics", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz) {
        try {
            future.get();
            throw this.fail("Expected CompletableFuture.get to return an exception", new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)("Expected an exception of type " + clazz.getName() + "; got type " + cause.getClass().getName()), (boolean)clazz.isInstance(cause));
            return;
        }
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())})), Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class);
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assert.assertEquals((long)partitionId, (long)partition.partition());
            Assert.assertEquals((long)3L, (long)partition.replicas().size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                AdminClientIntegrationTest.$anonfun$testCreateDeleteTopics$6(this, replica);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size());
            Assert.assertEquals((long)3L, (long)partition.isr().size());
            Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1 & Serializable & scala.Serializable)x$6 -> new NewTopic(x$6, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkUtils().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Collection nodes = (Collection)this.client().describeCluster().nodes().get();
        String clusterId = (String)this.client().describeCluster().clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).apis().clusterId(), (Object)clusterId);
        Node controller = (Node)this.client().describeCluster().controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).apis().metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            AdminClientIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 1, 1, (Seq<KafkaServer>)this.servers(), new Properties());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertTrue((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertTrue((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertTrue((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.zkUtils(), (Seq<KafkaServer>)this.servers(), this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkUtils(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class);
        this.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class);
        this.client().close();
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1 & Serializable & scala.Serializable)x$7 -> new NewTopic(x$7, 1, 1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(2L, TimeUnit.HOURS);
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.assertFutureExceptionTypeEquals(future2, TimeoutException.class);
        future.get();
        this.client().close(30L, TimeUnit.MINUTES);
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$8 -> new NewTopic(x$8, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(0L, TimeUnit.MILLISECONDS);
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:22");
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$9 -> new NewTopic(x$9, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        this.assertFutureExceptionTypeEquals(future, TimeoutException.class);
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
        this.client().close();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$13 = this.brokerCount();
        String x$14 = this.zkConnect();
        Some x$15 = new Some((Object)this.securityProtocol());
        Option<File> x$16 = this.trustStoreFile();
        Option<Properties> x$17 = this.serverSaslProperties();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$19 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$22 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$23 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$24 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$13, x$14, x$18, x$19, (Option<SecurityProtocol>)x$15, x$16, x$17, x$20, x$21, x$22, x$23, x$24);
        cfgs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value(), BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())})));
            config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.listenerName().value());
            config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value(), $this.securityProtocol().name})));
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            return !config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass") : BoxedUnit.UNIT;
        });
        cfgs.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.putAll((java.util.Map<?, ?>)this.serverConfig());
            return BoxedUnit.UNIT;
        });
        return (Seq)cfgs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        KafkaAdminClient client = KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory);
        CreateTopicsResult future = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$11 -> new NewTopic(x$11, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true));
        CreateTopicsResult future2 = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1 & Serializable & scala.Serializable)x$12 -> new NewTopic(x$12, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true));
        future.all().get();
        future2.all().get();
        client.close();
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$4(Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$6(AdminClientIntegrationTest $this, Node replica) {
        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((replica.id() < $this.brokerCount() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
    }

    public AdminClientIntegrationTest() {
        this.brokerCount = 3;
    }
}

