/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaId;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}c!B\u0001\u0003\u0003\u00039!!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0007\u0002I\tQ\"^:feB\u0013\u0018N\\2ja\u0006dW#A\n\u0011\u0005QibBA\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004=e>|GO\u0010\u0006\u00025\u0005)1oY1mC&\u0011A$G\u0001\u0007!J,G-\u001a4\n\u0005yy\"AB*ue&twM\u0003\u0002\u001d3!)\u0011\u0005\u0001D\u0001E\u0005y\u0001O]8ek\u000e,'/U;pi\u0006LE-F\u0001$!\t!s%D\u0001&\u0015\t1C!\u0001\u0004tKJ4XM]\u0005\u0003Q\u0015\u0012q!U;pi\u0006LE\rC\u0003+\u0001\u0019\u0005!%A\bd_:\u001cX/\\3s#V|G/Y%e\u0011\u0015a\u0003A\"\u0001.\u00039yg/\u001a:sS\u0012,\u0017+^8uCN$BA\f\u001a8sA\u0011q\u0006M\u0007\u00023%\u0011\u0011'\u0007\u0002\u0005+:LG\u000fC\u00034W\u0001\u0007A'A\u0007qe>$WoY3s#V|G/\u0019\t\u0003_UJ!AN\r\u0003\t1{gn\u001a\u0005\u0006q-\u0002\r\u0001N\u0001\u000eG>t7/^7feF+x\u000e^1\t\u000biZ\u0003\u0019A\u001e\u0002\u0019I,\u0017/^3tiF+x\u000e^1\u0011\u0005=b\u0014BA\u001f\u001a\u0005\u0019!u.\u001e2mK\")q\b\u0001D\u0001\u0001\u0006!\"/Z7pm\u0016\fVo\u001c;b\u001fZ,'O]5eKN$\u0012A\f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0011D\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\u0016\u0003\u0011\u0003\"aL#\n\u0005\u0019K\"aA%oi\"1\u0001\n\u0001Q\u0001\n\u0011\u000bAb]3sm\u0016\u00148i\\;oi\u0002BqA\u0013\u0001C\u0002\u0013\u00051)A\u0007qe>$WoY3s\u0007>,h\u000e\u001e\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002#\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!9a\n\u0001b\u0001\n\u0003\u0019\u0015!D2p]N,X.\u001a:D_VtG\u000f\u0003\u0004Q\u0001\u0001\u0006I\u0001R\u0001\u000fG>t7/^7fe\u000e{WO\u001c;!\u0011\u001d\u0011\u0006A1A\u0005\n\r\u000b!\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{K\"1A\u000b\u0001Q\u0001\n\u0011\u000b1\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{K\u0002BqA\u0016\u0001C\u0002\u0013Eq+\u0001\tqe>$WoY3s\u00072LWM\u001c;JIV\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006!A.\u00198h\u0015\u0005i\u0016\u0001\u00026bm\u0006L!A\b.\t\r\u0001\u0004\u0001\u0015!\u0003Y\u0003E\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE\r\t\u0005\bE\u0002\u0011\r\u0011\"\u0005X\u0003A\u0019wN\\:v[\u0016\u00148\t\\5f]RLE\r\u0003\u0004e\u0001\u0001\u0006I\u0001W\u0001\u0012G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\u0004\u0003b\u00024\u0001\u0005\u0004%\taQ\u0001\u0015I\u00164\u0017-\u001e7u!J|G-^2feF+x\u000e^1\t\r!\u0004\u0001\u0015!\u0003E\u0003U!WMZ1vYR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC\u0002BqA\u001b\u0001C\u0002\u0013\u00051)\u0001\u000beK\u001a\fW\u000f\u001c;D_:\u001cX/\\3s#V|G/\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011\u0002#\u0002+\u0011,g-Y;mi\u000e{gn];nKJ\fVo\u001c;bA!9a\u000e\u0001b\u0001\n\u0003\u0019\u0015a\u00053fM\u0006,H\u000e\u001e*fcV,7\u000f^)v_R\f\u0007B\u00029\u0001A\u0003%A)\u0001\u000beK\u001a\fW\u000f\u001c;SKF,Xm\u001d;Rk>$\u0018\r\t\u0005\be\u0002\u0001\r\u0011\"\u0001t\u0003)aW-\u00193fe:{G-Z\u000b\u0002iB\u0011A%^\u0005\u0003m\u0016\u00121bS1gW\u0006\u001cVM\u001d<fe\"9\u0001\u0010\u0001a\u0001\n\u0003I\u0018A\u00047fC\u0012,'OT8eK~#S-\u001d\u000b\u0003]iDqa_<\u0002\u0002\u0003\u0007A/A\u0002yIEBa! \u0001!B\u0013!\u0018a\u00037fC\u0012,'OT8eK\u0002Bqa \u0001A\u0002\u0013\u00051/\u0001\u0007g_2dwn^3s\u001d>$W\rC\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0001\u0002\u0006\u0005\u0001bm\u001c7m_^,'OT8eK~#S-\u001d\u000b\u0004]\u0005\u001d\u0001\u0002C>\u0002\u0002\u0005\u0005\t\u0019\u0001;\t\u000f\u0005-\u0001\u0001)Q\u0005i\u0006iam\u001c7m_^,'OT8eK\u0002B\u0001\"a\u0004\u0001\u0005\u0004%IaV\u0001\u0007i>\u0004\u0018nY\u0019\t\u000f\u0005M\u0001\u0001)A\u00051\u00069Ao\u001c9jGF\u0002\u0003BBA\f\u0001\u0011\u0005\u0003)A\u0003tKR,\u0006\u000f\u000b\u0003\u0002\u0016\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003K\t1a\u001c:h\u0013\u0011\tI#a\b\u0003\r\t+gm\u001c:f\u0011\u0019\ti\u0003\u0001C\u0001\u0001\u0006iB/Z:u)\"\u0014x\u000e\u001e;mK\u0012\u0004&o\u001c3vG\u0016\u00148i\u001c8tk6,'\u000f\u000b\u0003\u0002,\u0005E\u0002\u0003BA\u000f\u0003gIA!!\u000e\u0002 \t!A+Z:u\u0011\u0019\tI\u0004\u0001C\u0001\u0001\u00069C/Z:u!J|G-^2fe\u000e{gn];nKJ|e/\u001a:sS\u0012,WK\u001c;ie>$H\u000f\\3eQ\u0011\t9$!\r\t\r\u0005}\u0002\u0001\"\u0001A\u0003]!Xm\u001d;Rk>$\u0018m\u0014<feJLG-\u001a#fY\u0016$X\r\u000b\u0003\u0002>\u0005E\u0002BBA#\u0001\u0011\u0005\u0001)\u0001\u000buKN$H\u000b\u001b:piRdW\r\u001a*fcV,7\u000f\u001e\u0015\u0005\u0003\u0007\n\t\u0004C\u0004\u0002L\u0001!\t!!\u0014\u0002+A\u0014x\u000eZ;dKVsG/\u001b7UQJ|G\u000f\u001e7fIR)A)a\u0014\u0002v!A\u0011\u0011KA%\u0001\u0004\t\u0019&A\u0001q!!\t)&!\u001a\u0002j\u0005%TBAA,\u0015\u0011\tI&a\u0017\u0002\u0011A\u0014x\u000eZ;dKJTA!!\u0018\u0002`\u000591\r\\5f]R\u001c(bA\u0003\u0002b)!\u00111MA\u0012\u0003\u0019\t\u0007/Y2iK&!\u0011qMA,\u00055Y\u0015MZ6b!J|G-^2feB)q&a\u001b\u0002p%\u0019\u0011QN\r\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\n\t(C\u0002\u0002te\u0011AAQ=uK\"9\u0011qOA%\u0001\u0004!\u0015AC7bqJ+7m\u001c:eg\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!F2p]N,X.Z+oi&dG\u000b\u001b:piRdW\r\u001a\u000b\u0006\t\u0006}\u0014Q\u0012\u0005\t\u0003\u0003\u000bI\b1\u0001\u0002\u0004\u0006A1m\u001c8tk6,'\u000f\u0005\u0005\u0002\u0006\u0006%\u0015\u0011NA5\u001b\t\t9I\u0003\u0003\u0002\u0002\u0006m\u0013\u0002BAF\u0003\u000f\u0013QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\bbBA<\u0003s\u0002\r\u0001\u0012\u0005\b\u0003#\u0003A\u0011AAJ\u0003I9\u0018-\u001b;G_J\fVo\u001c;b+B$\u0017\r^3\u0015\u000f9\n)*a&\u0002\u001a\"11'a$A\u0002QBa\u0001OAH\u0001\u0004!\u0004B\u0002\u001e\u0002\u0010\u0002\u00071\bC\u0004\u0002\u001e\u0002!I!a(\u0002AY,'/\u001b4z!J|G-^2feRC'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u000b\u0004]\u0005\u0005\u0006\u0002CA-\u00037\u0003\r!a)1\r\u0005\u0015\u00161VA`!!\t)&!\u001a\u0002(\u0006u\u0006\u0003BAU\u0003Wc\u0001\u0001\u0002\u0007\u0002.\u0006\u0005\u0016\u0011!A\u0001\u0006\u0003\tyKA\u0002`IE\nB!!-\u00028B\u0019q&a-\n\u0007\u0005U\u0016DA\u0004O_RD\u0017N\\4\u0011\u0007=\nI,C\u0002\u0002<f\u00111!\u00118z!\u0011\tI+a0\u0005\u0019\u0005\u0005\u0017\u0011UA\u0001\u0002\u0003\u0015\t!a,\u0003\u0007}##\u0007C\u0004\u0002F\u0002!I!a2\u0002AY,'/\u001b4z\u0007>t7/^7feRC'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u000b\u0006]\u0005%\u00171\u001c\u0005\t\u0003\u0003\u000b\u0019\r1\u0001\u0002LB2\u0011QZAi\u0003/\u0004\u0002\"!\"\u0002\n\u0006=\u0017Q\u001b\t\u0005\u0003S\u000b\t\u000e\u0002\u0007\u0002T\u0006%\u0017\u0011!A\u0001\u0006\u0003\tyKA\u0002`IM\u0002B!!+\u0002X\u0012a\u0011\u0011\\Ae\u0003\u0003\u0005\tQ!\u0001\u00020\n\u0019q\f\n\u001b\t\u0015\u0005u\u00171\u0019I\u0001\u0002\u0004\ty.A\bnCb$\u0006N]8ui2,G+[7f!\u0011y\u0013\u0011]\u001e\n\u0007\u0005\r\u0018D\u0001\u0004PaRLwN\u001c\u0005\b\u0003O\u0004A\u0011BAu\u0003I!\bN]8ui2,W*\u001a;sS\u000et\u0015-\\3\u0015\r\u0005-\u0018q\u001fB\u0001!\u0011\ti/a=\u000e\u0005\u0005=(\u0002BAy\u0003?\naaY8n[>t\u0017\u0002BA{\u0003_\u0014!\"T3ue&\u001cg*Y7f\u0011!\tI0!:A\u0002\u0005m\u0018!C9v_R\fG+\u001f9f!\r!\u0013Q`\u0005\u0004\u0003\u007f,#!C)v_R\fG+\u001f9f\u0011\u001d\u0011\u0019!!:A\u0002\r\nq!];pi\u0006LE\rC\u0004\u0003\b\u0001!\tA!\u0003\u0002\u001dQD'o\u001c;uY\u0016lU\r\u001e:jGR1!1\u0002B\f\u00053\u0001BA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0005\u0005#\ty/A\u0004nKR\u0014\u0018nY:\n\t\tU!q\u0002\u0002\f\u0017\u000647.Y'fiJL7\r\u0003\u0005\u0002z\n\u0015\u0001\u0019AA~\u0011\u001d\u0011\u0019A!\u0002A\u0002\rBqA!\b\u0001\t\u0013\u0011y\"\u0001\fqe>$WoY3s)\"\u0014x\u000e\u001e;mK6+GO]5d+\t\u0011Y\u0001C\u0004\u0003$\u0001!IAa\b\u0002-\r|gn];nKJ$\u0006N]8ui2,W*\u001a;sS\u000eDqAa\n\u0001\t\u0013\u0011y\"A\u000fd_:\u001cX/\\3s%\u0016\fX/Z:u)\"\u0014x\u000e\u001e;mK6+GO]5d\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005?\t1#\u001a=f[B$(+Z9vKN$X*\u001a;sS\u000eDqAa\f\u0001\t\u0003\u0011\t$A\brk>$\u0018\r\u0015:pa\u0016\u0014H/[3t)!\u0011\u0019Da\u0010\u0003B\t\r\u0003\u0003\u0002B\u001b\u0005wi!Aa\u000e\u000b\u0007\teB,\u0001\u0003vi&d\u0017\u0002\u0002B\u001f\u0005o\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019\u0019$Q\u0006a\u0001i!1\u0001H!\fA\u0002QBaA\u000fB\u0017\u0001\u0004Y\u0004\"\u0003B$\u0001E\u0005I\u0011\u0002B%\u0003)2XM]5gs\u000e{gn];nKJ$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2%I\u00164\u0017-\u001e7uII*\"Aa\u0013+\t\u0005}'QJ\u0016\u0003\u0005\u001f\u0002BA!\u0015\u0003\\5\u0011!1\u000b\u0006\u0005\u0005+\u00129&A\u0005v]\u000eDWmY6fI*\u0019!\u0011L\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003^\tM#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int serverCount;
    private final int producerCount;
    private final int consumerCount;
    private final int producerBufferSize;
    private final String producerClientId;
    private final String consumerClientId;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private final String topic1;

    public abstract String userPrincipal();

    public abstract QuotaId producerQuotaId();

    public abstract QuotaId consumerQuotaId();

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)producer, numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyProducerThrottleTimeMetric(producer);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)consumer, produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        this.verifyConsumerThrottleTimeMetric(consumer, this.verifyConsumerThrottleTimeMetric$default$2());
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        int numRecords = 1000;
        Assert.assertEquals((long)numRecords, (long)this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.producerThrottleMetric().value(), (double)0.0);
        Assert.assertEquals((long)numRecords, (long)this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords));
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)this.consumerThrottleMetric().value(), (double)0.0);
        this.removeQuotaOverrides();
        int produced = this.produceUntilThrottled((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        Assert.assertTrue((String)"Should have been throttled", (this.producerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
        ((KafkaConsumer)this.consumers().head()).seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        this.consumeUntilThrottled((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords + produced);
        Assert.assertTrue((String)"Should have been throttled", (this.consumerThrottleMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testThrottledRequest() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!throttled && System.currentTimeMillis() < endTimeMs) {
            consumer.poll(100L);
            KafkaMetric throttleMetric = this.consumerRequestThrottleMetric();
            throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.verifyConsumerThrottleTimeMetric(consumer, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)this.exemptRequestMetric());
        Assert.assertTrue((String)"Exempt requests not recorded", (this.exemptRequestMetric().value() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(KafkaProducer<byte[], byte[]> p, int maxRecords) {
        void var3_3;
        int numProduced = 0;
        boolean throttled = false;
        do {
            byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)numProduced)).toString().getBytes();
            p.send(new ProducerRecord(this.topic1(), null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic1(), null, null, true)).get();
            KafkaMetric throttleMetric = this.producerThrottleMetric();
            boolean bl = throttled = throttleMetric != null && throttleMetric.value() > 0.0;
        } while (++numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int consumeUntilThrottled(KafkaConsumer<byte[], byte[]> consumer, int maxRecords) {
        void var3_3;
        consumer.subscribe(Collections.singleton(this.topic1()));
        int numConsumed = 0;
        boolean throttled = false;
        do {
            KafkaMetric throttleMetric;
            boolean bl = throttled = (throttleMetric = this.consumerThrottleMetric()) != null && throttleMetric.value() > 0.0;
        } while ((numConsumed += consumer.poll(100L).count()) < maxRecords && !throttled);
        if (throttled && numConsumed < maxRecords) {
            int minRecords = numConsumed + 1;
            while (numConsumed < minRecords) {
                numConsumed += consumer.poll(100L).count();
            }
        }
        return (int)var3_3;
    }

    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            QuotaFactory.QuotaManagers quotaManagers = this.leaderNode().apis().quotas();
            Quota overrideProducerQuota = quotaManagers.produce().quota(this.userPrincipal(), this.producerClientId());
            Quota overrideConsumerQuota = quotaManagers.fetch().quota(this.userPrincipal(), this.consumerClientId());
            Quota overrideProducerRequestQuota = quotaManagers.request().quota(this.userPrincipal(), this.producerClientId());
            Quota overrideConsumerRequestQuota = quotaManagers.request().quota(this.userPrincipal(), this.consumerClientId());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have producer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)producerQuota), (Object)overrideProducerQuota);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have consumer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)consumerQuota), (Object)overrideConsumerQuota);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)requestQuota), (Object)overrideProducerRequestQuota);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have request quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerClientId(), this.userPrincipal()})), (Object)Quota.upperBound((double)requestQuota), (Object)overrideConsumerRequestQuota);
        });
    }

    private void verifyProducerThrottleTimeMetric(KafkaProducer<?, ?> producer) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId());
        Metric avgMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        Metric maxMetric = (Metric)producer.metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> avgMetric.value() > 0.0 && maxMetric.value() > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)avgMetric.value()), BoxesRunTime.boxToDouble((double)maxMetric.value())})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void verifyConsumerThrottleTimeMetric(KafkaConsumer<?, ?> consumer, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId());
        Metric avgMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        Metric maxMetric = (Metric)consumer.metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> avgMetric.value() > 0.0 && maxMetric.value() > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer throttle metric not updated: avg=", " max=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)avgMetric.value()), BoxesRunTime.boxToDouble((double)maxMetric.value())})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        maxThrottleTime.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)max -> Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum consumer throttle too high: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)maxMetric.value())})), (maxMetric.value() <= max ? 1 : 0) != 0));
    }

    private Option<Object> verifyConsumerThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    private MetricName throttleMetricName(QuotaType quotaType, QuotaId quotaId) {
        return this.leaderNode().metrics().metricName("throttle-time", quotaType.toString(), "Tracking throttle-time per user/client-id", new String[]{"user", (String)quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), "client-id", (String)quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")});
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, QuotaId quotaId) {
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(this.throttleMetricName(quotaType, quotaId));
    }

    private KafkaMetric producerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerQuotaId());
    }

    private KafkaMetric consumerThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric consumerRequestThrottleMetric() {
        return this.throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerQuotaId());
    }

    private KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode().metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return (KafkaMetric)this.leaderNode().metrics().metrics().get(metricName);
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota, double requestQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        return props;
    }

    public BaseQuotaTest() {
        this.serverCount = 2;
        this.producerCount = 1;
        this.consumerCount = 1;
        this.producerBufferSize = 300000;
        this.producerClientId = "QuotasTestProducer-1";
        this.consumerClientId = "QuotasTestConsumer-1";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "0");
        this.producerConfig().setProperty("buffer.memory", ((Object)BoxesRunTime.boxToInteger((int)this.producerBufferSize())).toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.leaderNode = null;
        this.followerNode = null;
        this.topic1 = "topic-1";
    }
}

