/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.AdminClientIntegrationTest;
import kafka.api.Both$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011eU1tYN\u001bH.\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\u000eBI6Lgn\u00117jK:$\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f\u0005\u0002\n\u001b%\u0011aB\u0001\u0002\n'\u0006\u001cHnU3ukBDQ\u0001\u0005\u0001\u0005\u0002E\ta\u0001P5oSRtD#\u0001\n\u0011\u0005%\u0001\u0001\"\u0002\u000b\u0001\t#*\u0012\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u00051\u0002CA\f\"\u001b\u0005A\"BA\r\u001b\u0003!\u0001(o\u001c;pG>d'BA\u000e\u001d\u0003\u0019\u0019w.\\7p]*\u0011Q!\b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014x-\u0003\u0002#1\t\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\tI\u0001A)\u0019!C)K\u0005qAO];tiN#xN]3GS2,W#\u0001\u0014\u0011\u0007\u001dRC&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0011\u0019v.\\3\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014AA5p\u0015\u0005\t\u0014\u0001\u00026bm\u0006L!a\r\u0018\u0003\t\u0019KG.\u001a\u0005\u0006k\u0001!\tEN\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u)\u00059\u0004CA\u00149\u0013\tI\u0004F\u0001\u0003V]&$\b\"B\u001e\u0001\t\u00032\u0014!B:fiV\u0003\bF\u0001\u001e>!\tq\u0014)D\u0001@\u0015\t\u0001u$A\u0003kk:LG/\u0003\u0002C\u007f\t1!)\u001a4pe\u0016DQ\u0001\u0012\u0001\u0005\n\u0015\u000b!b\u00197vgR,'/Q2m)\r1ej\u0015\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA!Y;uQ*\u00111\nB\u0001\tg\u0016\u001cWO]5us&\u0011Q\n\u0013\u0002\u0004\u0003\u000ed\u0007\"B(D\u0001\u0004\u0001\u0016A\u00049fe6L7o]5p]RK\b/\u001a\t\u0003\u000fFK!A\u0015%\u0003\u001dA+'/\\5tg&|g\u000eV=qK\")Ak\u0011a\u0001+\u0006Iq\u000e]3sCRLwN\u001c\t\u0003\u000fZK!a\u0016%\u0003\u0013=\u0003XM]1uS>t\u0007\"B-\u0001\t\u0013Q\u0016!D1eI\u000ecWo\u001d;fe\u0006\u001bG\u000eF\u000287rCQa\u0014-A\u0002ACQ\u0001\u0016-A\u0002UCQA\u0018\u0001\u0005\n}\u000b\u0001C]3n_Z,7\t\\;ti\u0016\u0014\u0018i\u00197\u0015\u0007]\u0002\u0017\rC\u0003P;\u0002\u0007\u0001\u000bC\u0003U;\u0002\u0007Q\u000bC\u0003d\u0001\u0011\u0005c'\u0001\u0005uK\u0006\u0014Hi\\<oQ\t\u0011W\r\u0005\u0002?M&\u0011qm\u0010\u0002\u0006\u0003\u001a$XM\u001d\u0005\bS\u0002\u0011\r\u0011\"\u0001k\u0003\u0011\t7\r\u001c\u001a\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u000e\u0002\u0007\u0005\u001cG.\u0003\u0002q[\nQ\u0011i\u00197CS:$\u0017N\\4\t\rI\u0004\u0001\u0015!\u0003l\u0003\u0015\t7\r\u001c\u001a!\u0011\u001d!\bA1A\u0005\u0002)\fA!Y2mg!1a\u000f\u0001Q\u0001\n-\fQ!Y2mg\u0001Bq\u0001\u001f\u0001C\u0002\u0013\u0005!.\u0001\u0004g_>\f5\r\u001c\u0005\u0007u\u0002\u0001\u000b\u0011B6\u0002\u000f\u0019|w.Q2mA!9A\u0010\u0001b\u0001\n\u0003Q\u0017A\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133BG2DaA \u0001!\u0002\u0013Y\u0017a\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133BG2\u0004\u0003BBA\u0001\u0001\u0011\u0005c'A\tuKN$\u0018i\u00197Pa\u0016\u0014\u0018\r^5p]ND3a`A\u0003!\rq\u0014qA\u0005\u0004\u0003\u0013y$\u0001\u0002+fgRDq!!\u0004\u0001\t\u0003\ty!A\nxC&$hi\u001c:EKN\u001c'/\u001b2f\u0003\u000ed7\u000fF\u00048\u0003#\t)#a\f\t\u0011\u0005M\u00111\u0002a\u0001\u0003+\taa\u00197jK:$\b\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0003?a\u0012aB2mS\u0016tGo]\u0005\u0005\u0003G\tIBA\u0006BI6Lgn\u00117jK:$\b\u0002CA\u0014\u0003\u0017\u0001\r!!\u000b\u0002\r\u0019LG\u000e^3s!\ra\u00171F\u0005\u0004\u0003[i'\u0001E!dY\nKg\u000eZ5oO\u001aKG\u000e^3s\u0011!\t\t$a\u0003A\u0002\u0005M\u0012\u0001B1dYN\u0004R!!\u000e\u0002D-tA!a\u000e\u0002@A\u0019\u0011\u0011\b\u0015\u000e\u0005\u0005m\"bAA\u001f\r\u00051AH]8pizJ1!!\u0011)\u0003\u0019\u0001&/\u001a3fM&!\u0011QIA$\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u0003B\u0003BBA&\u0001\u0011\u0005a'\u0001\nuKN$\u0018i\u00197Pa\u0016\u0014\u0018\r^5p]N\u0014\u0004\u0006BA%\u0003\u000bAa!!\u0015\u0001\t\u00031\u0014A\b;fgR\fE\u000f^3naR$vn\u0011:fCR,\u0017J\u001c<bY&$\u0017i\u00197tQ\u0011\ty%!\u0002\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005Ab/\u001a:jMf\u001c\u0015-^:f\u0013N\u001cE.^:uKJ\fU\u000f\u001e5\u0015\u0007]\nY\u0006\u0003\u0005\u0002^\u0005U\u0003\u0019AA0\u0003\u0005)\u0007\u0003BA1\u0003WrA!a\u0019\u0002h9!\u0011\u0011HA3\u0013\u0005I\u0013bAA5Q\u00059\u0001/Y2lC\u001e,\u0017\u0002BA7\u0003_\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005%\u0004\u0006C\u0004\u0002t\u0001!I!!\u001e\u0002-Q,7\u000f^!dY\u000e\u0013X-\u0019;f\u000f\u0016$H)\u001a7fi\u0016$2aNA<\u0011!\tI(!\u001dA\u0002\u0005m\u0014AC3ya\u0016\u001cG/Q;uQB\u0019q%! \n\u0007\u0005}\u0004FA\u0004C_>dW-\u00198\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\u0006QA/Z:u\u0003\u000edw)\u001a;\u0015\u0007]\n9\t\u0003\u0005\u0002z\u0005\u0005\u0005\u0019AA>\u0011\u0019\tY\t\u0001C\u0001m\u0005QB/Z:u\u0003\u000ed\u0017)\u001e;i_JL'0\u0019;j_:$UM\\5fI\"\"\u0011\u0011RA\u0003\u0001")
public class SaslSslAdminClientIntegrationTest
extends AdminClientIntegrationTest
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final AclBinding acl2;
    private final AclBinding acl3;
    private final AclBinding fooAcl;
    private final AclBinding transactionalIdAcl;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    private Some<File> trustStoreFile$lzycompute() {
        SaslSslAdminClientIntegrationTest saslSslAdminClientIntegrationTest = this;
        synchronized (saslSslAdminClientIntegrationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        try (Authorizer authorizer = (Authorizer)CoreUtils$.MODULE$.createObject(SimpleAclAuthorizer.class.getName(), (Seq)Predef$.MODULE$.wrapRefArray(new Object[0]));){
            authorizer.configure(((AbstractConfig)this.configs().head()).originals());
            authorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)})), new Resource((kafka.security.auth.ResourceType)Topic$.MODULE$, "*"));
            authorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)Create$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)Delete$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)ClusterAction$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)AlterConfigs$.MODULE$), this.clusterAcl((PermissionType)Allow$.MODULE$, (Operation)Alter$.MODULE$)})), Resource$.MODULE$.ClusterResource());
        }
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GSSAPI"}))), (Option<String>)new Some((Object)"GSSAPI"), Both$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    private Acl clusterAcl(PermissionType permissionType, Operation operation) {
        return new Acl(new KafkaPrincipal("User", "*"), permissionType, Acl$.MODULE$.WildCardHost(), operation);
    }

    private void addClusterAcl(PermissionType permissionType, Operation operation) {
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.clusterAcl(permissionType, operation)}));
        Authorizer authorizer = (Authorizer)((KafkaServer)this.servers().head()).apis().authorizer().get();
        Set prevAcls = authorizer.getAcls(Resource$.MODULE$.ClusterResource());
        authorizer.addAcls(acls, Resource$.MODULE$.ClusterResource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)prevAcls.$plus$plus((GenTraversableOnce)acls)), authorizer, Resource$.MODULE$.ClusterResource());
    }

    private void removeClusterAcl(PermissionType permissionType, Operation operation) {
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.clusterAcl(permissionType, operation)}));
        Authorizer authorizer = (Authorizer)((KafkaServer)this.servers().head()).apis().authorizer().get();
        Set prevAcls = authorizer.getAcls(Resource$.MODULE$.ClusterResource());
        Assert.assertTrue((boolean)authorizer.removeAcls(acls, Resource$.MODULE$.ClusterResource()));
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)prevAcls.$minus$minus((GenTraversableOnce)acls)), authorizer, Resource$.MODULE$.ClusterResource());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    public AclBinding acl2() {
        return this.acl2;
    }

    public AclBinding acl3() {
        return this.acl3;
    }

    public AclBinding fooAcl() {
        return this.fooAcl;
    }

    public AclBinding transactionalIdAcl() {
        return this.transactionalIdAcl;
    }

    @Override
    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Assert.assertEquals((long)6L, (long)((Collection)this.client().describeAcls(AclBindingFilter.ANY).values().get()).size());
        CreateAclsResult results = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl3()}))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl3()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results.values().keySet()).asScala());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results.values().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)value -> (Void)value.get());
        AclBinding aclUnknown = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.UNKNOWN, AclPermissionType.ALLOW));
        CreateAclsResult results2 = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclUnknown}))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclUnknown})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results2.values().keySet()).asScala());
        this.assertFutureExceptionTypeEquals(results2.all(), InvalidRequestException.class);
        Map results3 = this.client().deleteAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.ACL1().toFilter(), this.acl2().toFilter(), this.acl3().toFilter()}))).asJava()).values();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.ACL1().toFilter(), this.acl2().toFilter(), this.acl3().toFilter()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results3.keySet()).asScala());
        Assert.assertEquals((long)0L, (long)((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.ACL1().toFilter())).get()).values().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.acl2().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl3()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.acl3().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    public void waitForDescribeAcls(AdminClient client, AclBindingFilter filter, Set<AclBinding> acls) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Collection results = (Collection)client.describeAcls(filter).values().get();
            Set set = acls;
            Set set2 = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results).asScala()).toSet();
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timed out waiting for ACLs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{acls})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAclOperations2() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        CreateAclsResult results = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl2(), this.transactionalIdAcl()}))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl2(), this.transactionalIdAcl()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results.values().keySet()).asScala());
        results.all().get();
        this.waitForDescribeAcls(this.client(), this.acl2().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()}))));
        this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
        AclBindingFilter filterA = new AclBindingFilter(new ResourceFilter(ResourceType.GROUP, null), AccessControlEntryFilter.ANY);
        AclBindingFilter filterB = new AclBindingFilter(new ResourceFilter(ResourceType.TOPIC, "mytopic2"), AccessControlEntryFilter.ANY);
        AclBindingFilter filterC = new AclBindingFilter(new ResourceFilter(ResourceType.TRANSACTIONAL_ID, null), AccessControlEntryFilter.ANY);
        this.waitForDescribeAcls(this.client(), filterA, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.waitForDescribeAcls(this.client(), filterC, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
        DeleteAclsResult results2 = this.client().deleteAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filterA, filterB, filterC}))).asJava(), new DeleteAclsOptions());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filterA, filterB, filterC})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results2.values().keySet()).asScala());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterA)).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterC)).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterB)).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
        this.waitForDescribeAcls(this.client(), filterB, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.waitForDescribeAcls(this.client(), filterC, (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    @Test
    public void testAttemptToCreateInvalidAcls() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AclBinding clusterAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.CLUSTER, "foobar"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding emptyResourceNameAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, ""), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        CreateAclsResult results = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{clusterAcl, emptyResourceNameAcl}))).asJava(), new CreateAclsOptions());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{clusterAcl, emptyResourceNameAcl})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(results.values().keySet()).asScala());
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.values().get(clusterAcl), InvalidRequestException.class);
        this.assertFutureExceptionTypeEquals((KafkaFuture)results.values().get(emptyResourceNameAcl), InvalidRequestException.class);
    }

    private void verifyCauseIsClusterAuth(Throwable e) {
        if (!(e.getCause() instanceof ClusterAuthorizationException)) {
            throw e.getCause();
        }
    }

    private void testAclCreateGetDelete(boolean expectAuth) {
        block1: {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                CreateAclsResult result = this.client().createAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl(), this.transactionalIdAcl()}))).asJava(), new CreateAclsOptions());
                if (expectAuth) {
                    boolean bl2;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Void)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl2 = false;
                    } else if (try_ instanceof Success) {
                        bl2 = true;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl2;
                } else {
                    boolean bl3;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Void)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl3 = true;
                    } else if (try_ instanceof Success) {
                        bl3 = false;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl3;
                }
                return bl;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for createAcls to " + (expectAuth ? "succeed" : "fail"), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            if (expectAuth) {
                this.waitForDescribeAcls(this.client(), this.fooAcl().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl()}))));
                this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (Set<AclBinding>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
            }
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                DeleteAclsResult result = this.client().deleteAcls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.fooAcl().toFilter(), this.transactionalIdAcl().toFilter()}))).asJava(), new DeleteAclsOptions());
                if (expectAuth) {
                    boolean bl2;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl2 = false;
                    } else if (try_ instanceof Success) {
                        bl2 = true;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl2;
                } else {
                    boolean bl3;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)result.all().get());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.verifyCauseIsClusterAuth(e);
                        bl3 = true;
                    } else if (try_ instanceof Success) {
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl(), this.transactionalIdAcl()})), result.values().keySet());
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get(this.fooAcl().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
                        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get(this.transactionalIdAcl().toFilter())).get()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.binding(), Buffer$.MODULE$.canBuildFrom())).toSet());
                        bl3 = true;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    bl = bl3;
                }
                return bl;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for deleteAcls to " + (expectAuth ? "succeed" : "fail"), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            if (!expectAuth) break block1;
            this.waitForDescribeAcls(this.client(), this.fooAcl().toFilter(), (Set<AclBinding>)Predef$.MODULE$.Set().empty());
            this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (Set<AclBinding>)Predef$.MODULE$.Set().empty());
        }
    }

    private void testAclGet(boolean expectAuth) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            AclBinding userAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "*"), new AccessControlEntry("User:*", "*", AclOperation.ALL, AclPermissionType.ALLOW));
            DescribeAclsResult results = this.client().describeAcls(userAcl.toFilter());
            if (expectAuth) {
                boolean bl2;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)results.values().get());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.verifyCauseIsClusterAuth(e);
                    bl2 = false;
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Collection acls = (Collection)success.value();
                    bl2 = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{userAcl}))).equals((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(acls).asScala()).toSet());
                } else {
                    throw new MatchError((Object)try_);
                }
                bl = bl2;
            } else {
                boolean bl3;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Collection)results.values().get());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.verifyCauseIsClusterAuth(e);
                    bl3 = true;
                } else if (try_ instanceof Success) {
                    bl3 = false;
                } else {
                    throw new MatchError((Object)try_);
                }
                bl = bl3;
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for describeAcls to " + (expectAuth ? "succeed" : "fail"), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAclAuthorizationDenied() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.addClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Alter$.MODULE$);
        this.testAclGet(true);
        this.testAclCreateGetDelete(false);
        this.addClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Describe$.MODULE$);
        this.testAclGet(false);
        this.testAclCreateGetDelete(false);
        this.removeClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Describe$.MODULE$);
        this.removeClusterAcl((PermissionType)Deny$.MODULE$, (Operation)Alter$.MODULE$);
        this.testAclGet(true);
        this.testAclCreateGetDelete(true);
        this.removeClusterAcl((PermissionType)Allow$.MODULE$, (Operation)Alter$.MODULE$);
        this.removeClusterAcl((PermissionType)Allow$.MODULE$, (Operation)Delete$.MODULE$);
        this.testAclGet(false);
        this.testAclCreateGetDelete(false);
        this.addClusterAcl((PermissionType)Allow$.MODULE$, (Operation)Describe$.MODULE$);
        this.testAclGet(true);
        this.testAclCreateGetDelete(false);
    }

    public SaslSslAdminClientIntegrationTest() {
        SaslSetup.$init$(this);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.acl2 = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "mytopic2"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        this.acl3 = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.fooAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TOPIC, "foobar"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.transactionalIdAcl = new AclBinding(new org.apache.kafka.common.resource.Resource(ResourceType.TRANSACTIONAL_ID, "transactional_id"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.ALLOW));
    }
}

