/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.BaseQuotaTest;
import kafka.server.ConfigEntityName$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaId;
import kafka.server.QuotaId$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.Before;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\t)Rk]3s\u00072LWM\u001c;JIF+x\u000e^1UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\u0007CCN,\u0017+^8uCR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000bE\u0001A\u0011\u000b\n\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#A\n\u0011\u0005QqR\"A\u000b\u000b\u0005Y9\u0012\u0001\u00039s_R|7m\u001c7\u000b\u0005aI\u0012AB2p[6|gN\u0003\u0002\u00065)\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0013\tyRC\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"A\u0011\u0005\u0001EC\u0002\u0013E#%\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0003\r\u00022\u0001J\u0014*\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#\u0001B*p[\u0016\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0005%|'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u0012AAR5mK\"9!\u0007\u0001b\u0001\n\u0003\u001a\u0014!D;tKJ\u0004&/\u001b8dSB\fG.F\u00015!\t)\u0004(D\u00017\u0015\t9T&\u0001\u0003mC:<\u0017BA\u001d7\u0005\u0019\u0019FO]5oO\"11\b\u0001Q\u0001\nQ\na\"^:feB\u0013\u0018N\\2ja\u0006d\u0007\u0005C\u0003>\u0001\u0011\u0005c(A\bqe>$WoY3s#V|G/Y%e+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011A)\u0011\u0002\b#V|G/Y%e\u0011\u00151\u0005\u0001\"\u0011?\u0003=\u0019wN\\:v[\u0016\u0014\u0018+^8uC&#\u0007\"\u0002%\u0001\t\u0003J\u0015!B:fiV\u0003H#\u0001&\u0011\u0005\u0011Z\u0015B\u0001'&\u0005\u0011)f.\u001b;)\u0005\u001ds\u0005CA(S\u001b\u0005\u0001&BA)\u001d\u0003\u0015QWO\\5u\u0013\t\u0019\u0006K\u0001\u0004CK\u001a|'/\u001a\u0005\u0006+\u0002!\tEV\u0001\u000f_Z,'O]5eKF+x\u000e^1t)\u0011Qu\u000b\u00180\t\u000ba#\u0006\u0019A-\u0002\u001bA\u0014x\u000eZ;dKJ\fVo\u001c;b!\t!#,\u0003\u0002\\K\t!Aj\u001c8h\u0011\u0015iF\u000b1\u0001Z\u00035\u0019wN\\:v[\u0016\u0014\u0018+^8uC\")q\f\u0016a\u0001A\u0006a!/Z9vKN$\u0018+^8uCB\u0011A%Y\u0005\u0003E\u0016\u0012a\u0001R8vE2,\u0007\"\u00023\u0001\t\u0003J\u0015\u0001\u0006:f[>4X-U;pi\u0006|e/\u001a:sS\u0012,7\u000fC\u0003g\u0001\u0011%q-A\nva\u0012\fG/Z)v_R\fwJ^3se&$W\r\u0006\u0003KQN,\b\"\u0002\u001af\u0001\u0004I\u0007C\u00016r\u001d\tYw\u000e\u0005\u0002mK5\tQN\u0003\u0002o\r\u00051AH]8pizJ!\u0001]\u0013\u0002\rA\u0013X\rZ3g\u0013\tI$O\u0003\u0002qK!)A/\u001aa\u0001S\u0006A1\r\\5f]RLE\rC\u0003wK\u0002\u0007q/\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"\u0001_>\u000e\u0003eT!A_\u0017\u0002\tU$\u0018\u000e\\\u0005\u0003yf\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0001")
public class UserClientIdQuotaTest
extends BaseQuotaTest {
    private Some<File> trustStoreFile;
    private final String userPrincipal;
    private volatile boolean bitmap$0;

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SSL;
    }

    private Some<File> trustStoreFile$lzycompute() {
        UserClientIdQuotaTest userClientIdQuotaTest = this;
        synchronized (userClientIdQuotaTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    @Override
    public String userPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public QuotaId producerQuotaId() {
        return new QuotaId((Option)new Some((Object)QuotaId$.MODULE$.sanitize(this.userPrincipal())), (Option)new Some((Object)this.producerClientId()));
    }

    @Override
    public QuotaId consumerQuotaId() {
        return new QuotaId((Option)new Some((Object)QuotaId$.MODULE$.sanitize(this.userPrincipal())), (Option)new Some((Object)this.consumerClientId()));
    }

    @Override
    @Before
    public void setUp() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        super.setUp();
        Properties defaultProps = this.quotaProperties(this.defaultProducerQuota(), this.defaultConsumerQuota(), this.defaultRequestQuota());
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), ConfigEntityName$.MODULE$.Default() + "/clients/" + ConfigEntityName$.MODULE$.Default(), defaultProps);
        this.waitForQuotaUpdate(this.defaultProducerQuota(), this.defaultConsumerQuota(), this.defaultRequestQuota());
    }

    @Override
    public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
        Properties producerProps = new Properties();
        producerProps.setProperty(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        producerProps.setProperty(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.userPrincipal(), this.producerClientId(), producerProps);
        Properties consumerProps = new Properties();
        consumerProps.setProperty(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        consumerProps.setProperty(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.userPrincipal(), this.consumerClientId(), consumerProps);
    }

    @Override
    public void removeQuotaOverrides() {
        Properties emptyProps = new Properties();
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), QuotaId$.MODULE$.sanitize(this.userPrincipal()) + "/clients/" + this.producerClientId(), emptyProps);
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), QuotaId$.MODULE$.sanitize(this.userPrincipal()) + "/clients/" + this.consumerClientId(), emptyProps);
    }

    private void updateQuotaOverride(String userPrincipal, String clientId, Properties properties) {
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), QuotaId$.MODULE$.sanitize(userPrincipal) + "/clients/" + clientId, properties);
    }

    public UserClientIdQuotaTest() {
        this.userPrincipal = "O=A client,CN=localhost";
    }
}

