/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.test.ProducerCompressionTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001%\u0011q\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u0002;fgRT!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018NC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u000551\u0011A\u0001>l\u0013\tyAB\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u0005Y1m\\7qe\u0016\u001c8/[8o!\t\u0019BD\u0004\u0002\u00155A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0007yI|w\u000e\u001e \u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0002\rA\u0013X\rZ3g\u0013\tibD\u0001\u0004TiJLgn\u001a\u0006\u00037aAQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtDC\u0001\u0012%!\t\u0019\u0003!D\u0001\u0003\u0011\u0015\tr\u00041\u0001\u0013\u0011\u001d1\u0003A1A\u0005\n\u001d\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002QA\u0011\u0011FK\u0007\u00021%\u00111\u0006\u0007\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0001&A\u0005ce>\\WM]%eA!9q\u0006\u0001b\u0001\n\u0013\u0001\u0014!\u0002;pa&\u001cW#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001\u00027b]\u001eT\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u0002\u001eg!1\u0011\b\u0001Q\u0001\nE\na\u0001^8qS\u000e\u0004\u0003bB\u001e\u0001\u0005\u0004%IaJ\u0001\u000b]Vl'+Z2pe\u0012\u001c\bBB\u001f\u0001A\u0003%\u0001&A\u0006ok6\u0014VmY8sIN\u0004\u0003bB \u0001\u0001\u0004%I\u0001Q\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0003\u0005\u0003\"A\u0011#\u000e\u0003\rS!a\u0010\u0004\n\u0005\u0015\u001b%aC&bM.\f7+\u001a:wKJDqa\u0012\u0001A\u0002\u0013%\u0001*\u0001\u0006tKJ4XM]0%KF$\"!\u0013'\u0011\u0005%R\u0015BA&\u0019\u0005\u0011)f.\u001b;\t\u000f53\u0015\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\t\r=\u0003\u0001\u0015)\u0003B\u0003\u001d\u0019XM\u001d<fe\u0002BQ!\u0015\u0001\u0005BI\u000bQa]3u+B$\u0012!\u0013\u0015\u0003!R\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u000b),h.\u001b;\u000b\u0003e\u000b1a\u001c:h\u0013\tYfK\u0001\u0004CK\u001a|'/\u001a\u0005\u0006;\u0002!\tEU\u0001\ti\u0016\f'\u000fR8x]\"\u0012Al\u0018\t\u0003+\u0002L!!\u0019,\u0003\u000b\u00053G/\u001a:\t\u000b\r\u0004A\u0011\u0001*\u0002\u001fQ,7\u000f^\"p[B\u0014Xm]:j_:D#AY3\u0011\u0005U3\u0017BA4W\u0005\u0011!Vm\u001d;)\t\u0001Iw\u000e\u001d\t\u0003U6l\u0011a\u001b\u0006\u0003YZ\u000baA];o]\u0016\u0014\u0018B\u00018l\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003iZ\u000bqA];o]\u0016\u00148/\u0003\u0002wg\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012<Q\u0001\u001f\u0002\t\u0002e\fq\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u0011\u0005\rRh!B\u0001\u0003\u0011\u0003Y8c\u0001>}\u007fB\u0011\u0011&`\u0005\u0003}b\u0011a!\u00118z%\u00164\u0007cA\u0015\u0002\u0002%\u0019\u00111\u0001\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\r\u0001RH\u0011AA\u0004)\u0005I\bbBA\u0006u\u0012\u0005\u0011QB\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cXCAA\b!\u0019\t\t\"a\u0006\u0002\u001c5\u0011\u00111\u0003\u0006\u0004\u0003+)\u0014\u0001B;uS2LA!!\u0007\u0002\u0014\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t%\niBE\u0005\u0004\u0003?A\"!B!se\u0006L\b\u0006CA\u0005\u0003G\ti$a\u0010\u0011\t\u0005\u0015\u0012q\u0007\b\u0005\u0003O\t\u0019D\u0004\u0003\u0002*\u0005Eb\u0002BA\u0016\u0003_q1!FA\u0017\u0013\u0005I\u0016BA,Y\u0013\t!h+C\u0002\u00026M\fQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BA\u001d\u0003w\u0011!\u0002U1sC6,G/\u001a:t\u0015\r\t)d]\u0001\u0005]\u0006lW-\t\u0002\u0002B\u0005i20\u001b8eKbl\beY8naJ,7o]5p]RK\b/\u001a\u0011>Am\u0004T\u0010C\u0005\u0002Fi\f\t\u0011\"\u0003\u0002H\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u0005E\u00023\u0003\u0017J1!!\u00144\u0005\u0019y%M[3di\u0002")
public class ProducerCompressionTest
extends ZooKeeperTestHarness {
    private final String compression;
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaServer server;

    @Parameterized.Parameters(name="{index} compressionType = {0}")
    public static Collection<String[]> parameters() {
        return ProducerCompressionTest$.MODULE$.parameters();
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        super.tearDown();
    }

    @Test
    public void testCompression() {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", this.compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        String x$3 = bootstrapServers;
        SecurityProtocol x$4 = SecurityProtocol.PLAINTEXT;
        String x$5 = TestUtils$.MODULE$.createNewConsumer$default$2();
        String x$6 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$7 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$8 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$9 = TestUtils$.MODULE$.createNewConsumer$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createNewConsumer$default$8();
        Option<Properties> x$11 = TestUtils$.MODULE$.createNewConsumer$default$9();
        Option<Properties> x$12 = TestUtils$.MODULE$.createNewConsumer$default$10();
        KafkaConsumer<byte[], byte[]> consumer = TestUtils$.MODULE$.createNewConsumer(x$3, x$5, x$6, x$7, x$8, x$9, x$4, x$10, x$11, x$12);
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 1, (Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()})), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 0;
            IndexedSeq messageValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1 & Serializable & scala.Serializable)i -> ProducerCompressionTest.$anonfun$testCompression$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            long now = System.currentTimeMillis();
            IndexedSeq responses = (IndexedSeq)messageValues.map((Function1 & Serializable & scala.Serializable)message -> producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)responses.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerCompressionTest.$anonfun$testCompression$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$1);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((TraversableLike)((IterableLike)messageValues.zip(records, IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ProducerCompressionTest.$anonfun$testCompression$5(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$6(now, x$2);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    public static final /* synthetic */ String $anonfun$testCompression$1(int i) {
        return "value" + i;
    }

    public static final /* synthetic */ boolean $anonfun$testCompression$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Future future = (Future)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)((RecordMetadata)future.get()).offset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testCompression$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$2;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testCompression$6(long now$1, Tuple2 x$2) {
        int index;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$2;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                index = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String messageValue = (String)tuple2._1();
        ConsumerRecord record = (ConsumerRecord)tuple2._2();
        Assert.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
        Assert.assertEquals((long)now$1, (long)record.timestamp());
        Assert.assertEquals((long)index, (long)record.offset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ProducerCompressionTest(String compression) {
        this.compression = compression;
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
        this.server = null;
    }
}

