/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.BrokerEndPoint$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.Test;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001\u000f\t\u0011\"I]8lKJ,e\u000e\u001a)pS:$H+Z:u\u0015\t\u0019A!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012!\u0005;fgRD\u0015m\u001d5B]\u0012,\u0015/^1mgR\tA\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0005+:LG\u000f\u000b\u0002\u001aAA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001d\u0012#\u0001\u0002+fgRDQ!\u000b\u0001\u0005\u0002m\t\u0011\u0004^3ti\u001a\u0013x.\u001c&t_:4U\u000f^;sKZ+'o]5p]\"\u0012\u0001\u0006\t\u0005\u0006Y\u0001!\t!L\u0001\u000fi\u0016\u001cHO\u0012:p[*\u001bxN\u001c,3+\u0005a\u0002FA\u0016!\u0011\u0015\u0001\u0004\u0001\"\u0001\u001c\u00039!Xm\u001d;Ge>l'j]8o-FB#a\f\u0011\t\u000bM\u0002A\u0011A\u000e\u00023Q,7\u000f\u001e\"s_.,'/\u00128ea>Lg\u000e\u001e$s_6,&/\u001b\u0015\u0003e\u0001BQA\u000e\u0001\u0005\u0002m\t1\u0003^3ti\u0016sG\r]8j]R4%o\\7Ve&D#!\u000e\u0011")
public class BrokerEndPointTest
implements Logging {
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.trace$((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.debug$((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.info$((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.warn$((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.error$((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BrokerEndPointTest brokerEndPointTest = this;
        synchronized (brokerEndPointTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Test
    public void testHashAndEquals() {
        Broker broker1 = TestUtils$.MODULE$.createBroker(1, "myhost", 9092, TestUtils$.MODULE$.createBroker$default$4());
        Broker broker2 = TestUtils$.MODULE$.createBroker(1, "myhost", 9092, TestUtils$.MODULE$.createBroker$default$4());
        Broker broker3 = TestUtils$.MODULE$.createBroker(2, "myhost", 1111, TestUtils$.MODULE$.createBroker$default$4());
        Broker broker4 = TestUtils$.MODULE$.createBroker(1, "other", 1111, TestUtils$.MODULE$.createBroker$default$4());
        Broker broker = broker1;
        Broker broker5 = broker2;
        Predef$.MODULE$.assert(!(broker != null ? !broker.equals(broker5) : broker5 != null));
        Broker broker6 = broker1;
        Broker broker7 = broker3;
        Predef$.MODULE$.assert(broker6 == null ? broker7 != null : !broker6.equals(broker7));
        Broker broker8 = broker1;
        Broker broker9 = broker4;
        Predef$.MODULE$.assert(broker8 == null ? broker9 != null : !broker8.equals(broker9));
        Predef$.MODULE$.assert(broker1.hashCode() == broker2.hashCode());
        Predef$.MODULE$.assert(broker1.hashCode() != broker3.hashCode());
        Predef$.MODULE$.assert(broker1.hashCode() != broker4.hashCode());
        HashMap hashmap = new HashMap();
        hashmap.put((Object)broker1, (Object)BoxesRunTime.boxToInteger((int)1));
        Predef$.MODULE$.assert(BoxesRunTime.unboxToInt((Object)hashmap.getOrElse((Object)broker1, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)) == 1);
    }

    @Test
    public void testFromJsonFutureVersion() {
        String brokerInfoStr = "{\n      \"foo\":\"bar\",\n      \"version\":100,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"SSL://localhost:9093\"]\n    }";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Predef$.MODULE$.assert(broker.id() == 1);
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        String string = brokerEndPoint.host();
        String string2 = "localhost";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(brokerEndPoint.port() == 9093);
    }

    @Test
    public void testFromJsonV2() {
        String brokerInfoStr = "{\n      \"version\":2,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"PLAINTEXT://localhost:9092\"]\n    }";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Predef$.MODULE$.assert(broker.id() == 1);
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String string = brokerEndPoint.host();
        String string2 = "localhost";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(brokerEndPoint.port() == 9092);
    }

    @Test
    public void testFromJsonV1() {
        String brokerInfoStr = "{\"jmx_port\":-1,\"timestamp\":\"1420485325400\",\"host\":\"172.16.8.243\",\"version\":1,\"port\":9091}";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Predef$.MODULE$.assert(broker.id() == 1);
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String string = brokerEndPoint.host();
        String string2 = "172.16.8.243";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(brokerEndPoint.port() == 9091);
    }

    @Test
    public void testBrokerEndpointFromUri() {
        String connectionString = "localhost:9092";
        BrokerEndPoint endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string = endpoint.host();
        String string2 = "localhost";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        connectionString = "local_host:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string3 = endpoint.host();
        String string4 = "local_host";
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        connectionString = "[::1]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string5 = endpoint.host();
        String string6 = "::1";
        Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        connectionString = "[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string7 = endpoint.host();
        String string8 = "fe80::b1da:69ca:57f7:63d8%3";
        Predef$.MODULE$.assert(!(string7 != null ? !string7.equals(string8) : string8 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        connectionString = "MyHostname:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        String string9 = endpoint.host();
        String string10 = "MyHostname";
        Predef$.MODULE$.assert(!(string9 != null ? !string9.equals(string10) : string10 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
    }

    @Test
    public void testEndpointFromUri() {
        String connectionString = "PLAINTEXT://localhost:9092";
        EndPoint endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        String string = endpoint.host();
        String string2 = "localhost";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string3 = endpoint.connectionString();
        String string4 = "PLAINTEXT://localhost:9092";
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
        connectionString = "PLAINTEXT://local_host:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        String string5 = endpoint.host();
        String string6 = "local_host";
        Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string7 = endpoint.connectionString();
        String string8 = "PLAINTEXT://local_host:9092";
        Predef$.MODULE$.assert(!(string7 != null ? !string7.equals(string8) : string8 != null));
        connectionString = "PLAINTEXT://:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Predef$.MODULE$.assert(endpoint.host() == null);
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string9 = endpoint.connectionString();
        String string10 = "PLAINTEXT://:9092";
        Predef$.MODULE$.assert(!(string9 != null ? !string9.equals(string10) : string10 != null));
        connectionString = "PLAINTEXT://[::1]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        String string11 = endpoint.host();
        String string12 = "::1";
        Predef$.MODULE$.assert(!(string11 != null ? !string11.equals(string12) : string12 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string13 = endpoint.connectionString();
        String string14 = "PLAINTEXT://[::1]:9092";
        Predef$.MODULE$.assert(!(string13 != null ? !string13.equals(string14) : string14 != null));
        connectionString = "PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        String string15 = endpoint.host();
        String string16 = "fe80::b1da:69ca:57f7:63d8%3";
        Predef$.MODULE$.assert(!(string15 != null ? !string15.equals(string16) : string16 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string17 = endpoint.connectionString();
        String string18 = "PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092";
        Predef$.MODULE$.assert(!(string17 != null ? !string17.equals(string18) : string18 != null));
        connectionString = "PLAINTEXT://MyHostname:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        String string19 = endpoint.host();
        String string20 = "MyHostname";
        Predef$.MODULE$.assert(!(string19 != null ? !string19.equals(string20) : string20 != null));
        Predef$.MODULE$.assert(endpoint.port() == 9092);
        String string21 = endpoint.connectionString();
        String string22 = "PLAINTEXT://MyHostname:9092";
        Predef$.MODULE$.assert(!(string21 != null ? !string21.equals(string22) : string22 != null));
    }

    public BrokerEndPointTest() {
        Logging.$init$((Logging)this);
    }
}

