/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import kafka.common.InterBrokerSendThread;
import kafka.common.InterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.utils.MockTime;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fG\rV3ti*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0005+\u0005!A/[7f+\u00051\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002D\u0001\u0005N_\u000e\\G+[7f\u0011\u0019i\u0002\u0001)A\u0005-\u0005)A/[7fA!9q\u0004\u0001b\u0001\n\u0013\u0001\u0013!\u00048fi^|'o[\"mS\u0016tG/F\u0001\"!\t\u0011#&D\u0001$\u0015\t!S%A\u0004dY&,g\u000e^:\u000b\u0005\u00151#BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001eL!aK\u0012\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0011\u0019i\u0003\u0001)A\u0005C\u0005qa.\u001a;x_J\\7\t\\5f]R\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\u0012G>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014X#A\u0019\u0011\u0005I\u001aT\"\u0001\u0001\u0007\tQ\u0002A!\u000e\u0002\u0016'R,(mQ8na2,G/[8o\u0011\u0006tG\r\\3s'\r\u0019dG\u0010\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nA\u0001\\1oO*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u0019y%M[3diB\u0011!eP\u0005\u0003\u0001\u000e\u0012\u0001DU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0011\u0015y1\u0007\"\u0001C)\u0005\t\u0004\"\u0003#4\u0001\u0004\u0005\r\u0011\"\u0001F\u0003!\u0011Xm\u001d9p]N,W#\u0001$\u0011\u0005\t:\u0015B\u0001%$\u00059\u0019E.[3oiJ+7\u000f]8og\u0016D\u0011BS\u001aA\u0002\u0003\u0007I\u0011A&\u0002\u0019I,7\u000f]8og\u0016|F%Z9\u0015\u00051{\u0005CA\u0005N\u0013\tq%B\u0001\u0003V]&$\bb\u0002)J\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0004B\u0002*4A\u0003&a)A\u0005sKN\u0004xN\\:fA!)Ak\rC!+\u0006QqN\\\"p[BdW\r^3\u0015\u000513\u0006\"\u0002#T\u0001\u00041\u0005B\u0002-\u0001A\u0003%\u0011'\u0001\nd_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ\u0004\u0003\"\u0002.\u0001\t\u0003Y\u0016aI:i_VdGMT8u'\u0016tG-\u00118zi\"LgnZ,iK:tuNU3rk\u0016\u001cHo\u001d\u000b\u0002\u0019\"\u0012\u0011,\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\"\nQA[;oSRL!AY0\u0003\tQ+7\u000f\u001e\u0005\u0006I\u0002!\taW\u00010g\"|W\u000f\u001c3De\u0016\fG/Z\"mS\u0016tGOU3rk\u0016\u001cH/\u00118e'\u0016tGm\u00165f]:{G-Z%t%\u0016\fG-\u001f\u0015\u0003GvCQa\u001a\u0001\u0005\u0002m\u000b1i\u001d5pk2$7)\u00197m\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014x+\u001b;i\t&\u001c8m\u001c8oK\u000e$X\r\u001a*fgB|gn]3XQ\u0016tgj\u001c3f\u001d>$(+Z1es\"\u0012a-\u0018\u0004\u0005U\u0002!1N\u0001\nTiV\u0014'+Z9vKN$()^5mI\u0016\u00148CA5m!\riGo\u001e\b\u0003]Jl\u0011a\u001c\u0006\u0003aF\f\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u0007\u0015J!a]8\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRL!!\u001e<\u0003\u000f\t+\u0018\u000e\u001c3fe*\u00111o\u001c\t\u0003\u0013aL!!\u001f\u0006\u0003\u000f9{G\u000f[5oO\")q\"\u001bC\u0001wR\tA\u0010\u0005\u00023S\")a0\u001bC!\u007f\u0006)!-^5mIR\u0019q/!\u0001\t\u000f\u0005\rQ\u00101\u0001\u0002\u0006\u00059a/\u001a:tS>t\u0007cA\u0005\u0002\b%\u0019\u0011\u0011\u0002\u0006\u0003\u000bMCwN\u001d;")
public class InterBrokerSendThreadTest {
    private final MockTime kafka$common$InterBrokerSendThreadTest$$time = new MockTime();
    private final NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient = (NetworkClient)EasyMock.createMock(NetworkClient.class);
    private final StubCompletionHandler completionHandler = new StubCompletionHandler();

    public MockTime kafka$common$InterBrokerSendThreadTest$$time() {
        return this.kafka$common$InterBrokerSendThreadTest$$time;
    }

    public NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient() {
        return this.kafka$common$InterBrokerSendThreadTest$$networkClient;
    }

    private StubCompletionHandler completionHandler() {
        return this.completionHandler;
    }

    @Test
    public void shouldNotSendAnythingWhenNoRequests() {
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this){

            public Iterable<Nothing$> generateRequests() {
                return (Iterable)Iterable$.MODULE$.empty();
            }
        };
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn((Object)Utils.mkList((Object[])new ClientResponse[0]));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
    }

    @Test
    public void shouldCreateClientRequestAndSendWhenNodeIsReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, handler){
            private final RequestAndCompletionHandler handler$1;

            public List<RequestAndCompletionHandler> generateRequests() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RequestAndCompletionHandler[]{this.handler$1}));
            }
            {
                this.handler$1 = handler$1;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4());
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, handler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.kafka$common$InterBrokerSendThreadTest$$networkClient().send(clientRequest, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn((Object)Utils.mkList((Object[])new ClientResponse[0]));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
    }

    @Test
    public void shouldCallCompletionHandlerWithDisconnectedResponseWhenNodeNotReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler requestAndCompletionHandler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, requestAndCompletionHandler){
            private final RequestAndCompletionHandler requestAndCompletionHandler$1;

            public List<RequestAndCompletionHandler> generateRequests() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RequestAndCompletionHandler[]{this.requestAndCompletionHandler$1}));
            }
            {
                this.requestAndCompletionHandler$1 = requestAndCompletionHandler$1;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4());
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, requestAndCompletionHandler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)requestAndCompletionHandler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), (RequestCompletionHandler)EasyMock.same((Object)requestAndCompletionHandler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionDelay((Node)EasyMock.anyObject(), EasyMock.anyLong()))).andReturn((Object)BoxesRunTime.boxToLong((long)0L));
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn((Object)Utils.mkList((Object[])new ClientResponse[0]));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertTrue((boolean)this.completionHandler().response().wasDisconnected());
    }

    public class StubCompletionHandler
    implements RequestCompletionHandler {
        private ClientResponse response;

        public ClientResponse response() {
            return this.response;
        }

        public void response_$eq(ClientResponse x$1) {
            this.response = x$1;
        }

        public void onComplete(ClientResponse response) {
            this.response_$eq(response);
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubCompletionHandler$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubCompletionHandler() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
        }
    }

    public class StubRequestBuilder
    extends AbstractRequest.Builder<Nothing$> {
        public Nothing$ build(short version) {
            return Predef$.MODULE$.$qmark$qmark$qmark();
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubRequestBuilder$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubRequestBuilder() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
            super(ApiKeys.END_TXN);
        }
    }
}

