/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.ControllerTestUtils$;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u000f\tQ2i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0003\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0016\u0003Y\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014X#\u0001\f\u0011\u0005I9\u0012B\u0001\r\u0003\u0005Y\u0019uN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014\b\"\u0003\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u001c\u0003i\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014x\fJ3r)\tar\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0005+:LG\u000fC\u0004!3\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004#\u0001\u0001\u0006KAF\u0001\u0018G>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u00029!\u00121e\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nQA[;oSRT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018*\u0005\u0015\te\r^3s\u0011\u0015\u0001\u0004\u0001\"\u0001&\u0003M!Xm\u001d;Tk\u000e\u001cWm]:gk2,e/\u001a8uQ\ty#\u0007\u0005\u0002)g%\u0011A'\u000b\u0002\u0005)\u0016\u001cH\u000fC\u00037\u0001\u0011\u0005Q%\u0001\u000fuKN$XI^3oiRC\u0017\r\u001e+ie><8/\u0012=dKB$\u0018n\u001c8)\u0005U\u0012\u0004\"B\u001d\u0001\t\u0013Q\u0014!B2iK\u000e\\G\u0003\u0002\u000f<\u00116CQ\u0001\u0010\u001dA\u0002u\n!\"\\3ue&\u001cg*Y7f!\tqTI\u0004\u0002@\u0007B\u0011\u0001IC\u0007\u0002\u0003*\u0011!IB\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011S\u0011A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001\u0012\u0006\t\u000b%C\u0004\u0019\u0001&\u0002\u001f\r|g\u000e\u001e:pY2,'o\u0015;bi\u0016\u0004\"AE&\n\u00051\u0013!aD\"p]R\u0014x\u000e\u001c7feN#\u0018\r^3\t\u000b9C\u0004\u0019A(\u0002\u000fA\u0014xnY3tgB\u0019\u0011\u0002\u0015\u000f\n\u0005ES!!\u0003$v]\u000e$\u0018n\u001c81\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0003\u0015!\u0018.\\3s)\t)\u0016\r\u0005\u0002W?6\tqK\u0003\u0002Y3\u0006!1m\u001c:f\u0015\tQ6,A\u0004nKR\u0014\u0018nY:\u000b\u0005qk\u0016AB=b[6,'OC\u0001_\u0003\r\u0019w.\\\u0005\u0003A^\u0013Q\u0001V5nKJDQ\u0001\u0010*A\u0002u\u0002")
public class ControllerEventManagerTest {
    private ControllerEventManager controllerEventManager;

    private ControllerEventManager controllerEventManager() {
        return this.controllerEventManager;
    }

    private void controllerEventManager_$eq(ControllerEventManager x$1) {
        this.controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        block0: {
            if (this.controllerEventManager() == null) break block0;
            this.controllerEventManager().close();
        }
    }

    @Test
    public void testSuccessfulEvent() {
        this.check("kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs", (ControllerState)ControllerState.AutoLeaderBalance$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
    }

    @Test
    public void testEventThatThrowsException() {
        this.check("kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs", (ControllerState)ControllerState.BrokerChange$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new NullPointerException();
        });
    }

    private void check(String metricName, ControllerState controllerState, Function0<BoxedUnit> process) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        this.controllerEventManager_$eq(new ControllerEventManager(controllerStats.rateAndTimeMetrics(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            eventProcessedListenerCount.incrementAndGet();
            return BoxedUnit.UNIT;
        }));
        this.controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEvent eventMock = ControllerTestUtils$.MODULE$.createMockControllerEvent(controllerState, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            latch.await();
            process.apply$mcV$sp();
        });
        this.controllerEventManager().put(eventMock);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState controllerState2 = controllerState;
            return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller state is not ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{controllerState})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
            return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller state has not changed back to Idle", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$timer$1(metricName, x$2))).values().headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName}))));
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

