/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u0001\u0003\u0001%\u00111\u0004\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:UKN$(BA\u0002\u0005\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011aC2p_J$\u0017N\\1u_JT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#A\u0006qCJ$\u0018\u000e^5p]&#W#\u0001\r\u0011\u0005-I\u0012B\u0001\u000e\r\u0005\rIe\u000e\u001e\u0005\u00079\u0001\u0001\u000b\u0011\u0002\r\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000fy\u0001!\u0019!C\u0001/\u0005ia.^7QCJ$\u0018\u000e^5p]NDa\u0001\t\u0001!\u0002\u0013A\u0012A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bE\u0001\u0011\r\u0011\"\u0001\u0018\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\"1A\u0005\u0001Q\u0001\na\tQ\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\b\u0005C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0006\u0005\u0002*c5\t!F\u0003\u0002,Y\u000511m\\7n_:T!aB\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e)\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u00045\u0001\u0001\u0006I\u0001K\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!9a\u0007\u0001b\u0001\n\u00039\u0012\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u0019A\u0004\u0001)A\u00051\u0005\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005QA\u000f\u001f8SK\u000e|'\u000fZ:\u0016\u0003q\u00022!\u0010\"E\u001b\u0005q$BA A\u0003\u001diW\u000f^1cY\u0016T!!\u0011\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002D}\tY\u0011I\u001d:bs\n+hMZ3s!\t)\u0005*D\u0001G\u0015\t9%&\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003\u0013\u001a\u0013AbU5na2,'+Z2pe\u0012Daa\u0013\u0001!\u0002\u0013a\u0014a\u0003;y]J+7m\u001c:eg\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0003uS6,W#A(\u0011\u0005A\u001bV\"A)\u000b\u0005IS\u0013!B;uS2\u001c\u0018B\u0001+R\u0005!iunY6US6,\u0007B\u0002,\u0001A\u0003%q*A\u0003uS6,\u0007\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001.\u0011\u0005mkV\"\u0001/\u000b\u0005I3\u0011B\u00010]\u00055iunY6TG\",G-\u001e7fe\"1\u0001\r\u0001Q\u0001\ni\u000b!b]2iK\u0012,H.\u001a:!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\fqA_6Vi&d7/F\u0001e!\tYV-\u0003\u0002g9\n9!l[+uS2\u001c\bB\u00025\u0001A\u0003%A-\u0001\u0005{WV#\u0018\u000e\\:!\u0011\u001dQ\u0007A1A\u0005\u0002-\faB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001m!\ti\u0007/D\u0001o\u0015\tyg!\u0001\u0004tKJ4XM]\u0005\u0003c:\u0014aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0004t\u0001\u0001\u0006I\u0001\\\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!9Q\u000f\u0001b\u0001\n\u00031\u0018!\u0003;y]\u000e{gNZ5h+\u00059\bC\u0001\u000by\u0013\tI(AA\tUe\u0006t7/Y2uS>t7i\u001c8gS\u001eDaa\u001f\u0001!\u0002\u00139\u0018A\u0003;y]\u000e{gNZ5hA!9Q\u0010\u0001b\u0001\n\u0003q\u0018A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ,\u0012a \t\u0004)\u0005\u0005\u0011bAA\u0002\u0005\t9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM\u001d\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003\u0000\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:!\u0011%\tY\u0001\u0001b\u0001\n\u0003\ti!\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ecU\u0011\u0011q\u0002\t\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005m\u0001cAA\u000b\u00195\u0011\u0011q\u0003\u0006\u0004\u00033A\u0011A\u0002\u001fs_>$h(C\u0002\u0002\u001e1\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'bAA\u000f\u0019!A\u0011q\u0005\u0001!\u0002\u0013\ty!A\tue\u0006t7/Y2uS>t\u0017\r\\%ec\u0001B\u0011\"a\u000b\u0001\u0005\u0004%\t!!\u0004\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0004\u0002CA\u0018\u0001\u0001\u0006I!a\u0004\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0004\u0005C\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026\u0005\u0019B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3tcU\u0011\u0011q\u0007\t\u0006\u0017\u0005e\u0012QH\u0005\u0004\u0003wa!!B!se\u0006L\bcA\u0006\u0002@%\u0019\u0011\u0011\t\u0007\u0003\t\tKH/\u001a\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u00028\u0005!B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3tc\u0001B\u0011\"!\u0013\u0001\u0005\u0004%\t!!\u000e\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm\u001d\u001a\t\u0011\u00055\u0003\u0001)A\u0005\u0003o\tA\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgJ\u0002\u0003\"CA)\u0001\t\u0007I\u0011AA*\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\nZ:\u0016\u0005\u0005U\u0003\u0003CA,\u00033\ny!!\u0018\u000e\u0003\u0001K1!a\u0017A\u0005\ri\u0015\r\u001d\t\u0004\u0017\u0005}\u0013bAA1\u0019\t!Aj\u001c8h\u0011!\t)\u0007\u0001Q\u0001\n\u0005U\u0013\u0001\u00049s_\u0012,8-\u001a:JIN\u0004\u0003\"CA5\u0001\u0001\u0007I\u0011AA6\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\ti\u0007E\u0002\u0015\u0003_J1!!\u001d\u0003\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011%\t)\b\u0001a\u0001\n\u0003\t9(\u0001\tuq:lU\r^1eCR\f\u0017g\u0018\u0013fcR!\u0011\u0011PA@!\rY\u00111P\u0005\u0004\u0003{b!\u0001B+oSRD!\"!!\u0002t\u0005\u0005\t\u0019AA7\u0003\rAH%\r\u0005\t\u0003\u000b\u0003\u0001\u0015)\u0003\u0002n\u0005iA\u000f\u001f8NKR\fG-\u0019;bc\u0001B\u0011\"!#\u0001\u0001\u0004%\t!a\u001b\u0002\u0019QDh.T3uC\u0012\fG/\u0019\u001a\t\u0013\u00055\u0005\u00011A\u0005\u0002\u0005=\u0015\u0001\u0005;y]6+G/\u00193bi\u0006\u0014t\fJ3r)\u0011\tI(!%\t\u0015\u0005\u0005\u00151RA\u0001\u0002\u0004\ti\u0007\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0015BA7\u00035!\bP\\'fi\u0006$\u0017\r^13A!I\u0011\u0011\u0014\u0001A\u0002\u0013\u0005\u00111T\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0016\u0005\u0005u\u0005\u0003BAP\u0003Kk!!!)\u000b\u0007\u0005\r&&\u0001\u0005qe>$xnY8m\u0013\u0011\t9+!)\u0003\r\u0015\u0013(o\u001c:t\u0011%\tY\u000b\u0001a\u0001\n\u0003\ti+A\tfqB,7\r^3e\u000bJ\u0014xN]0%KF$B!!\u001f\u00020\"Q\u0011\u0011QAU\u0003\u0003\u0005\r!!(\t\u0011\u0005M\u0006\u0001)Q\u0005\u0003;\u000ba\"\u001a=qK\u000e$X\rZ#se>\u0014\b\u0005C\u0004\u00028\u0002!\t!!/\u0002\u000bM,G/\u00169\u0015\u0005\u0005e\u0004\u0006BA[\u0003{\u0003B!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007|\u0013!\u00026v]&$\u0018\u0002BAd\u0003\u0003\u0014aAQ3g_J,\u0007bBAf\u0001\u0011\u0005\u0011\u0011X\u0001\ti\u0016\f'\u000fR8x]\"\"\u0011\u0011ZAh!\u0011\ty,!5\n\t\u0005M\u0017\u0011\u0019\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003/\u0004A\u0011AA]\u0003y!Xm\u001d;WC2LG-\u0019;f)J\fgn]1di&|g\u000eV5nK>,H\u000f\u000b\u0003\u0002V\u0006m\u0007\u0003BA`\u0003;LA!a8\u0002B\n!A+Z:u\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003s\u000ba\u0002^3ti\u0006#GmR3u!&$7\u000f\u000b\u0003\u0002b\u0006m\u0007bBAu\u0001\u0011\u0005\u0011\u0011X\u0001*i\u0016\u001cH\u000fT8bI\u0006sGMU3n_Z,GK]1og\u0006\u001cG/[8og\u001a{'\u000fU1si&$\u0018n\u001c8)\t\u0005\u001d\u00181\u001c\u0005\b\u0003_\u0004A\u0011AA]\u0003%\"Xm\u001d;D_6\u0004H.\u001a;f)J\fgn]5uS>tw\u000b[3o\u0003B\u0004XM\u001c3Tk\u000e\u001cW-\u001a3fI\"\"\u0011Q^An\u0011\u001d\t)\u0010\u0001C\u0001\u0003s\u000bA\u0006^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8D_>\u0014H-\u001b8bi>\u0014hj\u001c;Bm\u0006LG.\u00192mK\u0016\u0013(o\u001c:)\t\u0005M\u00181\u001c\u0005\b\u0003w\u0004A\u0011AA]\u0003\r\"Xm\u001d;BaB,g\u000e\u001a$bS2$vNT8u\u0007>|'\u000fZ5oCR|'/\u0012:s_JDC!!?\u0002\\\"9!\u0011\u0001\u0001\u0005\u0002\u0005e\u0016a\n;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p\u0007>|'\u000fZ5oCR|'\u000fT8bI&tw-\u0012:s_JDC!a@\u0002\\\"9!q\u0001\u0001\u0005\u0002\u0005e\u0016\u0001\b;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p+:\\gn\\<o\u000bJ\u0014xN\u001d\u0015\u0005\u0005\u000b\tY\u000eC\u0004\u0003\u000e\u0001!\t!!/\u0002KQ,7\u000f\u001e)f]\u0012LgnZ*uCR,gj\u001c;SKN,Go\u00148SKR\u0014\u00180\u00119qK:$\u0007\u0006\u0002B\u0006\u00037DqAa\u0005\u0001\t\u0003\tI,A\u0017uKN$\u0018\t\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{wm\u00165jY\u0016\u0004&o\u001c3vG\u0016\u0014h)\u001a8dK\u0012DCA!\u0005\u0002\\\"9!\u0011\u0004\u0001\u0005\u0002\u0005e\u0016A\r;fgR\f\u0005\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><w\u000b[5mKB+g\u000eZ5oON#\u0018\r^3DQ\u0006tw-\u001a3)\u0011\t]\u00111\u001cB\u000f\u0005?\t\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0005C\u0001BAa\t\u0003.5\u0011!Q\u0005\u0006\u0005\u0005O\u0011I#\u0001\u0003mC:<'B\u0001B\u0016\u0003\u0011Q\u0017M^1\n\t\t=\"Q\u0005\u0002\u0016\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0003s\u000bqh\u001d5pk2$'+\u001a;ve:tu\u000e^\"p_JLGM\\1u_J,%O]8s\u0013\u001a$&/\u00198tC\u000e$\u0018n\u001c8JIB\u000b'\u000f^5uS>tgj\u001c;Po:,G\r\u000b\u0003\u00032\u0005m\u0007b\u0002B\u001d\u0001\u0011\u0005\u0011\u0011X\u00017g\"|W\u000f\u001c3P]2L8i\u001c8tS\u0012,'\u000f\u0016:b]N\f7\r^5p]NLe\u000e\u00165f\u001f:<w.\u001b8h'R\fG/\u001a+p\u0003\n|'\u000f\u001e\u0015\u0005\u0005o\tY\u000eC\u0004\u0003@\u0001!\t!!/\u0002qMDw.\u001e7e/JLG/\u001a+y]6\u000b'o[3sg\u001a{'\u000f\u0016:b]N\f7\r^5p]&s\u0007K]3qCJ,GmQ8n[&$8\u000b^1uK\"\"!QHAn\u0011\u001d\u0011)\u0005\u0001C\u0001\u0003s\u000bqg\u001d5pk2$wK]5uKRCh.T1sW\u0016\u00148OR8s)J\fgn]1di&|g.\u00138Qe\u0016\u0004\u0018M]3e\u0003\n|'\u000f^*uCR,\u0007\u0006\u0002B\"\u00037DqAa\u0013\u0001\t\u0003\tI,\u0001\u001atQ>,H\u000e\u001a*f[>4XmQ8na2,G/Z\"p[6l\u0017\u000e^#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\u0011\u0011I%a7\t\u000f\tE\u0003\u0001\"\u0001\u0002:\u0006\u00014\u000f[8vY\u0012\u0014V-\\8wK\u000e{W\u000e\u001d7fi\u0016\f%m\u001c:u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINDCAa\u0014\u0002\\\"9!q\u000b\u0001\u0005\u0002\u0005e\u0016\u0001K:i_VdGMU3n_Z,W)\u001c9us\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\b\u0006\u0002B+\u00037DqA!\u0018\u0001\t\u0003\tI,\u0001\u001ctQ>,H\u000e\u001a(piJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\rT8h\u0003B\u0004XM\u001c3GC&d7\u000f\u000b\u0003\u0003\\\u0005m\u0007b\u0002B2\u0001\u0011\u0005\u0011\u0011X\u0001'g\"|W\u000f\u001c3O_R\u0014V-\\8wK>swm\\5oOR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\b\u0006\u0002B1\u00037DqA!\u001b\u0001\t\u0003\tI,A\u0016tQ>,H\u000e\u001a(piJ+Wn\u001c<f!J,\u0007/\u0019:f\u0003\n|'\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\u0011\u00119'a7\t\u000f\t=\u0004\u0001\"\u0001\u0002:\u0006a3\u000f[8vY\u0012tu\u000e\u001e*f[>4X\r\u0015:fa\u0006\u0014XmQ8n[&$HK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0005\u0005[\nY\u000eC\u0004\u0003v\u0001!IAa\u001e\u0002/Y,'/\u001b4z\u001b\u0016$\u0018\rZ1uC\u0012{Wm]#ySN$H\u0003BA=\u0005sB\u0001Ba\u001f\u0003t\u0001\u0007\u0011qB\u0001\u0010iJ\fgn]1di&|g.\u00197JI\"9!q\u0010\u0001\u0005\n\t\u0005\u0015!\u0007<fe&4\u00170T3uC\u0012\fG/\u0019#pKNtG/\u0012=jgR$B!!\u001f\u0003\u0004\"A!1\u0010B?\u0001\u0004\ty\u0001C\u0004\u0003\b\u0002!IA!#\u0002IM,G/\u001e9B]\u0012\u0014VO\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$b!!\u001f\u0003\f\n=\u0005\u0002\u0003BG\u0005\u000b\u0003\r!!(\u0002\u000b\u0015\u0014(o\u001c:\t\u0011\tE%Q\u0011a\u0001\u0005'\u000b\u0001\u0002\u001e=o'R\fG/\u001a\t\u0004)\tU\u0015b\u0001BL\u0005\t\u0001BK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0005\b\u00057\u0003A\u0011\u0002BO\u0003\u00112XM]5gs^\u0013\u0018\u000e^3t)btW*\u0019:lKJ\u001c\u0018J\u001c)sKB\f'/Z*uCR,G\u0003BA=\u0005?C\u0001B!)\u0003\u001a\u0002\u0007!1S\u0001\u0006gR\fG/\u001a\u0005\b\u0005K\u0003A\u0011\u0002BT\u00039\t7o]3si\u000e\u000bG\u000e\u001c2bG.$B!!\u001f\u0003*\"A!Q\u0012BR\u0001\u0004\ti\nC\u0004\u0003.\u0002!IAa,\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\u0015\u00055$\u0011\u0017BZ\u0005o\u0013I\f\u0003\u0005\u0003|\t-\u0006\u0019AA\b\u0011!\u0011)La+A\u0002\u0005u\u0013A\u00039s_\u0012,8-\u001a:JI\"Q!\u0011\u0015BV!\u0003\u0005\rAa%\t\u0013\tm&1\u0016I\u0001\u0002\u0004A\u0012A\u0003;y]RKW.Z8vi\"9!q\u0018\u0001\u0005\n\t\u0005\u0017!\u00049sKB\f'/\u001a+y]2{w\r\u0006\u0005\u0002z\t\r'Q\u0019Be\u0011\u00191#Q\u0018a\u0001Q!A!q\u0019B_\u0001\u0004\ti&A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002\u0003Bf\u0005{\u0003\rA!4\u0002\u000fI,7m\u001c:egB\u0019QIa4\n\u0007\tEgIA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0005+\u0004A\u0011\u0002Bl\u0003i\u0001(/\u001a9be\u00164uN\u001d+y]6+7o]1hK\u0006\u0003\b/\u001a8e)\u0011\tIH!7\t\u0011\t5%1\u001ba\u0001\u0003;C\u0011B!8\u0001#\u0003%IAa8\u0002;Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"A!9+\t\tM%1]\u0016\u0003\u0005K\u0004BAa:\u0003r6\u0011!\u0011\u001e\u0006\u0005\u0005W\u0014i/A\u0005v]\u000eDWmY6fI*\u0019!q\u001e\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003t\n%(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u001f\u0001\u0012\u0002\u0013%!\u0011`\u0001\u001eiJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1 \u0016\u00041\t\r\b")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkUtils(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata2()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$1 -> TestUtils$.MODULE$.fail(this.transactionalId1() + "'s transaction state is already in the cache"));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$2 -> TestUtils$.MODULE$.fail(this.transactionalId2() + "'s transaction state is already in the cache"));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(x$3, x$4, x$5, x$6, x$7) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(x$3, BoxesRunTime.unboxToInt((Object)x$4), x$5, x$6, x$7);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> TestUtils$.MODULE$.fail(this.transactionalId1() + "'s transaction state access returns error " + err), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail(this.transactionalId1() + "'s transaction state was not loaded into the cache")));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> TestUtils$.MODULE$.fail(this.transactionalId1() + "'s transaction state access returns error " + err), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail(this.transactionalId1() + "'s transaction state was not loaded into the cache")));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> TestUtils$.MODULE$.fail(this.transactionalId2() + "'s transaction state access returns error " + err), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail(this.transactionalId2() + "'s transaction state was not loaded into the cache")));
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> TestUtils$.MODULE$.fail(this.transactionalId1() + "'s transaction state is still in the cache"));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$9 -> TestUtils$.MODULE$.fail(this.transactionalId2() + "'s transaction state is still in the cache"));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_FOR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$10)));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$11 -> TestUtils$.MODULE$.fail(this.transactionalId1() + "'s transaction state is already in the cache"));
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists("ongoing", this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("not-expiring", this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists("prepare-commit", this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("prepare-abort", this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-commit", this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-abort", this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0)})), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommmitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExist(this.transactionalId1());
        this.verifyMetadataDoesExist(this.transactionalId2());
    }

    private void verifyMetadataDoesExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw TestUtils$.MODULE$.fail("shouldn't have been any errors");
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                throw TestUtils$.MODULE$.fail("metadata should have been removed");
            }
        }
        if (!bl || !((option = (Option)right.value()) instanceof Some)) {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw TestUtils$.MODULE$.fail("shouldn't have been any errors");
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                throw TestUtils$.MODULE$.fail("metadata should have been removed");
            }
        }
        if (!bl || !None$.MODULE$.equals(option = (Option)right.value())) {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        BoxedUnit boxedUnit;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        Capture capturedArgument = EasyMock.newCapture();
        TopicPartition partition = new TopicPartition("__transaction_state", this.transactionManager().partitionFor(this.transactionalId1()));
        Map recordsByPartition = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds() + (long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null)}))}));
        TransactionState transactionState = txnState;
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        if (bl) {
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.eq((Object)recordsByPartition), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.eq((Object)None$.MODULE$));
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, error, capturedArgument, partition){
                private final Errors error$2;
                private final Capture capturedArgument$1;
                private final TopicPartition partition$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$1), (Object)new ProduceResponse.PartitionResponse(this.error$2, 0L, -1L))})));
                }
                {
                    this.error$2 = error$2;
                    this.capturedArgument$1 = capturedArgument$1;
                    this.partition$1 = partition$1;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId2(), this.txnMetadata2());
        this.transactionManager().enableTransactionalIdExpiration();
        this.time().sleep((long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)fileRecordsMock.readInto((ByteBuffer)EasyMock.anyObject(ByteBuffer.class), EasyMock.anyInt())).andReturn((Object)records.buffer());
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument){
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedArgument$2;

            public void answer() {
                ((Function1)this.capturedArgument$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", this.$outer.partitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedArgument$2 = capturedArgument$2;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(String x$3, int x$4, TransactionResult x$5, TransactionMetadata x$6, TxnTransitMetadata x$7) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$10) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private static final void rememberTxnMarkers$1(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = transactionalId;
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkUtils().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, this.zkUtils(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

