/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.BrokerTopicStats;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf!B\u0001\u0003\u0003\u00039!!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\rawn\u001a\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\n)\u0001\u0001\r\u00111A\u0005\u0002U\tqa\u00197fC:,'/F\u0001\u0017!\t\u0011r#\u0003\u0002\u0019\u0005\tQAj\\4DY\u0016\fg.\u001a:\t\u0013i\u0001\u0001\u0019!a\u0001\n\u0003Y\u0012aC2mK\u0006tWM]0%KF$\"\u0001H\u0010\u0011\u0005%i\u0012B\u0001\u0010\u000b\u0005\u0011)f.\u001b;\t\u000f\u0001J\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\t\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019G.Z1oKJ\u0004\u0003b\u0002\u0013\u0001\u0005\u0004%\t!J\u0001\u0007Y><G)\u001b:\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u0005%|'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012AAR5mK\"1q\u0006\u0001Q\u0001\n\u0019\nq\u0001\\8h\t&\u0014\b\u0005C\u00042\u0001\t\u0007I\u0011\u0002\u001a\u0002\t1|wm]\u000b\u0002gA\u0019A'O\u001e\u000e\u0003UR!AN\u001c\u0002\u000f5,H/\u00192mK*\u0011\u0001HC\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001e6\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0003%qJ!!\u0010\u0002\u0003\u00071{w\r\u0003\u0004@\u0001\u0001\u0006IaM\u0001\u0006Y><7\u000f\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003U!WMZ1vYRl\u0015\r_'fgN\fw-Z*ju\u0016,\u0012a\u0011\t\u0003\u0013\u0011K!!\u0012\u0006\u0003\u0007%sG\u000f\u0003\u0004H\u0001\u0001\u0006IaQ\u0001\u0017I\u00164\u0017-\u001e7u\u001b\u0006DX*Z:tC\u001e,7+\u001b>fA!9\u0011\n\u0001b\u0001\n\u0013Q\u0015!\b3fM\u0006,H\u000e^'j]\u000ecW-\u00198bE2,G)\u001b:usJ\u000bG/[8\u0016\u0003-\u0003\"!\u0003'\n\u00055S!!\u0002$m_\u0006$\bBB(\u0001A\u0003%1*\u0001\u0010eK\u001a\fW\u000f\u001c;NS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5pA!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001\u00063fM\u0006,H\u000e^\"p[B\f7\r^5p]2\u000bw-F\u0001T!\tIA+\u0003\u0002V\u0015\t!Aj\u001c8h\u0011\u00199\u0006\u0001)A\u0005'\u0006)B-\u001a4bk2$8i\\7qC\u000e$\u0018n\u001c8MC\u001e\u0004\u0003bB-\u0001\u0005\u0004%IAQ\u0001\u0013I\u00164\u0017-\u001e7u\t\u0016dW\r^3EK2\f\u0017\u0010\u0003\u0004\\\u0001\u0001\u0006IaQ\u0001\u0014I\u00164\u0017-\u001e7u\t\u0016dW\r^3EK2\f\u0017\u0010\t\u0005\b;\u0002\u0011\r\u0011\"\u0003C\u0003I!WMZ1vYR\u001cVmZ7f]R\u001c\u0016N_3\t\r}\u0003\u0001\u0015!\u0003D\u0003M!WMZ1vYR\u001cVmZ7f]R\u001c\u0016N_3!\u0011\u0015\t\u0007A\"\u0001c\u0003\u0011!\u0018.\\3\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005!,'\u0001C'pG.$\u0016.\\3\t\u000b)\u0004A\u0011A6\u0002\u0011Q,\u0017M\u001d3po:$\u0012\u0001\b\u0015\u0003S6\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\u000b),h.\u001b;\u000b\u0003I\f1a\u001c:h\u0013\t!xNA\u0003BMR,'\u000fC\u0003w\u0001\u0011\u0005q/A\nm_\u001e\u001cuN\u001c4jOB\u0013x\u000e]3si&,7\u000f\u0006\u0007y}\u0006\u0005\u0011QAA\u0005\u0003\u001b\t\t\u0002\u0005\u0002zy6\t!P\u0003\u0002|U\u0005!Q\u000f^5m\u0013\ti(P\u0001\u0006Qe>\u0004XM\u001d;jKNDqa`;\u0011\u0002\u0003\u0007\u00010A\tqe>\u0004XM\u001d;z\u001fZ,'O]5eKNDa!a\u0001v\u0001\u0004\u0019\u0015AD7bq6+7o]1hKNK'0\u001a\u0005\t\u0003\u000f)\b\u0013!a\u0001\u0017\u00061R.\u001b8DY\u0016\fg.\u00192mK\u0012K'\u000f^=SCRLw\u000e\u0003\u0005\u0002\fU\u0004\n\u00111\u0001T\u00035\u0019w.\u001c9bGRLwN\u001c'bO\"A\u0011qB;\u0011\u0002\u0003\u00071)A\u0006eK2,G/\u001a#fY\u0006L\b\u0002CA\nkB\u0005\t\u0019A\"\u0002\u0017M,w-\\3oiNK'0\u001a\u0005\b\u0003/\u0001A\u0011AA\r\u0003-i\u0017m[3DY\u0016\fg.\u001a:\u0015'Y\tY\"!\u0013\u0002L\u0005=\u00131KA+\u0003/\nI&a\u0017\t\u0011\u0005u\u0011Q\u0003a\u0001\u0003?\t!\u0002]1si&$\u0018n\u001c8t!\u0019\t\t#!\r\u000289!\u00111EA\u0017\u001d\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015\r\u00051AH]8pizJ\u0011aC\u0005\u0004\u0003_Q\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003g\t)D\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tyC\u0003\t\u0005\u0003s\t)%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0019\u0019w.\\7p]*\u0019Q!!\u0011\u000b\u0007\u0005\r\u0013/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u000f\nYD\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0013\u0005\u001d\u0011Q\u0003I\u0001\u0002\u0004Y\u0005\"CA'\u0003+\u0001\n\u00111\u0001D\u0003)qW/\u001c+ie\u0016\fGm\u001d\u0005\n\u0003#\n)\u0002%AA\u0002M\u000b\u0011BY1dW>3g-T:\t\u0013\u0005\r\u0011Q\u0003I\u0001\u0002\u0004\u0019\u0005\"CA\u0006\u0003+\u0001\n\u00111\u0001T\u0011%\ty!!\u0006\u0011\u0002\u0003\u00071\tC\u0005\u0002\u0014\u0005U\u0001\u0013!a\u0001\u0007\"Aq0!\u0006\u0011\u0002\u0003\u0007\u0001\u0010C\u0005\u0002`\u0001\t\n\u0011\"\u0001\u0002b\u0005iBn\\4D_:4\u0017n\u001a)s_B,'\u000f^5fg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002d)\u001a\u00010!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001d\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u001f\u0001#\u0003%\t!a\u001f\u0002;1|wmQ8oM&<\u0007K]8qKJ$\u0018.Z:%I\u00164\u0017-\u001e7uIM*\"!! +\u0007-\u000b)\u0007C\u0005\u0002\u0002\u0002\t\n\u0011\"\u0001\u0002\u0004\u0006iBn\\4D_:4\u0017n\u001a)s_B,'\u000f^5fg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0006*\u001a1+!\u001a\t\u0013\u0005%\u0005!%A\u0005\u0002\u0005-\u0015!\b7pO\u000e{gNZ5h!J|\u0007/\u001a:uS\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u00055%fA\"\u0002f!I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111R\u0001\u001eY><7i\u001c8gS\u001e\u0004&o\u001c9feRLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%m!I\u0011Q\u0013\u0001\u0012\u0002\u0013\u0005\u00111P\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011%\tI\nAI\u0001\n\u0003\tY)A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005u\u0005!%A\u0005\u0002\u0005\r\u0015!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003C\u0003\u0011\u0013!C\u0001\u0003\u0017\u000bQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$S\u0007C\u0005\u0002&\u0002\t\n\u0011\"\u0001\u0002\u0004\u0006)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u00122\u0004\"CAU\u0001E\u0005I\u0011AAF\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uI]B\u0011\"!,\u0001#\u0003%\t!a#\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%q!I\u0011\u0011\u0017\u0001\u0012\u0002\u0013\u0005\u0011\u0011M\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:\u0001")
public abstract class AbstractLogCleanerIntegrationTest {
    private LogCleaner cleaner;
    private final File logDir = TestUtils$.MODULE$.tempDir();
    private final ListBuffer<Log> logs = (ListBuffer)ListBuffer$.MODULE$.empty();
    private final int defaultMaxMessageSize;
    private final float defaultMinCleanableDirtyRatio;
    private final long defaultCompactionLag;
    private final int defaultDeleteDelay;
    private final int defaultSegmentSize;

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    private ListBuffer<Log> logs() {
        return this.logs;
    }

    private int defaultMaxMessageSize() {
        return this.defaultMaxMessageSize;
    }

    private float defaultMinCleanableDirtyRatio() {
        return this.defaultMinCleanableDirtyRatio;
    }

    private long defaultCompactionLag() {
        return this.defaultCompactionLag;
    }

    private int defaultDeleteDelay() {
        return this.defaultDeleteDelay;
    }

    private int defaultSegmentSize() {
        return this.defaultSegmentSize;
    }

    public abstract MockTime time();

    @After
    public void teardown() {
        if (this.cleaner() != null) {
            this.cleaner().shutdown();
        }
        this.time().scheduler().shutdown();
        this.logs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    public Properties logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio, long compactionLag, int deleteDelay, int segmentSize) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        props.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(102400));
        props.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(deleteDelay));
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.long2Long(compactionLag));
        props.putAll((Map<?, ?>)propertyOverrides);
        return props;
    }

    public Properties logConfigProperties$default$1() {
        return new Properties();
    }

    public float logConfigProperties$default$3() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public long logConfigProperties$default$4() {
        return this.defaultCompactionLag();
    }

    public int logConfigProperties$default$5() {
        return this.defaultDeleteDelay();
    }

    public int logConfigProperties$default$6() {
        return this.defaultSegmentSize();
    }

    public LogCleaner makeCleaner(Iterable<TopicPartition> partitions, float minCleanableDirtyRatio, int numThreads, long backOffMs, int maxMessageSize, long compactionLag, int deleteDelay, int segmentSize, Properties propertyOverrides) {
        Pool logMap = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            File dir = new File(this.logDir(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition.topic(), BoxesRunTime.boxToInteger((int)partition.partition())})));
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            LogConfig logConfig = new LogConfig((Map)this.logConfigProperties(propertyOverrides, maxMessageSize, minCleanableDirtyRatio, compactionLag, deleteDelay, segmentSize));
            File x$2 = dir;
            LogConfig x$3 = logConfig;
            long x$4 = 0L;
            long x$5 = 0L;
            MockScheduler x$6 = this.time().scheduler();
            MockTime x$7 = this.time();
            BrokerTopicStats x$8 = new BrokerTopicStats();
            int x$9 = Log$.MODULE$.apply$default$8();
            int x$10 = Log$.MODULE$.apply$default$9();
            Log log = Log$.MODULE$.apply(x$2, x$3, x$4, x$5, (Scheduler)x$6, x$8, (Time)x$7, x$9, x$10);
            logMap.put(partition, (Object)log);
            return this.logs().$plus$eq((Object)log);
        });
        int x$11 = numThreads;
        int x$12 = maxMessageSize / 2;
        int x$13 = maxMessageSize;
        long x$14 = backOffMs;
        long x$15 = CleanerConfig$.MODULE$.apply$default$2();
        double x$16 = CleanerConfig$.MODULE$.apply$default$3();
        double x$17 = CleanerConfig$.MODULE$.apply$default$6();
        boolean x$18 = CleanerConfig$.MODULE$.apply$default$8();
        String x$19 = CleanerConfig$.MODULE$.apply$default$9();
        CleanerConfig cleanerConfig = new CleanerConfig(x$11, x$15, x$16, x$12, x$13, x$17, x$14, x$18, x$19);
        return new LogCleaner(cleanerConfig, (File[])((Object[])new File[]{this.logDir()}), logMap, (Time)this.time());
    }

    public float makeCleaner$default$2() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public long makeCleaner$default$4() {
        return 15000L;
    }

    public int makeCleaner$default$5() {
        return this.defaultMaxMessageSize();
    }

    public long makeCleaner$default$6() {
        return this.defaultCompactionLag();
    }

    public int makeCleaner$default$7() {
        return this.defaultDeleteDelay();
    }

    public int makeCleaner$default$8() {
        return this.defaultSegmentSize();
    }

    public Properties makeCleaner$default$9() {
        return new Properties();
    }

    public AbstractLogCleanerIntegrationTest() {
        this.defaultMaxMessageSize = 128;
        this.defaultMinCleanableDirtyRatio = 0.0f;
        this.defaultCompactionLag = 0L;
        this.defaultDeleteDelay = 1000;
        this.defaultSegmentSize = 256;
    }
}

