/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.LogSegment;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004T8h\u00072,\u0017M\\3s\u0019\u0006<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0015G>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3\u0011\u0005UqbB\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\tIb!\u0001\u0004=e>|GO\u0010\u0006\u00027\u0005)1oY1mC&\u0011QDG\u0001\u0007!J,G-\u001a4\n\u0005}\u0001#AB*ue&twM\u0003\u0002\u001e5!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005%\u0001\u0001\"B\n\"\u0001\u0004!\u0002bB\u0014\u0001\u0005\u0004%\t\u0001K\u0001\n[N\u0004VM\u001d%pkJ,\u0012!\u000b\t\u0003U-j\u0011AG\u0005\u0003Yi\u00111!\u00138u\u0011\u0019q\u0003\u0001)A\u0005S\u0005QQn\u001d)fe\"{WO\u001d\u0011\t\u000fA\u0002!\u0019!C\u0001Q\u0005i1m\\7qC\u000e$\u0018n\u001c8MC\u001eDaA\r\u0001!\u0002\u0013I\u0013AD2p[B\f7\r^5p]2\u000bw\r\t\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0003\u0011!\u0018.\\3\u0016\u0003Y\u0002\"!D\u001c\n\u0005ar!\u0001C'pG.$\u0016.\\3\t\ri\u0002\u0001\u0015!\u00037\u0003\u0015!\u0018.\\3!\u0011\u001da\u0004A1A\u0005\u0002u\n\u0001c\u00197fC:,'OQ1dW>3g-T:\u0016\u0003y\u0002\"AK \n\u0005\u0001S\"\u0001\u0002'p]\u001eDaA\u0011\u0001!\u0002\u0013q\u0014!E2mK\u0006tWM\u001d\"bG.|eMZ'tA!9A\t\u0001b\u0001\n\u0003A\u0013aC:fO6,g\u000e^*ju\u0016DaA\u0012\u0001!\u0002\u0013I\u0013\u0001D:fO6,g\u000e^*ju\u0016\u0004\u0003b\u0002%\u0001\u0001\u0004%\t\u0001K\u0001\bG>,h\u000e^3s\u0011\u001dQ\u0005\u00011A\u0005\u0002-\u000b1bY8v]R,'o\u0018\u0013fcR\u0011Aj\u0014\t\u0003U5K!A\u0014\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b!&\u000b\t\u00111\u0001*\u0003\rAH%\r\u0005\u0007%\u0002\u0001\u000b\u0015B\u0015\u0002\u0011\r|WO\u001c;fe\u0002Bq\u0001\u0016\u0001C\u0002\u0013\u0005Q+A\bu_BL7\rU1si&$\u0018n\u001c8t+\u00051\u0006c\u0001\u0016X3&\u0011\u0001L\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00035\nl\u0011a\u0017\u0006\u00039v\u000baaY8n[>t'BA\u0003_\u0015\ty\u0006-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0006\u0019qN]4\n\u0005\r\\&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007K\u0002\u0001\u000b\u0011\u0002,\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0003bB4\u0001\u0005\u0004%\t\u0001[\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Yn\u000baA]3d_J$\u0017B\u00018l\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007B\u00029\u0001A\u0003%\u0011.A\td_6\u0004(/Z:tS>t7i\u001c3fG\u0002BQA\u001d\u0001\u0005\u0002M\f1b\u00197fC:,'\u000fV3tiR\tA\n\u000b\u0002rkB\u0011a/_\u0007\u0002o*\u0011\u0001\u0010Y\u0001\u0006UVt\u0017\u000e^\u0005\u0003u^\u0014A\u0001V3ti\")A\u0010\u0001C\u0005{\u0006Y!/Z1e\rJ|W\u000eT8h)\rq\u0018q\u0002\t\u0006\u007f\u0006\u0015\u0011\u0011B\u0007\u0003\u0003\u0003Q1!a\u0001\u001b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\t\tA\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0015Q\u00131B\u0015*\u0013\r\tiA\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\r\rY\b\u0019AA\t!\rI\u00111C\u0005\u0004\u0003+\u0011!a\u0001'pO\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011!C<sSR,G)\u001e9t)1\ti\"a\t\u0002(\u0005-\u0012QFA\u0019!\u0015y\u0018qDA\u0005\u0013\u0011\t\t#!\u0001\u0003\u0007M+\u0017\u000fC\u0004\u0002&\u0005]\u0001\u0019A\u0015\u0002\u000f9,XnS3zg\"9\u0011\u0011FA\f\u0001\u0004I\u0013a\u00028v[\u0012+\bo\u001d\u0005\b\u0007\u0005]\u0001\u0019AA\t\u0011\u001d\ty#a\u0006A\u0002%\fQaY8eK\u000eDq!a\r\u0002\u0018\u0001\u0007a(A\u0005uS6,7\u000f^1na\":\u0001!a\u000e\u0002D\u0005\u0015\u0003\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ur/\u0001\u0004sk:tWM]\u0005\u0005\u0003\u0003\nYDA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055s/A\u0004sk:tWM]:\n\t\u0005E\u00131\n\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\u0005U#\u0001#\u0001\u0002X\u0005aBj\\4DY\u0016\fg.\u001a:MC\u001eLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bcA\u0005\u0002Z\u00191\u0011A\u0001E\u0001\u00037\u001aB!!\u0017\u0002^A\u0019!&a\u0018\n\u0007\u0005\u0005$D\u0001\u0004B]f\u0014VM\u001a\u0005\bE\u0005eC\u0011AA3)\t\t9\u0006\u0003\u0005\u0002j\u0005eC\u0011AA6\u00031yg.\u001a)be\u0006lW\r^3s+\t\ti\u0007\u0005\u0004\u0002p\u0005e\u0014QP\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!Q\u000f^5m\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA>\u0003c\u0012!bQ8mY\u0016\u001cG/[8o!\rQs\u000b\u0006\u0005\t\u0003\u0003\u000bI\u0006\"\u0001\u0002l\u0005Q\u0001/\u0019:b[\u0016$XM]:)\t\u0005}\u0014Q\u0011\t\u0005\u0003\u000f\u000bIJ\u0004\u0003\u0002\n\u0006Ue\u0002BAF\u0003'sA!!$\u0002\u0012:\u0019q#a$\n\u0003\u0005L!\u0001\u001f1\n\u0007\u00055s/\u0003\u0003\u0002\u0018\u0006-\u0013!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002\u001c\u0006u%A\u0003)be\u0006lW\r^3sg*!\u0011qSA&\u0001")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final int msPerHour;
    private final int compactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private int counter;
    private final TopicPartition[] topicPartitions;
    private final CompressionType compressionCodec;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.trace$((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.debug$((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.info$((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.warn$((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.error$((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerLagIntegrationTest logCleanerLagIntegrationTest = this;
        synchronized (logCleanerLagIntegrationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int compactionLag() {
        return this.compactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    public CompressionType compressionCodec() {
        return this.compressionCodec;
    }

    @Test
    public void cleanerTest() {
        WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$4 = this.cleanerBackOffMs();
        long x$5 = this.compactionLag();
        int x$6 = this.segmentSize();
        float x$7 = this.makeCleaner$default$2();
        int x$8 = this.makeCleaner$default$3();
        int x$9 = this.makeCleaner$default$5();
        int x$10 = this.makeCleaner$default$7();
        Properties x$11 = this.makeCleaner$default$9();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$3, x$7, x$8, x$4, x$9, x$5, x$10, x$6, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log, this.compressionCodec(), T0);
        long startSizeBlock0 = log.size();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total log size at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSizeBlock0)})));
        LogSegment activeSegAtT0 = log.activeSegment();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"active segment at T0 has base offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)activeSegAtT0.baseOffset())})));
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log size up to base offset of active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sizeUpToActiveSegmentAtT0)})));
        this.cleaner().startup();
        this.time().sleep(this.compactionLag() / 2);
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assert.assertEquals((String)"There should be no cleaning until the compaction lag has passed", (long)startSizeBlock0, (long)log.size());
        this.time().sleep(this.compactionLag() / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log, this.compressionCodec(), T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$13 = activeSegAtT0.baseOffset();
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, x$13, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends1.toMap(Predef$.MODULE$.$conforms()), (Object)read1.toMap(Predef$.MODULE$.$conforms()));
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after cleaning the compacted size up to active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)compactedSize)})));
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstBlock1SegmentBaseOffset), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: size up to offset of active segment at T0=", " compacted size=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sizeUpToActiveSegmentAtT0), BoxesRunTime.boxToInteger((int)compactedSize)})), (sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerLagIntegrationTest.$anonfun$writeDups$1(this, numKeys, log, codec, timestamp, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(LogCleanerLagIntegrationTest $this, Log log$1, CompressionType codec$1, long timestamp$1, int key) {
        int count = $this.counter();
        byte[] x$15 = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString().getBytes();
        CompressionType x$16 = codec$1;
        byte[] x$17 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        long x$18 = timestamp$1;
        byte x$19 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$15, x$17, x$16, x$18, x$19), 0, log$1.appendAsLeader$default$3());
        $this.counter_$eq($this.counter() + 1);
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(LogCleanerLagIntegrationTest $this, int numKeys$1, Log log$1, CompressionType codec$1, long timestamp$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerLagIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, timestamp$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerLagIntegrationTest(String compressionCodecName) {
        Logging.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.compactionLag = 1 * this.msPerHour();
        Assert.assertTrue((String)"compactionLag must be divisible by 2 for this test", (this.compactionLag() % 2 == 0 ? 1 : 0) != 0);
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.counter = 0;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        this.compressionCodec = CompressionType.forName((String)compressionCodecName);
    }
}

