/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.server.BrokerTopicStats;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000bq\u0004^3ti\u0012+\b\u000f\\5dCR,7\t[3dW\u00063G/\u001a:DY\u0016\fg.\u001b8hQ\t\u0019\u0007\rC\u0003h\u0001\u0011\u0005\u0001+A\u0011uKN$()Y:jGR\u0013\u0018M\\:bGRLwN\\!xCJ,7\t\\3b]&tw\r\u000b\u0002gA\")!\u000e\u0001C\u0001!\u0006IC/Z:u\u00072,\u0017M\\,ji\"$&/\u00198tC\u000e$\u0018n\u001c8t'B\fgN\\5oON+w-\\3oiND#!\u001b1\t\u000b5\u0004A\u0011\u0001)\u0002/Q,7\u000f^\"p[6LG/T1sW\u0016\u0014(+Z7pm\u0006d\u0007F\u00017a\u0011\u0015\u0001\b\u0001\"\u0001Q\u0003Y!Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+Z7pm\u0006d\u0007FA8a\u0011\u0015\u0019\b\u0001\"\u0001Q\u0003A!Xm\u001d;MCJ<W-T3tg\u0006<W\r\u000b\u0002sA\")a\u000f\u0001C\u0001!\u00069B/Z:u\u00072,\u0017M\\5oO^KG\u000f\u001b#fY\u0016$Xm\u001d\u0015\u0003k\u0002DQ!\u001f\u0001\u0005\u0002A\u000b1\u0003^3ti2{wm\u00117fC:,'o\u0015;biNDQa\u001f\u0001\u0005\u0002A\u000b\u0011\u0006^3ti2{wm\u00117fC:,'OU3uC&t7\u000f\u0015:pIV\u001cWM\u001d'bgR\u001cV-];f]\u000e,\u0007F\u0001>a\u0011\u0015q\b\u0001\"\u0001Q\u0003e\"Xm\u001d;M_\u001e\u001cE.Z1oKJ\u0014V\r^1j]Nd\u0015m\u001d;TKF,XM\\2f\u000bZ,g.\u00134Ue\u0006t7/Y2uS>t\u0017IY8si\u0016$\u0007FA?a\u0011\u0019\t\u0019\u0001\u0001C\u0001!\u00069B/Z:u!\u0006\u0014H/[1m'\u0016<W.\u001a8u\u00072,\u0017M\u001c\u0015\u0004\u0003\u0003\u0001\u0007BBA\u0005\u0001\u0011\u0005\u0001+\u0001\u0012uKN$8\t\\3b]&twmV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0004\u0003\u000f\u0001\u0007BBA\b\u0001\u0011\u0005\u0001+\u0001\buKN$Hj\\4U_\u000ecW-\u00198)\u0007\u00055\u0001\r\u0003\u0004\u0002\u0016\u0001!\t\u0001U\u0001%i\u0016\u001cH\u000fT8h)>\u001cE.Z1o/&$\b.\u00168dY\u0016\fg.\u00192mKN+7\r^5p]\"\u001a\u00111\u00031\t\r\u0005m\u0001\u0001\"\u0001Q\u0003}!Xm\u001d;DY\u0016\fg.\u001b8h/&$\b.\u00168lKf,G-T3tg\u0006<Wm\u001d\u0015\u0004\u00033\u0001\u0007bBA\u0011\u0001\u0011\u0005\u00111E\u0001\nW\u0016L8/\u00138M_\u001e$B!!\n\u00028A1\u0011qEA\u0017\u0003ci!!!\u000b\u000b\u0007\u0005-2+\u0001\u0006d_2dWm\u0019;j_:LA!a\f\u0002*\tA\u0011\n^3sC\ndW\rE\u0002S\u0003gI1!!\u000eT\u0005\rIe\u000e\u001e\u0005\b\u0007\u0005}\u0001\u0019AA\u001d!\r1\u00121H\u0005\u0004\u0003{\u0011!a\u0001'pO\"9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0013\u0001D8gMN,Go]%o\u0019><G\u0003BA#\u0003\u001b\u0002b!a\n\u0002.\u0005\u001d\u0003c\u0001*\u0002J%\u0019\u00111J*\u0003\t1{gn\u001a\u0005\b\u0007\u0005}\u0002\u0019AA\u001d\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'\n\u0001$\u001e8lKf,G-T3tg\u0006<WmQ8v]RLe\u000eT8h)\u0011\t\t$!\u0016\t\u000f\r\ty\u00051\u0001\u0002:!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013AD1c_J$8\t[3dW\u0012{g.\u001a\u000b\u0004#\u0006u\u0003\u0002CA0\u0003/\u0002\r!!\u0019\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u00111MA8\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014AB2p[6|gNC\u0002\u0006\u0003WR1!!\u001c\u000f\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011OA3\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!\u001e\u0001\t\u0003\u0001\u0016A\u0007;fgR\u001cE.Z1o'\u0016<W.\u001a8ug^KG\u000f[!c_J$\bfAA:A\"1\u00111\u0010\u0001\u0005\u0002A\u000b1\u0003^3tiN+w-\\3oi\u001e\u0013x.\u001e9j]\u001eD3!!\u001fa\u0011\u0019\t\t\t\u0001C\u0001!\u0006!C/Z:u'\u0016<W.\u001a8u\u000fJ|W\u000f]5oO^KG\u000f[*qCJ\u001cXm\u00144gg\u0016$8\u000fK\u0002\u0002\u0000\u0001Da!a\"\u0001\t\u0003\u0001\u0016a\u000b;fgR\u001cVmZ7f]R<%o\\;qS:<gi\u001c7m_^Lgn\u001a'pC\u0012|eMW3s_&sG-\u001a=)\u0007\u0005\u0015\u0005\rC\u0004\u0002\u000e\u0002!I!a$\u0002#\rDWmY6TK\u001elWM\u001c;Pe\u0012,'\u000fF\u0002R\u0003#C\u0001\"a%\u0002\f\u0002\u0007\u0011QS\u0001\u0007OJ|W\u000f]:\u0011\r\u0005\u001d\u0012qSAN\u0013\u0011\tI*!\u000b\u0003\u0007M+\u0017\u000f\u0005\u0004\u0002(\u0005]\u0015Q\u0014\t\u0004-\u0005}\u0015bAAQ\u0005\tQAj\\4TK\u001elWM\u001c;\t\r\u0005\u0015\u0006\u0001\"\u0001Q\u0003I!Xm\u001d;Ck&dGm\u00144gg\u0016$X*\u00199)\u0007\u0005\r\u0006\r\u0003\u0004\u0002,\u0002!\t\u0001U\u0001\u0017i\u0016\u001cHOU3d_Z,'/_!gi\u0016\u00148I]1tQ\"\u001a\u0011\u0011\u00161\t\r\u0005E\u0006\u0001\"\u0001Q\u0003m!Xm\u001d;Ck&dGm\u00144gg\u0016$X*\u00199GC.,G*\u0019:hK\"\u001a\u0011q\u00161\t\r\u0005]\u0006\u0001\"\u0001Q\u0003e!Xm\u001d;Ck&dG\rU1si&\fGn\u00144gg\u0016$X*\u00199)\u0007\u0005U\u0006\r\u0003\u0004\u0002>\u0002!\t\u0001U\u0001\u001bi\u0016\u001cHo\u00117fC:\u001cuN\u001d:vaRlUm]:bO\u0016\u001cV\r\u001e\u0015\u0004\u0003w\u0003\u0007BBAb\u0001\u0011\u0005\u0001+A\u0013uKN$8\t\\5f]RD\u0015M\u001c3mS:<wJZ\"peJ,\b\u000f^'fgN\fw-Z*fi\"\u001a\u0011\u0011\u00191\t\r\u0005%\u0007\u0001\"\u0001Q\u0003I!Xm\u001d;DY\u0016\fg\u000eV8nEN$xN\\3)\u0007\u0005\u001d\u0007\rC\u0004\u0002P\u0002!I!!5\u0002\u0015]\u0014\u0018\u000e^3U_2{w\r\u0006\u0005\u0002F\u0005M\u0017Q[Aq\u0011\u001d\u0019\u0011Q\u001aa\u0001\u0003sA\u0001\"a6\u0002N\u0002\u0007\u0011\u0011\\\u0001\u000eW\u0016L8/\u00118e-\u0006dW/Z:\u0011\r\u0005\u001d\u0012QFAn!\u001d\u0011\u0016Q\\A\u0019\u0003cI1!a8T\u0005\u0019!V\u000f\u001d7fe!A\u00111]Ag\u0001\u0004\t)%A\u0005pM\u001a\u001cX\r^*fc\"9\u0011q\u001d\u0001\u0005\n\u0005%\u0018!F5om\u0006d\u0017\u000eZ\"mK\u0006tW\rZ'fgN\fw-\u001a\u000b\t\u0003W\f90a?\u0002~B!\u0011Q^Az\u001b\t\tyO\u0003\u0003\u0002r\u0006\u0015\u0014A\u0002:fG>\u0014H-\u0003\u0003\u0002v\u0006=(!D'f[>\u0014\u0018PU3d_J$7\u000f\u0003\u0005\u0002z\u0006\u0015\b\u0019AA$\u00035Ig.\u001b;jC2|eMZ:fi\"A\u0011q[As\u0001\u0004\tI\u000e\u0003\u0006\u0002\u0000\u0006\u0015\b\u0013!a\u0001\u0005\u0003\tQaY8eK\u000e\u0004B!!<\u0003\u0004%!!QAAx\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007b\u0002B\u0005\u0001\u0011%!1B\u0001\u0012[\u0016\u001c8/Y4f/&$\bn\u00144gg\u0016$H\u0003CAv\u0005\u001b\u0011iB!\t\t\u0011\t=!q\u0001a\u0001\u0005#\t1a[3z!\u0015\u0011&1\u0003B\f\u0013\r\u0011)b\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004%\ne\u0011b\u0001B\u000e'\n!!)\u001f;f\u0011!\u0011yBa\u0002A\u0002\tE\u0011!\u0002<bYV,\u0007\u0002\u0003B\u0012\u0005\u000f\u0001\r!a\u0012\u0002\r=4gm]3u\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005O!\u0002\"a;\u0003*\t-\"Q\u0006\u0005\t\u0005\u001f\u0011)\u00031\u0001\u00022!A!q\u0004B\u0013\u0001\u0004\t\t\u0004\u0003\u0005\u0003$\t\u0015\u0002\u0019AA$\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005g\tq!\\1lK2{w\r\u0006\u0005\u0002:\tU\"q\u0007B\u001e\u0011!)#q\u0006I\u0001\u0002\u0004Q\u0002\"\u0003B\u001d\u0005_\u0001\n\u00111\u00017\u0003\u0019\u0019wN\u001c4jO\"Q!Q\bB\u0018!\u0003\u0005\r!a\u0012\u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007\nQB\\8Pa\u000eCWmY6E_:,GcA)\u0003F!A\u0011q\fB \u0001\u0004\t\t\u0007C\u0004\u0003J\u0001!IAa\u0013\u0002\u00175\f7.Z\"mK\u0006tWM\u001d\u000b\t\u0005\u001b\u0012\u0019Fa\u0016\u0003bA\u0019aCa\u0014\n\u0007\tE#AA\u0004DY\u0016\fg.\u001a:\t\u0011\tU#q\ta\u0001\u0003c\t\u0001bY1qC\u000eLG/\u001f\u0005\u000b\u00053\u00129\u0005%AA\u0002\tm\u0013!C2iK\u000e\\Gi\u001c8f!\u0019\u0011&QLA1#&\u0019!qL*\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0003B2\u0005\u000f\u0002\n\u00111\u0001\u00022\u0005qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007bBAh\u0001\u0011%!q\r\u000b\u0007\u0003\u000b\u0012IGa\u001b\t\u000f\r\u0011)\u00071\u0001\u0002:!A!Q\u000eB3\u0001\u0004\tI.A\u0002tKFDqAa\u0004\u0001\t\u0013\u0011\t\b\u0006\u0003\u0003t\t}\u0004\u0003\u0002B;\u0005wj!Aa\u001e\u000b\u0007\ted$A\u0002oS>LAA! \u0003x\tQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\t\u0005%q\u000ea\u0001\u0003c\t!!\u001b3\t\u000f\u0005E\b\u0001\"\u0003\u0003\u0006Rq\u00111\u001eBD\u0005\u0013\u0013YIa$\u0003\u001a\nu\u0005\u0002\u0003B\b\u0005\u0007\u0003\r!!\r\t\u0011\t}!1\u0011a\u0001\u0003cA!B!$\u0003\u0004B\u0005\t\u0019AA$\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\u000b\u0005#\u0013\u0019\t%AA\u0002\tM\u0015!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002S\u0005+K1Aa&T\u0005\u0015\u0019\u0006n\u001c:u\u0011)\u0011YJa!\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\tg\u0016\fX/\u001a8dK\"Q!q\u0014BB!\u0003\u0005\r!!\r\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005K\u000b1$\u00199qK:$GK]1og\u0006\u001cG/[8oC2\f5\u000fT3bI\u0016\u0014H\u0003\u0003BT\u0005c\u0013\u0019L!.\u0011\u000fI\u0013iF!+\u0003,B1\u0011qEAL\u0003c\u00012A\u0006BW\u0013\r\u0011yK\u0001\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\r\u0011\t\u000b1\u0001\u0002:!A!Q\u0012BQ\u0001\u0004\t9\u0005\u0003\u0006\u0003\u0012\n\u0005\u0006\u0013!a\u0001\u0005'CqA!/\u0001\t\u0013\u0011Y,\u0001\rbaB,g\u000eZ%eK6\u0004x\u000e^3oi\u0006\u001bH*Z1eKJ$\"Ba*\u0003>\n}&\u0011\u0019Bb\u0011\u001d\u0019!q\u0017a\u0001\u0003sA\u0001B!$\u00038\u0002\u0007\u0011q\t\u0005\u000b\u0005#\u00139\f%AA\u0002\tM\u0005B\u0003Bc\u0005o\u0003\n\u00111\u0001\u0003H\u0006y\u0011n\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eE\u0002S\u0005\u0013L1Aa3T\u0005\u001d\u0011un\u001c7fC:DqAa4\u0001\t\u0013\u0011\t.\u0001\u0007d_6l\u0017\u000e^'be.,'\u000f\u0006\u0005\u0002l\nM'Q\u001bBl\u0011!\u0011iI!4A\u0002\u0005\u001d\u0003\u0002\u0003BI\u0005\u001b\u0004\rAa%\t\u0015\te'Q\u001aI\u0001\u0002\u0004\t9%A\u0005uS6,7\u000f^1na\"9!Q\u001c\u0001\u0005\n\t}\u0017aC1c_J$X*\u0019:lKJ$\u0002\"a;\u0003b\n\r(Q\u001d\u0005\t\u0005\u001b\u0013Y\u000e1\u0001\u0002H!A!\u0011\u0013Bn\u0001\u0004\u0011\u0019\n\u0003\u0006\u0003Z\nm\u0007\u0013!a\u0001\u0003\u000fBqA!;\u0001\t\u0013\u0011Y/\u0001\u0007f]\u0012$\u0006P\\'be.,'\u000f\u0006\u0007\u0002l\n5(q\u001eBy\u0005w\u0014i\u0010\u0003\u0005\u0003\u000e\n\u001d\b\u0019AA$\u0011!\u0011\tJa:A\u0002\tM\u0005\u0002\u0003Bz\u0005O\u0004\rA!>\u0002#\r|g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\r\u0005\u0003\u0002n\n]\u0018\u0002\u0002B}\u0003_\u0014\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011!\u0011\u0019Ca:A\u0002\u0005\u001d\u0003\u0002\u0003Bm\u0005O\u0004\r!a\u0012\t\u000f\u0005E\b\u0001\"\u0003\u0004\u0002Q1\u00111^B\u0002\u0007\u000bA\u0001Ba\u0004\u0003\u0000\u0002\u0007\u0011\u0011\u0007\u0005\t\u0005?\u0011y\u00101\u0001\u0003\u0012!91\u0011\u0002\u0001\u0005\n\r-\u0011!D;oW\u0016LX\r\u001a*fG>\u0014H\r\u0006\u0003\u0002l\u000e5\u0001\u0002\u0003B\u0010\u0007\u000f\u0001\r!!\r\t\u000f\rE\u0001\u0001\"\u0003\u0004\u0014\u0005yAo\\7cgR|g.\u001a*fG>\u0014H\r\u0006\u0003\u0002l\u000eU\u0001\u0002\u0003B\b\u0007\u001f\u0001\r!!\r\t\u0013\re\u0001!%A\u0005\n\rm\u0011!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007;QCAa\u0017\u0004 -\u00121\u0011\u0005\t\u0005\u0007G\u0019i#\u0004\u0002\u0004&)!1qEB\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0004,M\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019yc!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00044\u0001\t\n\u0011\"\u0003\u00046\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\u001aTCAB\u001cU\u0011\t\tda\b\t\u0013\rm\u0002!%A\u0005\n\ru\u0012!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\b\u0016\u00045\r}\u0001\"CB\"\u0001E\u0005I\u0011BB#\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0007\u000fR3ANB\u0010\u0011%\u0019Y\u0005AI\u0001\n\u0013\u0019i%A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uIM*\"aa\u0014+\t\u0005\u001d3q\u0004\u0005\n\u0007'\u0002\u0011\u0013!C\u0005\u0007\u001b\n\u0001C]3d_J$G\u0005Z3gCVdG\u000fJ\u001a\t\u0013\r]\u0003!%A\u0005\n\re\u0013\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019YF\u000b\u0003\u0003\u0014\u000e}\u0001\"CB0\u0001E\u0005I\u0011BB\u001b\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$S\u0007C\u0005\u0004d\u0001\t\n\u0011\"\u0003\u00046\u0005\u0001\"/Z2pe\u0012$C-\u001a4bk2$HE\u000e\u0005\n\u0007O\u0002\u0011\u0013!C\u0005\u00073\n!%\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012\u001a\u0004\"CB6\u0001E\u0005I\u0011BB7\u0003\t\n\u0007\u000f]3oI&#W-\u001c9pi\u0016tG/Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u000e\u0016\u0005\u0005\u000f\u001cy\u0002C\u0005\u0004t\u0001\t\n\u0011\"\u0003\u0004Z\u0005)\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u001bH*Z1eKJ$C-\u001a4bk2$He\r\u0005\n\u0007o\u0002\u0011\u0013!C\u0005\u0007\u001b\nQ#\u00192peRl\u0015M]6fe\u0012\"WMZ1vYR$3\u0007C\u0005\u0004|\u0001\t\n\u0011\"\u0003\u0004N\u000512m\\7nSRl\u0015M]6fe\u0012\"WMZ1vYR$3\u0007C\u0005\u0004\u0000\u0001\t\n\u0011\"\u0003\u0004\u0002\u0006y\u0012N\u001c<bY&$7\t\\3b]\u0016$W*Z:tC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\r%\u0006\u0002B\u0001\u0007?\u0001")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$38 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$39 = this.makeLog$default$1();
        long x$40 = this.makeLog$default$3();
        Log log = this.makeLog(x$39, x$38, x$40);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Seq segments = ((TraversableOnce)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, segments, (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> !keys.contains((Object)BoxesRunTime.boxToInteger((int)x$2)));
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$41 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$42 = this.makeLog$default$1();
        long x$43 = this.makeLog$default$3();
        ObjectRef log = ObjectRef.create((Object)this.makeLog(x$42, x$41, x$43));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log.elem;
        long x$44 = qual$1.roll$default$1();
        qual$1.roll(x$44);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 3, 4, 1, 4})), this.keysInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 5, 6, 7})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(logProps, log);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log.elem;
        long x$48 = qual$2.roll$default$1();
        qual$2.roll(x$48);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 3, 4, 1, 4, 2})), this.keysInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 7, 8})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(logProps, log);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$49 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$50 = this.makeLog$default$1();
        long x$51 = this.makeLog$default$3();
        Log log = this.makeLog(x$50, x$49, x$51);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, false);
        List abortedTransactions = log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)abortedTransactions, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$52 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$53 = this.makeLog$default$1();
        long x$54 = this.makeLog$default$3();
        Log log = this.makeLog(x$53, x$52, x$54);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), this.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), this.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$55 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$56 = this.makeLog$default$1();
        long x$57 = this.makeLog$default$3();
        Log log = this.makeLog(x$56, x$55, x$57);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$58 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$59 = this.makeLog$default$1();
        long x$60 = this.makeLog$default$3();
        Log log = this.makeLog(x$59, x$58, x$60);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$61 = Integer.MAX_VALUE;
        int x$62 = 1024;
        Function1<TopicPartition, BoxedUnit> x$63 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$61, x$63, x$62);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$64 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$65 = this.makeLog$default$1();
        long x$66 = this.makeLog$default$3();
        Log log = this.makeLog(x$65, x$64, x$66);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())), 0, log.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log.logSegments().head()})), (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !keys.contains((Object)BoxesRunTime.boxToInteger((int)x$3)));
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$67 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$68 = this.makeLog$default$1();
        long x$69 = this.makeLog$default$3();
        Log log = this.makeLog(x$68, x$67, x$69);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1 & Serializable & scala.Serializable)key -> log.appendAsLeader(this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log.appendAsLeader$default$3()));
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> !keys.contains((Object)BoxesRunTime.boxToInteger((int)x$4))));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$70 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$71 = this.makeLog$default$1();
        long x$72 = this.makeLog$default$3();
        Log log = this.makeLog(x$71, x$70, x$72);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
        Tuple2 tuple23 = tuple22;
        long endOffset2 = tuple23._1$mcJ$sp();
        CleanerStats stats2 = (CleanerStats)tuple23._2();
        Assert.assertEquals((long)5L, (long)endOffset2);
        Assert.assertEquals((long)5L, (long)stats2.messagesRead());
        Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
        Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
        Assert.assertEquals((long)log.size(), (long)stats2.bytesWritten());
        Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
        Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$73 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$74 = this.makeLog$default$1();
        long x$75 = this.makeLog$default$3();
        Log log = this.makeLog(x$74, x$73, x$75);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0, 1})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$76 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$77 = this.makeLog$default$1();
        long x$78 = this.makeLog$default$3();
        Log log = this.makeLog(x$77, x$76, x$78);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$79 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$80 = this.makeLog$default$1();
        long x$81 = this.makeLog$default$3();
        Log log = this.makeLog(x$80, x$79, x$81);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$82 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$83 = this.makeLog$default$1();
        long x$84 = this.makeLog$default$3();
        Log log = this.makeLog(x$83, x$82, x$84);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 > N));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$85 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$86 = this.makeLog$default$1();
        long x$87 = this.makeLog$default$3();
        Log log = this.makeLog(x$86, x$85, x$87);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3()));
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - (long)log.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$88 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$89 = this.makeLog$default$1();
        long x$90 = this.makeLog$default$3();
        Log log = this.makeLog(x$89, x$88, x$90);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3()));
        Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        CleanerStats stats;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$91 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$92 = this.makeLog$default$1();
        long x$93 = this.makeLog$default$3();
        Log log = this.makeLog(x$92, x$91, x$93);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CleanerStats cleanerStats = stats = (CleanerStats)tuple2._2();
        CleanerStats stats2 = cleanerStats;
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
        Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$keysInLog$2(batch))).flatMap((Function1 & Serializable & scala.Serializable)batch -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).withFilter((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$keysInLog$4(record))).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$keysInLog$5(record)), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)s -> (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.hasValue()))).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.hasKey()))).map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)m.offset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$94 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$95 = this.makeLog$default$1();
        long x$96 = this.makeLog$default$3();
        Log log = this.makeLog(x$95, x$94, x$96);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1())), ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$97 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$98 = this.makeLog$default$1();
        long x$99 = this.makeLog$default$3();
        Log log = this.makeLog(x$98, x$97, x$99);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$12))));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$13))));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, x$15))));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$16)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, x$17))));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$100 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$101 = this.makeLog$default$1();
        long x$102 = this.makeLog$default$3();
        Log log = this.makeLog(x$101, x$100, x$102);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().index().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$103 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$104 = this.makeLog$default$1();
        long x$105 = this.makeLog$default$3();
        Log log = this.makeLog(x$104, x$103, x$105);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll(0x3FFFFFFFL);
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log.logSegments().last()).index().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
            return BoxedUnit.UNIT;
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.baseOffset()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$109 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$110 = this.makeLog$default$1();
        long x$111 = this.makeLog$default$3();
        Log log = this.makeLog(x$110, x$109, x$111);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            Log qual$3 = log;
            MemoryRecords x$112 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$113 = 0;
            boolean x$114 = qual$3.appendAsLeader$default$3();
            qual$3.appendAsLeader(x$112, x$113, x$114);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Iterable<Object> cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$6(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$4 = log;
            MemoryRecords x$115 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$116 = 0;
            boolean x$117 = qual$4.appendAsLeader$default$3();
            qual$4.appendAsLeader(x$115, x$116, x$117);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$5 = log;
            MemoryRecords x$118 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$119 = 0;
            boolean x$120 = qual$5.appendAsLeader$default$3();
            qual$5.appendAsLeader(x$118, x$119, x$120);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> offsetMap.put(this.key(k), Long.MAX_VALUE));
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        this.recoverAndCheck$1(config, cleanedKeys);
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$121 = logConfig = new LogConfig((Map)logProps);
        File x$122 = this.makeLog$default$1();
        long x$123 = this.makeLog$default$3();
        Log log = this.makeLog(x$122, x$121, x$123);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 2;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 7206178L}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)start, (long)end, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        long endOffset = map.latestOffset();
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)7206178L, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.key(0)));
        Assert.assertEquals((String)"Map should contain second value", (long)7206178L, (long)map.get(this.key(1)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(this.record(4, 4, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.key(0)));
        Assert.assertEquals((long)2L, (long)map.get(this.key(2)));
        Assert.assertEquals((long)3L, (long)map.get(this.key(3)));
        Assert.assertEquals((long)-1L, (long)map.get(this.key(4)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$124 = logConfig = new LogConfig((Map)logProps);
        File x$125 = this.makeLog$default$1();
        long x$126 = this.makeLog$default$3();
        Log log = this.makeLog(x$125, x$124, x$126);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$127 = logConfig = new LogConfig((Map)new Properties());
        File x$128 = this.makeLog$default$1();
        long x$129 = this.makeLog$default$3();
        Log log = this.makeLog(x$128, x$127, x$129);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$130 = "0".getBytes();
        byte[] x$131 = "0".getBytes();
        long x$132 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$133 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$134 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$130, x$131, x$133, x$132, x$134), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Object x$135 = null;
        byte[] x$136 = "0".getBytes();
        long x$137 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$138 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$139 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$136, x$138, x$137, x$139), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$140 = "1".getBytes();
        byte[] x$141 = "1".getBytes();
        long x$142 = this.time().milliseconds();
        CompressionType x$143 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$144 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$140, x$141, x$143, x$142, x$144), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$writeToLog$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$20)), Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable & scala.Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes()), Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.sizeInBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        File x$29 = dir;
        LogConfig x$30 = config;
        long x$31 = 0L;
        long x$32 = recoveryPoint;
        MockScheduler x$33 = this.time().scheduler();
        MockTime x$34 = this.time();
        BrokerTopicStats x$35 = new BrokerTopicStats();
        int x$36 = Log$.MODULE$.apply$default$8();
        int x$37 = Log$.MODULE$.apply$default$9();
        return Log$.MODULE$.apply(x$29, x$30, x$31, x$32, (Scheduler)x$33, x$35, (Time)x$34, x$36, x$37);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private void noOpCheckDone(TopicPartition topicPartition) {
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.noOpCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$writeToLog$3(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$22)), Iterable$.MODULE$.canBuildFrom());
    }

    private ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log, long producerId, short producerEpoch) {
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, true);
    }

    private short appendTransactionalAsLeader$default$3() {
        return 0;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log, long producerId, short producerEpoch, boolean isTransactional) {
        IntRef sequence = IntRef.create((int)0);
        return (Function1 & Serializable & scala.Serializable)keys -> {
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable & scala.Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)), Seq$.MODULE$.canBuildFrom());
            MemoryRecords records = isTransactional ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            sequence$1.elem += simpleRecords.size();
            return log.appendAsLeader(records, 0, log.appendAsLeader$default$3());
        };
    }

    private short appendIdempotentAsLeader$default$3() {
        return 0;
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$145 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$146 = value;
        CompressionType x$147 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$148 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$149 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$146, x$145, x$147, x$148, x$149);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private final void reloadLog$1(Properties logProps$1, ObjectRef log$1) {
        ((Log)log$1.elem).close();
        LogConfig x$45 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        long x$46 = 0L;
        File x$47 = this.makeLog$default$1();
        log$1.elem = this.makeLog(x$47, x$45, x$46);
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom())).toSet().size();
    }

    private static final Seq distinctValuesBySegment$1(Log log$4) {
        return ((TraversableOnce)log$4.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int before = tuple2._1$mcI$sp();
        int after = tuple2._2$mcI$sp();
        boolean bl = after < before;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    private static final MemoryRecords createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private static final MemoryRecords createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$4(Record record) {
        return record.hasValue() && record.hasKey();
    }

    public static final /* synthetic */ int $anonfun$keysInLog$5(Record record) {
        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.hasValue()))).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$12) {
        return x$12.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$13) {
        return x$13.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$15) {
        return x$15.size() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$16) {
        return x$16.index().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$17) {
        return x$17.size() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).index().lastOffset() - ((LogSegment)group.head()).index().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).nextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Log log$8, Cleaner cleaner$2) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$2.buildOffsetMap(log$8, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((String)"Should find all the keys", (long)i, (long)map.get(this.key(i))));
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
        Assert.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$1(File file) {
        Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
        Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
        Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_6;
        LogConfig x$106 = config;
        File x$107 = this.makeLog$default$1();
        long x$108 = this.makeLog$default$3();
        Log recoveredLog = this.makeLog(x$107, x$106, x$108);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$1(file);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_6;
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$3(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$4(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$5(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$6(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Assert.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assert.assertEquals((long)record.offset(), (long)value);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        long offset = logEntry.offset();
        long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
        Assert.assertEquals((long)offset, (long)value);
    }

    public static final /* synthetic */ boolean $anonfun$writeToLog$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, Log log$10, Tuple2 x$20) {
        long offset;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$20;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                offset = tuple22._2$mcJ$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$10.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
        return l;
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$writeToLog$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, Log log$9, Tuple2 x$22) {
        Tuple2 tuple2 = x$22;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$9.appendAsLeader($this.record(key, value, $this.record$default$3(), $this.record$default$4(), $this.record$default$5(), $this.record$default$6()), 0, log$9.appendAsLeader$default$3()).firstOffset();
        return l;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime();
        double x$23 = Double.MAX_VALUE;
        long x$24 = Long.MAX_VALUE;
        MockTime x$25 = this.time();
        boolean x$26 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$27 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$28 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$23, x$24, x$26, x$27, x$28, (Time)x$25);
    }
}

