/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.LogSegment;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.ProducerIdEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001\f\u0011\u0005]yR\"\u0001\r\u000b\u0005eQ\u0012AB2p[6|gN\u0003\u0002\u00067)\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0013\t\u0001\u0003D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\t\u0002\u0001\u0015!\u0003\u0017\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003b\u0002\u0013\u0001\u0005\u0004%\t!J\u0001\tg\u0016<W.\u001a8ugV\ta\u0005E\u0002(Y9j\u0011\u0001\u000b\u0006\u0003S)\nq!\\;uC\ndWM\u0003\u0002,\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055B#aC!se\u0006L()\u001e4gKJ\u0004\"AE\u0018\n\u0005A\u0012!A\u0003'pON+w-\\3oi\"1!\u0007\u0001Q\u0001\n\u0019\n\u0011b]3h[\u0016tGo\u001d\u0011\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0003)\u0014A\u00027pO\u0012K'/F\u00017!\t9D(D\u00019\u0015\tI$(\u0001\u0002j_*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u00111\u0015\u000e\\3\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0003\u0001\u0015A\u00037pO\u0012K'o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003\u0013\tK!a\u0011\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u000bz\n\t\u00111\u00017\u0003\rAH%\r\u0005\u0007\u000f\u0002\u0001\u000b\u0015\u0002\u001c\u0002\u000f1|w\rR5sA!)\u0011\n\u0001C\u0001\u0015\u0006i1M]3bi\u0016\u001cVmZ7f]R$2AL&Q\u0011\u0015a\u0005\n1\u0001N\u0003\u0019ygMZ:fiB\u0011\u0011BT\u0005\u0003\u001f*\u0011A\u0001T8oO\"9\u0011\u000b\u0013I\u0001\u0002\u0004\u0011\u0016AE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\"!C*\n\u0005QS!aA%oi\")a\u000b\u0001C\u0001/\u00069!/Z2pe\u0012\u001cHc\u0001-_?B\u0011\u0011\fX\u0007\u00025*\u00111\fG\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005uS&!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0003M+\u0002\u0007Q\nC\u0003W+\u0002\u0007\u0001\rE\u0002\nC\u000eL!A\u0019\u0006\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002eW:\u0011Q-\u001b\t\u0003M*i\u0011a\u001a\u0006\u0003Q\u001a\ta\u0001\u0010:p_Rt\u0014B\u00016\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)T\u0001\"B8\u0001\t\u0003\u0001\u0018!B:fiV\u0004H#A!)\u00059\u0014\bCA:w\u001b\u0005!(BA;\u001e\u0003\u0015QWO\\5u\u0013\t9HO\u0001\u0004CK\u001a|'/\u001a\u0005\u0006s\u0002!\t\u0001]\u0001\ti\u0016\f'\u000fZ8x]\"\u0012\u0001p\u001f\t\u0003grL!! ;\u0003\u000b\u00053G/\u001a:\t\u000b}\u0004A\u0011\u00019\u0002-Q,7\u000f\u001e*fC\u0012|e.R7qif\u001cVmZ7f]RD3A`A\u0002!\r\u0019\u0018QA\u0005\u0004\u0003\u000f!(\u0001\u0002+fgRDa!a\u0003\u0001\t\u0003\u0001\u0018!\u0007;fgR\u0014V-\u00193CK\u001a|'/\u001a$jeN$xJ\u001a4tKRDC!!\u0003\u0002\u0004!1\u0011\u0011\u0003\u0001\u0005\u0002A\fQ\u0002^3ti6\u000b\u0007p\u00144gg\u0016$\b\u0006BA\b\u0003\u0007Aa!a\u0006\u0001\t\u0003\u0001\u0018!\u0005;fgR\u0014V-\u00193BMR,'\u000fT1ti\"\"\u0011QCA\u0002\u0011\u0019\ti\u0002\u0001C\u0001a\u0006yA/Z:u%\u0016\fGM\u0012:p[\u001e\u000b\u0007\u000f\u000b\u0003\u0002\u001c\u0005\r\u0001BBA\u0012\u0001\u0011\u0005\u0001/\u0001\u0007uKN$HK];oG\u0006$X\r\u000b\u0003\u0002\"\u0005\r\u0001BBA\u0015\u0001\u0011\u0005\u0001/\u0001\u001cuKN$(+\u001a7pC\u0012d\u0015M]4fgR$\u0016.\\3ti\u0006l\u0007/\u00118e\u001d\u0016DHo\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000e\u000b\u0003\u0002(\u0005\r\u0001BBA\u0018\u0001\u0011\u0005\u0001/\u0001\tuKN$HK];oG\u0006$XMR;mY\"\"\u0011QFA\u0002\u0011\u0019\t)\u0004\u0001C\u0001a\u0006IB/Z:u\r&tGm\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7qQ\u0011\t\u0019$a\u0001\t\r\u0005m\u0002\u0001\"\u0001q\u0003e!Xm\u001d;OKb$xJ\u001a4tKR\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8)\t\u0005e\u00121\u0001\u0005\u0007\u0003\u0003\u0002A\u0011\u00019\u0002-Q,7\u000f^\"iC:<WMR5mKN+hMZ5yKNDC!a\u0010\u0002\u0004!1\u0011q\t\u0001\u0005\u0002A\fQ\u0004^3tiJ+7m\u001c<fef4\u0015\u000e_3t\u0007>\u0014(/\u001e9u\u0013:$W\r\u001f\u0015\u0005\u0003\u000b\n\u0019\u0001\u0003\u0004\u0002N\u0001!\t\u0001]\u0001\u001ci\u0016\u001cHOU3d_Z,'\u000f\u0016:b]N\f7\r^5p]&sG-\u001a=)\t\u0005-\u00131\u0001\u0005\b\u0003'\u0002A\u0011BA+\u00035)g\u000e\u001a+y]J+7m\u001c:egRy\u0001,a\u0016\u0002b\u0005\u0015\u0014qNA9\u0003k\nI\b\u0003\u0005\u0002Z\u0005E\u0003\u0019AA.\u0003E\u0019wN\u001c;s_2\u0014VmY8sIRK\b/\u001a\t\u00043\u0006u\u0013bAA05\n\t2i\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\t\u000f\u0005\r\u0014\u0011\u000ba\u0001\u001b\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u0011\u0005\u001d\u0014\u0011\u000ba\u0001\u0003S\nQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007cA\u0005\u0002l%\u0019\u0011Q\u000e\u0006\u0003\u000bMCwN\u001d;\t\u00111\u000b\t\u0006%AA\u00025C\u0011\"a\u001d\u0002RA\u0005\t\u0019\u0001*\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011%\t9(!\u0015\u0011\u0002\u0003\u0007!+\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"I\u00111PA)!\u0003\u0005\r!T\u0001\ni&lWm\u001d;b[BDa!a \u0001\t\u0003\u0001\u0018!\t;fgR\u0014VmY8wKJLh)\u001b=fg\u000e{'O];qiRKW.Z%oI\u0016D\b\u0006BA?\u0003\u0007Aa!!\"\u0001\t\u0003\u0001\u0018A\b;fgR\u0014VmY8wKJLx+\u001b;i\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4fQ\u0011\t\u0019)a\u0001\t\r%\u0003A\u0011AAF)%q\u0013QRAH\u00033\u000bi\n\u0003\u0004M\u0003\u0013\u0003\r!\u0014\u0005\t\u0003#\u000bI\t1\u0001\u0002\u0014\u0006\tb-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:\u0011\u0007%\t)*C\u0002\u0002\u0018*\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001c\u0006%\u0005\u0019\u0001*\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u0011\u0005}\u0015\u0011\u0012a\u0001\u0003'\u000b1\u0002\u001d:fC2dwnY1uK\"1\u00111\u0015\u0001\u0005\u0002A\fq\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138ji\u001aKG.Z*ju\u0016\f\u0005\u000f]3oI6+7o]1hK\"\"\u0011\u0011UA\u0002\u0011\u0019\tI\u000b\u0001C\u0001a\u00069C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\\5u\r&dWmU5{K\u000ecW-\u0019:TQV$Hm\\<oQ\u0011\t9+a\u0001\t\r\u0005=\u0006\u0001\"\u0001q\u00039\u001a\bn\\;mIR\u0013XO\\2bi\u0016,e/\u001a8JM>3gm]3u!>Lg\u000e^:U_\u0006;\u0015\r]%o)\",Gj\\4)\t\u00055\u00161\u0001\u0005\n\u0003k\u0003\u0011\u0013!C\u0001\u0003o\u000bqc\u0019:fCR,7+Z4nK:$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005e&f\u0001*\u0002<.\u0012\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003%)hn\u00195fG.,GMC\u0002\u0002H*\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY-!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002P\u0002\t\n\u0011\"\u0003\u0002R\u00069RM\u001c3Uq:\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003'T3!TA^\u0011%\t9\u000eAI\u0001\n\u0013\t9,A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%k!I\u00111\u001c\u0001\u0012\u0002\u0013%\u0011qW\u0001\u0018K:$G\u000b\u001f8SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIYB\u0011\"a8\u0001#\u0003%I!!5\u0002/\u0015tG\r\u0016=o%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:\u0004")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes) {
        File msFile = TestUtils$.MODULE$.tempFile();
        FileRecords ms = FileRecords.open((File)msFile);
        File idxFile = TestUtils$.MODULE$.tempFile();
        File timeIdxFile = TestUtils$.MODULE$.tempFile();
        File txnIdxFile = TestUtils$.MODULE$.tempFile();
        idxFile.delete();
        timeIdxFile.delete();
        txnIdxFile.delete();
        OffsetIndex idx = new OffsetIndex(idxFile, offset, 1000, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        TimeIndex timeIdx = new TimeIndex(timeIdxFile, offset, 1500, TimeIndex$.MODULE$.$lessinit$greater$default$4());
        TransactionIndex txnIndex = new TransactionIndex(offset, txnIdxFile);
        LogSegment seg = new LogSegment(ms, idx, timeIdx, txnIndex, offset, indexIntervalBytes, 0L, Time.SYSTEM);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)LogSegmentTest.$anonfun$teardown$1(seg)));
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        long x$3 = 40L;
        int x$4 = 300;
        None$ x$5 = None$.MODULE$;
        long x$6 = seg.read$default$4();
        boolean x$7 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$3, (Option)x$5, x$4, x$6, x$7);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(50L, 53L, -1L, -1L, ms);
        long x$8 = 41L;
        int x$9 = 300;
        None$ x$10 = None$.MODULE$;
        long x$11 = seg.read$default$4();
        boolean x$12 = seg.read$default$5();
        Records read = seg.read(x$8, (Option)x$10, x$9, x$11, x$12).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2());
        MemoryRecords ms = this.records(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append((long)baseOffset, 52L, -1L, -1L, ms);
        LogSegmentTest.validate$1(50L, seg, ms);
        LogSegmentTest.validate$1(51L, seg, ms);
        LogSegmentTest.validate$1(52L, seg, ms);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        long x$18 = 52L;
        int x$19 = 200;
        None$ x$20 = None$.MODULE$;
        long x$21 = seg.read$default$4();
        boolean x$22 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$18, (Option)x$20, x$19, x$21, x$22);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$23 = 55L;
        int x$24 = 200;
        None$ x$25 = None$.MODULE$;
        long x$26 = seg.read$default$4();
        boolean x$27 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$23, (Option)x$25, x$24, x$26, x$27);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$3.elem, (long)offset$3.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = this.records(offset$3.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$3.elem + 1), (long)(offset$3.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$3.elem, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{(Record)ms1.records().iterator().next(), (Record)ms2.records().iterator().next()})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
            seg.truncateTo((long)(offset$3.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$3.elem, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
            Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
            ++offset$3.elem;
        });
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1);
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$4.elem, (long)offset$4.elem, (long)offset$4.elem, (long)offset$4.elem, this.records(offset$4.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$4.elem;
        });
        Assert.assertEquals((long)offset.elem, (long)seg.nextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have ", " time indexes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumEntries)})), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have 0 time indexes"})).s((Seq)Nil$.MODULE$), (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Largest timestamp should be 400"})).s((Seq)Nil$.MODULE$), (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.nextOffset());
    }

    @Test
    public void testTruncateFull() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        seg.append(40L, 41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        seg.truncateTo(0L);
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024, seg.read$default$4(), seg.read$default$5()));
        seg.append(40L, 41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).s((Seq)Nil$.MODULE$)})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))}))));
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((TimestampOffset)seg.findOffsetByTimestamp(420L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(421L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(430L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)44L, (long)((TimestampOffset)seg.findOffsetByTimestamp(431L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((TimestampOffset)seg.findOffsetByTimestamp(401L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assert.assertEquals((long)40L, (long)((TimestampOffset)seg.findOffsetByTimestamp(399L, seg.findOffsetByTimestamp$default$2()).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        Assert.assertEquals((long)40L, (long)seg.nextOffset());
        seg.append(50L, 52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.nextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        File logFile = seg.log().file();
        File indexFile = seg.index().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)(logFile.getAbsolutePath() + ".deleted"), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)(indexFile.getAbsolutePath() + ".deleted"), (Object)seg.index().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.index().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
        File indexFile = seg.index().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)i, (long)((Record)seg.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024, seg.read$default$4(), seg.read$default$5()).records().records().iterator().next()).offset()));
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 0;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(100L, 101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(102L, 103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(104L, 105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, 106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, 107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        stateManager.loadProducerEntry(new ProducerIdEntry(pid2, producerEpoch, 10, 90L, 5, -1L, 0, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private long endTxnRecords$default$4() {
        return 0L;
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
        File timeIndexFile = seg.timeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                Assert.assertEquals((long)i, (long)((TimestampOffset)seg.findOffsetByTimestamp((long)(i * 10), seg.findOffsetByTimestamp$default$2()).get()).offset());
                if (i >= 99) break block0;
                Assert.assertEquals((long)(i + 1), (long)((TimestampOffset)seg.findOffsetByTimestamp((long)(i * 10 + 1), seg.findOffsetByTimestamp$default$2()).get()).offset());
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            FileRecords.LogOffsetPosition recordPosition = seg.log().searchForOffsetWithSize((long)offsetToBeginCorruption, 0);
            int position = recordPosition.position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
            Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList());
            seg.delete();
        });
    }

    public LogSegment createSegment(long offset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, offset, 10, 1000, 0L, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$28 = 55L;
        int x$29 = 200;
        None$ x$30 = None$.MODULE$;
        long x$31 = seg.read$default$4();
        boolean x$32 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$28, (Option)x$30, x$29, x$31, x$32);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, 40L, 10, 1000, 0L, Time.SYSTEM, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$33 = 55L;
        int x$34 = 200;
        None$ x$35 = None$.MODULE$;
        long x$36 = seg.read$default$4();
        boolean x$37 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$33, (Option)x$35, x$34, x$36, x$37);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = new LogSegment(tempDir, 40L, 10, 1000, 0L, Time.SYSTEM, true, 0x20000000, true);
        this.segments().$plus$eq((Object)segReopen);
        long x$38 = 55L;
        int x$39 = 200;
        None$ x$40 = None$.MODULE$;
        long x$41 = segReopen.read$default$4();
        boolean x$42 = segReopen.read$default$5();
        FetchDataInfo readAgain = segReopen.read(x$38, (Option)x$40, x$39, x$41, x$42);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size);
        Assert.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, (long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), (long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, (Option)None$.MODULE$, 10000, seg.read$default$4(), seg.read$default$5());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(log.records().batches()).asScala()).size());
    }

    public static final /* synthetic */ boolean $anonfun$teardown$1(LogSegment seg) {
        seg.index().delete();
        seg.timeIndex().delete();
        seg.txnIndex().delete();
        return seg.log().delete();
    }

    public static final /* synthetic */ boolean $anonfun$testMaxOffset$1(long offset$2, Record x$1) {
        return x$1.offset() == offset$2;
    }

    private static final void validate$1(long offset, LogSegment seg$1, MemoryRecords ms$1) {
        long x$13 = offset;
        int x$14 = 1024;
        Some x$15 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        long x$16 = seg$1.read$default$4();
        boolean x$17 = seg$1.read$default$5();
        Assert.assertEquals((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms$1.records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogSegmentTest.$anonfun$testMaxOffset$1(offset, x$1)))).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg$1.read(x$13, (Option)x$15, x$14, x$16, x$17).records().records()).asScala()).toList());
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }
}

