/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001\u001d\u0011qb\u00144gg\u0016$\u0018J\u001c3fqR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002\u00011A\u0005\u0002e\t1!\u001b3y+\u0005Q\u0002C\u0001\f\u001c\u0013\ta\"AA\u0006PM\u001a\u001cX\r^%oI\u0016D\bb\u0002\u0010\u0001\u0001\u0004%\taH\u0001\bS\u0012Dx\fJ3r)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bbB\u0014\u001e\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004BB\u0015\u0001A\u0003&!$\u0001\u0003jIb\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u0017\u0011\u0005\u0005r\u0013BA\u0018#\u0005\rIe\u000e\u001e\u0005\u0007c\u0001\u0001\u000b\u0011B\u0017\u0002\u00175\f\u00070\u00128ue&,7\u000f\t\u0005\u0006g\u0001!\t\u0001N\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002A!\u0012!G\u000e\t\u0003oej\u0011\u0001\u000f\u0006\u0003\u00179I!A\u000f\u001d\u0003\r\t+gm\u001c:f\u0011\u0015a\u0004\u0001\"\u00015\u0003!!X-\u0019:e_^t\u0007FA\u001e?!\t9t(\u0003\u0002Aq\t)\u0011I\u001a;fe\")!\t\u0001C\u0001i\u0005\u0001\"/\u00198e_6dun\\6vaR+7\u000f\u001e\u0015\u0003\u0003\u0012\u0003\"aN#\n\u0005\u0019C$\u0001\u0002+fgRDQ\u0001\u0013\u0001\u0005\u0002Q\n!\u0003\\8pWV\u0004X\t\u001f;sK6,7)Y:fg\"\u0012q\t\u0012\u0005\u0006\u0017\u0002!\t\u0001N\u0001\u000eCB\u0004XM\u001c3U_>l\u0015M\\=)\u0005)#\u0005\"\u0002(\u0001\t\u0003!\u0014\u0001E1qa\u0016tGmT;u\u001f\u001a|%\u000fZ3sQ\u0011iE\tU)\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0012\taaY8n[>t\u0017BA,U\u0005YIeN^1mS\u0012|eMZ:fi\u0016C8-\u001a9uS>t\u0007\"B-\u0001\t\u0003!\u0014!\u0007;fgR4U\r^2i+B\u0004XM\u001d\"pk:$wJ\u001a4tKRD#\u0001\u0017#\t\u000bq\u0003A\u0011\u0001\u001b\u0002\u0015Q,7\u000f\u001e*f_B,g\u000e\u000b\u0002\\\t\")q\f\u0001C\u0001i\u0005AAO];oG\u0006$X\r\u000b\u0002_\t\")!\r\u0001C\u0001G\u0006\u0001\u0012m]:feR<&/\u001b;f\r\u0006LGn]\u000b\u0003Ir$R\u0001I3sgVDQAZ1A\u0002\u001d\fq!\\3tg\u0006<W\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003U\nj\u0011a\u001b\u0006\u0003Y\u001a\ta\u0001\u0010:p_Rt\u0014B\u00018#\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u0014\u0003\"\u0002\rb\u0001\u0004Q\u0002\"\u0002;b\u0001\u0004i\u0013AB8gMN,G\u000fC\u0003wC\u0002\u0007q/A\u0003lY\u0006\u001c8\u000fE\u0002iqjL!!_9\u0003\u000b\rc\u0017m]:\u0011\u0005mdH\u0002\u0001\u0003\u0006{\u0006\u0014\rA \u0002\u0002)F\u0019q0!\u0002\u0011\u0007\u0005\n\t!C\u0002\u0002\u0004\t\u0012qAT8uQ&tw\rE\u0002\"\u0003\u000fI1!!\u0003#\u0005\r\te.\u001f\u0005\b\u0003\u001b\u0001A\u0011AA\b\u00031iwN\\8u_:L7mU3r)\u0019\t\t\"!\b\u0002\"A)\u00111CA\r[5\u0011\u0011Q\u0003\u0006\u0004\u0003/\u0011\u0013AC2pY2,7\r^5p]&!\u00111DA\u000b\u0005\r\u0019V-\u001d\u0005\b\u0003?\tY\u00011\u0001.\u0003\u0011\u0011\u0017m]3\t\u000f\u0005\r\u00121\u0002a\u0001[\u0005\u0019A.\u001a8\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005\u0019bn\u001c8Fq&\u001cH/\u00198u)\u0016l\u0007OR5mKR\u0011\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\tIwN\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\u0011\tI$a\f\u0003\t\u0019KG.\u001a")
public class OffsetIndexTest
extends JUnitSuite {
    private OffsetIndex idx = null;
    private final int maxEntries;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistantTempFile(), 45L, 240, OffsetIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        block0: {
            if (this.idx() == null) break block0;
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$1 -> x$1, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1 & Serializable & scala.Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)OffsetIndexTest.$anonfun$randomLookupTest$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p), Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(offsets)).take(30))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> {
            OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)valMap.firstKey()) ? new OffsetPosition(this.idx().baseOffset(), 0) : new OffsetPosition(valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
            Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)this.idx().lookup(offset));
        });
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long offset = this.idx().baseOffset() + (long)i + 1L;
            this.idx().append(offset, i);
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(0L, 0);
        OffsetPosition second = new OffsetPosition(1L, 10);
        OffsetPosition third = new OffsetPosition(2L, 23);
        OffsetPosition fourth = new OffsetPosition(3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetPosition[]{first, second, third, fourth}))).foreach((Function1 & Serializable & scala.Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistantTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> idx.append((long)i, i));
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            throw this.fail(message, new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, e.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable & scala.Serializable)_ -> OffsetIndexTest.$anonfun$monotonicSeq$1(rand, vals, last, BoxesRunTime.unboxToInt((Object)_)));
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistantTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ boolean $anonfun$randomLookupTest$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long logical = tuple2._1$mcJ$sp();
        int physical = tuple2._2$mcI$sp();
        Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(Random rand$1, ArrayBuffer vals$1, IntRef last$1, int _) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
    }
}

