/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u000f\t!BK]1og\u0006\u001cG/[8o\u0013:$W\r\u001f+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0005\u0019\u0001\u0001\u0007\t\u0019!C\u00013\u0005!a-\u001b7f+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\tIwNC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"\u0001\u0002$jY\u0016D\u0011b\t\u0001A\u0002\u0003\u0007I\u0011\u0001\u0013\u0002\u0011\u0019LG.Z0%KF$\"!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bY\t\n\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007]\u0001\u0001\u000b\u0015\u0002\u000e\u0002\u000b\u0019LG.\u001a\u0011\t\u0013A\u0002\u0001\u0019!a\u0001\n\u0003\t\u0014!B5oI\u0016DX#\u0001\u001a\u0011\u0005Y\u0019\u0014B\u0001\u001b\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010C\u00057\u0001\u0001\u0007\t\u0019!C\u0001o\u0005I\u0011N\u001c3fq~#S-\u001d\u000b\u0003KaBq\u0001L\u001b\u0002\u0002\u0003\u0007!\u0007\u0003\u0004;\u0001\u0001\u0006KAM\u0001\u0007S:$W\r\u001f\u0011\t\u000fq\u0002!\u0019!C\u0001{\u00051qN\u001a4tKR,\u0012A\u0010\t\u0003M}J!\u0001Q\u0014\u0003\t1{gn\u001a\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002 \u0002\u000f=4gm]3uA!)A\t\u0001C\u0001\u000b\u0006)1/\u001a;vaV\tQ\u0005\u000b\u0002D\u000fB\u0011\u0001JS\u0007\u0002\u0013*\u00111BD\u0005\u0003\u0017&\u0013aAQ3g_J,\u0007\"B'\u0001\t\u0003)\u0015\u0001\u0003;fCJ$wn\u001e8)\u00051{\u0005C\u0001%Q\u0013\t\t\u0016JA\u0003BMR,'\u000fC\u0003T\u0001\u0011\u0005A+\u0001\u0012uKN$\bk\\:ji&|gnU3u\u0007>\u0014(/Z2uYf<\u0006.\u001a8Pa\u0016tW\r\u001a\u000b\u0002K!\u0012!K\u0016\t\u0003\u0011^K!\u0001W%\u0003\tQ+7\u000f\u001e\u0005\u00065\u0002!\t\u0001V\u0001\u0010i\u0016\u001cHoU1oSRL8\t[3dW\"\"\u0011L\u0016/^\u0003!)\u0007\u0010]3di\u0016$7%\u00010\u0011\u0005};gB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019g!\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011amJ\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017N\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T!AZ\u0014\t\u000b-\u0004A\u0011\u0001+\u00025Q,7\u000f\u001e'bgR|eMZ:fi6+8\u000f^%oGJ,\u0017m]3)\t)4F,\u0018\u0005\u0006]\u0002!\t\u0001V\u0001\u001di\u0016\u001cH\u000fT1ti>3gm]3u\u0007\u0006tgn\u001c;EK\u000e\u0014X-Y:fQ\u0011ig\u000bX/\t\u000bE\u0004A\u0011\u0001+\u0002=Q,7\u000f^\"pY2,7\r^!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\bF\u00019W\u0011\u0015!\b\u0001\"\u0001U\u00031!Xm\u001d;UeVt7-\u0019;fQ\t\u0019h\u000bC\u0003x\u0001\u0011\u0005A+A\nuKN$\u0018IY8si\u0016$G\u000b\u001f8TKJ$W\r\u000b\u0002w-\")!\u0010\u0001C\u0001)\u0006yA/Z:u%\u0016t\u0017-\\3J]\u0012,\u0007\u0010\u000b\u0002z-\u0002")
public class TransactionIndexTest
extends JUnitSuite {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @Before
    public void setup() {
        this.file_$eq(TestUtils$.MODULE$.tempFile());
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @After
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assert.assertEquals((Object)abortedTxns.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{anotherAbortedTxn})), List$.MODULE$.canBuildFrom()), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSanityCheck() {
        List abortedTxns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file());
        reopenedIndex.sanityCheck();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 15L, 11L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
    }

    @Test
    public void testCollectAbortedTransactions() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 11L), new AbortedTxn(1L, 5L, 15L, 13L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assert.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assert.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        List abortedTransactions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(0L, 0L, 10L, 2L), new AbortedTxn(1L, 5L, 15L, 16L), new AbortedTxn(2L, 18L, 35L, 25L), new AbortedTxn(3L, 32L, 50L, 40L)}));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1 & java.io.Serializable & Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().truncateTo(51L);
        Assert.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncate();
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assert.assertEquals((long)AbortedTxn$.MODULE$.CurrentVersion(), (long)abortedTxn.version());
        Assert.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assert.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils$.MODULE$.tempFile();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        Assert.assertEquals((long)2L, (long)abortedTxns.size());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.apply(0)).firstOffset());
        Assert.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.apply(1)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }
}

