/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.SnappyCompressionCodec$;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyOutputStream;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u000f\t1R*Z:tC\u001e,7i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012\u0001\b;fgR\u001c\u0016.\u001c9mK\u000e{W\u000e\u001d:fgN$UmY8naJ,7o\u001d\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0005)\u0016\u001cH\u000fC\u0003(\u0001\u0011\u0005\u0011$\u0001\tuKN$8i\\7qe\u0016\u001c8oU5{K\"\u0012a%\t\u0005\u00061\u0001!\tA\u000b\u000b\u00035-BQ\u0001L\u0015A\u00025\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005Yq\u0013BA\u0018\u0003\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u0003(\u0001\u0011\u0005\u0011\u0007\u0006\u0003\u001beM\"\u0005\"\u0002\u00171\u0001\u0004i\u0003\"\u0002\u001b1\u0001\u0004)\u0014\u0001C7fgN\fw-Z:\u0011\u0007Yr\u0014I\u0004\u00028y9\u0011\u0001hO\u0007\u0002s)\u0011!HB\u0001\u0007yI|w\u000e\u001e \n\u0003uI!!\u0010\u000f\u0002\u000fA\f7m[1hK&\u0011q\b\u0011\u0002\u0005\u0019&\u001cHO\u0003\u0002>9A\u0011aCQ\u0005\u0003\u0007\n\u0011q!T3tg\u0006<W\rC\u0003Fa\u0001\u0007a)\u0001\u0007fqB,7\r^3e'&TX\r\u0005\u0002\u001c\u000f&\u0011\u0001\n\b\u0002\u0004\u0013:$\b\"\u0002&\u0001\t\u0003Y\u0015!E5t':\f\u0007\u000f]=Bm\u0006LG.\u00192mKV\tA\n\u0005\u0002\u001c\u001b&\u0011a\n\b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\u0006\u0001\"\u0001L\u00039I7\u000f\u0014.5\u0003Z\f\u0017\u000e\\1cY\u0016\u0004")
public class MessageCompressionTest
extends JUnitSuite {
    @Test
    public void testSimpleCompressDecompress() {
        ArrayBuffer codecs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompressionCodec[]{GZIPCompressionCodec$.MODULE$}));
        Object object = this.isSnappyAvailable() ? codecs.$plus$eq((Object)SnappyCompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        Object object2 = this.isLZ4Available() ? codecs.$plus$eq((Object)LZ4CompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        codecs.foreach((Function1 & Serializable & scala.Serializable)codec -> {
            this.testSimpleCompressDecompress(codec);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCompressSize() {
        block1: {
            byte[] bytes1k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)MessageCompressionTest.$anonfun$testCompressSize$1(BoxesRunTime.unboxToInt((Object)x$1))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
            byte[] bytes2k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1000), 2000).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)MessageCompressionTest.$anonfun$testCompressSize$2(BoxesRunTime.unboxToInt((Object)x$2))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
            byte[] bytes3k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3000), 4000).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToByte((byte)MessageCompressionTest.$anonfun$testCompressSize$3(BoxesRunTime.unboxToInt((Object)x$3))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
            List messages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(bytes1k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1()), new Message(bytes2k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1()), new Message(bytes3k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1())}));
            this.testCompressSize((CompressionCodec)GZIPCompressionCodec$.MODULE$, (List<Message>)messages, 396);
            if (this.isSnappyAvailable()) {
                this.testCompressSize((CompressionCodec)SnappyCompressionCodec$.MODULE$, (List<Message>)messages, 502);
            }
            if (!this.isLZ4Available()) break block1;
            this.testCompressSize((CompressionCodec)LZ4CompressionCodec$.MODULE$, (List<Message>)messages, 387);
        }
    }

    public void testSimpleCompressDecompress(CompressionCodec compressionCodec) {
        List messages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hi there".getBytes()), new Message("I am fine".getBytes()), new Message("I am not so well today".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, (Seq)messages);
        Assert.assertEquals((Object)compressionCodec, (Object)((MessageAndOffset)messageSet.shallowIterator().next()).message().compressionCodec());
        List decompressed = messageSet.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.message()).toList();
        Assert.assertEquals((Object)messages, (Object)decompressed);
    }

    public void testCompressSize(CompressionCodec compressionCodec, List<Message> messages, int expectedSize) {
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, messages);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " size has changed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressionCodec})), (long)expectedSize, (long)messageSet.sizeInBytes());
    }

    public boolean isSnappyAvailable() {
        boolean bl;
        try {
            new SnappyOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof UnsatisfiedLinkError ? true : throwable2 instanceof SnappyError;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    public boolean isLZ4Available() {
        boolean bl;
        try {
            new LZ4BlockOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ byte $anonfun$testCompressSize$1(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$testCompressSize$2(int x$2) {
        return (byte)x$2;
    }

    public static final /* synthetic */ byte $anonfun$testCompressSize$3(int x$3) {
        return (byte)x$3;
    }
}

