/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import kafka.message.CompressionCodec;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.InvalidMessageException;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageTestVal;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u000f\tYQ*Z:tC\u001e,G+Z:u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001\u0001\u0019!C\u00013\u0005AQ.Z:tC\u001e,7/F\u0001\u001b!\rY\"\u0005J\u0007\u00029)\u0011QDH\u0001\b[V$\u0018M\u00197f\u0015\ty\u0002%\u0001\u0006d_2dWm\u0019;j_:T\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003Gq\u00111\"\u0011:sCf\u0014UO\u001a4feB\u0011a#J\u0005\u0003M\t\u0011a\"T3tg\u0006<W\rV3tiZ\u000bG\u000eC\u0004)\u0001\u0001\u0007I\u0011A\u0015\u0002\u00195,7o]1hKN|F%Z9\u0015\u0005)r\u0003CA\u0016-\u001b\u0005\u0001\u0013BA\u0017!\u0005\u0011)f.\u001b;\t\u000f=:\u0013\u0011!a\u00015\u0005\u0019\u0001\u0010J\u0019\t\rE\u0002\u0001\u0015)\u0003\u001b\u0003%iWm]:bO\u0016\u001c\b\u0005C\u00034\u0001\u0011\u0005A'A\u0003tKR,\u0006\u000fF\u0001+Q\t\u0011d\u0007\u0005\u00028s5\t\u0001H\u0003\u0002\f\u001d%\u0011!\b\u000f\u0002\u0007\u0005\u00164wN]3\t\u000bq\u0002A\u0011A\u001f\u0002\u001fQ,7\u000f\u001e$jK2$g+\u00197vKN,\u0012A\u000b\u0015\u0003w}\u0002\"a\u000e!\n\u0005\u0005C$\u0001\u0002+fgRDQa\u0011\u0001\u0005\u0002Q\nA\u0002^3ti\u000eCWmY6tk6D#AQ \t\u000b\u0019\u0003A\u0011\u0001\u001b\u0002\u0019Q,7\u000f^#rk\u0006d\u0017\u000e^=)\u0005\u0015{\u0004\"B%\u0001\t\u0003!\u0014\u0001\f;fgRLeN^1mS\u0012$\u0016.\\3ti\u0006l\u0007/\u00118e\u001b\u0006<\u0017n\u0019,bYV,7i\\7cS:\fG/[8oQ\u0011Auh\u0013'\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\u0014\t\u0003\u001dZs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005I3\u0011A\u0002\u001fs_>$h(C\u0001\"\u0013\t)\u0006%A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011Q\u000b\t\u0005\u00065\u0002!\t\u0001N\u0001\u0015i\u0016\u001cH/\u00138wC2LG\rV5nKN$\u0018-\u001c9)\te{4\n\u0014\u0005\u0006;\u0002!\t\u0001N\u0001\u0015i\u0016\u001cH/\u00138wC2LG-T1hS\u000e\u0014\u0015\u0010^3)\tq{4\n\u0014\u0005\u0006A\u0002!\t\u0001N\u0001\u000fi\u0016\u001cH/S:ICND\u0017M\u00197fQ\tyv\bC\u0003d\u0001\u0011\u0005A'\u0001\u000buKN$X\t_2faRLwN\\'baBLgn\u001a\u0015\u0003E~\u0002")
public class MessageTest
extends JUnitSuite {
    private ArrayBuffer<MessageTestVal> messages = new ArrayBuffer();

    public ArrayBuffer<MessageTestVal> messages() {
        return this.messages;
    }

    public void messages_$eq(ArrayBuffer<MessageTestVal> x$1) {
        this.messages = x$1;
    }

    @Before
    public void setUp() {
        byte[][] keys = (byte[][])((Object[])new byte[][]{null, "key".getBytes(), "".getBytes()});
        byte[][] vals = (byte[][])((Object[])new byte[][]{"value".getBytes(), "".getBytes(), null});
        Product[] codecs = (Product[])((Object[])new Product[]{NoCompressionCodec$.MODULE$, GZIPCompressionCodec$.MODULE$, SnappyCompressionCodec$.MODULE$, LZ4CompressionCodec$.MODULE$});
        long[] timestamps = new long[]{Message$.MODULE$.NoTimestamp(), 0L, 1L};
        byte[] magicValues = new byte[]{Message$.MODULE$.MagicValue_V0(), Message$.MODULE$.MagicValue_V1()};
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).foreach((Function1 & Serializable & scala.Serializable)k -> {
            MessageTest.$anonfun$setUp$1(this, vals, codecs, timestamps, magicValues, k);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFieldValues() {
        this.messages().foreach((Function1 & Serializable & scala.Serializable)v -> {
            MessageTest.$anonfun$testFieldValues$1(v);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testChecksum() {
        this.messages().foreach((Function1 & Serializable & scala.Serializable)v -> {
            MessageTest.$anonfun$testChecksum$1(v);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEquality() {
        this.messages().foreach((Function1 & Serializable & scala.Serializable)v -> {
            MessageTest.$anonfun$testEquality$1(v);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTimestampAndMagicValueCombination() {
        new Message("hello".getBytes(), 0L, Message$.MODULE$.MagicValue_V0());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTimestamp() {
        new Message("hello".getBytes(), -3L, Message$.MODULE$.MagicValue_V1());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMagicByte() {
        new Message("hello".getBytes(), 0L, (byte)2);
    }

    @Test
    public void testIsHashable() {
        HashMap m = new HashMap();
        this.messages().foreach((Function1 & Serializable & scala.Serializable)v -> m.put(v.message(), v.message()));
        this.messages().foreach((Function1 & Serializable & scala.Serializable)v -> {
            MessageTest.$anonfun$testIsHashable$2(m, v);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testExceptionMapping() {
        Errors expected = Errors.CORRUPT_MESSAGE;
        Errors actual = Errors.forException((Throwable)new InvalidMessageException());
        Assert.assertEquals((String)"InvalidMessageException should map to a corrupt message error", (Object)expected, (Object)actual);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$setUp$5(MessageTest $this, byte[] k$1, byte[] v$1, Product codec$1, long t$1, byte mv) {
        long timestamp = MessageTest.ensureValid$1(mv, t$1);
        return $this.messages().$plus$eq((Object)new MessageTestVal(k$1, v$1, (CompressionCodec)codec$1, timestamp, mv, new Message(v$1, k$1, timestamp, (CompressionCodec)codec$1, mv)));
    }

    public static final /* synthetic */ void $anonfun$setUp$3(MessageTest $this, long[] timestamps$1, byte[] magicValues$1, byte[] k$1, byte[] v$1, Product codec) {
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(timestamps$1)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)t -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(magicValues$1)).foreach((Function1 & Serializable & scala.Serializable)mv -> MessageTest.$anonfun$setUp$5($this, k$1, v$1, codec, t, BoxesRunTime.unboxToByte((Object)mv))));
    }

    public static final /* synthetic */ void $anonfun$setUp$2(MessageTest $this, Product[] codecs$1, long[] timestamps$1, byte[] magicValues$1, byte[] k$1, byte[] v) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codecs$1)).foreach((Function1 & Serializable & scala.Serializable)codec -> {
            MessageTest.$anonfun$setUp$3($this, timestamps$1, magicValues$1, k$1, v, codec);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$setUp$1(MessageTest $this, byte[][] vals$1, Product[] codecs$1, long[] timestamps$1, byte[] magicValues$1, byte[] k) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])vals$1)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            MessageTest.$anonfun$setUp$2($this, codecs$1, timestamps$1, magicValues$1, k, v);
            return BoxedUnit.UNIT;
        });
    }

    private static final long ensureValid$1(byte magicValue, long timestamp) {
        return magicValue > Message$.MODULE$.MagicValue_V0() ? timestamp : Message$.MODULE$.NoTimestamp();
    }

    public static final /* synthetic */ void $anonfun$testFieldValues$1(MessageTestVal v) {
        if (v.payload() == null) {
            Assert.assertTrue((boolean)v.message().isNull());
            Assert.assertEquals((String)"Payload should be null", null, (Object)v.message().payload());
        } else {
            TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.payload()), v.message().payload());
        }
        if (v.magicValue() > Message$.MODULE$.MagicValue_V0()) {
            Assert.assertEquals((String)"Timestamp should be the same", (long)v.timestamp(), (long)v.message().timestamp());
        } else {
            Assert.assertEquals((String)"Timestamp should be the NoTimestamp", (long)Message$.MODULE$.NoTimestamp(), (long)v.message().timestamp());
        }
        Assert.assertEquals((long)v.magicValue(), (long)v.message().magic());
        if (v.message().hasKey()) {
            TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.key()), v.message().key());
        } else {
            Assert.assertEquals(null, (Object)v.message().key());
        }
        Assert.assertEquals((Object)v.codec(), (Object)v.message().compressionCodec());
    }

    public static final /* synthetic */ void $anonfun$testChecksum$1(MessageTestVal v) {
        Assert.assertTrue((String)"Auto-computed checksum should be valid", (boolean)v.message().isValid());
        int badChecksum = (int)(v.message().checksum() + 1L);
        ByteUtils.writeUnsignedInt((ByteBuffer)v.message().buffer(), (int)Message$.MODULE$.CrcOffset(), (long)badChecksum);
        Assert.assertFalse((String)"Message with invalid checksum should be invalid", (boolean)v.message().isValid());
    }

    public static final /* synthetic */ void $anonfun$testEquality$1(MessageTestVal v) {
        Assert.assertFalse((String)"Should not equal null", (boolean)v.message().equals(null));
        Assert.assertFalse((String)"Should not equal a random string", (boolean)v.message().equals((Object)"asdf"));
        Assert.assertTrue((String)"Should equal itself", (boolean)v.message().equals((Object)v.message()));
        Message copy = new Message(v.payload(), v.key(), v.timestamp(), v.codec(), v.magicValue());
        Assert.assertTrue((String)"Should equal another message with the same content.", (boolean)v.message().equals((Object)copy));
    }

    public static final /* synthetic */ void $anonfun$testIsHashable$2(HashMap m$1, MessageTestVal v) {
        Assert.assertEquals((Object)v.message(), m$1.get(v.message()));
    }
}

