/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.BrokerTopicStats$;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005Aa.^7O_\u0012,7/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u00139,XNT8eKN\u0004\u0003bB\u0013\u0001\u0005\u0004%\taG\u0001\t]Vl\u0007+\u0019:ug\"1q\u0005\u0001Q\u0001\nq\t\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019!\u0004\u0001)A\u0005W\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\u0006m\u0001!\taN\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgR\t\u0001\bE\u0002:\u0003\u0012s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011A\u0002\u001fs_>$h(C\u0001 \u0013\t\u0001e$A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%aA*fc*\u0011\u0001I\b\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0012\taa]3sm\u0016\u0014\u0018BA%G\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f-\u0003!\u0019!C\u00017\u0005Ia.T3tg\u0006<Wm\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u000f\u0002\u00159lUm]:bO\u0016\u001c\b\u0005C\u0003P\u0001\u0011\u0005\u0001+A\buKN$X*\u001a;sS\u000e\u001cH*Z1l)\u0005\t\u0006CA\u000fS\u0013\t\u0019fD\u0001\u0003V]&$\b\u0006\u0002(V1j\u0003\"!\b,\n\u0005]s\"A\u00033faJ,7-\u0019;fI\u0006\n\u0011,\u0001%UQ&\u001c\b\u0005^3ti\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI5uA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012\u0004\u0013N\u001c\u0011bA\u0019,H/\u001e:fAI,G.Z1tK\u0006\n1,\u0001\u00051]E\u0002d\u0006\r\u00181Q\tqU\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006)!.\u001e8ji*\t!-A\u0002pe\u001eL!\u0001Z0\u0003\tQ+7\u000f\u001e\u0005\u0006M\u0002!\t\u0001U\u0001&i\u0016\u001cH/T3ue&\u001c7OU3q_J$XM]!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000eD#!Z/\t\u000b%\u0004A\u0011\u0001)\u0002iQ,7\u000f\u001e\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN,fN]3hSN$XM]3e\u0003\u001a$XM\u001d#fY\u0016$\u0018N\\4U_BL7\r\u000b\u0002i;\")A\u000e\u0001C\u0001!\u0006\u0019B/Z:u\u00072,8\u000f^3s\u0013\u0012lU\r\u001e:jG\"\u00121.\u0018\u0005\u0006_\u0002!\t\u0001]\u0001\u0016GJ,\u0017\r^3B]\u0012\u001c\u0006.\u001e;e_^t7\u000b^3q)\u0015\t\u0016o_?\u0000\u0011\u0015\u0011h\u000e1\u0001t\u0003\u0015!x\u000e]5d!\t!\bP\u0004\u0002vmB\u00111HH\u0005\u0003oz\ta\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011qO\b\u0005\u0006y:\u0004\ra]\u0001\u0006OJ|W\u000f\u001d\u0005\u0006}:\u0004\ra]\u0001\u000bG>t7/^7fe&#\u0007BBA\u0001]\u0002\u00071/\u0001\u0006qe>$WoY3s\u0013\u0012DCA\\+Y5\"1\u0011q\u0001\u0001\u0005\u0002A\u000b\u0001\u0005^3ti\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m\u001d\"zi\u0016\u001c\u0018J\\(vi\"\u001a\u0011QA/\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010\u0005QQ.\u001a;fe\u000e{WO\u001c;\u0015\t\u0005E\u0011q\u0003\t\u0004;\u0005M\u0011bAA\u000b=\t!Aj\u001c8h\u0011\u001d\tI\"a\u0003A\u0002M\f!\"\\3ue&\u001cg*Y7f\u0011\u001d\ti\u0002\u0001C\u0005\u0003?\t\u0011\u0003^8qS\u000elU\r\u001e:jG\u001e\u0013x.\u001e9t)\u0011\t\t#!\f\u0011\u000b\u0005\r\u0012\u0011F:\u000e\u0005\u0005\u0015\"bAA\u0014=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0012Q\u0005\u0002\u0004'\u0016$\bB\u0002:\u0002\u001c\u0001\u00071\u000f")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$7 = this.numNodes();
        String x$8 = this.zkConnect();
        boolean x$9 = true;
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        Option<SecurityProtocol> x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$7, x$8, x$10, x$9, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsLeak() {
        String topic = "test-metrics-leak";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.createAndShutdownStep(topic, "group0", "consumer0", "producer0");
        Assert.assertNotNull((Object)DelayedFetchMetrics$.MODULE$);
        int countOfStaticMetrics = Metrics.defaultRegistry().allMetrics().keySet().size();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.createAndShutdownStep(topic, "group" + i % 3, "consumer" + i % 2, "producer" + i % 2);
            Assert.assertEquals((long)countOfStaticMetrics, (long)Metrics.defaultRegistry().allMetrics().keySet().size());
        });
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5());
        Assert.assertTrue((String)"Topic metrics don't exist", (boolean)this.topicMetricGroups(topic).nonEmpty());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, s);
            return BoxedUnit.UNIT;
        });
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(x$2))), (long)1L);
    }

    public void createAndShutdownStep(String topic, String group, String consumerId, String producerId) {
        TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.sendMessages$default$4(), TestUtils$.MODULE$.sendMessages$default$5());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, consumerId, TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages());
        zkConsumerConnector1.shutdown();
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesInPerSec(), topic}));
        String bytesOut = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesOutPerSec(), topic}));
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, this.numNodes(), (Seq<KafkaServer>)this.servers(), topicConfig);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
        long initialReplicationBytesIn = this.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = this.meterCount(replicationBytesOut);
        long initialBytesIn = this.meterCount(bytesIn);
        long initialBytesOut = this.meterCount(bytesOut);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5());
        Assert.assertTrue((this.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assert.assertEquals((long)initialBytesOut, (long)this.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages() * 2, TestUtils$.MODULE$.consumeTopicRecords$default$4());
        Assert.assertTrue((this.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    private long meterCount(String metricName) {
        return ((Meter)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$meterCount$1(metricName, x$5))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164)))).count();
    }

    private Set<String> topicMetricGroups(String topic) {
        Regex topicMetricRegex = new Regex(".*BrokerTopicMetrics.*(" + topic + ")$", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return (Set)metricGroups.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$topicMetricGroups$1(topicMetricRegex, x$6)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$2, KafkaServer s) {
        Assert.assertNotNull((Object)s.brokerTopicStats().topicStats(topic$2));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.server:type=KafkaServer,name=ClusterId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$3, TopicPartition topicPartition$1, KafkaServer server) {
        Option log = server.logManager().logsByTopicPartition().get((Object)new TopicPartition(topic$3, 0));
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected broker ", " to have a Log for ", " with positive size, actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), topicPartition$1, logSize})), (boolean)BoxesRunTime.unboxToBoolean((Object)logSize.map((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0L).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
    }

    public static final /* synthetic */ boolean $anonfun$meterCount$1(String metricName$1, MetricName x$5) {
        return x$5.getMBeanName().endsWith(metricName$1);
    }

    public static final /* synthetic */ boolean $anonfun$topicMetricGroups$1(Regex topicMetricRegex$1, String x$6) {
        return topicMetricRegex$1.pattern().matcher(x$6).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

