/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionMetadata$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.ProducerResponseStatus;
import kafka.api.ProducerResponseStatus$;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadata$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.FailedToSendMessageException;
import kafka.common.QueueFullException;
import kafka.common.TopicAndPartition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.AsyncProducerTest$NegativePartitioner$;
import kafka.producer.KeyedMessage;
import kafka.producer.Partitioner;
import kafka.producer.Producer;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.SyncProducer;
import kafka.producer.SyncProducerConfig$;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.Encoder;
import kafka.serializer.NullEncoder;
import kafka.serializer.NullEncoder$;
import kafka.serializer.StringEncoder;
import kafka.serializer.StringEncoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.FixedValuePartitioner$;
import kafka.utils.IntEncoder;
import kafka.utils.IntEncoder$;
import kafka.utils.TestUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#Q:z]\u000e\u0004&o\u001c3vG\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005qe>$WoY3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\r\u0011!\u0002\u0001A\u000b\u0003'9+w-\u0019;jm\u0016\u0004\u0016M\u001d;ji&|g.\u001a:\u0014\u0007MAa\u0003\u0005\u0002\u0013/%\u0011\u0001D\u0001\u0002\f!\u0006\u0014H/\u001b;j_:,'\u000f\u0003\u0005\u001b'\t\u0005\t\u0015!\u0003\u001c\u0003\u0015\u0001(o\u001c9t!\tar$D\u0001\u001e\u0015\tqB!A\u0003vi&d7/\u0003\u0002!;\t!b+\u001a:jM&\f'\r\\3Qe>\u0004XM\u001d;jKNDQaD\n\u0005\u0002\t\"\"aI\u0013\u0011\u0005\u0011\u001aR\"\u0001\u0001\t\u000fi\t\u0003\u0013!a\u00017!)qe\u0005C\u0001Q\u0005I\u0001/\u0019:uSRLwN\u001c\u000b\u0004S1\n\u0004CA\u0005+\u0013\tY#BA\u0002J]RDQ!\f\u0014A\u00029\nA\u0001Z1uCB\u0011\u0011bL\u0005\u0003a)\u00111!\u00118z\u0011\u0015\u0011d\u00051\u0001*\u00035qW/\u001c)beRLG/[8og\u001e9A\u0007AA\u0001\u0012\u0003)\u0014a\u0005(fO\u0006$\u0018N^3QCJ$\u0018\u000e^5p]\u0016\u0014\bC\u0001\u00137\r\u001d!\u0002!!A\t\u0002]\u001a\"A\u000e\u0005\t\u000b=1D\u0011A\u001d\u0015\u0003UBqa\u000f\u001c\u0012\u0002\u0013\u0005A(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0002{)\u00121DP\u0016\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0012\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002G\u0003\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fi\u0001!\u0019!C\u0001\u0011V\t\u0011\nE\u0002K\u001b>k\u0011a\u0013\u0006\u0003\u0019*\t!bY8mY\u0016\u001cG/[8o\u0013\tq5JA\u0002TKF\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0006Qe>\u0004XM\u001d;jKNDa\u0001\u0017\u0001!\u0002\u0013I\u0015A\u00029s_B\u001c\b\u0005C\u0004[\u0001\t\u0007I\u0011A.\u0002\u000f\r|gNZ5hgV\tA\fE\u0002K\u001bv\u0003\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\rM,'O^3s\u0013\t\u0011wLA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u00023\u0001A\u0003%A,\u0001\u0005d_:4\u0017nZ:!\u0011\u001d1\u0007A1A\u0005\u0002\u001d\f!B\u0019:pW\u0016\u0014H*[:u+\u0005A\u0007CA5q\u001d\tQg\u000e\u0005\u0002l\u00155\tAN\u0003\u0002n\r\u00051AH]8pizJ!a\u001c\u0006\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_*Aa\u0001\u001e\u0001!\u0002\u0013A\u0017a\u00032s_.,'\u000fT5ti\u0002BQA\u001e\u0001\u0005\u0002]\fQ\u0003^3tiB\u0013x\u000eZ;dKJ\fV/Z;f'&TX\rF\u0001y!\tI\u00110\u0003\u0002{\u0015\t!QK\\5uQ\t)H\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011!\u00026v]&$(BAA\u0002\u0003\ry'oZ\u0005\u0004\u0003\u000fq(\u0001\u0002+fgRDa!a\u0003\u0001\t\u00039\u0018A\u0006;fgR\u0004&o\u001c3vG\u0016\fe\r^3s\u00072|7/\u001a3)\u0007\u0005%A\u0010\u0003\u0004\u0002\u0012\u0001!\ta^\u0001\u000ei\u0016\u001cHOQ1uG\"\u001c\u0016N_3)\u0007\u0005=A\u0010\u0003\u0004\u0002\u0018\u0001!\ta^\u0001\u0015i\u0016\u001cH/U;fk\u0016$\u0016.\\3FqBL'/\u001a3)\u0007\u0005UA\u0010\u0003\u0004\u0002\u001e\u0001!\ta^\u0001\u001ei\u0016\u001cH\u000fU1si&$\u0018n\u001c8B]\u0012\u001cu\u000e\u001c7bi\u0016,e/\u001a8ug\"\u001a\u00111\u0004?\t\r\u0005\r\u0002\u0001\"\u0001x\u0003M!Xm\u001d;TKJL\u0017\r\\5{K\u00163XM\u001c;tQ\r\t\t\u0003 \u0005\u0007\u0003S\u0001A\u0011A<\u0002)Q,7\u000f^%om\u0006d\u0017\u000e\u001a)beRLG/[8oQ\r\t9\u0003 \u0005\u0007\u0003_\u0001A\u0011A<\u0002\u0019Q,7\u000f\u001e(p\u0005J|7.\u001a:)\u0007\u00055B\u0010\u0003\u0004\u00026\u0001!\ta^\u0001\u0018i\u0016\u001cH/\u00138d_6\u0004\u0018\r^5cY\u0016,enY8eKJD3!a\r}\u0011\u0019\tY\u0004\u0001C\u0001o\u0006)B/Z:u%\u0006tGm\\7QCJ$\u0018\u000e^5p]\u0016\u0014\bfAA\u001dy\"1\u0011\u0011\t\u0001\u0005\u0002]\f\u0001\u0004^3ti\u001a\u000b\u0017\u000e\\3e'\u0016tGMU3uefdunZ5dQ\r\ty\u0004 \u0005\u0007\u0003\u000f\u0002A\u0011A<\u0002!Q,7\u000f\u001e&bm\u0006\u0004&o\u001c3vG\u0016\u0014\bfAA#y\"1\u0011Q\n\u0001\u0005\u0002]\f\u0001\u0004^3ti&sg/\u00197jI\u000e{gNZ5hkJ\fG/[8oQ\r\tY\u0005 \u0005\b\u0003'\u0002A\u0011AA+\u000399W\r\u001e)s_\u0012,8-\u001a#bi\u0006$B!a\u0016\u0002nA1\u0011\u0011LA2\u0003OrA!a\u0017\u0002`9\u00191.!\u0018\n\u0003-I1!!\u0019\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L1ATA3\u0015\r\t\tG\u0003\t\u0006%\u0005%\u0004\u000e[\u0005\u0004\u0003W\u0012!\u0001D&fs\u0016$W*Z:tC\u001e,\u0007bBA8\u0003#\u0002\r!K\u0001\b]\u00163XM\u001c;t\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\n\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0019\u0005]\u00141QAD\u0003\u0013\u000bi)!%\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \u0005\u0003\r\t\u0007/[\u0005\u0005\u0003\u0003\u000bYHA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\b\u0003\u000b\u000b\t\b1\u0001i\u0003\u0015!x\u000e]5d\u0011\u00199\u0013\u0011\u000fa\u0001S!9\u00111RA9\u0001\u0004I\u0013\u0001\u00032s_.,'/\u00133\t\u000f\u0005=\u0015\u0011\u000fa\u0001Q\u0006Q!M]8lKJDun\u001d;\t\u000f\u0005M\u0015\u0011\u000fa\u0001S\u0005Q!M]8lKJ\u0004vN\u001d;\t\u000f\u0005M\u0004\u0001\"\u0003\u0002\u0018Ra\u0011qOAM\u00037\u000by*!)\u0002$\"9\u0011QQAK\u0001\u0004A\u0007bB\u0014\u0002\u0016\u0002\u0007\u0011Q\u0014\t\u0006\u00033\n\u0019'\u000b\u0005\b\u0003\u0017\u000b)\n1\u0001*\u0011\u001d\ty)!&A\u0002!Dq!a%\u0002\u0016\u0002\u0007\u0011\u0006C\u0004\u0002(\u0002!\t!!+\u0002\u001b5,7o]1hKN$vnU3u)\u0011\tY+a.\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-\u0005\u0003\u001diWm]:bO\u0016LA!!.\u00020\n!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRD\u0001\"!/\u0002&\u0002\u0007\u00111X\u0001\t[\u0016\u001c8/Y4fgB)\u0011\u0011LA2Q\"9\u0011q\u0015\u0001\u0005\u0002\u0005}FCBAV\u0003\u0003\f\t\u000e\u0003\u0005\u0002D\u0006u\u0006\u0019AAc\u0003\rYW-\u001f\t\u0006\u0013\u0005\u001d\u00171Z\u0005\u0004\u0003\u0013T!!B!se\u0006L\bcA\u0005\u0002N&\u0019\u0011q\u001a\u0006\u0003\t\tKH/\u001a\u0005\t\u0003s\u000bi\f1\u0001\u0002TB1\u0011\u0011LA2\u0003\u000bDs\u0001AAl\u0003;\f\t\u000fE\u0002\n\u00033L1!a7\u000b\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003?\f\u0011\n\u00165jg\u0002\"Xm\u001d;!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004\u0013\u000e\u001e\u0011xS2d\u0007EY3!e\u0016lwN^3eA%t\u0007%\u0019\u0011gkR,(/\u001a\u0011sK2,\u0017m]3/C\t\t\u0019/\u0001\u00051]E\u0002d\u0006\r\u00181\u0001")
public class AsyncProducerTest {
    private volatile AsyncProducerTest$NegativePartitioner$ NegativePartitioner$module;
    private final Seq<Properties> props;
    private final Seq<KafkaConfig> configs;
    private final String brokerList;

    public AsyncProducerTest$NegativePartitioner$ NegativePartitioner() {
        if (this.NegativePartitioner$module == null) {
            this.NegativePartitioner$lzycompute$1();
        }
        return this.NegativePartitioner$module;
    }

    public Seq<Properties> props() {
        return this.props;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String brokerList() {
        return this.brokerList;
    }

    @Test
    public void testProducerQueueSize() {
        EventHandler<String, String> mockEventHandler = new EventHandler<String, String>(null){

            public void handle(Seq<KeyedMessage<String, String>> events) {
                Thread.sleep(500L);
            }

            public void close() {
            }
        };
        Properties props = new Properties();
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("metadata.broker.list", this.brokerList());
        props.put("producer.type", "async");
        props.put("queue.buffering.max.messages", "10");
        props.put("batch.num.messages", "1");
        props.put("queue.enqueue.timeout.ms", "0");
        ProducerConfig config = new ProducerConfig(props);
        Seq<KeyedMessage<String, String>> produceData = this.getProduceData(12);
        try (Producer producer = new Producer(config, (EventHandler)mockEventHandler);){
            try {
                producer.send(produceData);
                throw TestUtils$.MODULE$.fail("Queue should be full");
            }
            catch (QueueFullException queueFullException) {
            }
        }
    }

    @Test
    public void testProduceAfterClosed() {
        Seq<KeyedMessage<String, String>> produceData = this.getProduceData(10);
        Producer producer = TestUtils$.MODULE$.createProducer(this.brokerList(), StringEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5());
        producer.close();
        try {
            producer.send(produceData);
            throw TestUtils$.MODULE$.fail("should complain that producer is already closed");
        }
        catch (ProducerClosedException producerClosedException) {
            return;
        }
    }

    @Test
    public void testBatchSize() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(10);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle((Seq)producerDataList.take(5));
        EasyMock.expectLastCall();
        mockHandler.handle((Seq)producerDataList.takeRight(5));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, Integer.MAX_VALUE, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1 & Serializable & scala.Serializable)producerData -> {
            queue.put(producerData);
            return BoxedUnit.UNIT;
        });
        producerSendThread.shutdown();
        EasyMock.verify((Object[])new Object[]{mockHandler});
    }

    @Test
    public void testQueueTimeExpired() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(2);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle(producerDataList);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        int queueExpirationTime = 200;
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, (long)queueExpirationTime, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1 & Serializable & scala.Serializable)producerData -> {
            queue.put(producerData);
            return BoxedUnit.UNIT;
        });
        Thread.sleep(queueExpirationTime + 100);
        EasyMock.verify((Object[])new Object[]{mockHandler});
        producerSendThread.shutdown();
    }

    @Test
    public void testPartitionAndCollateEvents() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        BrokerEndPoint broker1 = new BrokerEndPoint(0, "localhost", 9092);
        BrokerEndPoint broker2 = new BrokerEndPoint(1, "localhost", 9093);
        PartitionMetadata partition1Metadata = new PartitionMetadata(0, (Option)new Some((Object)broker1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        PartitionMetadata partition2Metadata = new PartitionMetadata(1, (Option)new Some((Object)broker2), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        TopicMetadata topic2Metadata = new TopicMetadata("topic2", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
        Partitioner intPartitioner = new Partitioner(null){

            public int partition(Object key, int numPartitions) {
                return BoxesRunTime.unboxToInt((Object)key) % numPartitions;
            }
        };
        ProducerConfig config = new ProducerConfig(props);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, intPartitioner, null, (Encoder)new IntEncoder(IntEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        ArrayBuffer topic1Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes())), new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        ArrayBuffer topic1Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        ArrayBuffer topic2Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        ArrayBuffer topic2Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        Some expectedResult = new Some((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)topic1Broker1Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)topic2Broker1Data)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)topic1Broker2Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)topic2Broker2Data)})))})));
        Option actualResult = handler.partitionAndCollate((Seq)producerDataList);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testSerializeEvents() {
        Seq produceData = (Seq)TestUtils$.MODULE$.getMsgStrings(5).map((Function1 & Serializable & scala.Serializable)m -> new KeyedMessage("topic1", m), Seq$.MODULE$.canBuildFrom());
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        Seq serializedData = handler.serialize(produceData);
        Seq deserializedData = (Seq)serializedData.map((Function1 & Serializable & scala.Serializable)d -> new KeyedMessage(d.topic(), (Object)TestUtils$.MODULE$.readString(((Message)d.message()).payload(), TestUtils$.MODULE$.readString$default$2())), Seq$.MODULE$.canBuildFrom());
        Seq streamedSerializedData = handler.serialize((Seq)package$.MODULE$.Stream().apply(produceData));
        Seq deserializedStreamData = (Seq)streamedSerializedData.map((Function1 & Serializable & scala.Serializable)d -> new KeyedMessage(d.topic(), (Object)TestUtils$.MODULE$.readString(((Message)d.message()).payload(), TestUtils$.MODULE$.readString$default$2())), Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.checkEquals(produceData.iterator(), deserializedData.iterator());
        TestUtils$.MODULE$.checkEquals(produceData.iterator(), deserializedStreamData.iterator());
    }

    @Test
    public void testInvalidPartition() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"key1", (Object)new Message("msg1".getBytes()))}));
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new NegativePartitioner(this.NegativePartitioner().$lessinit$greater$default$1()), null, null, producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        try {
            handler.partitionAndCollate((Seq)producerDataList);
        }
        catch (Throwable throwable) {
            throw TestUtils$.MODULE$.fail("Should not throw any exception");
        }
    }

    @Test
    public void testNoBroker() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)Seq$.MODULE$.empty(), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"msg1")}));
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        try {
            handler.handle((Seq)producerDataList);
            throw TestUtils$.MODULE$.fail("Should fail with FailedToSendMessageException");
        }
        catch (FailedToSendMessageException failedToSendMessageException) {
            return;
        }
    }

    @Test
    public void testIncompatibleEncoder() {
        Properties props = new Properties();
        props.put("message.send.max.retries", "0");
        String x$19 = this.brokerList();
        String x$20 = DefaultEncoder.class.getName();
        String x$21 = DefaultEncoder.class.getName();
        Properties x$22 = props;
        String x$23 = TestUtils$.MODULE$.createProducer$default$4();
        try (Producer producer = TestUtils$.MODULE$.createProducer(x$19, x$20, x$21, x$23, x$22);){
            try {
                producer.send(this.getProduceData(1));
                throw TestUtils$.MODULE$.fail("Should fail with ClassCastException due to incompatible Encoder");
            }
            catch (ClassCastException classCastException) {
            }
        }
    }

    @Test
    public void testRandomPartitioner() {
        Option partitionedDataOpt;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        TopicMetadata topic2Metadata = this.getTopicMetadata("topic2", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, null, null, null, producerPool, topicPartitionInfos, DefaultEventHandler$.MODULE$.$lessinit$greater$default$7());
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg1".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)new Message("msg2".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg3".getBytes()))}));
        Option option = partitionedDataOpt = handler.partitionAndCollate((Seq)producerDataList);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw TestUtils$.MODULE$.fail("Failed to collate requests by topic, partition");
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Map partitionedData = (Map)some.value();
        partitionedData.values().foreach((Function1 & Serializable & scala.Serializable)dataPerBroker -> {
            AsyncProducerTest.$anonfun$testRandomPartitioner$1(dataPerBroker);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Test
    public void testFailedSendRetryLogic() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        props.put("request.required.acks", "1");
        props.put("serializer.class", StringEncoder.class.getName().toString());
        props.put("key.serializer.class", NullEncoder.class.getName().toString());
        props.put("producer.num.retries", ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        ProducerConfig config = new ProducerConfig(props);
        String topic1 = "topic1";
        TopicMetadata topic1Metadata = this.getTopicMetadata(topic1, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(2);
        List x$24 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$25 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$26 = this.messagesToSet(msgs);
        int x$27 = 1;
        int x$28 = 11;
        int x$29 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$30 = SyncProducerConfig$.MODULE$.DefaultClientId();
        ProducerRequest request1 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$24, (Seq<Object>)x$25, x$26, x$27, x$29, x$28, x$30);
        List x$31 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$32 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$33 = this.messagesToSet(msgs);
        int x$34 = 1;
        int x$35 = 17;
        int x$36 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$37 = SyncProducerConfig$.MODULE$.DefaultClientId();
        ProducerRequest request2 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$31, (Seq<Object>)x$32, x$33, x$34, x$36, x$35, x$37);
        ProducerResponse response1 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(Errors.NOT_LEADER_FOR_PARTITION, 0L, ProducerResponseStatus$.MODULE$.apply$default$3())), new Tuple2((Object)new TopicAndPartition("topic1", 1), (Object)new ProducerResponseStatus(Errors.NONE, 0L, ProducerResponseStatus$.MODULE$.apply$default$3()))})), ProducerResponse$.MODULE$.apply$default$3(), ProducerResponse$.MODULE$.apply$default$4());
        String x$38 = topic1;
        int x$39 = 0;
        ByteBufferMessageSet x$40 = this.messagesToSet(msgs);
        int x$41 = 1;
        int x$42 = 21;
        int x$43 = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        String x$44 = SyncProducerConfig$.MODULE$.DefaultClientId();
        ProducerRequest request3 = TestUtils$.MODULE$.produceRequest(x$38, x$39, x$40, x$41, x$43, x$42, x$44);
        ProducerResponse response2 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(Errors.NONE, 0L, ProducerResponseStatus$.MODULE$.apply$default$3()))})), ProducerResponse$.MODULE$.apply$default$3(), ProducerResponse$.MODULE$.apply$default$4());
        SyncProducer mockSyncProducer = (SyncProducer)EasyMock.createMock(SyncProducer.class);
        EasyMock.expect((Object)mockSyncProducer.config()).andReturn(EasyMock.anyObject()).anyTimes();
        EasyMock.expect((Object)mockSyncProducer.send(request1)).andThrow((Throwable)new RuntimeException());
        EasyMock.expect((Object)mockSyncProducer.send(request2)).andReturn((Object)response1);
        EasyMock.expect((Object)mockSyncProducer.send(request3)).andReturn((Object)response2);
        EasyMock.replay((Object[])new Object[]{mockSyncProducer});
        ProducerPool producerPool = (ProducerPool)EasyMock.createMock(ProducerPool.class);
        EasyMock.expect((Object)producerPool.getProducer(0)).andReturn((Object)mockSyncProducer).times(4);
        producerPool.close();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{producerPool});
        Time time = new Time(null){

            public long nanoseconds() {
                return 0L;
            }

            public long milliseconds() {
                return 0L;
            }

            public void sleep(long ms) {
            }

            public long hiResClockMs() {
                return 0L;
            }
        };
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new FixedValuePartitioner(FixedValuePartitioner$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new NullEncoder(NullEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos, time);
        Seq data = (Seq)((TraversableLike)msgs.map((Function1 & Serializable & scala.Serializable)m -> new KeyedMessage(topic1, (Object)BoxesRunTime.boxToInteger((int)0), m), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)msgs.map((Function1 & Serializable & scala.Serializable)m -> new KeyedMessage(topic1, (Object)BoxesRunTime.boxToInteger((int)1), m), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        handler.handle(data);
        handler.close();
        EasyMock.verify((Object[])new Object[]{mockSyncProducer});
        EasyMock.verify((Object[])new Object[]{producerPool});
    }

    @Test
    public void testJavaProducer() {
        String topic = "topic1";
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(5);
        Seq scalaProducerData = (Seq)msgs.map((Function1 & Serializable & scala.Serializable)m -> new KeyedMessage(topic, m), Seq$.MODULE$.canBuildFrom());
        java.util.List javaProducerData = JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(scalaProducerData);
        Producer mockScalaProducer = (Producer)EasyMock.createMock(Producer.class);
        mockScalaProducer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{(KeyedMessage)scalaProducerData.head()}));
        EasyMock.expectLastCall();
        mockScalaProducer.send(scalaProducerData);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockScalaProducer});
        kafka.javaapi.producer.Producer javaProducer = new kafka.javaapi.producer.Producer(mockScalaProducer);
        javaProducer.send((KeyedMessage)javaProducerData.get(0));
        javaProducer.send(javaProducerData);
        EasyMock.verify((Object[])new Object[]{mockScalaProducer});
    }

    @Test
    public void testInvalidConfiguration() {
        Properties props = new Properties();
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("producer.type", "async");
        try {
            new ProducerConfig(props);
            throw TestUtils$.MODULE$.fail("should complain about wrong config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Seq<KeyedMessage<String, String>> getProduceData(int nEvents) {
        void var2_2;
        ArrayBuffer producerDataList = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nEvents).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", null, (Object)("msg" + i))})));
        return var2_2;
    }

    private TopicMetadata getTopicMetadata(String topic, int partition, int brokerId, String brokerHost, int brokerPort) {
        return this.getTopicMetadata(topic, (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition})), brokerId, brokerHost, brokerPort);
    }

    private TopicMetadata getTopicMetadata(String topic, Seq<Object> partition, int brokerId, String brokerHost, int brokerPort) {
        BrokerEndPoint broker1 = new BrokerEndPoint(brokerId, brokerHost, brokerPort);
        return new TopicMetadata(topic, (Seq)partition.map((Function1 & Serializable & scala.Serializable)x$2 -> AsyncProducerTest.$anonfun$getTopicMetadata$1(broker1, BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom()), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public ByteBufferMessageSet messagesToSet(Seq<String> messages) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages.map((Function1 & Serializable & scala.Serializable)m -> new Message(m.getBytes(), 0L, Message$.MODULE$.MagicValue_V1()), Seq$.MODULE$.canBuildFrom()));
    }

    public ByteBufferMessageSet messagesToSet(byte[] key, Seq<byte[]> messages) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages.map((Function1 & Serializable & scala.Serializable)m -> {
            byte[] x$45 = key;
            byte[] x$46 = m;
            long x$47 = 0L;
            byte x$48 = Message$.MODULE$.MagicValue_V1();
            return new Message(x$46, x$45, x$47, x$48);
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private final void NegativePartitioner$lzycompute$1() {
        AsyncProducerTest asyncProducerTest = this;
        synchronized (asyncProducerTest) {
            if (this.NegativePartitioner$module == null) {
                this.NegativePartitioner$module = new AsyncProducerTest$NegativePartitioner$(null);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$brokerList$2(EndPoint x$1) {
        SecurityProtocol securityProtocol = x$1.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ void $anonfun$testRandomPartitioner$2(TopicAndPartition tp) {
        Assert.assertTrue((tp.partition() == 0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testRandomPartitioner$1(scala.collection.mutable.Map dataPerBroker) {
        dataPerBroker.keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AsyncProducerTest.$anonfun$testRandomPartitioner$2(tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ PartitionMetadata $anonfun$getTopicMetadata$1(BrokerEndPoint broker1$1, int x$2) {
        return new PartitionMetadata(x$2, (Option)new Some((Object)broker1$1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{broker1$1})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
    }

    public AsyncProducerTest() {
        Properties[] propertiesArray = new Properties[1];
        int x$3 = 1;
        String x$4 = "127.0.0.1:1";
        int x$5 = 65534;
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$18 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        propertiesArray[0] = TestUtils$.MODULE$.createBrokerConfig(x$3, x$4, x$6, x$7, x$5, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        this.props = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])propertiesArray));
        this.configs = (Seq)this.props().map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.brokerList = ((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)config -> {
            EndPoint endPoint = (EndPoint)config.advertisedListeners().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AsyncProducerTest.$anonfun$brokerList$2(x$1))).get();
            return Utils.formatAddress((String)endPoint.host(), (Integer)Predef$.MODULE$.int2Integer(endPoint.port()));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public class NegativePartitioner
    implements Partitioner {
        public int partition(Object data, int numPartitions) {
            return -1;
        }

        public /* synthetic */ AsyncProducerTest kafka$producer$AsyncProducerTest$NegativePartitioner$$$outer() {
            return AsyncProducerTest.this;
        }

        public NegativePartitioner(VerifiableProperties props) {
            if (AsyncProducerTest.this == null) {
                throw null;
            }
        }
    }
}

