/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Properties;
import java.util.UUID;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u0001%\u0011qcU5na2,\u0017i\u00197BkRDwN]5{KJ$Vm\u001d;\u000b\u0005\r!\u0011\u0001B1vi\"T!!\u0002\u0004\u0002\u0011M,7-\u001e:jifT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tAB\u0003\u0002\u000e\r\u0005\u0011!p[\u0005\u0003\u001f1\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\u0002]\t1c]5na2,\u0017i\u00197BkRDwN]5{KJ,\u0012\u0001\u0007\t\u0003)eI!A\u0007\u0002\u0003'MKW\u000e\u001d7f\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\t\rq\u0001\u0001\u0015!\u0003\u0019\u0003Q\u0019\u0018.\u001c9mK\u0006\u001bG.Q;uQ>\u0014\u0018N_3sA!9a\u0004\u0001b\u0001\n\u00039\u0012\u0001F:j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014(\u0007\u0003\u0004!\u0001\u0001\u0006I\u0001G\u0001\u0016g&l\u0007\u000f\\3BG2\fU\u000f\u001e5pe&TXM\u001d\u001a!\u0011\u001d\u0011\u0003A1A\u0005\u0002\r\nQ\u0002^3tiB\u0013\u0018N\\2ja\u0006dW#\u0001\u0013\u0011\u0005\u0015zS\"\u0001\u0014\u000b\u0005\r9#BA\u0003)\u0015\tI#&\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f-R!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO&\u0011\u0001G\n\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011\u0019\u0011\u0004\u0001)A\u0005I\u0005qA/Z:u!JLgnY5qC2\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%\t!N\u0001\ri\u0016\u001cH\u000fS8ti:\u000bW.Z\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0004]\u0016$(\"A\u001e\u0002\t)\fg/Y\u0005\u0003{a\u00121\"\u00138fi\u0006#GM]3tg\"1q\b\u0001Q\u0001\nY\nQ\u0002^3ti\"{7\u000f\u001e(b[\u0016\u0004\u0003bB!\u0001\u0005\u0004%\tAQ\u0001\bg\u0016\u001c8/[8o+\u0005\u0019\u0005C\u0001#Q\u001d\t)UJ\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nC\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!\u0001\u0014\u0004\u0002\u000f9,Go^8sW&\u0011ajT\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0015\tae!\u0003\u0002R%\n91+Z:tS>t'B\u0001(P\u0011\u0019!\u0006\u0001)A\u0005\u0007\u0006A1/Z:tS>t\u0007\u0005C\u0004W\u0001\u0001\u0007I\u0011A,\u0002\u0011I,7o\\;sG\u0016,\u0012\u0001\u0017\t\u0003)eK!A\u0017\u0002\u0003\u0011I+7o\\;sG\u0016Dq\u0001\u0018\u0001A\u0002\u0013\u0005Q,\u0001\u0007sKN|WO]2f?\u0012*\u0017\u000f\u0006\u0002_IB\u0011qLY\u0007\u0002A*\t\u0011-A\u0003tG\u0006d\u0017-\u0003\u0002dA\n!QK\\5u\u0011\u001d)7,!AA\u0002a\u000b1\u0001\u001f\u00132\u0011\u00199\u0007\u0001)Q\u00051\u0006I!/Z:pkJ\u001cW\r\t\u0005\bS\u0002\u0011\r\u0011\"\u0001k\u0003)\u0019X\u000f]3s+N,'o]\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011aNO\u0001\u0005Y\u0006tw-\u0003\u0002q[\n11\u000b\u001e:j]\u001eDaA\u001d\u0001!\u0002\u0013Y\u0017aC:va\u0016\u0014Xk]3sg\u0002Bq\u0001\u001e\u0001C\u0002\u0013\u0005!.\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u00191\b\u0001)A\u0005W\u0006IQo]3s]\u0006lW\r\t\u0005\bq\u0002\u0001\r\u0011\"\u0001z\u0003\u0019\u0019wN\u001c4jOV\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~\r\u000511/\u001a:wKJL!a ?\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0001\u0003\u000b\t!bY8oM&<w\fJ3r)\rq\u0016q\u0001\u0005\tK\u0006\u0005\u0011\u0011!a\u0001u\"9\u00111\u0002\u0001!B\u0013Q\u0018aB2p]\u001aLw\r\t\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0003\u0015\u0019X\r^+q)\u0005q\u0006\u0006BA\u0007\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037i\u0013!\u00026v]&$\u0018\u0002BA\u0010\u00033\u0011aAQ3g_J,\u0007bBA\u0012\u0001\u0011\u0005\u0013\u0011C\u0001\ti\u0016\f'\u000fR8x]\"\"\u0011\u0011EA\u0014!\u0011\t9\"!\u000b\n\t\u0005-\u0012\u0011\u0004\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003_\u0001A\u0011AA\t\u00031!Xm\u001d;U_BL7-Q2mQ\u0011\ti#a\r\u0011\t\u0005]\u0011QG\u0005\u0005\u0003o\tIB\u0001\u0003UKN$\bbBA\u001e\u0001\u0011\u0005\u0011\u0011C\u0001\u0018i\u0016\u001cH\u000fR3osR\u000b7.Z:Qe\u0016\u001cW\rZ3oG\u0016DC!!\u000f\u00024!9\u0011\u0011\t\u0001\u0005\u0002\u0005E\u0011A\u0005;fgR\fE\u000e\\8x\u00032d\u0017iY2fgNDC!a\u0010\u00024!9\u0011q\t\u0001\u0005\u0002\u0005E\u0011A\u0006;fgR\u001cV\u000f]3s+N,'\u000fS1t\u0003\u000e\u001cWm]:)\t\u0005\u0015\u00131\u0007\u0005\b\u0003\u001b\u0002A\u0011AA\t\u0003A!Xm\u001d;XS2$7)\u0019:e\u0003\u000ed7\u000f\u000b\u0003\u0002L\u0005M\u0002bBA*\u0001\u0011\u0005\u0011\u0011C\u0001\u000fi\u0016\u001cHOT8BG24u.\u001e8eQ\u0011\t\t&a\r\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\u0012\u00051B/Z:u\u001d>\f5\r\u001c$pk:$wJ^3se&$W\r\u000b\u0003\u0002X\u0005M\u0002bBA0\u0001\u0011\u0005\u0011\u0011C\u0001\u0016i\u0016\u001cH/Q2m\u001b\u0006t\u0017mZ3nK:$\u0018\tU%tQ\u0011\ti&a\r\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002\u0012\u0005iA/Z:u\u0019>\fGmQ1dQ\u0016DC!a\u0019\u00024!9\u00111\u000e\u0001\u0005\u0002\u0005E\u0011!\f;fgRdunY1m\u0007>t7-\u001e:sK:$Xj\u001c3jM&\u001c\u0017\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\"\u0011\u0011NA\u001a\u0011\u001d\t\t\b\u0001C\u0001\u0003#\t1\u0007^3ti\u0012K7\u000f\u001e:jEV$X\rZ\"p]\u000e,(O]3oi6{G-\u001b4jG\u0006$\u0018n\u001c8PMJ+7o\\;sG\u0016\f5\r\\:)\t\u0005=\u00141\u0007\u0005\b\u0003o\u0002A\u0011AA\t\u00035\"Xm\u001d;IS\u001eD7i\u001c8dkJ\u0014XM\\2z\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0005\u0003k\n\u0019\u0004C\u0004\u0002~\u0001!\t!!\u0005\u0002%Q,7\u000f^!dY&s\u0007.\u001a:ji\u0006t7-\u001a\u0015\u0005\u0003w\n\u0019\u0004C\u0004\u0002\u0004\u0002!I!!\"\u0002/Q,7\u000f^%na2L7-\u0019;j_:\u001cxJZ!mY><H#\u00020\u0002\b\u0006E\u0005\u0002CAE\u0003\u0003\u0003\r!a#\u0002\u0011A\f'/\u001a8u\u001fB\u00042\u0001FAG\u0013\r\tyI\u0001\u0002\n\u001fB,'/\u0019;j_:D\u0001\"a%\u0002\u0002\u0002\u0007\u0011QS\u0001\u000bC2dwn^3e\u001fB\u001c\bCBAL\u0003?\u000bYI\u0004\u0003\u0002\u001a\u0006m\u0005CA$a\u0013\r\ti\nY\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00161\u0015\u0002\u0004'\u0016$(bAAOA\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0016A\u0006;fgRLU\u000e\u001d7jG\u0006$\u0018n\u001c8t\u001f\u001a$UM\\=\u0015\u000by\u000bY+!,\t\u0011\u0005%\u0015Q\u0015a\u0001\u0003\u0017C\u0001\"a,\u0002&\u0002\u0007\u0011QS\u0001\nI\u0016t\u0017.\u001a3PaNDq!a-\u0001\t\u0003\t\t\"A\u0015uKN$\b*[4i\u0007>t7-\u001e:sK:\u001c\u0017\u0010R3mKRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0005\u0003c\u000b\u0019\u0004C\u0004\u0002:\u0002!I!a/\u0002%\rD\u0017M\\4f\u0003\u000ed\u0017I\u001c3WKJLg-\u001f\u000b\u000b\u0003{\u000b)-!3\u0002N\u0006E\u0007CBAL\u0003?\u000by\fE\u0002\u0015\u0003\u0003L1!a1\u0003\u0005\r\t5\r\u001c\u0005\t\u0003\u000f\f9\f1\u0001\u0002>\u0006aqN]5hS:\fG.Q2mg\"A\u00111ZA\\\u0001\u0004\ti,A\u0005bI\u0012,G-Q2mg\"A\u0011qZA\\\u0001\u0004\ti,A\u0006sK6|g/\u001a3BG2\u001c\b\u0002\u0003,\u00028B\u0005\t\u0019\u0001-\t\u0013\u0005U\u0007!%A\u0005\n\u0005]\u0017\u0001H2iC:<W-Q2m\u0003:$g+\u001a:jMf$C-\u001a4bk2$H\u0005N\u000b\u0003\u00033T3\u0001WAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAtA\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SimpleAclAuthorizerTest
extends ZooKeeperTestHarness {
    private final SimpleAclAuthorizer simpleAclAuthorizer = new SimpleAclAuthorizer();
    private final SimpleAclAuthorizer simpleAclAuthorizer2 = new SimpleAclAuthorizer();
    private final KafkaPrincipal testPrincipal = Acl$.MODULE$.WildCardPrincipal();
    private final InetAddress testHostName = InetAddress.getByName("192.168.0.1");
    private final RequestChannel.Session session = new RequestChannel.Session(this.testPrincipal(), this.testHostName());
    private Resource resource = null;
    private final String superUsers;
    private final String username;
    private KafkaConfig config = null;

    public SimpleAclAuthorizer simpleAclAuthorizer() {
        return this.simpleAclAuthorizer;
    }

    public SimpleAclAuthorizer simpleAclAuthorizer2() {
        return this.simpleAclAuthorizer2;
    }

    public KafkaPrincipal testPrincipal() {
        return this.testPrincipal;
    }

    public InetAddress testHostName() {
        return this.testHostName;
    }

    public RequestChannel.Session session() {
        return this.session;
    }

    public Resource resource() {
        return this.resource;
    }

    public void resource_$eq(Resource x$1) {
        this.resource = x$1;
    }

    public String superUsers() {
        return this.superUsers;
    }

    public String username() {
        return this.username;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.simpleAclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.simpleAclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
        this.simpleAclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString()));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleAclAuthorizer().close();
        this.simpleAclAuthorizer2().close();
        super.tearDown();
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        Acl acl5 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl acl6 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        Acl acl7 = new Acl(user3, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session(user1, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Alter$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Alter$.MODULE$, this.resource()));
        RequestChannel.Session user2Session = new RequestChannel.Session(user2, host1);
        RequestChannel.Session user3Session = new RequestChannel.Session(user3, host1);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestChannel.Session session = new RequestChannel.Session(user, host);
        Acl allowAll = Acl$.MODULE$.AllowAllAcl();
        Acl denyAcl = new Acl(user, (PermissionType)Deny$.MODULE$, host.getHostAddress(), (Operation)All$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testAllowAllAccess() {
        Acl allowAllAcl = Acl$.MODULE$.AllowAllAcl();
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session1 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        RequestChannel.Session session2 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session1, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session2, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        Acl readAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Resource wildCardResource = new Resource(this.resource().resourceType(), Resource$.MODULE$.WildCardResource());
        Set<Acl> acls = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{readAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), wildCardResource);
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Assert.assertTrue((String)"User1 should have Read access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Acl writeAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Acl denyWriteOnWildCardResourceAcl = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify(acls, (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyWriteOnWildCardResourceAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), wildCardResource);
        Assert.assertFalse((String)"User1 should not have Write access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (SimpleAclAuthorizer testAuthorizer = new SimpleAclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should fail open with allow.everyone = true.", (boolean)testAuthorizer.authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        }
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Write$.MODULE$);
        Acl acl3 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Write$.MODULE$);
        ObjectRef acls = ObjectRef.create(this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4()));
        Acl acl5 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl5}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})))}));
            Map map = this.simpleAclAuthorizer().getAcls(user1);
            return !(genMap != null ? !genMap.equals(map) : map != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3, acl4, acl5})))}));
            Map map = this.simpleAclAuthorizer().getAcls(user2);
            return !(genMap != null ? !genMap.equals(map) : map != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Topic$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Cluster$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)((Set)acls.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, "test-ConsumerGroup")), (Object)((Set)acls.elem))}));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Resource key = (Resource)tuple2._1();
            Set value = (Set)tuple2._2();
            Set<Acl> set = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)value, (Set<Acl>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map map = resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)((Set)acls$1.elem)));
            Map map2 = this.simpleAclAuthorizer().getAcls();
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        Assert.assertTrue((!this.zkUtils().pathExists(this.simpleAclAuthorizer().toResourcePath(this.resource())) ? 1 : 0) != 0);
        acls.elem = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)acls.elem), this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkUtils().pathExists(this.simpleAclAuthorizer().toResourcePath(this.resource())) ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, "host-1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}));
        this.simpleAclAuthorizer().addAcls(acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, "test-2");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, "host3", (Operation)Read$.MODULE$);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2}));
        this.simpleAclAuthorizer().addAcls(acls1, resource1);
        this.zkUtils().deletePathRecursive(SimpleAclAuthorizer$.MODULE$.AclChangedZkPath());
        try (SimpleAclAuthorizer authorizer = new SimpleAclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, (Object)authorizer.getAcls(this.resource()));
            Assert.assertEquals((Object)acls1, (Object)authorizer.getAcls(resource1));
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        Acl acl3 = new Acl(user3, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        boolean deleted = this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test");
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)acl -> (Function0 & Serializable & scala.Serializable)() -> {
            int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
            if (aclId % 2 == 0) {
                this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            } else {
                this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            }
            return aclId % 10 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource)) : BoxedUnit.UNIT;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)acls.filter((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(acl)))).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Read$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Write$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Delete$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Alter$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)Describe$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow((Operation)AlterConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{DescribeConfigs$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)DescribeConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(Operation parentOp, Set<Operation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session hostSession = new RequestChannel.Session(user, host);
        Acl acl = new Acl(user, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfAllow$1(this, parentOp, allowedOps, hostSession, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
    }

    private void testImplicationsOfDeny(Operation parentOp, Set<Operation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user1, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp), new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)}));
        this.simpleAclAuthorizer().addAcls(acls, Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfDeny$1(this, parentOp, deniedOps, host1Session, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls(acls, Resource$.MODULE$.ClusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        Acl acl = new Acl(new KafkaPrincipal("User", this.username()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$1 -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer2(), this.resource());
    }

    private Set<Acl> changeAclAndVerify(Set<Acl> originalAcls, Set<Acl> addedAcls, Set<Acl> removedAcls, Resource resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().addAcls(addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().removeAcls(removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.simpleAclAuthorizer(), resource);
        return acls;
    }

    private Resource changeAclAndVerify$default$4() {
        return this.resource();
    }

    public static final /* synthetic */ Acl $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        return new Acl(useri, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Acl acl) {
        int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
        return aclId % 10 != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$1(SimpleAclAuthorizerTest $this, Operation parentOp$1, Set allowedOps$1, RequestChannel.Session hostSession$1, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(hostSession$1, op, Resource$.MODULE$.ClusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                Operation operation2 = parentOp$1;
                if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
            }
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW ", " should imply ALLOW ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentOp$1, op})), (boolean)authorized);
            return;
        }
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW ", " should not imply ALLOW ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentOp$1, op})), (boolean)authorized);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$1(SimpleAclAuthorizerTest $this, Operation parentOp$2, Set deniedOps$1, RequestChannel.Session host1Session$1, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(host1Session$1, op, Resource$.MODULE$.ClusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                Operation operation2 = parentOp$2;
                if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
            }
            Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DENY ", " should imply DENY ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentOp$2, op})), (boolean)authorized);
            return;
        }
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DENY ", " should not imply DENY ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentOp$2, op})), (boolean)authorized);
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(SimpleAclAuthorizerTest $this, Acl acl$1, int x$1) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$1})), $this.resource());
            return $this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$1})), $this.resource());
        };
    }

    public SimpleAclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }
}

