/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.minikdc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import kafka.security.minikdc.MiniKdc$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.loader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.kafka.common.utils.Java;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0001\u0003\u0001%\u0011q!T5oS.#7M\u0003\u0002\u0004\t\u00059Q.\u001b8jW\u0012\u001c'BA\u0003\u0007\u0003!\u0019XmY;sSRL(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0003\t\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g!\t\tB#D\u0001\u0013\u0015\t\u0019b!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\r\r|gNZ5h!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003vi&d'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013aB<pe.$\u0015N\u001d\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003Kq\t!![8\n\u0005\u001d\"#\u0001\u0002$jY\u0016DQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDcA\u0016.]A\u0011A\u0006A\u0007\u0002\u0005!)q\u0003\u000ba\u00011!)\u0011\u0005\u000ba\u0001E!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0014aB8sO:\u000bW.Z\u000b\u0002eA\u00111GN\u0007\u0002i)\u0011Q\u0007H\u0001\u0005Y\u0006tw-\u0003\u00028i\t11\u000b\u001e:j]\u001eDa!\u000f\u0001!\u0002\u0013\u0011\u0014\u0001C8sO:\u000bW.\u001a\u0011\t\u000fm\u0002!\u0019!C\u0005c\u0005IqN]4E_6\f\u0017N\u001c\u0005\u0007{\u0001\u0001\u000b\u0011\u0002\u001a\u0002\u0015=\u0014x\rR8nC&t\u0007\u0005C\u0004@\u0001\t\u0007I\u0011\u0002!\u0002\u000bI,\u0017\r\\7\u0016\u0003\u0005\u0003\"AQ%\u000f\u0005\r;\u0005C\u0001#\r\u001b\u0005)%B\u0001$\t\u0003\u0019a$o\\8u}%\u0011\u0001\nD\u0001\u0007!J,G-\u001a4\n\u0005]R%B\u0001%\r\u0011\u0019a\u0005\u0001)A\u0005\u0003\u00061!/Z1m[\u0002BqA\u0014\u0001C\u0002\u0013%q*\u0001\u0005le\n,4m\u001c8g+\u0005\u0011\u0003BB)\u0001A\u0003%!%A\u0005le\n,4m\u001c8gA!91\u000b\u0001a\u0001\n\u0013!\u0016!B0q_J$X#A+\u0011\u0005-1\u0016BA,\r\u0005\rIe\u000e\u001e\u0005\b3\u0002\u0001\r\u0011\"\u0003[\u0003%y\u0006o\u001c:u?\u0012*\u0017\u000f\u0006\u0002\\=B\u00111\u0002X\u0005\u0003;2\u0011A!\u00168ji\"9q\fWA\u0001\u0002\u0004)\u0016a\u0001=%c!1\u0011\r\u0001Q!\nU\u000baa\u00189peR\u0004\u0003bB2\u0001\u0001\u0004%I\u0001Z\u0001\u0003IN,\u0012!\u001a\t\u0003MNl\u0011a\u001a\u0006\u0003Q&\f1!\u00199j\u0015\tQ7.\u0001\u0003d_J,'B\u00017n\u0003\u0019\u0019XM\u001d<fe*\u0011an\\\u0001\nI&\u0014Xm\u0019;pefT!\u0001]9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0018aA8sO&\u0011Ao\u001a\u0002\u0011\t&\u0014Xm\u0019;pef\u001cVM\u001d<jG\u0016DqA\u001e\u0001A\u0002\u0013%q/\u0001\u0004eg~#S-\u001d\u000b\u00037bDqaX;\u0002\u0002\u0003\u0007Q\r\u0003\u0004{\u0001\u0001\u0006K!Z\u0001\u0004IN\u0004\u0003b\u0002?\u0001\u0001\u0004%I!`\u0001\u0004W\u0012\u001cW#\u0001@\u0011\u0007}\f9!\u0004\u0002\u0002\u0002)\u0019A0a\u0001\u000b\u0007\u0005\u00151.\u0001\u0005lKJ\u0014WM]8t\u0013\u0011\tI!!\u0001\u0003\u0013-#7mU3sm\u0016\u0014\b\"CA\u0007\u0001\u0001\u0007I\u0011BA\b\u0003\u001dYGmY0%KF$2aWA\t\u0011!y\u00161BA\u0001\u0002\u0004q\bbBA\u000b\u0001\u0001\u0006KA`\u0001\u0005W\u0012\u001c\u0007\u0005C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c\u000511\r\\8tK\u0012,\"!!\b\u0011\u0007-\ty\"C\u0002\u0002\"1\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002(\u0005Q1\r\\8tK\u0012|F%Z9\u0015\u0007m\u000bI\u0003C\u0005`\u0003G\t\t\u00111\u0001\u0002\u001e!A\u0011Q\u0006\u0001!B\u0013\ti\"A\u0004dY>\u001cX\r\u001a\u0011\t\r\u0005E\u0002\u0001\"\u0001U\u0003\u0011\u0001xN\u001d;\t\r\u0005U\u0002\u0001\"\u0001A\u0003\u0011Awn\u001d;\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<\u0005)1\u000f^1siR\t1\fC\u0004\u0002@\u0001!I!a\u000f\u0002)%t\u0017\u000e\u001e#je\u0016\u001cGo\u001c:z'\u0016\u0014h/[2f\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003w\tQ\"\u001b8ji.#7mU3sm\u0016\u0014\bbBA$\u0001\u0011%\u00111H\u0001\u0016S:LGO\u0013<n\u0017\u0016\u0014(-\u001a:pg\u000e{gNZ5h\u0011\u001d\tY\u0005\u0001C\u0005\u0003w\tQb\u001e:ji\u0016\\%OY\u001bD_:4\u0007bBA(\u0001\u0011%\u00111H\u0001\u0019e\u00164'/Z:i\u0015Zl7*\u001a:cKJ|7oQ8oM&<\u0007bBA*\u0001\u0011\u0005\u00111H\u0001\u0005gR|\u0007\u000fC\u0004\u0002X\u0001!I!!\u0017\u0002\u001f\r\u0014X-\u0019;f!JLgnY5qC2$RaWA.\u0003?Bq!!\u0018\u0002V\u0001\u0007\u0011)A\u0005qe&t7-\u001b9bY\"9\u0011\u0011MA+\u0001\u0004\t\u0015\u0001\u00039bgN<xN\u001d3\t\u000f\u0005]\u0003\u0001\"\u0001\u0002fQ)1,a\u001a\u0002l!9\u0011\u0011NA2\u0001\u0004\u0011\u0013AC6fsR\f'MR5mK\"A\u0011QNA2\u0001\u0004\ty'\u0001\u0006qe&t7-\u001b9bYN\u0004BaCA9\u0003&\u0019\u00111\u000f\u0007\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0004\u0002x\u0001!I!!\u001f\u00029\u0005$G-\u00128ue&,7\u000fV8ESJ,7\r^8ssN+'O^5dKR\u00191,a\u001f\t\u000f\u0005u\u0014Q\u000fa\u0001\u0003\u0006YA\u000eZ5g\u0007>tG/\u001a8u\u000f\u001d\t\tI\u0001E\u0001\u0003\u0007\u000bq!T5oS.#7\rE\u0002-\u0003\u000b3a!\u0001\u0002\t\u0002\u0005\u001d5cAAC\u0015!9\u0011&!\"\u0005\u0002\u0005-ECAAB\u0011%\ty)!\"C\u0002\u0013\u0005\u0011'\u0001\u000bKCZ\f7+Z2ve&$\u0018p\u0013:ck\r{gN\u001a\u0005\t\u0003'\u000b)\t)A\u0005e\u0005)\"*\u0019<b'\u0016\u001cWO]5us.\u0013(-N\"p]\u001a\u0004\u0003\"CAL\u0003\u000b\u0013\r\u0011\"\u00012\u0003Q\u0019VO\\*fGV\u0014\u0018\u000e^=Le\n,D)\u001a2vO\"A\u00111TACA\u0003%!'A\u000bTk:\u001cVmY;sSRL8J\u001d26\t\u0016\u0014Wo\u001a\u0011\t\u0011\u0005}\u0015Q\u0011C\u0001\u0003C\u000bA!\\1j]R\u00191,a)\t\u0011\u0005\u0015\u0016Q\u0014a\u0001\u0003O\u000bA!\u0019:hgB!1\"!+B\u0013\r\tY\u000b\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0003s\t)\t\"\u0003\u00020RI1,!-\u00024\u0006U\u0016q\u0017\u0005\u0007C\u00055\u0006\u0019\u0001\u0012\t\r]\ti\u000b1\u0001\u0019\u0011\u001d\tI'!,A\u0002\tB\u0001\"!\u001c\u0002.\u0002\u0007\u0011\u0011\u0018\t\u0006\u0003w\u000b)-\u0011\b\u0005\u0003{\u000b\tMD\u0002E\u0003\u007fK\u0011!D\u0005\u0004\u0003\u0007d\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\fIMA\u0002TKFT1!a1\r\u0011%\ti-!\"C\u0002\u0013\u0005\u0011'A\u0004Pe\u001et\u0015-\\3\t\u0011\u0005E\u0017Q\u0011Q\u0001\nI\n\u0001b\u0014:h\u001d\u0006lW\r\t\u0005\n\u0003+\f)I1A\u0005\u0002E\n\u0011b\u0014:h\t>l\u0017-\u001b8\t\u0011\u0005e\u0017Q\u0011Q\u0001\nI\n!b\u0014:h\t>l\u0017-\u001b8!\u0011%\ti.!\"C\u0002\u0013\u0005\u0011'\u0001\bLI\u000e\u0014\u0015N\u001c3BI\u0012\u0014Xm]:\t\u0011\u0005\u0005\u0018Q\u0011Q\u0001\nI\nqb\u00133d\u0005&tG-\u00113ee\u0016\u001c8\u000f\t\u0005\n\u0003K\f)I1A\u0005\u0002E\nqa\u00133d!>\u0014H\u000f\u0003\u0005\u0002j\u0006\u0015\u0005\u0015!\u00033\u0003!YEm\u0019)peR\u0004\u0003\"CAw\u0003\u000b\u0013\r\u0011\"\u00012\u0003!Ien\u001d;b]\u000e,\u0007\u0002CAy\u0003\u000b\u0003\u000b\u0011\u0002\u001a\u0002\u0013%s7\u000f^1oG\u0016\u0004\u0003\"CA{\u0003\u000b\u0013\r\u0011\"\u00012\u0003Ei\u0015\r\u001f+jG.,G\u000fT5gKRLW.\u001a\u0005\t\u0003s\f)\t)A\u0005e\u0005\u0011R*\u0019=US\u000e\\W\r\u001e'jM\u0016$\u0018.\\3!\u0011%\ti0!\"C\u0002\u0013\u0005\u0011'\u0001\u000bNCb\u0014VM\\3xC\ndW\rT5gKRLW.\u001a\u0005\t\u0005\u0003\t)\t)A\u0005e\u0005)R*\u0019=SK:,w/\u00192mK2Kg-\u001a;j[\u0016\u0004\u0003\"\u0003B\u0003\u0003\u000b\u0013\r\u0011\"\u00012\u0003%!&/\u00198ta>\u0014H\u000f\u0003\u0005\u0003\n\u0005\u0015\u0005\u0015!\u00033\u0003)!&/\u00198ta>\u0014H\u000f\t\u0005\n\u0005\u001b\t)I1A\u0005\u0002E\nQ\u0001R3ck\u001eD\u0001B!\u0005\u0002\u0006\u0002\u0006IAM\u0001\u0007\t\u0016\u0014Wo\u001a\u0011\t\u0015\tU\u0011Q\u0011b\u0001\n\u0013\u00119\"\u0001\nSKF,\u0018N]3e!J|\u0007/\u001a:uS\u0016\u001cXC\u0001B\r!\u0015\u0011YB!\n3\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012!C5n[V$\u0018M\u00197f\u0015\r\u0011\u0019\u0003D\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0014\u0005;\u00111aU3u\u0011%\u0011Y#!\"!\u0002\u0013\u0011I\"A\nSKF,\u0018N]3e!J|\u0007/\u001a:uS\u0016\u001c\b\u0005\u0003\u0006\u00030\u0005\u0015%\u0019!C\u0005\u0005c\tQ\u0002R3gCVdGoQ8oM&<WC\u0001B\u001a!\u0019\u0011YB!\u000e3e%!!q\u0007B\u000f\u0005\ri\u0015\r\u001d\u0005\n\u0005w\t)\t)A\u0005\u0005g\ta\u0002R3gCVdGoQ8oM&<\u0007\u0005\u0003\u0005\u0003@\u0005\u0015E\u0011\u0001B!\u00031\u0019'/Z1uK\u000e{gNZ5h+\u0005A\u0002\u0002\u0003B#\u0003\u000b#\tAa\u0012\u0002'\u001d,GOU3t_V\u00148-Z!t'R\u0014X-Y7\u0015\t\t%#q\n\t\u0004G\t-\u0013b\u0001B'I\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0011\tFa\u0011A\u0002\u0005\u000bAB]3t_V\u00148-\u001a(b[\u0016DcAa\u0011\u0003V\t\u0005\u0004#B\u0006\u0003X\tm\u0013b\u0001B-\u0019\t1A\u000f\u001b:poN\u00042a\tB/\u0013\r\u0011y\u0006\n\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0004\u001f\u0003\n\r$QR\u0019\nG\t\u0015$1\u000eBB\u0005[*2\u0001\u0011B4\t\u001d\u0011I\u0007\u0003b\u0001\u0005g\u0012\u0011\u0001V\u0005\u0005\u0005[\u0012y'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0005cb\u0011A\u0002;ie><8/\u0005\u0003\u0003v\tm\u0004cA\u0006\u0003x%\u0019!\u0011\u0010\u0007\u0003\u000f9{G\u000f[5oOB!!Q\u0010B@\u001d\rY\u0011\u0011Y\u0005\u0005\u0005\u0003\u000bIMA\u0005UQJ|w/\u00192mKFJ1E!\"\u0003\b\n%%\u0011\u000f\b\u0004\u0017\t\u001d\u0015b\u0001B9\u0019E*!e\u0003\u0007\u0003\f\n)1oY1mCF\u001aaEa\u0017")
public class MiniKdc
implements Logging {
    private final Properties config;
    private final File workDir;
    private final String orgName;
    private final String orgDomain;
    private final String kafka$security$minikdc$MiniKdc$$realm;
    private final File kafka$security$minikdc$MiniKdc$$krb5conf;
    private int _port;
    private DirectoryService ds;
    private KdcServer kdc;
    private boolean closed;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static InputStream getResourceAsStream(String string) throws IOException {
        return MiniKdc$.MODULE$.getResourceAsStream(string);
    }

    public static Properties createConfig() {
        return MiniKdc$.MODULE$.createConfig();
    }

    public static String Debug() {
        return MiniKdc$.MODULE$.Debug();
    }

    public static String Transport() {
        return MiniKdc$.MODULE$.Transport();
    }

    public static String MaxRenewableLifetime() {
        return MiniKdc$.MODULE$.MaxRenewableLifetime();
    }

    public static String MaxTicketLifetime() {
        return MiniKdc$.MODULE$.MaxTicketLifetime();
    }

    public static String Instance() {
        return MiniKdc$.MODULE$.Instance();
    }

    public static String KdcPort() {
        return MiniKdc$.MODULE$.KdcPort();
    }

    public static String KdcBindAddress() {
        return MiniKdc$.MODULE$.KdcBindAddress();
    }

    public static String OrgDomain() {
        return MiniKdc$.MODULE$.OrgDomain();
    }

    public static String OrgName() {
        return MiniKdc$.MODULE$.OrgName();
    }

    public static void main(String[] stringArray) {
        MiniKdc$.MODULE$.main(stringArray);
    }

    public static String SunSecurityKrb5Debug() {
        return MiniKdc$.MODULE$.SunSecurityKrb5Debug();
    }

    public static String JavaSecurityKrb5Conf() {
        return MiniKdc$.MODULE$.JavaSecurityKrb5Conf();
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.trace$((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.debug$((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.info$((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.warn$((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.error$((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MiniKdc miniKdc = this;
        synchronized (miniKdc) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private String orgName() {
        return this.orgName;
    }

    private String orgDomain() {
        return this.orgDomain;
    }

    public String kafka$security$minikdc$MiniKdc$$realm() {
        return this.kafka$security$minikdc$MiniKdc$$realm;
    }

    public File kafka$security$minikdc$MiniKdc$$krb5conf() {
        return this.kafka$security$minikdc$MiniKdc$$krb5conf;
    }

    private int _port() {
        return this._port;
    }

    private void _port_$eq(int x$1) {
        this._port = x$1;
    }

    private DirectoryService ds() {
        return this.ds;
    }

    private void ds_$eq(DirectoryService x$1) {
        this.ds = x$1;
    }

    private KdcServer kdc() {
        return this.kdc;
    }

    private void kdc_$eq(KdcServer x$1) {
        this.kdc = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public int port() {
        return this._port();
    }

    public String host() {
        return this.config.getProperty(MiniKdc$.MODULE$.KdcBindAddress());
    }

    public void start() {
        if (this.kdc() != null) {
            throw new RuntimeException("KDC already started");
        }
        if (this.closed()) {
            throw new RuntimeException("KDC is closed");
        }
        this.initDirectoryService();
        this.initKdcServer();
        this.initJvmKerberosConfig();
    }

    private void initDirectoryService() {
        this.ds_$eq((DirectoryService)new DefaultDirectoryService());
        this.ds().setInstanceLayout(new InstanceLayout(this.workDir));
        this.ds().setCacheService(new CacheService());
        InstanceLayout instanceLayout = this.ds().getInstanceLayout();
        File schemaPartitionDirectory = new File(instanceLayout.getPartitionsDirectory(), "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(instanceLayout.getPartitionsDirectory());
        extractor.extractOrCopy();
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaPartitionDirectory);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        schemaManager.loadAllEnabled();
        this.ds().setSchemaManager((SchemaManager)schemaManager);
        LdifPartition schemaLdifPartition = new LdifPartition((SchemaManager)schemaManager, this.ds().getDnFactory());
        schemaLdifPartition.setPartitionPath(schemaPartitionDirectory.toURI());
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        schemaPartition.setWrappedPartition((Partition)schemaLdifPartition);
        this.ds().setSchemaPartition(schemaPartition);
        JdbmPartition systemPartition = new JdbmPartition(this.ds().getSchemaManager(), this.ds().getDnFactory());
        systemPartition.setId("system");
        systemPartition.setPartitionPath(new File(this.ds().getInstanceLayout().getPartitionsDirectory(), systemPartition.getId()).toURI());
        systemPartition.setSuffixDn(new Dn(new String[]{"ou=system"}));
        systemPartition.setSchemaManager(this.ds().getSchemaManager());
        this.ds().setSystemPartition((Partition)systemPartition);
        this.ds().getChangeLog().setEnabled(false);
        this.ds().setDenormalizeOpAttrsEnabled(true);
        this.ds().addLast((Interceptor)new KeyDerivationInterceptor());
        String orgName = this.config.getProperty(MiniKdc$.MODULE$.OrgName()).toLowerCase(Locale.ENGLISH);
        String orgDomain = this.config.getProperty(MiniKdc$.MODULE$.OrgDomain()).toLowerCase(Locale.ENGLISH);
        JdbmPartition partition = new JdbmPartition(this.ds().getSchemaManager(), this.ds().getDnFactory());
        partition.setId(orgName);
        partition.setPartitionPath(new File(this.ds().getInstanceLayout().getPartitionsDirectory(), orgName).toURI());
        Dn dn = new Dn(new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dc=", ",dc=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{orgName, orgDomain}))});
        partition.setSuffixDn(dn);
        this.ds().addPartition((Partition)partition);
        java.util.Set indexedAttributes = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Index[]{new JdbmIndex("objectClass", false), new JdbmIndex("dc", false), new JdbmIndex("ou", false)}))).asJava();
        partition.setIndexedAttributes(indexedAttributes);
        this.ds().setInstanceId(this.config.getProperty(MiniKdc$.MODULE$.Instance()));
        this.ds().startup();
        Entry entry = this.ds().newEntry(dn);
        entry.add("objectClass", new String[]{"top", "domain"});
        entry.add("dc", new String[]{orgName});
        this.ds().getAdminSession().add(entry);
    }

    private void initKdcServer() {
        TcpTransport tcpTransport;
        String bindAddress = this.config.getProperty(MiniKdc$.MODULE$.KdcBindAddress());
        this.addInitialEntriesToDirectoryService$1(bindAddress);
        KerberosConfig kerberosConfig = new KerberosConfig();
        kerberosConfig.setMaximumRenewableLifetime(new StringOps(Predef$.MODULE$.augmentString(this.config.getProperty(MiniKdc$.MODULE$.MaxRenewableLifetime()))).toLong());
        kerberosConfig.setMaximumTicketLifetime(new StringOps(Predef$.MODULE$.augmentString(this.config.getProperty(MiniKdc$.MODULE$.MaxTicketLifetime()))).toLong());
        kerberosConfig.setSearchBaseDn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dc=", ",dc=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.orgName(), this.orgDomain()})));
        kerberosConfig.setPaEncTimestampRequired(false);
        this.kdc_$eq(new KdcServer(kerberosConfig));
        this.kdc().setDirectoryService(this.ds());
        String transport = this.config.getProperty(MiniKdc$.MODULE$.Transport());
        String string = transport.trim();
        if ("TCP".equals(string)) {
            tcpTransport = new TcpTransport(bindAddress, this.port(), 3, 50);
        } else if ("UDP".equals(string)) {
            tcpTransport = new UdpTransport(this.port());
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid transport: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transport})));
        }
        TcpTransport absTransport = tcpTransport;
        this.kdc().addTransports(new Transport[]{absTransport});
        this.kdc().setServiceName(this.config.getProperty(MiniKdc$.MODULE$.Instance()));
        this.kdc().start();
        if (this.port() == 0) {
            this._port_$eq(((InetSocketAddress)absTransport.getAcceptor().getLocalAddress()).getPort());
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MiniKdc listening at port: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.port())})));
    }

    private void initJvmKerberosConfig() {
        this.writeKrb5Conf();
        System.setProperty(MiniKdc$.MODULE$.JavaSecurityKrb5Conf(), this.kafka$security$minikdc$MiniKdc$$krb5conf().getAbsolutePath());
        System.setProperty(MiniKdc$.MODULE$.SunSecurityKrb5Debug(), this.config.getProperty(MiniKdc$.MODULE$.Debug(), "false"));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MiniKdc setting JVM krb5.conf to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$security$minikdc$MiniKdc$$krb5conf().getAbsolutePath()})));
        this.refreshJvmKerberosConfig();
    }

    private void writeKrb5Conf() {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(MiniKdc$.MODULE$.getResourceAsStream("minikdc-krb5.conf"), StandardCharsets.UTF_8));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("{3}");
            }
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close());
        }
        String output = MessageFormat.format(stringBuilder.toString(), this.kafka$security$minikdc$MiniKdc$$realm(), this.host(), ((Object)BoxesRunTime.boxToInteger((int)this.port())).toString(), System.lineSeparator());
        Files.write(this.kafka$security$minikdc$MiniKdc$$krb5conf().toPath(), output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void refreshJvmKerberosConfig() {
        Class<?> klass = Java.isIBMJdk() ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        klass.getMethod("refresh", new Class[0]).invoke(klass, new Object[0]);
    }

    public void stop() {
        block3: {
            if (this.closed()) break block3;
            this.closed_$eq(true);
            if (this.kdc() != null) {
                System.clearProperty(MiniKdc$.MODULE$.JavaSecurityKrb5Conf());
                System.clearProperty(MiniKdc$.MODULE$.SunSecurityKrb5Debug());
                this.kdc().stop();
                try {
                    this.ds().shutdown();
                }
                catch (Exception ex) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Could not shutdown ApacheDS properly", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                }
            }
        }
    }

    private void createPrincipal(String principal, String password) {
        String ldifContent = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |dn: uid=", ",ou=users,dc=", ",dc=", "\n      |objectClass: top\n      |objectClass: person\n      |objectClass: inetOrgPerson\n      |objectClass: krb5principal\n      |objectClass: krb5kdcentry\n      |cn: ", "\n      |sn: ", "\n      |uid: ", "\n      |userPassword: ", "\n      |krb5PrincipalName: ", "@", "\n      |krb5KeyVersionNumber: 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal, this.orgName().toLowerCase(Locale.ENGLISH), this.orgDomain().toLowerCase(Locale.ENGLISH), principal, principal, principal, password, principal, this.kafka$security$minikdc$MiniKdc$$realm()})))).stripMargin();
        this.addEntriesToDirectoryService(ldifContent);
    }

    public void createPrincipal(File keytabFile, Seq<String> principals) {
        String generatedPassword = UUID.randomUUID().toString();
        Keytab keytab = new Keytab();
        Seq entries = (Seq)principals.flatMap((Function1 & Serializable & scala.Serializable)principal -> {
            this.createPrincipal((String)principal, generatedPassword);
            String principalWithRealm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "@", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal, this.kafka$security$minikdc$MiniKdc$$realm()}));
            KerberosTime timestamp = new KerberosTime();
            return (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(KerberosKeyFactory.getKerberosKeys((String)principalWithRealm, (String)generatedPassword)).asScala()).values().map((Function1 & Serializable & scala.Serializable)encryptionKey -> {
                byte keyVersion = (byte)encryptionKey.getKeyVersion();
                return new KeytabEntry(principalWithRealm, 1, timestamp, keyVersion, encryptionKey);
            }, Iterable$.MODULE$.canBuildFrom());
        }, Seq$.MODULE$.canBuildFrom());
        keytab.setEntries((List)JavaConverters$.MODULE$.seqAsJavaListConverter(entries).asJava());
        keytab.write(keytabFile);
    }

    private void addEntriesToDirectoryService(String ldifContent) {
        LdifReader reader = new LdifReader((Reader)new StringReader(ldifContent));
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)reader).asScala()).foreach((Function1 & Serializable & scala.Serializable)ldifEntry -> {
                MiniKdc.$anonfun$addEntriesToDirectoryService$1(this, ldifEntry);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close());
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(MiniKdc $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void addInitialEntriesToDirectoryService$1(String bindAddress) {
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0"), (Object)this.orgName().toLowerCase(Locale.ENGLISH)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)this.orgDomain().toLowerCase(Locale.ENGLISH)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2"), (Object)this.orgName().toUpperCase(Locale.ENGLISH)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"3"), (Object)this.orgDomain().toUpperCase(Locale.ENGLISH)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"4"), (Object)bindAddress)}));
        InputStream inputStream = MiniKdc$.MODULE$.getResourceAsStream("minikdc.ldiff");
        try {
            this.addEntriesToDirectoryService(StrSubstitutor.replace((Object)IOUtils.toString((InputStream)inputStream), (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)map).asJava())));
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> inputStream.close());
        }
    }

    public static final /* synthetic */ void $anonfun$addEntriesToDirectoryService$1(MiniKdc $this, LdifEntry ldifEntry) {
        $this.ds().getAdminSession().add((Entry)new DefaultEntry($this.ds().getSchemaManager(), ldifEntry.getEntry()));
    }

    public MiniKdc(Properties config, File workDir) {
        this.config = config;
        this.workDir = workDir;
        Logging.$init$((Logging)this);
        if (!config.keySet().containsAll((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(MiniKdc$.MODULE$.kafka$security$minikdc$MiniKdc$$RequiredProperties()).asJava())) {
            scala.collection.immutable.Set missingProperties = (scala.collection.immutable.Set)MiniKdc$.MODULE$.kafka$security$minikdc$MiniKdc$$RequiredProperties().filterNot((Function1)JavaConverters$.MODULE$.asScalaSetConverter(config.keySet()).asScala());
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing configuration properties: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingProperties})));
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Configuration:");
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "---------------------------------------------------------------");
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(config).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MiniKdc.$anonfun$new$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "---------------------------------------------------------------");
        this.orgName = config.getProperty(MiniKdc$.MODULE$.OrgName());
        this.orgDomain = config.getProperty(MiniKdc$.MODULE$.OrgDomain());
        this.kafka$security$minikdc$MiniKdc$$realm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.orgName().toUpperCase(Locale.ENGLISH), this.orgDomain().toUpperCase(Locale.ENGLISH)}));
        this.kafka$security$minikdc$MiniKdc$$krb5conf = new File(workDir, "krb5.conf");
        this._port = new StringOps(Predef$.MODULE$.augmentString(config.getProperty(MiniKdc$.MODULE$.KdcPort()))).toInt();
        this.ds = null;
        this.kdc = null;
        this.closed = false;
    }
}

