/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.network.SocketServer;
import kafka.server.BrokerShuttingDown$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh!B\u0001\u0003\u0003\u00039!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aC5oi\u0016<'/\u0019;j_:L!!\u0004\u0006\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001\u0001\u0019!C\u0005+\u0005i1m\u001c:sK2\fG/[8o\u0013\u0012,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bbB\u000f\u0001\u0001\u0004%IAH\u0001\u0012G>\u0014(/\u001a7bi&|g.\u00133`I\u0015\fHCA\u0010#!\t9\u0002%\u0003\u0002\"1\t!QK\\5u\u0011\u001d\u0019C$!AA\u0002Y\t1\u0001\u001f\u00132\u0011\u0019)\u0003\u0001)Q\u0005-\u0005q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0003\"B\u0014\u0001\t#)\u0012A\u00038v[\n\u0013xn[3sg\")\u0011\u0006\u0001C\tU\u0005\t\u0002O]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005}Y\u0003\"\u0002\u0017)\u0001\u0004i\u0013A\u00039s_B,'\u000f^5fgB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005kRLGNC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#A\u0003)s_B,'\u000f^5fg\")a\u0007\u0001C\u0001o\u0005yq-\u001a8fe\u0006$XmQ8oM&<7\u000fF\u00019!\rI\u0014\t\u0012\b\u0003u}r!a\u000f \u000e\u0003qR!!\u0010\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012B\u0001!\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!AQ\"\u0003\u0007M+\u0017O\u0003\u0002A1A\u0011!#R\u0005\u0003\r\n\u00111bS1gW\u0006\u001cuN\u001c4jO\")\u0001\n\u0001C\u0001\u0013\u0006y\u0011M\\=T_\u000e\\W\r^*feZ,'/F\u0001K!\tYe*D\u0001M\u0015\tiE!A\u0004oKR<xN]6\n\u0005=c%\u0001D*pG.,GoU3sm\u0016\u0014\b\"B)\u0001\t\u0003I\u0015AF2p]R\u0014x\u000e\u001c7feN{7m[3u'\u0016\u0014h/\u001a:\t\u000bM\u0003A\u0011A%\u000239|GoQ8oiJ|G\u000e\\3s'>\u001c7.\u001a;TKJ4XM\u001d\u0005\u0006+\u0002!\tAV\u0001\u0013EJ|7.\u001a:T_\u000e\\W\r^*feZ,'\u000f\u0006\u0002K/\")\u0001\f\u0016a\u0001-\u0005A!M]8lKJLE\rC\u0003[\u0001\u0011\u00051,A\u0004d_:tWm\u0019;\u0015\u0007q\u0013G\r\u0005\u0002^A6\taL\u0003\u0002`c\u0005\u0019a.\u001a;\n\u0005\u0005t&AB*pG.,G\u000fC\u0004d3B\u0005\t\u0019\u0001&\u0002\u0003MDq!Z-\u0011\u0002\u0003\u0007a-\u0001\u0005qe>$xnY8m!\t9\u0007/D\u0001i\u0015\t)\u0017N\u0003\u0002kW\u000611m\\7n_:T!!\u00027\u000b\u00055t\u0017AB1qC\u000eDWMC\u0001p\u0003\ry'oZ\u0005\u0003c\"\u0014\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000bM\u0004A\u0011\u0002;\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0004?U<\b\"\u0002<s\u0001\u0004a\u0016AB:pG.,G\u000fC\u0003ye\u0002\u0007\u00110A\u0004sKF,Xm\u001d;\u0011\u0007]QH0\u0003\u0002|1\t)\u0011I\u001d:bsB\u0011q#`\u0005\u0003}b\u0011AAQ=uK\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0011a\u0004:fG\u0016Lg/\u001a*fgB|gn]3\u0015\u0007e\f)\u0001C\u0003w\u007f\u0002\u0007A\fC\u0004\u0002\n\u0001!\t!a\u0003\u0002#I,\u0017/^3ti\u0006sGMU3dK&4X\rF\u0003z\u0003\u001b\ty\u0001\u0003\u0004w\u0003\u000f\u0001\r\u0001\u0018\u0005\u0007q\u0006\u001d\u0001\u0019A=\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005q1m\u001c8oK\u000e$\u0018I\u001c3TK:$G\u0003DA\f\u0003G\t\t$a\u000f\u0002@\u0005=\u0003\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u\u0011'A\u0002oS>LA!!\t\u0002\u001c\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000fa\f\t\u00021\u0001\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,%\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003_\tICA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011!\t\u0019$!\u0005A\u0002\u0005U\u0012AB1qS.+\u0017\u0010E\u0002h\u0003oI1!!\u000fi\u0005\u001d\t\u0005/[&fsND\u0011\"!\u0010\u0002\u0012A\u0005\t\u0019\u0001&\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\u0005\u000b\u0003\u0003\n\t\u0002%AA\u0002\u0005\r\u0013AC1qSZ+'o]5p]B)q#!\u0012\u0002J%\u0019\u0011q\t\r\u0003\r=\u0003H/[8o!\r9\u00121J\u0005\u0004\u0003\u001bB\"!B*i_J$\b\u0002C3\u0002\u0012A\u0005\t\u0019\u00014\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005!2m\u001c8oK\u000e$\u0018I\u001c3TK:$7\u000b\u001e:vGR$B\"a\u0006\u0002X\u0005\u001d\u0014\u0011NA6\u0003[B\u0001\"!\u0017\u0002R\u0001\u0007\u00111L\u0001\u000ee\u0016\fX/Z:u'R\u0014Xo\u0019;\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019i\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t)'a\u0018\u0003\rM#(/^2u\u0011!\t\u0019$!\u0015A\u0002\u0005U\u0002\u0002CA!\u0003#\u0002\r!!\u0013\t\u0013\u0005u\u0012\u0011\u000bI\u0001\u0002\u0004Q\u0005\u0002C3\u0002RA\u0005\t\u0019\u00014\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005!1/\u001a8e))\t9\"!\u001e\u0002x\u0005e\u00141\u0010\u0005\bq\u0006=\u0004\u0019AA\u0013\u0011!\t\u0019$a\u001cA\u0002\u0005U\u0002B\u0002<\u0002p\u0001\u0007A\f\u0003\u0006\u0002B\u0005=\u0004\u0013!a\u0001\u0003\u0007Bq!a \u0001\t\u0003\t\t)\u0001\u0006tK:$7\u000b\u001e:vGR$\"\"a\u0006\u0002\u0004\u0006\u0015\u0015qQAE\u0011!\tI&! A\u0002\u0005m\u0003\u0002CA\u001a\u0003{\u0002\r!!\u000e\t\rY\fi\b1\u0001]\u0011!\t\t%! A\u0002\u0005%\u0003bBAG\u0001\u0011E\u0011qR\u0001\u0013g.L\u0007OU3ta>t7/\u001a%fC\u0012,'\u000f\u0006\u0003\u0002\u0018\u0005E\u0005bBAJ\u0003\u0017\u0003\r!_\u0001\te\u0016\u001c\bo\u001c8tK\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0015!\u00058fqR\u0014V-];fgRDU-\u00193feR1\u00111TAQ\u0003G\u0003B!a\n\u0002\u001e&!\u0011qTA\u0015\u00055\u0011V-];fgRDU-\u00193fe\"A\u00111GAK\u0001\u0004\t)\u0004\u0003\u0005\u0002B\u0005U\u0005\u0019AA%\u0011%\t9\u000bAI\u0001\n\u0003\tI+\u0001\rd_:tWm\u0019;B]\u0012\u001cVM\u001c3%I\u00164\u0017-\u001e7uIM*\"!a++\u0007)\u000bik\u000b\u0002\u00020B!\u0011\u0011WA^\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016!C;oG\",7m[3e\u0015\r\tI\fG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA_\u0003g\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\t\rAI\u0001\n\u0003\t\u0019-\u0001\rd_:tWm\u0019;B]\u0012\u001cVM\u001c3%I\u00164\u0017-\u001e7uIQ*\"!!2+\t\u0005\r\u0013Q\u0016\u0005\n\u0003\u0013\u0004\u0011\u0013!C\u0001\u0003\u0017\f\u0001dY8o]\u0016\u001cG/\u00118e'\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00136+\t\tiMK\u0002g\u0003[C\u0011\"!5\u0001#\u0003%\t!!+\u0002=\r|gN\\3di\u0006sGmU3oIN#(/^2uI\u0011,g-Y;mi\u0012\"\u0004\"CAk\u0001E\u0005I\u0011AAf\u0003y\u0019wN\u001c8fGR\fe\u000eZ*f]\u0012\u001cFO];di\u0012\"WMZ1vYR$S\u0007C\u0005\u0002Z\u0002\t\n\u0011\"\u0001\u0002*\u0006\t2m\u001c8oK\u000e$H\u0005Z3gCVdG\u000fJ\u0019\t\u0013\u0005u\u0007!%A\u0005\u0002\u0005-\u0017!E2p]:,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011\u001d\u0001\u0012\u0002\u0013\u0005\u00111Y\u0001\u000fg\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public abstract class BaseRequestTest
extends KafkaServerTestHarness {
    private int correlationId = 0;

    private int correlationId() {
        return this.correlationId;
    }

    private void correlationId_$eq(int x$1) {
        this.correlationId = x$1;
    }

    public int numBrokers() {
        return 3;
    }

    public void propertyOverrides(Properties properties) {
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> props2 = TestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnect(), false, true, (Option<SecurityProtocol>)new Some((Object)this.securityProtocol()), this.trustStoreFile(), this.serverSaslProperties(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12());
        props2.foreach((Function1 & Serializable & scala.Serializable)properties -> {
            this.propertyOverrides(properties);
            return BoxedUnit.UNIT;
        });
        return (Seq)props2.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    public SocketServer anySocketServer() {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$anySocketServer$1(server))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No live broker is available");
        });
    }

    public SocketServer controllerSocketServer() {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$controllerSocketServer$1(server))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No controller broker is available");
        });
    }

    public SocketServer notControllerSocketServer() {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$notControllerSocketServer$1(server))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No non-controller broker is available");
        });
    }

    public SocketServer brokerSocketServer(int brokerId) {
        return (SocketServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)BaseRequestTest.$anonfun$brokerSocketServer$1(brokerId, server))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.socketServer()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find broker with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        });
    }

    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
    }

    public SocketServer connect$default$1() {
        return this.anySocketServer();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public byte[] requestAndReceive(Socket socket, byte[] request) {
        this.sendRequest(socket, request);
        return this.receiveResponse(socket);
    }

    public ByteBuffer connectAndSend(AbstractRequest request, ApiKeys apiKey, SocketServer destination, Option<Object> apiVersion, SecurityProtocol protocol) {
        ByteBuffer byteBuffer;
        try (Socket socket = this.connect(destination, protocol);){
            byteBuffer = this.send(request, apiKey, socket, apiVersion);
        }
        return byteBuffer;
    }

    public SocketServer connectAndSend$default$3() {
        return this.anySocketServer();
    }

    public Option<Object> connectAndSend$default$4() {
        return None$.MODULE$;
    }

    public SecurityProtocol connectAndSend$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ByteBuffer connectAndSendStruct(Struct requestStruct, ApiKeys apiKey, short apiVersion, SocketServer destination, SecurityProtocol protocol) {
        ByteBuffer byteBuffer;
        try (Socket socket = this.connect(destination, protocol);){
            byteBuffer = this.sendStruct(requestStruct, apiKey, socket, apiVersion);
        }
        return byteBuffer;
    }

    public SocketServer connectAndSendStruct$default$4() {
        return this.anySocketServer();
    }

    public SecurityProtocol connectAndSendStruct$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ByteBuffer send(AbstractRequest request, ApiKeys apiKey, Socket socket, Option<Object> apiVersion) {
        RequestHeader header = this.nextRequestHeader(apiKey, BoxesRunTime.unboxToShort((Object)apiVersion.getOrElse((Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> request.version())));
        byte[] serializedBytes = request.serialize(header).array();
        byte[] response = this.requestAndReceive(socket, serializedBytes);
        return this.skipResponseHeader(response);
    }

    public Option<Object> send$default$4() {
        return None$.MODULE$;
    }

    public ByteBuffer sendStruct(Struct requestStruct, ApiKeys apiKey, Socket socket, short apiVersion) {
        RequestHeader header = this.nextRequestHeader(apiKey, apiVersion);
        byte[] serializedBytes = AbstractRequestResponse.serialize((Struct)header.toStruct(), (Struct)requestStruct).array();
        byte[] response = this.requestAndReceive(socket, serializedBytes);
        return this.skipResponseHeader(response);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer skipResponseHeader(byte[] response) {
        void var2_2;
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader.parse((ByteBuffer)responseBuffer);
        return var2_2;
    }

    public RequestHeader nextRequestHeader(ApiKeys apiKey, short apiVersion) {
        this.correlationId_$eq(this.correlationId() + 1);
        return new RequestHeader(apiKey.id, apiVersion, "client-id", this.correlationId());
    }

    public static final /* synthetic */ boolean $anonfun$anySocketServer$1(KafkaServer server) {
        byte state = server.brokerState().currentState();
        return state != NotRunning$.MODULE$.state() && state != BrokerShuttingDown$.MODULE$.state();
    }

    public static final /* synthetic */ boolean $anonfun$controllerSocketServer$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$notControllerSocketServer$1(KafkaServer server) {
        return !server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$brokerSocketServer$1(int brokerId$1, KafkaServer server) {
        return server.config().brokerId() == brokerId$1;
    }
}

