/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.admin.ConfigCommand$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaId$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u0001\u001d\u0011ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005i&lW-F\u0001\u0017!\t9\u0012%D\u0001\u0019\u0015\tI\"$A\u0003vi&d7O\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u000511m\u001c8gS\u001e,\u0012\u0001\u000b\t\u0003%%J!A\u000b\u0002\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw\r\u0003\u0004-\u0001\u0001\u0006I\u0001K\u0001\bG>tg-[4!\u0011\u001dq\u0003\u00011A\u0005\u0002=\nAB\\;n\u0007\u0006dGNY1dWN,\u0012\u0001\r\t\u0003\u0013EJ!A\r\u0006\u0003\u0007%sG\u000fC\u00045\u0001\u0001\u0007I\u0011A\u001b\u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHC\u0001\u001c:!\tIq'\u0003\u00029\u0015\t!QK\\5u\u0011\u001dQ4'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019a\u0004\u0001)Q\u0005a\u0005ia.^7DC2d'-Y2lg\u0002BQA\u0010\u0001\u0005\u0002}\n\u0001bY1mY\n\f7m\u001b\u000b\u0003m\u0001CQ!Q\u001fA\u0002A\n1\u0002Z3mCf$\u0016.\\3Ng\")1\t\u0001C\u0001\t\u0006a!-\u001a4pe\u0016lU\r\u001e5pIR\ta\u0007\u000b\u0002C\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011jH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0017\"\u0013aAQ3g_J,\u0007\"B'\u0001\t\u0013q\u0015\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)%1t\nUAM\u0003;\u000b\t\u000bC\u0003'\u0019\u0002\u0007\u0001\u0006C\u0003R\u0019\u0002\u0007!+A\u0004dY&,g\u000e^\u0019\u0011\u0005M#V\"\u0001\u0001\u0007\tU\u0003AI\u0016\u0002\u000b+N,'o\u00117jK:$8\u0003\u0002+\t/j\u0003\"!\u0003-\n\u0005eS!a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013mK!\u0001\u0018\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y#&Q3A\u0005\u0002}\u000bA!^:feV\t\u0001\r\u0005\u0002bQ:\u0011!M\u001a\t\u0003G*i\u0011\u0001\u001a\u0006\u0003K\u001a\ta\u0001\u0010:p_Rt\u0014BA4\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dT\u0001\u0002\u00037U\u0005#\u0005\u000b\u0011\u00021\u0002\u000bU\u001cXM\u001d\u0011\t\u00119$&Q3A\u0005\u0002}\u000b\u0001b\u00197jK:$\u0018\n\u001a\u0005\taR\u0013\t\u0012)A\u0005A\u0006I1\r\\5f]RLE\r\t\u0005\teR\u0013)\u001a!C\u0001g\u0006Q1m\u001c8gS\u001e,6/\u001a:\u0016\u0003Q\u00042!C;a\u0013\t1(B\u0001\u0004PaRLwN\u001c\u0005\tqR\u0013\t\u0012)A\u0005i\u0006Y1m\u001c8gS\u001e,6/\u001a:!\u0011!QHK!f\u0001\n\u0003\u0019\u0018AD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0005\tyR\u0013\t\u0012)A\u0005i\u0006y1m\u001c8gS\u001e\u001cE.[3oi&#\u0007\u0005C\u0003\u0010)\u0012\u0005a\u0010\u0006\u0005S\u007f\u0006\u0005\u00111AA\u0003\u0011\u0015qV\u00101\u0001a\u0011\u0015qW\u00101\u0001a\u0011\u001d\u0011X\u0010%AA\u0002QDqA_?\u0011\u0002\u0003\u0007A\u000fC\u0005\u0002\nQ\u000b\t\u0011\"\u0001\u0002\f\u0005!1m\u001c9z)%\u0011\u0016QBA\b\u0003#\t\u0019\u0002\u0003\u0005_\u0003\u000f\u0001\n\u00111\u0001a\u0011!q\u0017q\u0001I\u0001\u0002\u0004\u0001\u0007\u0002\u0003:\u0002\bA\u0005\t\u0019\u0001;\t\u0011i\f9\u0001%AA\u0002QD\u0011\"a\u0006U#\u0003%\t!!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0004\u0016\u0004A\u0006u1FAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\"\"\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005EB+%A\u0005\u0002\u0005e\u0011AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003k!\u0016\u0013!C\u0001\u0003o\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002:)\u001aA/!\b\t\u0013\u0005uB+%A\u0005\u0002\u0005]\u0012AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003\u0003\"\u0016\u0011!C!\u0003\u0007\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nA\u0001\\1oO*\u0011\u0011qJ\u0001\u0005U\u00064\u0018-C\u0002j\u0003\u0013B\u0001\"!\u0016U\u0003\u0003%\taL\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u00033\"\u0016\u0011!C\u0001\u00037\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002^\u0005\r\u0004cA\u0005\u0002`%\u0019\u0011\u0011\r\u0006\u0003\u0007\u0005s\u0017\u0010\u0003\u0005;\u0003/\n\t\u00111\u00011\u0011%\t9\u0007VA\u0001\n\u0003\nI'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u0007\u0005\u0004\u0002n\u0005M\u0014QL\u0007\u0003\u0003_R1!!\u001d\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\nyG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tI\bVA\u0001\n\u0003\tY(\u0001\u0005dC:,\u0015/^1m)\u0011\ti(a!\u0011\u0007%\ty(C\u0002\u0002\u0002*\u0011qAQ8pY\u0016\fg\u000eC\u0005;\u0003o\n\t\u00111\u0001\u0002^!I\u0011q\u0011+\u0002\u0002\u0013\u0005\u0013\u0011R\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0001\u0007C\u0005\u0002\u000eR\u000b\t\u0011\"\u0011\u0002\u0010\u0006AAo\\*ue&tw\r\u0006\u0002\u0002F!I\u00111\u0013+\u0002\u0002\u0013\u0005\u0013QS\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u\u0014q\u0013\u0005\nu\u0005E\u0015\u0011!a\u0001\u0003;Ba!a'M\u0001\u0004\u0011\u0016aB2mS\u0016tGO\r\u0005\u0007\u0003?c\u0005\u0019\u0001*\u0002\u0019I\fg\u000eZ8n\u00072LWM\u001c;\t\r\u0005\rF\n1\u0001S\u0003M!WMZ1vYR\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0011\u0019\t9\u000b\u0001C\u0001\t\u0006AB/Z:u\u00072LWM\u001c;JIF+x\u000e^1QCJ\u001c\u0018N\\4)\t\u0005\u0015\u00161\u0016\t\u0004\u000f\u00065\u0016bAAX\u0011\n!A+Z:u\u0011\u0019\t\u0019\f\u0001C\u0001\t\u0006!B/Z:u+N,'/U;pi\u0006\u0004\u0016M]:j]\u001eDC!!-\u0002,\"1\u0011\u0011\u0018\u0001\u0005\u0002\u0011\u000bA\u0004^3tiV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\r\u000b\u0003\u00028\u0006-\u0006BBA`\u0001\u0011\u0005A)\u0001\u0017uKN$Xk]3s#V|G/\u0019)beNLgnZ,ji\"$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\"\"\u0011QXAV\u0011\u0019\t)\r\u0001C\u0001\t\u0006!D/Z:u+N,'o\u00117jK:$\u0018+^8uCB\u000b'o]5oO&#w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\t\u0005\r\u00171\u0016\u0005\u0007\u0003\u0017\u0004A\u0011\u0001#\u00023Q,7\u000f^)v_R\f7i\u001c8gS\u001e\u0004&/Z2fI\u0016t7-\u001a\u0015\u0005\u0003\u0013\fY\u000b\u0003\u0004\u0002R\u0002!\t\u0001R\u0001\u0013i\u0016\u001cH/U;pi\u00064\u0016n\u001c7bi&|g\u000e\u000b\u0003\u0002P\u0006-\u0006BBAl\u0001\u0011\u0005A)A\u0012uKN$(+Z9vKN$\b+\u001a:dK:$\u0018mZ3Rk>$\u0018MV5pY\u0006$\u0018n\u001c8)\t\u0005U\u00171\u0016\u0005\u0007\u0003;\u0004A\u0011\u0001#\u00029Q,7\u000f^#ya&\u0014X\r\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe\"\"\u00111\\AV\u0011\u0019\t\u0019\u000f\u0001C\u0001\t\u00061B/Z:u\u000bb\u0004\u0018N]3Rk>$\u0018mU3og>\u00148\u000f\u000b\u0003\u0002b\u0006-\u0006BBAu\u0001\u0011\u0005A)A\u000buKN$\u0018+^8uCV\u001bXM]*b]&$\u0018N_3)\t\u0005\u001d\u00181\u0016\u0005\b\u0003_\u0004A\u0011AAy\u0003)qWm^'fiJL7m]\u000b\u0003\u0003g\u0004B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0004\u0003sT\u0012aB7fiJL7m]\u0005\u0005\u0003{\f9PA\u0004NKR\u0014\u0018nY:\b\u0013\t\u0005\u0001!!A\t\n\t\r\u0011AC+tKJ\u001cE.[3oiB\u00191K!\u0002\u0007\u0011U\u0003\u0011\u0011!E\u0005\u0005\u000f\u0019RA!\u0002\u0003\ni\u0003\u0012Ba\u0003\u0003\u0012\u0001\u0004G\u000f\u001e*\u000e\u0005\t5!b\u0001B\b\u0015\u00059!/\u001e8uS6,\u0017\u0002\u0002B\n\u0005\u001b\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85\u0011\u001dy!Q\u0001C\u0001\u0005/!\"Aa\u0001\t\u0015\u00055%QAA\u0001\n\u000b\ny\t\u0003\u0006\u0003\u001e\t\u0015\u0011\u0011!CA\u0005?\tQ!\u00199qYf$\u0012B\u0015B\u0011\u0005G\u0011)Ca\n\t\ry\u0013Y\u00021\u0001a\u0011\u0019q'1\u0004a\u0001A\"A!Oa\u0007\u0011\u0002\u0003\u0007A\u000f\u0003\u0005{\u00057\u0001\n\u00111\u0001u\u0011)\u0011YC!\u0002\u0002\u0002\u0013\u0005%QF\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yCa\u000e\u0011\t%)(\u0011\u0007\t\b\u0013\tM\u0002\r\u0019;u\u0013\r\u0011)D\u0003\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\te\"\u0011FA\u0001\u0002\u0004\u0011\u0016a\u0001=%a!Q!Q\bB\u0003#\u0003%\t!a\u000e\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!B!\u0011\u0003\u0006E\u0005I\u0011AA\u001c\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004B\u0003B#\u0005\u000b\t\n\u0011\"\u0001\u00028\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!B!\u0013\u0003\u0006E\u0005I\u0011AA\u001c\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class ClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final MockTime time = new MockTime();
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public void callback(int delayTimeMs) {
        this.numCallbacks_$eq(this.numCallbacks() + 1);
    }

    @Before
    public void beforeMethod() {
        this.numCallbacks_$eq(0);
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)("Default producer quota should be " + config.quotaBytesPerSecondDefault()), (Object)new Quota((double)config.quotaBytesPerSecondDefault(), true), (Object)clientMetrics.quota(randomClient.user(), randomClient.clientId()));
            Assert.assertEquals((String)"Should return the overridden value (2000)", (Object)new Quota(2000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            Assert.assertEquals((String)"Should return the overridden value (4000)", (Object)new Quota(4000.0, true), (Object)clientMetrics.quota(client2.user(), client2.clientId()));
            int throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), (double)(2500 * config.numQuotaSamples()), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (Object)new Quota(3000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), 0.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (Object)new Quota(500.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), 0.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (Object)new Quota(4000.0, true), (Object)clientMetrics.quota(client1.user(), client1.clientId()));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle(client1.user(), client1.clientId(), (double)(1000 * config.numQuotaSamples()), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time());
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "unknown", 400.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            this.time().sleep(500L);
            int sleepTime = clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "unknown", 2300.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            Assert.assertEquals((long)1L, (long)((int)queueSizeMetric.value()));
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            this.time().sleep((long)sleepTime);
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            Assert.assertEquals((long)11L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "unknown", 400.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "unknown", 0.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs)));
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testRequestPercentageQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time());
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                quotaManager.recordAndMaybeThrottle("ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            this.time().sleep(500L);
            int throttleTime = quotaManager.recordAndMaybeThrottle("ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(67.1), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            Assert.assertEquals((long)1L, (long)((int)queueSizeMetric.value()));
            quotaManager.throttledRequestReaper().doWork();
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            quotaManager.throttledRequestReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            Assert.assertEquals((long)11L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                quotaManager.recordAndMaybeThrottle("ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)quotaManager.recordAndMaybeThrottle("ANONYMOUS", "test-client", 0.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs)));
            Assert.assertEquals((long)1000L, (long)quotaManager.recordAndMaybeThrottle("ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(500.0), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.time().sleep(1000L);
                Assert.assertEquals((long)1000L, (long)quotaManager.recordAndMaybeThrottle("ANONYMOUS", "test-client", 0.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs)));
            });
            this.time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)quotaManager.recordAndMaybeThrottle("ANONYMOUS", "test-client", 0.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs)));
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time());
        try {
            clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 100.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            metrics.removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 10000.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time());
        try {
            clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 100.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            metrics.removeSensor("ProduceThrottleTime-:client1");
            metrics.removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = clientMetrics.recordAndMaybeThrottle("ANONYMOUS", "client1", 10000.0, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testQuotaUserSanitize() {
        String principal = "CN=Some characters !@#$%&*()_-+=';:,/~";
        String sanitizedPrincipal = QuotaId$.MODULE$.sanitize(principal);
        ConfigCommand$.MODULE$.validateChars("sanitized-principal", sanitizedPrincipal.replace('%', '_'));
        Assert.assertEquals((Object)principal, (Object)QuotaId$.MODULE$.desanitize(sanitizedPrincipal));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
        }
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((Object)new Quota((double)expectedBound, true), (Object)quotaManager$1.quota(user, clientId));
        int throttleTimeMs = quotaManager$1.recordAndMaybeThrottle(user, clientId, (double)(value * this.config().numQuotaSamples()), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.callback(delayTimeMs));
        if (expectThrottle) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.user();
                    break;
                }
                case 1: {
                    option = this.clientId();
                    break;
                }
                case 2: {
                    option = this.configUser();
                    break;
                }
                case 3: {
                    option = this.configClientId();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            if (((UserClient)object).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

