/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminUtils$;
import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.config.ConfigException;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u000f\t\tB)\u001f8b[&\u001c7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007IQB\u000b\u0002#9|g.\u0012=jgR,g\u000e^\"p]\u001aLw-F\u0001\u0017!\t9bD\u0004\u0002\u00199A\u0011\u0011DC\u0007\u00025)\u00111DB\u0001\u0007yI|w\u000e\u001e \n\u0005uQ\u0011A\u0002)sK\u0012,g-\u0003\u0002 A\t11\u000b\u001e:j]\u001eT!!\b\u0006\t\r\t\u0002\u0001\u0015!\u0004\u0017\u0003IqwN\\#ySN$XM\u001c;D_:4\u0017n\u001a\u0011\t\u000f\u0011\u0002!\u0019!C\u0007+\u0005I1o\\7f-\u0006dW/\u001a\u0005\u0007M\u0001\u0001\u000bQ\u0002\f\u0002\u0015M|W.\u001a,bYV,\u0007\u0005C\u0005)\u0001\u0001\u0007\t\u0019!C\u0001S\u00059!p[+uS2\u001cX#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\"\u0011!B;uS2\u001c\u0018BA\u0018-\u0005\u001dQ6.\u0016;jYND\u0011\"\r\u0001A\u0002\u0003\u0007I\u0011\u0001\u001a\u0002\u0017i\\W\u000b^5mg~#S-\u001d\u000b\u0003gY\u0002\"!\u0003\u001b\n\u0005UR!\u0001B+oSRDqa\u000e\u0019\u0002\u0002\u0003\u0007!&A\u0002yIEBa!\u000f\u0001!B\u0013Q\u0013\u0001\u0003>l+RLGn\u001d\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u000bM,G/\u00169\u0015\u0003MB#A\u000f \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015!\u00026v]&$(\"A\"\u0002\u0007=\u0014x-\u0003\u0002F\u0001\n1!)\u001a4pe\u0016DQa\u0012\u0001\u0005\u0002q\n\u0011f\u001d5pk2$g)Y5m/\",gn\u00115b]\u001eLgn\u001a\"s_.,'/\u00168l]><hnQ8oM&<\u0007\u0006\u0002$J\u00196\u0003\"a\u0010&\n\u0005-\u0003%\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u001dB\u0011q\n\u0016\b\u0003!Js!!G)\n\u0003-I!a\u0015\u0006\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'BA*\u000b\u0011\u0015A\u0006\u0001\"\u0001=\u0003-\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\,iK:\u001c\u0005.\u00198hS:<7\t\\5f]RLE-\u00168l]><hnQ8oM&<\u0007\u0006B,J\u00196CQa\u0017\u0001\u0005\u0002q\nqe\u001d5pk2$g)Y5m/\",gn\u00115b]\u001eLgnZ+tKJ,fn\u001b8po:\u001cuN\u001c4jO\"\"!,\u0013'N\u0011\u0015q\u0006\u0001\"\u0001=\u0003!\u001a\bn\\;mI\u001a\u000b\u0017\u000e\u001c'fC\u0012,'oQ8oM&<7oV5uQ&sg/\u00197jIZ\u000bG.^3tQ\u0011i\u0016\n\u00141$\u0003\u0005\u0004\"A\u00196\u000e\u0003\rT!\u0001Z3\u0002\r\r|gNZ5h\u0015\t1w-\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b!T!!\u001b\"\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tY7MA\bD_:4\u0017nZ#yG\u0016\u0004H/[8o\u0011\u0015i\u0007\u0001\"\u0001=\u0003)\u001a\bn\\;mI\u001a\u000b\u0017\u000e\u001c$pY2|w/\u001a:D_:4\u0017nZ:XSRD\u0017J\u001c<bY&$g+\u00197vKNDC\u0001\\%MA\u0002")
public class DynamicConfigTest {
    private final String nonExistentConfig;
    private final String someValue;
    private ZkUtils zkUtils;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(zkClient, false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingBrokerUnknownConfig() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingUserUnknownConfig() {
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailLeaderConfigsWithInvalidValues() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100"));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailFollowerConfigsWithInvalidValues() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100"));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

