/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u000f\ta\u0002*[4io\u0006$XM]7be.\u0004VM]:jgR,gnY3UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012aB2p]\u001aLwm]\u000b\u0002-A\u0019qC\u0007\u000f\u000e\u0003aQ!!\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001c1\t\u00191+Z9\u0011\u0005Ii\u0012B\u0001\u0010\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0001\u0002\u0001\u0015!\u0003\u0017\u0003!\u0019wN\u001c4jON\u0004\u0003b\u0002\u0012\u0001\u0005\u0004%\taI\u0001\u0006i>\u0004\u0018nY\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB*ue&tw\r\u0003\u0004.\u0001\u0001\u0006I\u0001J\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f=\u0002!\u0019!C\u0001a\u0005YAn\\4NC:\fw-\u001a:t+\u0005\t\u0004cA\f\u001beA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\u0004Y><\u0017BA\u001c5\u0005)aunZ'b]\u0006<WM\u001d\u0005\u0007s\u0001\u0001\u000b\u0011B\u0019\u0002\u00191|w-T1oC\u001e,'o\u001d\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u0011Q,\u0017M\u001d3po:$\u0012!\u0010\t\u0003\u0013yJ!a\u0010\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003u\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u000b),h.\u001b;\u000b\u0003\u0019\u000b1a\u001c:h\u0013\tA5IA\u0003BMR,'\u000fC\u0003K\u0001\u0011\u0005A(A\u0016uKN$\b*[4i/\u0006$XM]7be.\u0004VM]:jgR,gnY3TS:<G.\u001a)beRLG/[8oQ\tIE\n\u0005\u0002C\u001b&\u0011aj\u0011\u0002\u0005)\u0016\u001cH\u000fC\u0003Q\u0001\u0011\u0005A(\u0001\u0018uKN$\b*[4i/\u0006$XM]7be.\u0004VM]:jgR,gnY3Nk2$\u0018\u000e\u001d7f!\u0006\u0014H/\u001b;j_:\u001c\bFA(M\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019Aw/\u001c$peR!Q\u000bW/i!\tIa+\u0003\u0002X\u0015\t!Aj\u001c8h\u0011\u0015I&\u000b1\u0001[\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"AE.\n\u0005q\u0013!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006EI\u0003\rA\u0018\t\u0003?\u001at!\u0001\u00193\u0011\u0005\u0005TQ\"\u00012\u000b\u0005\r4\u0011A\u0002\u001fs_>$h(\u0003\u0002f\u0015\u00051\u0001K]3eK\u001aL!aK4\u000b\u0005\u0015T\u0001\"B5S\u0001\u0004Q\u0017!\u00039beRLG/[8o!\tI1.\u0003\u0002m\u0015\t\u0019\u0011J\u001c;")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> {
        File[] x$2 = (File[])((TraversableOnce)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class));
        CleanerConfig x$3 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
        LogConfig x$4 = TestUtils$.MODULE$.createLogManager$default$2();
        MockTime x$5 = TestUtils$.MODULE$.createLogManager$default$4();
        return TestUtils$.MODULE$.createLogManager(x$2, x$4, x$3, x$5);
    }, Seq$.MODULE$.canBuildFrom());

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable & scala.Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createMock(ZkUtils.class);
        EasyMock.replay((Object[])new Object[]{zkUtils});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, zkUtils, (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time).follower(), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), ReplicaManager$.MODULE$.$lessinit$greater$default$11());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            Partition partition0 = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            Log log0 = ((LogManager)this.logManagers().head()).createLog(new TopicPartition(this.topic(), 0), LogConfig$.MODULE$.apply());
            Replica leaderReplicaPartition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), partition0, (Time)time, 0L, (Option)new Some((Object)log0));
            partition0.addReplicaIfNotExists(leaderReplicaPartition0);
            Replica followerReplicaPartition0 = new Replica(((KafkaConfig)this.configs().last()).brokerId(), partition0, (Time)time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            partition0.addReplicaIfNotExists(followerReplicaPartition0);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            ((Replica)partition0.getReplica(partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{zkUtils});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        ZkUtils zkUtils = (ZkUtils)EasyMock.createMock(ZkUtils.class);
        EasyMock.replay((Object[])new Object[]{zkUtils});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, zkUtils, (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time).follower(), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), ReplicaManager$.MODULE$.$lessinit$greater$default$11());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            Partition topic1Partition0 = replicaManager.getOrCreatePartition(new TopicPartition(topic1, 0));
            Log topic1Log0 = ((LogManager)this.logManagers().head()).createLog(new TopicPartition(topic1, 0), LogConfig$.MODULE$.apply());
            Replica leaderReplicaTopic1Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), topic1Partition0, (Time)time, 0L, (Option)new Some((Object)topic1Log0));
            topic1Partition0.addReplicaIfNotExists(leaderReplicaTopic1Partition0);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset(), (long)topic1Partition0Hw);
            ((Replica)topic1Partition0.getReplica(topic1Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            Partition topic2Partition0 = replicaManager.getOrCreatePartition(new TopicPartition(topic2, 0));
            Log topic2Log0 = ((LogManager)this.logManagers().head()).createLog(new TopicPartition(topic2, 0), LogConfig$.MODULE$.apply());
            Replica leaderReplicaTopic2Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), topic2Partition0, (Time)time, 0L, (Option)new Some((Object)topic2Log0));
            topic2Partition0.addReplicaIfNotExists(leaderReplicaTopic2Partition0);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)leaderReplicaTopic2Partition0.highWatermark().messageOffset(), (long)topic2Partition0Hw);
            ((Replica)topic2Partition0.getReplica(topic2Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)15L, (long)leaderReplicaTopic2Partition0.highWatermark().messageOffset());
            ((Replica)topic1Partition0.getReplica(topic1Partition0.getReplica$default$1()).get()).highWatermark_$eq(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)10L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{zkUtils});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    public long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])manager.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

